<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAdvancedReportsSaleOrder
 * @property ModelSaleOrder $model_sale_order
 */
class ModelAdvancedReportsSaleOrder extends Model {

    public function editOrderProducts($order_id,$data) {
        $order_id = (int)$order_id;
        $order_product_id = (int)$data['order_product_id'];
        $product_id = (int)$data['product_id'];

        if(!$product_id || !$order_id){
            return false;
        }

        $this->load->model('catalog/product');
        if(isset($data['product'])) {
            foreach ($data['product'] as $product) {
                $exists = $this->db->query("SELECT op.product_id, op.quantity,p.cost,op.discount,p.free_shipping,op.tax,p.tax_class_id
												 FROM " . $this->db->table("order_products") . " op
												 LEFT JOIN ". $this->db->table("products"). " p on p.product_id=op.product_id
												 WHERE op.order_id = '" . (int)$order_id . "'
													    AND op.product_id='" . (int)$product_id . "'
													    AND op.order_product_id = '" . (int)$order_product_id . "'");
                $exist = $exists->row;
                if($exist){
                    continue;
                } else {
                    $product_query = $this->db->query(
                        "SELECT *, p.product_id
							 FROM " . $this->db->table("products") . " p
							 LEFT JOIN " . $this->db->table("product_descriptions") . " pd
							    ON (p.product_id = pd.product_id AND pd.language_id=" . $this->language->getContentLanguageID() . ")
							 WHERE p.product_id='" . (int)$product_id . "'");
                    $this->db->query("UPDATE ".$this->db->table("order_products"). " SET cost = ".$this->db->escape(preformatFloat($product_query->row['cost'], $this->language->get('decimal_point')))." WHERE product_id = " . (int)$product_id);

                    $po_ids = [];
                    if ($product['option']) {
                        foreach ($product['option'] as $k => $option) {
                            $po_ids[] = (int)$k;
                        }
                        //get all data of given product options from db
                        $sql = "SELECT *, pov.product_option_value_id, povd.name as option_value_name,pov.cost as cost, pod.name as option_name
								FROM " . $this->db->table('product_options') . " po
								LEFT JOIN " . $this->db->table('product_option_descriptions') . " pod
									ON (pod.product_option_id = po.product_option_id AND pod.language_id=" . $this->language->getContentLanguageID() . ")
								LEFT JOIN " . $this->db->table('product_option_values') . " pov
									ON po.product_option_id = pov.product_option_id
								LEFT JOIN " . $this->db->table('product_option_value_descriptions') . " povd
								    ON (povd.product_option_value_id = pov.product_option_value_id AND povd.language_id=" . $this->language->getContentLanguageID() . ")
								WHERE po.product_option_id IN (" . implode(',', $po_ids) . ")
								ORDER BY po.product_option_id";

                        $result = $this->db->query($sql);

                        $elements_with_options = HtmlElementFactory::getElementsWithOptions();
                        $exclude_list = [];
                        $option_value_info = [];
                        foreach ($result->rows as $row) {
                            //skip files
                            if (in_array($row['element_type'], ['U'])) {
                                $exclude_list[] = (int)$row['product_option_value_id'];
                            }
                            $option_value_info[$row['product_option_id'] . '_' . $row['product_option_value_id']] = $row; //compond key for cases when val_id is null
                            $option_types[$row['product_option_id']] = $row['element_type'];
                        }

                        foreach ($product['option'] as $opt_id => $values) {
                            if (!is_array($values)) { // for non-multioptional elements
                                //do not save empty inputs and texareas
                                if (in_array($option_types[$opt_id], ['I', 'T']) && $values == '') {
                                    continue;
                                } elseif ($option_types[$opt_id] == 'S') {
                                    $values = [$values];
                                } else {
                                    foreach ($option_value_info as $o) {
                                        if ($o['product_option_id'] === $opt_id) {
                                            if (!in_array($option_types[$opt_id], $elements_with_options)) {
                                                $option_value_info[$o['product_option_id'] . '_' . $o['product_option_value_id']]['option_value_name'] = $values;
                                            }
                                            $values = [$o['product_option_value_id']];
                                            break;
                                        }
                                    }
                                }
                            }
                            foreach ($values as $value) {
                                $order_product_ids = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " WHERE order_id=" . (int)$order_id . " AND product_id=" . (int)$product_id);
                                $order_product_id = $order_product_ids->row;
                                $arr_key = $opt_id . '_' . $value;
                                $sql = "UPDATE " . $this->db->table('order_options') . " SET `cost` = " . $this->db->escape($option_value_info[$arr_key]['cost']) . " WHERE order_product_id=" . $order_product_id['order_product_id'] . " 
                                    AND product_option_value_id=" . (int)$value;
                                $this->db->query($sql);
                            }
                        }
                    }
                }
            }
        }
    }

    public function editOrderOption($order_id,$data) {
        $order_id = (int)$order_id;
        foreach ($data as $options) {
            if ($options) {
                foreach ($options as $option) {
                    $this->db->query("UPDATE ".$this->db->table("order_options"). " SET `cost`=".$option['cost']." WHERE `product_option_value_id`=".$option['product_option_value_id']." AND `order_id`=".(int)$order_id);
                }
            }
        }
    }

    /**
     * @param int $order_id
     * @param int $order_product_id
     *
     * @return array
     */
    public function getOrderProducts($order_id, $order_product_id = 0) {
        $query = $this->db->query("SELECT *
									FROM ".$this->db->table("order_products")."
									WHERE order_id = '".(int)$order_id."'
									".((int)$order_product_id ? " AND order_product_id='".(int)$order_product_id."'" : ''));
        return $query->rows;
    }

    public function updateOrderProductTax($order_id,$product_id,$tax) {
        $this->db->query("UPDATE ".$this->db->table("order_products")." SET tax=".(float)$tax." WHERE order_id=".(int)$order_id." AND product_id=".(int)$product_id);
    }
}