<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelAdvancedReportsSale
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 * @property ModelBuildAGiftOrder $model_build_a_gift_order
 */

class ModelAdvancedReportsSale extends Model {

    public $data = [];
    private $error = [];

    /**
     * This is for Sales By Category Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByCategory( $data = []) {
        $report_period = isset($data['report_period'])?$data['report_period']:'month';
        $select_datefield = ' CONCAT(MONTH(o.date_added),"/",YEAR(o.date_added)) AS datefield';
        switch ($report_period) {
            case 'day':
                $select_datefield = 'DATE(o.date_added) AS datefield';
                break;
            case 'week':
                $select_datefield = 'CONCAT(YEAR(o.date_added),"0",WEEK(o.date_added)) AS datefield';
                break;
            case 'quarter':
                $select_datefield = 'CONCAT(QUARTER(o.date_added),"/",YEAR(o.date_added)) AS datefield';
                break;
            case 'year':
                $select_datefield = 'YEAR(o.date_added) AS datefield';
                break;
        }

        if ($this->validateTaxjar()) {
            $get_tax = "ROUND((SELECT ROUND(ott.value,2) FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'taxjar_integration') OR (ott.order_id = o.order_id AND ott.type='tax') ),2) order_tax,";
        } elseif ($this->config->get('avatax_integration_status') === '1') {
            $get_tax = "ROUND((SELECT ROUND(ott.value,2) FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'avatax_integration') OR (ott.order_id = o.order_id AND ott.type='tax') ),2) order_tax,";
        } else {
            $get_tax = "ROUND((SELECT ROUND(ott.value,2) FROM " . $this->db->table("order_totals") . " ott WHERE ott.order_id = o.order_id AND ott.type = 'tax' ),2) order_tax,";
        }

        $details = "SELECT " . $select_datefield . ",op.product_id,o.order_id,o.coupon_id,p.tax_class_id,
                op.total,op.tax,op.discount,op.order_product_id as order_product_id,
                p.tax_class_id,op.tax as tax,op.product_coupon as product_coupon,op.certain_product as certain_product,
                (SELECT COUNT(*) FROM " . $this->db->table("order_products") . " ot WHERE ot.order_id=o.order_id) total_products,".$get_tax."
				ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE ott.order_id = o.order_id AND ott.type = 'discount' ),2) order_discount,
				ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE ott.order_id = o.order_id AND ott.type = 'subtotal' ),2) order_subtotal
				FROM " . $this->db->table("products_to_categories") . " pc
				LEFT JOIN " . $this->db->table("category_descriptions") . " cd ON cd.category_id = pc.category_id
				LEFT JOIN " . $this->db->table("products") . " p on p.product_id = pc.product_id
				LEFT JOIN " . $this->db->table("order_products") . " op on op.product_id = p.product_id
				LEFT JOIN " . $this->db->table("orders") . " o on o.order_id = op.order_id
				LEFT JOIN " . $this->db->table("categories") . " c on c.category_id = cd.category_id
				WHERE cd.language_id = '" . (int)$this->session->data['content_language_id'] . "' AND c.category_id='" . $data['filter_category_id'] . "'";

        if (!empty($data['filter_date_start'])) {
            $details .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $details .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $results = $this->db->query($details);
        $res = $results->rows;
        $rows = $tax_rates = [];
        $taxes = [];
        foreach ($res as $k => $v) {
            $disc = (float)$v['discount'];
            $product_id = $v['product_id'];
            $order_product_id = $v['order_product_id'];
            $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$v['order_id'] . "' ORDER BY order_product_id ASC");
            $order_product_ids = $queryOrderProducts->rows;
            $last_order_product_ids = end($order_product_ids);
            $last_order_product_id = $last_order_product_ids['order_product_id'];
            $query_order_subtotal = $this->db->query("SELECT ROUND(value,2) as order_subtotal FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='subtotal'");
            $order_subtotal = $query_order_subtotal->row['order_subtotal'];
            $query_order_discount = $this->db->query("SELECT ROUND(value,2) as order_discount FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='discount'");
            $order_discount = $query_order_discount->row['order_discount'];
            $query_order_shipping = $this->db->query("SELECT ROUND(value,2) as order_shipping FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='shipping'");
            $order_shipping = $query_order_shipping->row['order_shipping'];

            if ($this->validateTaxjar()) {
                $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='taxjar_integration') or (order_id='" . $v['order_id'] . "' AND type='tax')");
            } elseif ($this->config->get('avatax_integration_status') === '1') {
                $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='avatax_integration') or (order_id='" . $v['order_id'] . "' AND type='tax')");
            } else {
                $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='tax'");
            }

            $order_tax = $query_order_tax->row['order_tax'];

            if ($v['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                if ($v['tax'] != '0.0000') {
                    if ($v['product_coupon'] === '' && $v['certain_product'] === '') {
                        $count = $v['total'] / $order_subtotal;

                        if ($count == '1') {
                            $amount = $order_tax;
                        } else {
                            if ($order_product_id !== $last_order_product_id) {
                                if (empty($v['tax'])) {
                                    continue;
                                }
                                $disc_cost = explode('.', $order_discount);
                                $ship_cost = explode('.', $order_shipping);
                                $discCost = $disc_cost[1];
                                $shipCost = $ship_cost[1];

                                if ($discCost == $shipCost) {
                                    $tax_rates = round(($v['total'] / $order_subtotal) * ($order_tax / $v['total_products']), 4);
                                    $amount = $this->rounding($tax_rates);
                                    $tax_total[$v['order_id']][] = $amount;
                                } else {
                                    $tax_rates = round(($v['total'] / $order_subtotal) * $order_tax, 4);
                                    $amount = $this->rounding($tax_rates);
                                    $tax_total[$v['order_id']][] = $amount;
                                }
                                $ttl = array_sum($tax_total[$v['order_id']]);
                                $taxes[$v['order_id']][] = $ttl;
                            } elseif ($order_product_id == $last_order_product_id) {
                                //$ttl_taxes = ;

                                if (sizeof((array)$taxes[$v['order_id']]) > 0) {
                                    $tax_rate = end($taxes[$v['order_id']]);
                                } else {
                                    $tax_rate = $taxes[$v['order_id']];
                                }
                                $amount = $order_tax - $tax_rate;
                            }
                        }

                        $tax_amount = $amount;
                    } else {
                        $tax_amount = $v['tax'];
                    }
                } else {
                    $tax_amount = '0';
                }
            } else {
                $tax_amount = '0';
            }

            $rates[$v['datefield']][] = round($tax_amount, 2);
        }

        if ($rates) {
            foreach ($rates as $k => $v) {
                $ttl = array_sum($v);
                $rows[$k] = $ttl;
            }
        }

        $sql = "SELECT " . $select_datefield . ", sum(op.quantity) items_ordered, sum(op.total) total
				FROM " . $this->db->table("products_to_categories") . " pc
				LEFT JOIN " . $this->db->table("category_descriptions") . " cd ON cd.category_id = pc.category_id
				LEFT JOIN " . $this->db->table("order_products") . " op on op.product_id = pc.product_id
				LEFT JOIN " . $this->db->table("orders") . " o on o.order_id = op.order_id
				LEFT JOIN " . $this->db->table("categories") . " c on c.category_id = cd.category_id
				WHERE cd.language_id = '" . (int)$this->session->data['content_language_id'] . "' AND c.category_id='" . $data['filter_category_id'] . "'";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= "  GROUP BY datefield ORDER BY datefield";

        $query = $this->db->query($sql);
        $sales = $query->rows;
        $reports = [];
        foreach ($sales as $key => $row) {
            $row['items_ordered'] = $row['items_ordered'];
            $row['tax'] = $rows[$row['datefield']];
            $row['total'] = $row['total'];
            $reports[$row['datefield']] = $row;
        }

        return $reports;
    }

    /**
     * This is for Earnings Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getEarningsReport( $data = []) {
        $where = "";
        $base_where = "";
        $filter_year = isset($data['filter_year'])?$data['filter_year']: "";
        $filter_month = isset($data['filter_month'])?$data['filter_month']: "";
        $filter_day = isset($data['filter_day'])?$data['filter_day']: "";

        $select_datefield_year = $filter_datefield_year = $select_datefield_month = $filter_datefield_month = $select_datefield_date = $filter_datefield_date = "";

        $group = "datefield";
        $order = "datefield";

        if ($filter_year) {
            $select_datefield = ', MONTH(o.date_added) AS `datefield`';
            $filter_datefield_year = " AND YEAR(o.date_added) = '" . $filter_year . "'";
            $filter_datefield = ' MONTH(o.date_added) ';
        } else {
            $select_datefield = ', YEAR(o.date_added) AS `datefield`';
            $filter_datefield = ' YEAR(o.date_added) ';
        }

        if ($filter_month) {
            $select_datefield = ', DAY(o.date_added) AS `datefield`';
            $filter_datefield_month = " AND MONTH(o.date_added) ='" . $filter_month . "'";
            $filter_datefield = ' DAY(o.date_added) ';
        }

        if ($filter_day) {
            $select_datefield = ', HOUR(o.date_added) `datefield`';
            $filter_datefield_date = " AND DAY(o.date_added) = '" . $filter_day . "'";
            $filter_datefield = ' HOUR(o.date_added) ';
        }


        $sql1 = "SELECT COUNT(o.order_id) `number_orders`, SUM(ROUND(ot.value,2)) as `subtotal`, o.date_added" . $select_datefield . " 
                    FROM " . $this->db->table("orders") . " o 
                    LEFT JOIN " . $this->db->table("order_totals") . " ot ON ot.order_id=o.order_id";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id." AND ot.type='total'";
        $base_where .= " AND o.store_id = ".$store_id;

        $where .= $filter_datefield_year . $filter_datefield_month . $filter_datefield_date;
        $base_where .= $filter_datefield_year . $filter_datefield_month . $filter_datefield_date;

        $sql1 .= $where;

        $sql1 .= " GROUP BY " . $group . " ORDER BY " . $order;

        $query = $this->db->query($sql1);

        $reports = [];

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {

                $rows['datefield'] = $row['datefield'];
                $rows['number_orders'] = $row['number_orders'];

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`, SUM(op.total) as `total`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE " . $filter_datefield . "='" . $row['datefield'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                $rows['subtotal'] = $row['subtotal'];

                $reports[$row['datefield']] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Profit Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getProfit( $data = [])  {
        $where = "";
        $base_where = "";

        $select_datefield = 'DATE(o.date_added) AS datefield';
        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $this->load->model('advanced_reports/verify');
        $build_a_gift_status = $this->model_advanced_reports_verify->verifyBuildAGift();

        $sql = "SELECT " . $select_datefield . ", o.order_id, o.date_added AS order_date,op.quantity as quantity,
                    IFNULL(SUM(op.price * op.quantity), 0) as subtotal,
                    IFNULL(SUM(op.discount), 0) as discount,
                    IFNULL(SUM(op.cost * op.quantity),0) as cost,
                    IFNULL(SUM(p.cost * op.quantity),0) as cost2,
                    o.currency,op.order_product_id
					FROM " . $this->db->table("orders") . " o
					LEFT JOIN " . $this->db->table("order_products") . " op ON op.order_id = o.order_id
					LEFT JOIN " . $this->db->table("products") . " p ON op.product_id = p.product_id";

        $sql .= $where;
        $sql .= " GROUP BY o.order_id ORDER BY o.order_id";
        $query = $this->db->query($sql);
        $reports = [];
        $i = 0;
        if ($query->num_rows > 0) {
            /*query get order info*/
            $sales = $query->rows;
            $this->load->model('sale/order');
            foreach ($sales as $key => $r) {
                $sql = "SELECT oo.order_id, oo.cost, op.quantity,aroo.option_sort_order as option_sort_order,aroo.is_default as option_default
									FROM " . $this->db->table("order_options") . " oo
									LEFT JOIN " . $this->db->table("product_option_values") . " pov ON oo.product_option_value_id = pov.product_option_value_id
									LEFT JOIN " . $this->db->table("product_options") . " po ON pov.product_option_id = po.product_option_id
									LEFT JOIN " . $this->db->table("order_products") . " op ON oo.order_product_id=op.order_product_id
									LEFT JOIN " . $this->db->table("advanced_reports_order_options") . " aroo ON aroo.order_product_id=op.order_product_id AND aroo.product_option_value_id = oo.product_option_value_id
									WHERE oo.order_id = '" . (int)$r['order_id'] . "'";
                $query = $this->db->query($sql);

                $options = $query->rows;
                $i++;
                $row['number'] = $i;
                $row['datefield'] = $r['datefield'];
                $row['order_id'] = $r['order_id'];
                $row['subtotal'] = (float)$r['subtotal'];
                $row['quantity'] = (float)$r['quantity'];
                $query_discount = $this->db->query("SELECT ot.title as coupon_name,ROUND(ot.value,2) as `discount` FROM " . $this->db->table("order_totals") . " ot
                       LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE ot.order_id='" . (int)$r['order_id'] . "' AND ot.type = 'discount'" . $base_where);
                $total_discount = (float)$query_discount->row['discount'];
                $product_discount = (float)$r['discount'];
                if ($total_discount && $product_discount !== '0.0000') {
                    $row['discount'] = $total_discount;
                } else {
                    $row['discount'] = $product_discount;
                }
                $coupon_name = $query_discount->row['coupon_name'];
                if ($coupon_name === '' || is_null($coupon_name) || empty($coupon_name)) {
                    $row['coupon_name'] = '-';
                } else {
                    $row['coupon_name'] = str_replace(':', '', $coupon_name);
                }
                $sql = "SELECT order_product_id,cost,product_id,quantity FROM ".$this->db->table("order_products") . " WHERE order_id =".(int)$r['order_id'];
                $query = $this->db->query($sql);
                $order_product_ids = $query->rows;
                $cost=0;
                foreach ($order_product_ids as $order_product_id) {
                    if ($build_a_gift_status) {
                        $query = $this->db->query("SELECT COUNT(*) as total FROM " . $this->db->table("build_a_gift_order") . " WHERE order_id=" . (int)$r['order_id'] . " AND product_id =".(int)$order_product_id['product_id']);
                        $exist = $query->row['total'];
                        if ($exist > 0) {
                            continue;
                        }
                    }
                    $sql2 = "SELECT COUNT(*) as has_options FROM " . $this->db->table("order_options") . " WHERE order_product_id =" . $order_product_id['order_product_id'];
                    $query2 = $this->db->query($sql2);
                    $has_options = $query2->row['has_options'];
                    if ($has_options === '0') {
                        $cost += ($order_product_id['cost'] * $order_product_id['quantity']);
                    } else {
                        $sql3 = "SELECT aroo.option_sort_order as option_sort_order,aroo.is_default as option_default,oo.cost FROM " . $this->db->table("advanced_reports_order_options") . " aroo 
                                LEFT JOIN " . $this->db->table("order_options") . " oo ON oo.order_product_id = aroo.order_product_id AND oo.product_option_value_id = aroo.product_option_value_id 
                                WHERE aroo.order_product_id=" . $order_product_id['order_product_id'];
                        $query3 = $this->db->query($sql3);
                        $results = $query3->rows;
                        foreach ($results as $result) {
                            if ($result['option_sort_order'] < '3' && $result['cost']==='0.0000') {
                                $cost += ($order_product_id['cost'] * $order_product_id['quantity']);
                            }
                        }
                    }
                };

                if ($build_a_gift_status) {
                    $query = $this->db->query("SELECT SUM(total_cost) as total_cost FROM " . $this->db->table("build_a_gift_order") . " WHERE order_id=" . (int)$r['order_id']);
                    $total_cost = $query->row['total_cost'];
                    $cost += (float)$total_cost;
                    $r['cost2'] += (float)$total_cost;
                } 
                $row['cost'] = (float)$cost;
                $row['cost2'] = (float)$r['cost'];
                $row['option'] = $options;
                $reports[$row['number']] = $row;
            }
        }

        return $reports;
    }

    /**
     * This is for Sale By Country Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByCountry($data = []) {

        $sql = "SELECT  o.payment_country `country_name`, COUNT(o.order_id) order_quantity,
                    IFNULL(SUM(ROUND(o.total,2)),0) AS order_totals, c.iso_code_2 `country_code`, o.payment_country_id `country_id`, o.order_status_id
					FROM " . $this->db->table("orders") . " o
					LEFT JOIN " . $this->db->table("countries") . " c ON (o.payment_country_id = c.country_id)
					WHERE 1";


        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.payment_country ORDER BY order_totals DESC";

        $query = $this->db->query($sql);

        $reports = [];
        if ($query->num_rows > 0) {
            $sales = $query->rows;
            $i = 0;
            foreach ($sales as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['country_name'] = $row['country_name'];
                $rows['order_quantity'] = $row['order_quantity'];
                $rows['order_totals'] = $row['order_totals'];
                $rows['country_code'] = $row['country_code'];
                $rows['country_id'] = $row['country_id'];
                $rows['order_status_id'] = $row['order_status_id'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Sales By Coupon Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByCoupon( $data = []) {

        $where = "";
        $base_where = "";

        $sql1 = "SELECT COUNT(o.order_id) `number_orders`, o.date_added, coupon_id 
                     FROM " . $this->db->table("orders") . " o 
                     LEFT JOIN " . $this->db->table("order_products") . " op ON (op.order_id = o.order_id )
                     LEFT JOIN " . $this->db->table("order_totals") . " ot ON (ot.order_id = o.order_id )
                     ";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY `coupon_id` ORDER BY `coupon_id`";

        $query = $this->db->query($sql1);

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $query_coupon = $this->db->query("SELECT c.code as `code`, cd.name as `name` FROM " . $this->db->table("coupons") . " c 
                    LEFT JOIN " . $this->db->table("coupon_descriptions") . " cd ON (c.coupon_id = cd.coupon_id 
                    AND cd.language_id = '" . (int)$this->config->get('storefront_language_id') . "' )
                    WHERE c.coupon_id ='" . $row['coupon_id'] . "'");
                $coupon_code = $query_coupon->row['code'];
                $coupon_name = $query_coupon->row['name'];
                if (!$coupon_code) {
                    continue;
                }
                $row['items_ordered'] = $row['total'] = $row['tax'] = $row['shipping'] = 0;

                /* Get number of orders */
                $query_products = $this->db->query("SELECT COUNT(o.order_id) `number_orders`
						 FROM " . $this->db->table("orders") . " o 
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "'" . $base_where);
                if ($query_products->num_rows > 0) {
                    $row['number_orders'] = $query_products->row['number_orders'];
                }

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`
						 FROM " . $this->db->table("order_products") . " op
						 LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=op.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $row['items_ordered'] = $query_products->row['items_ordered'];
                }

                /* Get subtotal */
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` 
                         FROM " . $this->db->table("order_totals") . " ot
						 LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'subtotal'" . $base_where);
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total shipping*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
						 LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'shipping'" . $base_where);
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot
							LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'discount'" . $base_where);
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
							LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE (o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'taxjar_integration') OR (o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
							LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE (o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'avatax_integration') OR (o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
							LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'tax'" . $base_where);
                }

                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot
							LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id=ot.order_id)
						 WHERE o.coupon_id = '" . $row['coupon_id'] . "' AND ot.type = 'total'" . $base_where);

                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }


                $row['coupon_code'] = $coupon_code;
                $row['coupon_name'] = $coupon_name;
                $reports[$coupon_code] = $row;
            }
        }

        return $reports;
    }

    /**
     * This is for Sale By Day Week Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByDayWeek( $data = [] ) {

        $sql = "SELECT WEEKDAY(o.date_added) AS week_day,
				COUNT(o.order_id) AS `quantity`, SUM(ROUND(ot.value,2)) AS total
				FROM " . $this->db->table("orders") . " o
                LEFT JOIN " . $this->db->table("order_totals") . " ot on ot.order_id=o.order_id";

        $sql .= " WHERE 1 ";
        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id." AND ot.type='total'";

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY week_day ORDER BY week_day";

        $query = $this->db->query($sql);
        $reports = $query->rows;

        return $reports;
    }

    /**
     * This is for Sale By Hour Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByHour( $data = [] ) {

        $sql = "SELECT date_format(o.date_added, '%H:00') as the_hour,
					COUNT(o.order_id) AS `quantity`, SUM(ROUND(ot.value,2)) AS total
					FROM " . $this->db->table("orders") . " o
                    LEFT JOIN " . $this->db->table("order_totals") . " ot ON ot.order_id=o.order_id";

        $sql .= " WHERE 1 ";
        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id." AND ot.type='total'";

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY the_hour ORDER BY the_hour";

        $query = $this->db->query($sql);

        $reports = $query->rows;

        return $reports;
    }

    /**
     * This is for Sales By Manufacturer Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByManufacturer( $data = []) {

        $where = "1 ";
        $order = isset($data['order']) ? $data['order'] : 'manufacturer';
        $sort = isset($data['sort']) ? $data['sort'] : 'ASC';

        $query = "SELECT o.order_id, op.total as total,
                          op.product_id,op.order_product_id as order_product_id,op.tax as tax,op.certain_product as certain_product,m.manufacturer_id
                          FROM " . $this->db->table("orders") . " o
                          LEFT JOIN " . $this->db->table("order_products") . " op ON op.order_id = o.order_id
                          LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
                          LEFT JOIN " . $this->db->table("manufacturers") . " m ON m.manufacturer_id = p.manufacturer_id
						  ";
        if (!empty($data['filter_date_start'])) {
            $query .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $query .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }
        $query .= " ORDER BY m.manufacturer_id ASC,op.order_product_id ASC";
        $queries = $this->db->query($query);

        $res = $queries->rows;
        $row = $rows = [];
        $taxes = [];
        if ($queries->num_rows > 0) {
            foreach ($res as $k => $v) {
                $order_product_id = $v['order_product_id'];
                $manufacturer_id = $v['manufacturer_id'];
                $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$v['order_id'] . "' ORDER BY order_product_id ASC");
                $order_product_ids = $queryOrderProducts->rows;
                $last_order_product_ids = end($order_product_ids);
                $last_order_product_id = $last_order_product_ids['order_product_id'];

                $query_order_subtotal = $this->db->query("SELECT ROUND(value,2) as order_subtotal FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='subtotal'");
                $order_subtotal = $query_order_subtotal->row['order_subtotal'];
                $query_order_discount = $this->db->query("SELECT ROUND(value,2) as order_discount FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='discount'");
                $order_discount = $query_order_discount->row['order_discount'];
                $query_order_shipping = $this->db->query("SELECT ROUND(value,2) as order_shipping FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='shipping'");
                $order_shipping = $query_order_shipping->row['order_shipping'];

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='taxjar_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax')");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='avatax_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax')");
                } else {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='tax'");
                }

                $order_tax = $query_order_tax->row['order_tax'];
                if ($v['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                    if ($v['tax'] != '0.0000') {
                        if ($v['certain_product'] === '') {
                            $count = $v['total'] / $order_subtotal;

                            if ($count == '1') {
                                $amount = $order_tax;
                            } else {
                                if ($order_product_id !== $last_order_product_id) {
                                    $disc_cost = explode('.', $order_discount);
                                    $ship_cost = explode('.', $order_shipping);
                                    $discCost = $disc_cost[1];
                                    $shipCost = $ship_cost[1];
                                    if ($discCost == $shipCost && isset($v['total_products'])) {
                                        $tax_rates = round(($v['total'] / $order_subtotal) * ($order_tax / $v['total_products']), 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$v['order_id']][] = $amount;
                                    } else {
                                        $tax_rates = round(($v['total'] / $order_subtotal) * $order_tax, 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$v['order_id']][] = $amount;
                                    }
                                    $ttl = array_sum($tax_total[$v['order_id']]);
                                    $taxes[$v['order_id']][] = $ttl;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    //$ttl_taxes = ;
                                    if (sizeof((array)$taxes[$v['order_id']]) > 0) {
                                        $tax_rate = end($taxes[$v['order_id']]);
                                    } else {
                                        $tax_rate = $taxes[$v['order_id']];
                                    }
                                    $amount = $order_tax - $tax_rate;
                                }
                            }

                            $tax_amount = $amount;
                        } else {
                            $tax_amount = round($v['tax'], 2);
                        }

                    } else {
                        $tax_amount = '0';
                    }
                    $total = $v['total'];
                } else {
                    $tax_amount = '0';
                    $total = '0';
                }
                $row[$manufacturer_id]['taxes'][] = $tax_amount;
                $row[$manufacturer_id]['total'][] = $total;

            }
        }

        if ($row) {
            foreach ($row as $k => $v) {
                $taxes[$k]['taxes'][] = array_sum($v['taxes']);
                $totals[$k]['total'][] = array_sum($v['total']);
            }
        }

        $sql = " SELECT m.name manufacturer, m.manufacturer_id,COUNT(op.order_id) number_orders, SUM(op.quantity) items_ordered, 
                SUM(ROUND(op.total,2)) total
				FROM " . $this->db->table("manufacturers") . " m
				LEFT JOIN " . $this->db->table("products") . " p on p.manufacturer_id = m.manufacturer_id
				LEFT JOIN " . $this->db->table("order_products") . " op on op.product_id = p.product_id
				LEFT JOIN " . $this->db->table("orders") . " o on o.order_id = op.order_id
				WHERE p.manufacturer_id > 0	";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN(" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY manufacturer ORDER BY " . $order . " " . $sort;

        $query = $this->db->query($sql);

        $results = $query->rows;
        $reports = [];
        foreach ($results as $k => $v) {
            $rowS['manufacturer'] = $v['manufacturer'];
            $rowS['number_orders'] = $v['number_orders'];
            $rowS['items_ordered'] = $v['items_ordered'];
            $rowS['tax'] = $taxes[$v['manufacturer_id']]['taxes'][0];
            $rowS['total'] = $totals[$v['manufacturer_id']]['total'][0];
            $reports[] = $rowS;
        }

        return $reports;
    }

    /**
     * This is for Sale Order Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleOrder( $data = []) {
        $where = "";
        $base_where = "";
        $report_period = isset($data['report_period'])?$data['report_period']:'month';

        $select_datefield = ' CONCAT(MONTH(o.date_added),"/",YEAR(o.date_added)) AS datefield';
        $filter_datefield = ' CONCAT(MONTH(o.date_added),"/",YEAR(o.date_added)) ';
        switch ($report_period) {
            case 'day':
                $select_datefield = 'DATE(o.date_added) AS datefield';
                $filter_datefield = ' DATE(o.date_added) ';
                break;
            case 'week':
                $select_datefield = 'CONCAT(YEAR(o.date_added),"0",WEEK(o.date_added)) AS datefield';
                $filter_datefield = ' CONCAT(YEAR(o.date_added),"0",WEEK(o.date_added)) ';
                break;
            case 'quarter':
                $select_datefield = 'CONCAT(QUARTER(o.date_added),"/",YEAR(o.date_added)) AS datefield';
                $filter_datefield = ' CONCAT(QUARTER(o.date_added),"/",YEAR(o.date_added)) ';
                break;
            case 'year':
                $select_datefield = 'YEAR(o.date_added) AS datefield';
                $filter_datefield = ' YEAR(o.date_added) ';
                break;
        }

        $sql1 = "SELECT " . $select_datefield . ", COUNT(o.order_id) `number_orders`  
            FROM " . $this->db->table("orders") . " o";
        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY datefield ORDER BY datefield";
        $query = $this->db->query($sql1);
        $reports = [];

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {

                /*Get ordered items and total*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`,op.product_id as `product_id`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "'" . $base_where);
                $row['items_ordered'] = $query_products->row['items_ordered'];

                /* Get Subtotal */
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'subtotal'" . $base_where);
                $row['subtotal'] = $query_subtotal->row['subtotal'];

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE (" . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'taxjar_integration') OR (" . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE (" . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'avatax_integration') OR (" . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'tax'" . $base_where);
                }

                $row['tax'] = $query_tax->row['tax'];

                /*Get shipping rates*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'shipping'" . $base_where);
                $row['shipping'] = $query_shipping->row['shipping'];

                /*Get discount*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'discount'" . $base_where);
                $total_discount = $query_discount->row['discount'];
                $row['discount'] = $total_discount;

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot  
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "' AND ot.type = 'total'" . $base_where);
                $row['total'] = $query_total->row['total'];

                $row['product_id'] = $query_products->row['product_id'];

                $reports[$row['datefield']] = $row;
            }
        }

        return $reports;
    }

    /**
     * This is for Sale By Payment Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByPayment( $data = []) {

        $where = "";
        $base_where = "";

        $sql1 = "SELECT o.order_id, COUNT(o.order_id) `number_orders`,
            COUNT(DISTINCT o.customer_id) `customers`, o.date_added,
            TRIM(o.payment_method) as `payment_method`, o.payment_method
            FROM " . $this->db->table("orders") . " o ";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY `payment_method` ORDER BY `payment_method`";

        $query = $this->db->query($sql1);

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $rows['payment_method'] = trim($row['payment_method']);
                if (!$rows['payment_method']) {
                    continue;
                }

                $rows['number_orders'] = $row['number_orders'];

                /*Get number products*/
                $query_products = $this->db->query("SELECT op.order_id,SUM(op.quantity) as `items_ordered`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                /*Get subtotal*/
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'subtotal'" . $base_where);
                if ($query_subtotal->num_rows > 0) {
                    $rows['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total shipping*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'shipping'" . $base_where);
                if ($query_shipping->num_rows > 0) {
                    $rows['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot
                                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					                WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'discount'" . $base_where);
                if ($query_discount->num_rows > 0) {
                    $rows['discount'] = $query_discount->row['discount'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'taxjar_integration') OR (TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'avatax_integration') OR (TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'tax'" . $base_where);
                }

                if ($query_tax->num_rows > 0) {
                    $rows['tax'] = $query_tax->row['tax'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_method) = '" . $row['payment_method'] . "' AND ot.type = 'total'" . $base_where);
                if ($query_total->num_rows > 0) {
                    $rows['total'] = $query_total->row['total'];
                }
                $rows['order_id'] = $row['order_id'];
                $rows['customers'] = $row['customers'];
                $rows['date_added'] = $row['date_added'];
                $reports[$rows['payment_method']] = $rows;
            }
        }

        return $reports;
    }

    /**
     * @param array $data
     * @return array|false|mixed
     * @throws AException
     */
    public function getSaleProfit( $data = [] ) {
        $where = " ";

        $report_period = isset($data['report_period']) ? $data['report_period'] : 'day';
        if ($report_period == 'day') {
            $select_datefield = 'DATE(o.date_added) AS datefield';
        }
        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN(" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();

        $where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $filter_date = " WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $filter_date .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $this->load->model('advanced_reports/verify');
        $build_a_gift_status = $this->model_advanced_reports_verify->verifyBuildAGift();

        //need to add build a gift cost
        $sql = "SELECT " . $select_datefield . ",o.order_id, CONCAT(o.invoice_prefix,'',o.invoice_id) AS invoice_id, 
                         o.date_added AS order_date, p.model,
                          o.email as customer_email, o.payment_company as `customer_company`, 
                          cgd.name as custom_group_name, o.payment_country as `country`,
                          o.payment_zone `region`, o.payment_city `city`, o.payment_postcode `zipcode`,
                          op.name AS product_name, m.name as `manufacturer`, op.quantity as quantity, 
                          op.price,IFNULL(arop.original_price,p.price) as original_price,
                          op.total as total, op.discount as discount,
                          op.cost as cost,
                          p.cost as cost2,
                          op.product_id,op.order_product_id as order_product_id,o.currency,o.coupon_id as coupon_id,
                          p.tax_class_id,op.tax as tax,op.product_coupon as product_coupon,op.certain_product as certain_product,
                          (SELECT COUNT(*) FROM " . $this->db->table("order_products") . " ot WHERE ot.order_id=o.order_id) total_products
                          FROM " . $this->db->table("orders") . " o
						  LEFT JOIN " . $this->db->table("order_products") . " op ON op.order_id = o.order_id
						  LEFT JOIN " . $this->db->table("advanced_reports_order_products") . " arop ON arop.order_id = o.order_id and arop.product_id = op.product_id
						  LEFT JOIN " . $this->db->table("customer_groups") . " cgd ON cgd.customer_group_id = o.customer_group_id
						  LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
						  LEFT JOIN " . $this->db->table("manufacturers") . " m ON m.manufacturer_id = p.manufacturer_id
						  ";
        $sql .= $where;

        $sql .= " ORDER BY o.order_id ASC,op.order_product_id ASC";
        $query = $this->db->query($sql);
        if ($query->num_rows > 0) {
            /*query get order info*/
            $sales = $query->rows;
            $this->load->model('sale/order');
            $disc_total = [];
            $taxes = [];
            $discs = [];
            foreach ($sales as $key => $r) {
                //'model_filter' not working;
                if (!empty($data['filter_model']) && $r['model'] !== '') {
                    $modelPos = strpos($r['model'], $data['filter_model']);
                    if ($modelPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_model']) && $r['model'] == '') {
                    continue;
                }

                if (!empty($data['filter_customer_email'])) {
                    $countryPos = strpos($r['customer_email'], html_entity_decode($this->db->escape($data['filter_customer_email'])));
                    if ($countryPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_customer_company']) && $r['customer_company'] !== '') {
                    $countryPos = strpos($r['customer_company'], html_entity_decode($this->db->escape($data['filter_customer_company'])));
                    if ($countryPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_customer_company']) && $r['customer_company'] == '') {
                    continue;
                }

                if (!empty($data['filter_country'])) {
                    $countryPos = strpos($r['country'], html_entity_decode($this->db->escape($data['filter_country'])));
                    if ($countryPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_region'])) {
                    $regionPos = strpos($r['region'], html_entity_decode($this->db->escape($data['filter_region'])));
                    if ($regionPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_city'])) {
                    $cityPos = strpos($r['city'], html_entity_decode($this->db->escape($data['filter_city'])));
                    if ($cityPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_zipcode']) && $r['zipcode'] !== '') {
                    $zipCodePos = strpos($r['zipcode'], $this->db->escape($data['filter_zipcode']));
                    if ($zipCodePos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_product_name']) && $r['product_name'] !== '') {
                    $productNamePos = strpos($r['product_name'], $data['filter_product_name']);
                    if ($productNamePos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_manufacturer']) && $r['manufacturer'] !== '') {
                    $manufacturerPos = strpos($r['manufacturer'], $data['filter_manufacturer']);
                    if ($manufacturerPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_manufacturer']) && $r['manufacturer'] == '') {
                    continue;
                }

                if ($build_a_gift_status) {
                    $query = $this->db->query("SELECT child_products FROM  " . $this->db->table("order_products") . " WHERE order_id=" . (int)$r['order_id'] . " AND order_product_id=" . (int)$r['order_product_id']);
                    $has_child = $query->row['child_products'];
                    if ($has_child) {
                        continue;
                    }
                }
                $product_id = $r['product_id'];
                $order_product_id = $r['order_product_id'];
                $disc = (float)$r['discount'];
                $sql2 = "SELECT oo.name as name,oo.value as value,oo.price as price,oo.cost as cost,po.sort_order as sort_order,
                                    aroo.original_price as option_original_price,aroo.price as option_selling_price,aroo.option_sort_order as option_sort_order,aroo.is_default as option_default
									FROM " . $this->db->table("order_options") . " oo
									LEFT JOIN " . $this->db->table("product_option_values") . " pov ON oo.product_option_value_id = pov.product_option_value_id
									LEFT JOIN " . $this->db->table("product_options") . " po ON pov.product_option_id = po.product_option_id
									LEFT JOIN " . $this->db->table("advanced_reports_order_options") . " aroo ON aroo.product_option_value_id = pov.product_option_value_id AND aroo.order_product_id = oo.order_product_id
									AND aroo.order_id = oo.order_id 
									WHERE oo.order_id = '" . (int)$r['order_id'] . "' AND oo.order_product_id = '" . (int)$r['order_product_id'] . "'";
                $query2 = $this->db->query($sql2);
                $row = $query2->rows;
                $total_row = $query2->num_rows;
                $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$r['order_id'] . "' ORDER BY order_product_id ASC");
                $order_product_ids = $queryOrderProducts->rows;
                $last_order_product_ids = end($order_product_ids);
                $last_order_product_id = $last_order_product_ids['order_product_id'];
                $query_coupon_name = $this->db->query("SELECT title as coupon_name FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='discount'");
                $coupon_name = $query_coupon_name->row['coupon_name'];
                $query_order_subtotal = $this->db->query("SELECT ROUND(value,2) as order_subtotal FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='subtotal'");
                $order_subtotal = $query_order_subtotal->row['order_subtotal'];
                $query_order_discount = $this->db->query("SELECT ROUND(value,2) as order_discount FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='discount'");
                $order_discount = $query_order_discount->row['order_discount'];
                $query_order_shipping = $this->db->query("SELECT ROUND(value,2) as order_shipping FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='shipping'");
                $order_shipping = $query_order_shipping->row['order_shipping'];

                if ($this->validateTaxjar()) {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $r['order_id'] . "' AND type='taxjar_integration')
                     or (order_id='" . $r['order_id'] . "' AND type='tax')");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $r['order_id'] . "' AND type='avatax_integration')
                     or (order_id='" . $r['order_id'] . "' AND type='tax')");
                } else {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='tax'");
                }

                $order_tax = $query_order_tax->row['order_tax'];
                $rows['product_id'] = $product_id;
                $rows['order_id'] = $r['order_id'];
                $rows['invoice_id'] = $r['invoice_id'];
                $rows['order_date'] = $r['order_date'];
                $rows['model'] = $r['model'];
                $rows['customer_email'] = $r['customer_email'];
                $rows['customer_company'] = $r['customer_company'];
                $rows['custom_group_name'] = $r['custom_group_name'];
                $rows['country'] = $r['country'];
                $rows['region'] = $r['region'];
                $rows['city'] = $r['city'];
                $rows['zipcode'] = $r['zipcode'];
                $rows['product_name'] = $r['product_name'];
                $rows['manufacturer'] = $r['manufacturer'];
                $rows['quantity'] = (int)$r['quantity'];
                $show_coupon = '';
                if ($r['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                    if ($r['tax'] !== '0.0000') {
                        if ($r['product_coupon'] === '' && $r['certain_product'] === '') {
                            $count = $r['total'] / $order_subtotal;
                            if ($count == '1') {
                                $amount = $order_tax;
                                $disc = $order_discount;
                            } else {
                                if ($order_product_id !== $last_order_product_id) {
                                    if (empty($r['tax'])) {
                                        continue;
                                    }
                                    $disc_cost = explode('.', $order_discount);
                                    $ship_cost = explode('.', $order_shipping);
                                    $discCost = $disc_cost[1];
                                    $shipCost = $ship_cost[1];

                                    if ($discCost === $shipCost) {
                                        $tax_rates = round(($r['total'] / $order_subtotal) * ($order_tax / $r['total_products']), 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$r['order_id']][] = $amount;
                                    } else {
                                        $tax_rates = round(($r['total'] / $order_subtotal) * $order_tax, 4);
                                        $amount = $r['tax'];
                                        $tax_total[$r['order_id']][] = $amount;
                                    }
                                    $ttl = array_sum($tax_total[$r['order_id']]);
                                    $taxes[$r['order_id']][] = $ttl;
                                    $disc_rates = round(($r['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$r['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$r['order_id']]);
                                    $discs[$r['order_id']][] = $total;
                                } else {
                                    if (sizeof((array)$discs[$r['order_id']]) > 0) {
                                        $discs_rate = end($discs[$r['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$r['order_id']];
                                    }
                                    if (sizeof((array)$taxes[$r['order_id']]) > 0) {
                                        $tax_rate = end($taxes[$r['order_id']]);
                                    } else {
                                        $tax_rate = $taxes[$r['order_id']];
                                    }
                                    $amount = $this->rounding($r['tax']);
                                    $disc = $order_discount - $discs_rate;
                                }
                            }

                            if ($order_discount !== '0.0000') {
                                $disc_rate = $disc;
                                $rows['discount'] = $disc_rate;
                                if ($disc_rate === '0.0000' || empty($disc_rate)) {
                                    $show_coupon = '0';
                                } else {
                                    $show_coupon = '1';
                                }
                            }

                            $tax_amount = $amount;
                        } else {
                            $tax_amount = $r['tax'];
                            $rows['discount'] = $disc;
                            if ($disc === '0.0000' || empty($disc)) {
                                $show_coupon = '0';
                            } else {
                                $show_coupon = '1';
                            }
                        }
                    } else {
                        if ($r['product_coupon'] === '' && $r['certain_product'] === '') {
                            if ($order_discount !== '0.0000') {
                                if ($order_product_id !== $last_order_product_id) {
                                    $disc_rates = round(($r['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$r['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$r['order_id']]);
                                    $discs[$r['order_id']][] = $total;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    //$ttl_discs = ;
                                    if (sizeof((array)$discs[$r['order_id']]) > 0) {
                                        $discs_rate = end($discs[$r['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$r['order_id']];
                                    }
                                    $disc = $order_discount - $discs_rate;
                                }

                                $rows['discount'] = $disc;
                            }
                        } else {
                            $rows['discount'] = $disc;
                            if ($disc === '0.0000' || empty($disc)) {
                                $show_coupon = '0';
                            } else {
                                $show_coupon = '1';
                            }
                        }
                        $tax_amount = '0';
                    }
                } else {
                    $tax_amount = '0';
                }

                if (($coupon_name === '' || is_null($coupon_name) || empty($coupon_name)) ||
                    ($coupon_name !== '' && !empty($coupon_name) && $show_coupon == '0')) {
                    $rows['coupon_name'] = '-';
                } else {
                    $rows['coupon_name'] = str_replace(':', '', $coupon_name);
                }

                if ($order_subtotal !== '0.00') {
                    $rows['price'] = (float)$r['price'];
                    $rows['original_price'] = (float)$r['original_price'];
                    $rows['tax'] = round((float)$tax_amount, 2);
                    $rows['total'] = (float)$r['total'];
                } else {
                    $rows['price'] = 0;
                    $rows['original_price'] = 0;
                    $rows['tax'] = 0;
                    $rows['total'] = 0;
                }

                $rows['cost'] = (float)$r['cost'];
                $rows['cost2'] = (float)$r['cost'];
                $options = [];
                foreach ($row as $option) {
                    $option_price = $option['original_option_price'];
                    if ($option['option_sort_order'] < '3') {
                        if ( $option['option_default']==='1') {
                            $option_price = $r['original_price'];
                        } else {
                            $option_price += $r['original_price'];
                        }
                    }

                    $opts['name'] = $option['name'];
                    $opts['value'] = $option['value'];
                    $opts['price'] = $option['price'];

                    if ($option['option_sort_order'] < '3' && $option['cost']==='0.0000') {
                        $opts['raw_cost'] = $r['cost'];
                        $opts['cost'] = $this->currency->format($r['cost'], $this->config->get('config_currency'));
                    } else {
                        $opts['raw_cost'] = $option['cost'];
                        $opts['cost'] = $this->currency->format($option['cost'], $this->config->get('config_currency'));
                    }

                    $opts['sort_order'] = $option['sort_order'];
                    $opts['raw_option_original_price'] = $option['option_original_price'];
                    $opts['option_original_price'] = $this->currency->format($option['option_original_price'], $this->config->get('config_currency'));
                    $opts['raw_option_selling_price'] = $option['option_selling_price'];
                    $opts['option_selling_price'] = $this->currency->format($option['option_selling_price'], $this->config->get('config_currency'));
                    $opts['price_prefix'] = $option['price_prefix'];
                    $opts['option_sort_order'] = $option['option_sort_order'];
                    $opts['option_default'] = $option['option_default'];
                    //$opts['raw_calculated_option_price'] = $option_price;
                    //$opts['calculated_option_price'] = $this->currency->format($option_price, $this->config->get('config_currency'));
                    $options[] = $opts;
                }
                $rows['option'] = $options;
                $rows['total_option'] = $total_row;
                $rows['order_product_id'] = $r['order_product_id'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    public function deleteOrderInfo($order_id) {
        $this->db->query("DELETE FROM ".$this->db->table("advanced_reports_order_products")." WHERE order_id=".(int)$order_id);
        $this->db->query("DELETE FROM ".$this->db->table("advanced_reports_order_options")." WHERE order_id=".(int)$order_id);
    }

    /**
     * @param array $data
     * @return array|false|mixed
     * @throws AException
     */
    public function getSaleProfitBuildAGift( $data = [] ) {
        $where = " ";

        $report_period = isset($data['report_period']) ? $data['report_period'] : 'day';
        if ($report_period == 'day') {
            $select_datefield = 'DATE(o.date_added) AS datefield';
        }
        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN(" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
        }
        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $filter_date = " WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $filter_date .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $this->load->model('advanced_reports/verify');

        //need to add build a gift cost
        $sql = "SELECT " . $select_datefield . ",op.child_products, o.order_id, CONCAT(o.invoice_prefix,'',o.invoice_id) AS invoice_id, 
                         o.date_added AS order_date, p.model,
                          o.email as customer_email, o.payment_company as `customer_company`, 
                          cgd.name as custom_group_name, o.payment_country as `country`,
                          o.payment_zone `region`, o.payment_city `city`, o.payment_postcode `zipcode`,
                          op.name AS product_name, op.quantity as quantity, 
                          op.price,p.price as original_price,
                          op.total as total, op.discount as discount,
                          op.product_id,op.order_product_id as order_product_id,o.currency,o.coupon_id as coupon_id,
                          p.tax_class_id,op.tax as tax,op.product_coupon as product_coupon,op.certain_product as certain_product,
                          (SELECT COUNT(*) FROM " . $this->db->table("order_products") . " ot WHERE ot.order_id=o.order_id) total_products
                          FROM " . $this->db->table("orders") . " o
						  LEFT JOIN " . $this->db->table("order_products") . " op ON op.order_id = o.order_id
						  LEFT JOIN " . $this->db->table("customer_groups") . " cgd ON cgd.customer_group_id = o.customer_group_id
						  LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
						  LEFT JOIN " . $this->db->table("manufacturers") . " m ON m.manufacturer_id = p.manufacturer_id
						  ";
        $sql .= $where;

        $sql .= " ORDER BY o.order_id ASC,op.order_product_id ASC";
        $query = $this->db->query($sql);
        if ($query->num_rows > 0) {
            /*query get order info*/
            $sales = $query->rows;
            $this->load->model('sale/order');
            $disc_total = [];
            $taxes = [];
            $discs = [];
            foreach ($sales as $key => $r) {
                if (!$r['child_products']) {
                    continue;
                }

                //'model_filter' not working;
                if (!empty($data['filter_model']) && $r['model'] !== '') {
                    $modelPos = strpos($r['model'], $data['filter_model']);
                    if ($modelPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_model']) && $r['model'] == '') {
                    continue;
                }

                if (!empty($data['filter_customer_email'])) {
                    $countryPos = strpos($r['customer_email'], html_entity_decode($this->db->escape($data['filter_customer_email'])));
                    if ($countryPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_customer_company']) && $r['customer_company'] !== '') {
                    $countryPos = strpos($r['customer_company'], html_entity_decode($this->db->escape($data['filter_customer_company'])));
                    if ($countryPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_customer_company']) && $r['customer_company'] == '') {
                    continue;
                }

                if (!empty($data['filter_country'])) {
                    $countryPos = strpos($r['country'], html_entity_decode($this->db->escape($data['filter_country'])));
                    if ($countryPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_region'])) {
                    $regionPos = strpos($r['region'], html_entity_decode($this->db->escape($data['filter_region'])));
                    if ($regionPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_city'])) {
                    $cityPos = strpos($r['city'], html_entity_decode($this->db->escape($data['filter_city'])));
                    if ($cityPos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_zipcode']) && $r['zipcode'] !== '') {
                    $zipCodePos = strpos($r['zipcode'], $this->db->escape($data['filter_zipcode']));
                    if ($zipCodePos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_product_name']) && $r['product_name'] !== '') {
                    $productNamePos = strpos($r['product_name'], $data['filter_product_name']);
                    if ($productNamePos === false) {
                        continue;
                    }
                }

                if (!empty($data['filter_manufacturer']) && $r['manufacturer'] !== '') {
                    $manufacturerPos = strpos($r['manufacturer'], $data['filter_manufacturer']);
                    if ($manufacturerPos === false) {
                        continue;
                    }
                } elseif (!empty($data['filter_manufacturer']) && $r['manufacturer'] == '') {
                    continue;
                }

                $product_id = $r['product_id'];
                $order_product_id = $r['order_product_id'];

                $disc = (float)$r['discount'];

                $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$r['order_id'] . "' ORDER BY order_product_id ASC");
                $order_product_ids = $queryOrderProducts->rows;
                $last_order_product_ids = end($order_product_ids);
                $last_order_product_id = $last_order_product_ids['order_product_id'];
                $query_coupon_name = $this->db->query("SELECT title as coupon_name FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='discount'");
                $coupon_name = $query_coupon_name->row['coupon_name'];
                $query_order_subtotal = $this->db->query("SELECT ROUND(value,2) as order_subtotal FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='subtotal'");
                $order_subtotal = $query_order_subtotal->row['order_subtotal'];
                $query_order_discount = $this->db->query("SELECT ROUND(value,2) as order_discount FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='discount'");
                $order_discount = $query_order_discount->row['order_discount'];
                $query_order_shipping = $this->db->query("SELECT ROUND(value,2) as order_shipping FROM " . $this->db->table("order_totals") . " where order_id='" . $r['order_id'] . "' AND type='shipping'");
                $order_shipping = $query_order_shipping->row['order_shipping'];

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " WHERE (order_id = " . $r['order_id'] . " AND type = 'taxjar_integration') OR 
                    (order_id = " . $r['order_id'] . " AND type='tax')");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " WHERE (order_id = " . $r['order_id'] . " AND type = 'avatax_integration') OR 
                    (order_id = " . $r['order_id'] . " AND type='tax')");
                } else {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " WHERE order_id = " . $r['order_id'] . " AND type = 'tax'");
                }

                $order_tax = $query_order_tax->row['order_tax'];
                $rows['product_id'] = $product_id;
                $rows['order_id'] = $r['order_id'];
                $rows['invoice_id'] = $r['invoice_id'];
                $rows['order_date'] = $r['order_date'];
                $rows['model'] = $r['model'];
                $rows['customer_email'] = $r['customer_email'];
                $rows['customer_company'] = $r['customer_company'];
                $rows['custom_group_name'] = $r['custom_group_name'];
                $rows['country'] = $r['country'];
                $rows['region'] = $r['region'];
                $rows['city'] = $r['city'];
                $rows['zipcode'] = $r['zipcode'];
                $rows['product_name'] = $r['product_name'];
                $rows['manufacturer'] = $r['manufacturer'];
                $rows['quantity'] = (int)$r['quantity'];
                $show_coupon = '';

                if ($r['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                    if ($r['tax'] !== '0.0000') {
                        if ($r['product_coupon'] === '' && $r['certain_product'] === '') {
                            $count = $r['total'] / $order_subtotal;
                            if ($count == '1') {
                                $amount = $order_tax;
                                $disc = $order_discount;
                            } else {
                                if ($order_product_id !== $last_order_product_id) {
                                    if (empty($r['tax'])) {
                                        continue;
                                    }
                                    $disc_cost = explode('.', $order_discount);
                                    $ship_cost = explode('.', $order_shipping);
                                    $discCost = $disc_cost[1];
                                    $shipCost = $ship_cost[1];

                                    if ($discCost === $shipCost) {
                                        $tax_rates = round(($r['total'] / $order_subtotal) * ($order_tax / $r['total_products']), 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$r['order_id']][] = $amount;
                                    } else {
                                        $tax_rates = round(($r['total'] / $order_subtotal) * $order_tax, 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$r['order_id']][] = $amount;
                                    }
                                    $ttl = array_sum($tax_total[$r['order_id']]);
                                    $taxes[$r['order_id']][] = $ttl;
                                    $disc_rates = round(($r['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$r['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$r['order_id']]);
                                    $discs[$r['order_id']][] = $total;
                                } else {
                                    //$ttl_discs = ;
                                    //$ttl_taxes = ;
                                    if (sizeof((array)$discs[$r['order_id']]) > 0) {
                                        $discs_rate = end($discs[$r['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$r['order_id']];
                                    }
                                    if (sizeof((array)$taxes[$r['order_id']]) > 0) {
                                        $tax_rate = end($taxes[$r['order_id']]);
                                    } else {
                                        $tax_rate = $taxes[$r['order_id']];
                                    }
                                    $amount = $order_tax - $tax_rate;
                                    $disc = $order_discount - $discs_rate;
                                }
                            }

                            if ($order_discount !== '0.0000') {
                                $disc_rate = $disc;
                                $rows['discount'] = $disc_rate;
                                if ($disc_rate === '0.0000' || empty($disc_rate)) {
                                    $show_coupon = '0';
                                } else {
                                    $show_coupon = '1';
                                }
                            }

                            $tax_amount = $amount;
                        } else {
                            $tax_amount = $this->rounding($r['tax']);
                            $rows['discount'] = $disc;
                            if ($disc === '0.0000' || empty($disc)) {
                                $show_coupon = '0';
                            } else {
                                $show_coupon = '1';
                            }
                        }
                    } else {
                        if ($r['product_coupon'] === '' && $r['certain_product'] === '') {
                            if ($order_discount !== '0.0000') {
                                if ($order_product_id !== $last_order_product_id) {
                                    $disc_rates = round(($r['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$r['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$r['order_id']]);
                                    $discs[$r['order_id']][] = $total;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    //$ttl_discs = ;
                                    if (sizeof((array)$discs[$r['order_id']]) > 0) {
                                        $discs_rate = end($discs[$r['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$r['order_id']];
                                    }
                                    $disc = $order_discount - $discs_rate;
                                }

                                $rows['discount'] = $disc;
                            }
                        } else {
                            $rows['discount'] = $disc;
                            if ($disc === '0.0000' || empty($disc)) {
                                $show_coupon = '0';
                            } else {
                                $show_coupon = '1';
                            }
                        }
                        $tax_amount = '0';
                    }
                } else {
                    $tax_amount = '0';
                }

                if (($coupon_name === '' || is_null($coupon_name) || empty($coupon_name)) ||
                    ($coupon_name !== '' && !empty($coupon_name) && $show_coupon == '0')) {
                    $rows['coupon_name'] = '-';
                } else {
                    $rows['coupon_name'] = str_replace(':', '', $coupon_name);
                }
                if ($order_subtotal !== '0.00') {
                    $rows['price'] = (float)$r['price'];
                    $rows['original_price'] = (float)$r['original_price'];
                    $rows['tax'] = round((float)$tax_amount, 2);
                    $rows['total'] = (float)$r['total'];
                } else {
                    $rows['price'] = 0;
                    $rows['original_price'] = 0;
                    $rows['tax'] = 0;
                    $rows['total'] = 0;
                }

                $sql2 = "SELECT p.model,pd.name, CONCAT(pod.name,' ',povd.name) as value, bago.qty, bago.total_price as price, bago.total_cost as cost FROM " . $this->db->table("product_descriptions") . " pd
                           LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = pd.product_id
                           LEFT JOIN " . $this->db->table("build_a_gift_order") . " bago ON bago.product_id = pd.product_id
                           LEFT JOIN " . $this->db->table("product_option_descriptions") . " pod ON pod.product_option_id = bago.product_option_id
                           LEFT JOIN " . $this->db->table("product_option_value_descriptions") . " povd ON povd.product_option_value_id = bago.product_option_value_id
                           WHERE bago.order_id =" . (int)$r['order_id'] . " ORDER BY bago.product_cost_id ASC";
                $query2 = $this->db->query($sql2);
                $row = $query2->rows;
                $total_row = $query2->num_rows;

                $rows['option'] = $row;
                $rows['total_option'] = $total_row;
                $rows['order_product_id'] = $r['order_product_id'];

                $query3 = $this->db->query("SELECT pricing_type,SUM(total_cost) FROM " . $this->db->table("build_a_gift_order") . " WHERE order_id=" . (int)$r['order_id']);
                $pricing_type = $query3->row['pricing_type'];
                $rows['pricing_type'] = $this->language->get('text_' . $pricing_type);
                $rows['total_cost'] = $query3->row['total_cost'];

                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Sales By State Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByState( $data = []) {

        $where = "";
        $base_where = "";

        $sql1 = "SELECT o.order_id, COUNT(o.order_id) `number_orders`, o.date_added,o.shipping_zone as `zone_name`, TRIM(o.shipping_zone_id) as `zone_id`
            FROM " . $this->db->table("orders") . " o ";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY `zone_id` ORDER BY `zone_name`";

        $query = $this->db->query($sql1);

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $rows['zone_id'] = trim($row['zone_id']);
                if (!$row['zone_id']) {
                    continue;
                }
                $rows['zone_name'] = $row['zone_name'];
                $rows['number_orders'] = $row['number_orders'];

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                /*Get subtotal*/
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'subtotal'" . $base_where);
                if ($query_subtotal->num_rows > 0) {
                    $rows['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'taxjar_integration') OR (TRIM(o.payment_zone_id) = '" . $row['zone_id'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'avatax_integration') OR (TRIM(o.payment_zone_id) = '" . $row['zone_id'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'tax'" . $base_where);
                }

                if ($query_tax->num_rows > 0) {
                    $rows['tax'] = $query_tax->row['tax'];
                }

                /*Get total shipping*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "' AND ot.type = 'shipping'" . $base_where);
                if ($query_shipping->num_rows > 0) {
                    $rows['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot  
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'  AND ot.type = 'discount'" . $base_where);
                if ($query_discount->num_rows > 0) {
                    $rows['discount'] = $query_discount->row['discount'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot  
                    LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.shipping_zone_id) = '" . $row['zone_id'] . "'  AND ot.type = 'total'" . $base_where);
                if ($query_total->num_rows > 0) {
                    $rows['total'] = $query_total->row['total'];
                }

                $rows['order_id'] = $row['order_id'];
                $rows['zone_id'] = $row['zone_id'];
                $rows['date_added'] = $row['date_added'];
                $reports[$rows['zone_id']] = $rows;
            }
        }
        return $reports;
    }

    /**
     * This is for Sales Statistic Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleStatistics( $data = []) {
        $where = "";
        $base_where = "";
        $report_period = isset($data['report_period'])?$data['report_period']:'month';

        $select_datefield = ' CONCAT(MONTH(o.date_added),"/",YEAR(o.date_added)) AS datefield';
        $filter_datefield = ' CONCAT(MONTH(o.date_added),"/",YEAR(o.date_added)) ';
        switch ($report_period) {
            case 'day':
                $select_datefield = 'DATE(o.date_added) AS datefield';
                $filter_datefield = ' DATE(o.date_added) ';
                break;
            case 'week':
                $select_datefield = 'CONCAT(YEAR(o.date_added),"0",WEEK(o.date_added)) AS datefield';
                $filter_datefield = ' CONCAT(YEAR(o.date_added),"0",WEEK(o.date_added)) ';
                break;
            case 'quarter':
                $select_datefield = 'CONCAT(QUARTER(o.date_added),"/",YEAR(o.date_added)) AS datefield';
                $filter_datefield = ' CONCAT(QUARTER(o.date_added),"/",YEAR(o.date_added)) ';
                break;
            case 'year':
                $select_datefield = 'YEAR(o.date_added) AS datefield';
                $filter_datefield = ' YEAR(o.date_added) ';
                break;
        }

        $sql1 = "SELECT COUNT(o.order_id) `number_orders`, SUM(ROUND(ot.value,2)) as `total`, o.date_added,
                     AVG(o.total) total_avg, " . $select_datefield . " FROM " . $this->db->table("orders") . " o
                     LEFT JOIN " . $this->db->table("order_totals") . " ot on ot.order_id = o.order_id";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }
        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " AND ot.type='total' GROUP BY datefield ORDER BY datefield";

        $query = $this->db->query($sql1);

        $reports = [];

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $rows['datefield'] = $row['datefield'];
                $rows['number_orders'] = $row['number_orders'];

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`, SUM(op.total) as `subtotal`,
                     AVG(op.total) as `product_total_avg`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE " . $filter_datefield . " = '" . $row['datefield'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                $rows['total'] = $row['total'];

                $rows['total_avg'] = $row['total_avg'];
                if ($query_products->num_rows > 0) {
                    $rows['product_total_avg'] = $query_products->row['product_total_avg'];
                }
                $rows['date_added'] = $row['date_added'];

                $reports[$rows['datefield']] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Sales By State Code Total Order
     * @param array $data
     * @return int
     */
    public function getTotalSaleState( $data = [] ) {
        $sql1 = "SELECT COUNT(o.order_id) AS `total` FROM ".$this->db->table("orders")." o ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for getting Sales by Zip Code Total Order
     * @param array $data
     * @return int
     */
    public function getTotalSaleZipcode( $data = [] ) {
        $sql1 = "SELECT COUNT(o.order_id) AS `total` FROM ".$this->db->table("orders")." o ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }
        $query = $this->db->query($sql1);
        return $query->row['total'];
    }

    /**
     * This is for Sales By Zipcode Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSaleByZipcode( $data = []) {

        $where = "";
        $base_where = "";
        $sql1 = "SELECT o.order_id, COUNT(o.order_id) `number_orders`, 
                     o.date_added, TRIM(o.payment_postcode) as `zipcode` FROM " . $this->db->table("orders") . " o ";

        if ($data['filter_order_status_id'] != '') {
            $where .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
            $base_where .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " WHERE o.order_status_id >= '0'";
            $base_where .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;
        $base_where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $base_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $base_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql1 .= $where;

        $sql1 .= " GROUP BY `zipcode` ORDER BY `zipcode`";

        $query = $this->db->query($sql1);

        if ($query->num_rows > 0) {
            /*query get order info*/
            $orders = $query->rows;
            foreach ($orders as $key => $row) {
                $rows['zipcode'] = trim($row['zipcode']);
                if (!$row['zipcode']) {
                    continue;
                }
                $rows['number_orders'] = trim($row['number_orders']);
                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `items_ordered`
					 FROM " . $this->db->table("order_products") . " op
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = op.order_id
					 WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "'" . $base_where);

                if ($query_products->num_rows > 0) {
                    $rows['items_ordered'] = $query_products->row['items_ordered'];
                }

                /*Get subtotal*/
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'subtotal'" . $base_where);
                if ($query_subtotal->num_rows > 0) {
                    $rows['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total shipping*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot
					 LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'shipping'" . $base_where);
                if ($query_shipping->num_rows > 0) {
                    $rows['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $query_discount = $this->db->query("SELECT  SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot 
                     LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'discount'" . $base_where);
                if ($query_discount->num_rows > 0) {
                    $rows['discount'] = $query_discount->row['discount'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'taxjar_integration') or (TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type='tax')" . $base_where);
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE (TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'avatax_integration') or (TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type='tax')" . $base_where);
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot
						LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					    WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'tax'" . $base_where);
                }

                if ($query_tax->num_rows > 0) {
                    $rows['tax'] = $query_tax->row['tax'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT  SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot 
                     LEFT JOIN " . $this->db->table("orders") . " o ON o.order_id = ot.order_id
					 WHERE TRIM(o.payment_postcode) = '" . $row['zipcode'] . "' AND ot.type = 'total'" . $base_where);
                if ($query_total->num_rows > 0) {
                    $rows['total'] = $query_total->row['total'];
                }

                $rows['date_added'] = $row['date_added'];

                $reports[$rows['zipcode']] = $rows;
            }
        }

        return $reports;
    }

    /**
     * Function to Get Total Sales
     * @param int $filter_order_status_id
     * @return int
     */
    public function getTotalSales($filter_order_status_id = 5) {
        $sql1 = "SELECT SUM(ROUND(o.total,2)) as `subtotal` FROM ".$this->db->table("orders")." o ";
        $store_id = $this->getStoreId();
        $sql1 .= " WHERE o.store_id = ".$store_id;

        if (!empty($filter_order_status_id)) {
            $sql1 .= " AND o.order_status_id IN (" . $filter_order_status_id . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }
        $query = $this->db->query($sql1);

        return isset($query->row['subtotal'])?$query->row['subtotal']:0;
    }

    /**
     * Function to get Current Month Report
     * @param int $filter_order_status_id
     * @return mixed
     */
    public function getCurrentMonthReport($filter_order_status_id = 5) {
        $current_year = date("Y");
        $current_month = date("m");

        $sql1 = "SELECT COUNT(distinct o.order_id) `number_orders`, SUM(ROUND(o.total,2)) as `subtotal`, o.date_added, CONCAT(YEAR(o.date_added),'/',MONTH(o.date_added)) AS datefield, DATE_FORMAT(o.date_added, '%c/%Y') AS datefield2 FROM ".$this->db->table("orders")." o WHERE DATE_FORMAT(o.date_added, '%c/%Y') = '".(int)$current_month."/".$current_year."'";
        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($filter_order_status_id)) {
            $sql1 .= " AND o.order_status_id IN (" . $filter_order_status_id . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $query = $this->db->query($sql1);

        return $query->row;
    }

    /**
     * Function to get Total Sales Order
     * @param array $data
     * @return int
     */
    public function getTotalSaleOrder( $data = [] ) {
        $sql1 = "SELECT COUNT(o.order_id) AS `total` FROM ".$this->db->table("orders")." o ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    public function getOrders($data = []) {
        $sql = "SELECT MIN(tmp.date_added) AS date_start, MAX(tmp.date_added) AS date_end, COUNT(tmp.order_id) AS `orders`, SUM(tmp.products) AS products, SUM(tmp.tax) AS tax, SUM(tmp.total) AS total FROM (SELECT o.order_id, (SELECT SUM(op.quantity) FROM ".$this->db->table("order_products")." op WHERE op.order_id = o.order_id GROUP BY op.order_id) AS products, (SELECT SUM(ot.value) FROM ".$this->db->table("order_totals")." ot WHERE ot.order_id = o.order_id AND ot.type = 'tax' GROUP BY ot.order_id) AS tax, o.total, o.date_added FROM ".$this->db->table("orders")." o";

        if ($data['filter_order_status_id']!='') {
            $sql .= " WHERE o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " WHERE o.order_status_id >= '0'";
        }

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.order_id) tmp";

        if (!empty($data['filter_group'])) {
            $group = $data['filter_group'];
        } else {
            $group = 'week';
        }

        switch($group) {
            case 'day';
                $sql .= " GROUP BY DAY(tmp.date_added)";
                break;
            default:
            case 'week':
                $sql .= " GROUP BY WEEK(tmp.date_added)";
                break;
            case 'month':
                $sql .= " GROUP BY MONTH(tmp.date_added)";
                break;
            case 'year':
                $sql .= " GROUP BY YEAR(tmp.date_added)";
                break;
        }

        $sql .= " ORDER BY tmp.date_added DESC";

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * Function to get Product Tax
     * @param $tax_class_id
     * @return mixed
     */
    private function getProductTax($tax_class_id) {
        $language = $this->registry->get('language');
        $language_id = $language->getLanguageID();
        $default_lang_id = $language->getDefaultLanguageID();
        $sql = "SELECT tr.tax_class_id,
							tr.rate AS rate, tr.rate_prefix AS rate_prefix, 
							tr.threshold_condition AS threshold_condition, 
							tr.threshold AS threshold,
							tr.tax_exempt_groups AS tax_exempt_groups,
							COALESCE( td1.title,td2.title) as title,
							COALESCE( NULLIF(trd1.description, ''),
									  NULLIF(td1.description, ''),
									  NULLIF(trd2.description, ''),
									  NULLIF(td2.description, ''),
									  COALESCE( td1.title,td2.title)
							) as description,
							tr.priority	
					FROM " . $this->db->table("tax_rates") . " tr
					LEFT JOIN " . $this->db->table("tax_rate_descriptions") . " trd1 ON 
						(tr.tax_rate_id = trd1.tax_rate_id AND trd1.language_id = '" . (int)$language_id . "')
					LEFT JOIN " . $this->db->table("tax_rate_descriptions") . " trd2 ON 
						(tr.tax_rate_id = trd2.tax_rate_id AND trd2.language_id = '" . (int)$default_lang_id . "')
					LEFT JOIN " . $this->db->table("tax_classes") . " tc ON tc.tax_class_id = tr.tax_class_id
					LEFT JOIN " . $this->db->table("tax_class_descriptions") . " td1 ON 
						(tc.tax_class_id = td1.tax_class_id AND td1.language_id = '" . (int)$language_id . "')
					LEFT JOIN " . $this->db->table("tax_class_descriptions") . " td2 ON 
						(tc.tax_class_id = td2.tax_class_id AND td2.language_id = '" . (int)$default_lang_id . "')
					WHERE (tr.tax_class_id = '" . $tax_class_id . "')
					ORDER BY tr.priority ASC";
        $tax_rate_query = $this->db->query($sql);
        $results = $tax_rate_query->row;
        return $results;
    }

    /**
     * Rounding Rates Function
     * @param $rate
     * @return string
     */
    private function rounding($rate) {
        $Rates = explode(".", $rate);
        $rates_len = strlen($Rates[1]);
        if ($rates_len === 4) {
            $splitRates = str_split($Rates[1], 2);
            $temp_rates = (int)$splitRates[1];
            if ($temp_rates <= 25) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0];
            } elseif ($temp_rates > 25 && $temp_rates <= 75) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 75) {
                $tmp_amount = $Rates[0] . '.' . (string)((int)$splitRates[0] + 1);
            }
            $amt = explode(".", $tmp_amount);
            $amt_len = strlen($amt[1]);
            if ($amt_len === 3) {
                $splitAmt = str_split($amt[1], 1);
                $temp_amt = (int)$splitAmt[2];
                $temp_amt2 = (int)$splitAmt[1] . $splitAmt[2];
                if ($temp_amt <= 2 || $temp_amt2 <= 25) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . $splitAmt[1];
                } elseif (($temp_amt > 2 && $temp_amt <= 7) || ($temp_amt2 > 25 && $temp_amt2 <= 75)) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . '5';
                } elseif ($temp_amt > 7 ||  $temp_amt2 > 75) {
                    $rates = $amt[0] . '.' . (string)((int)($splitAmt[0] . $splitAmt[1]) + 1);
                }
            } else {
                $rates = $tmp_amount;
            }
        } elseif ($rates_len === 3) {
            $splitRates = str_split($Rates[1], 1);
            $temp_rates = (int)$splitRates[2];
            if ($temp_rates <= 2) {
                $rates = $Rates[0] . '.' . $splitRates[0] . $splitRates[1];
            } elseif ($temp_rates > 2 && $temp_rates <= 7) {
                $rates = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 7) {
                $rates = $Rates[0] . '.' . (string)((int)($splitRates[0] . $splitRates[1]) + 1);
            }
        } else {
            $rates = $rate;
        }
        return $rates;
    }

    private function validateTaxjar() {
        if ($this->config->get('taxjar_integration_status')==='1') {
            $this->load->model('extension/taxjar_integration_license_info');
            $license_key = $this->config->get('taxjar_integration_license_code');
            $shared_secret = 'taxjar_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxjar_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxjar_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_taxjar_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxjar_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxjar_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}