<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ModelAdvancedReportsProductOptions
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ModelAdvancedReportsProductOptions extends Model {

    /**
     *  Update single product option value
     * @param int $pd_opt_val_id
     * @param int $attribute_value_id
     * @param array $data
     * @return null|int
     */
    public function updateProductOptionValue($pd_opt_val_id, $attribute_value_id, $data) {
        if (empty($pd_opt_val_id) || empty($data)) {
            return null;
        }

        $this->db->query(
            "UPDATE " . $this->db->table("product_option_values") . "
	        SET cost = '" . $this->db->escape($data['cost']) . "'
	        WHERE product_option_value_id = '" . (int)$pd_opt_val_id . "'");

        return $pd_opt_val_id;
    }

    /**
     *    Main function to be called to update option values.
     * @param int $product_id
     * @param int $option_id
     * @param array $data
     * @return null
     */
    public function updateProductOptionValues($product_id, $option_id, $data) {
        if (!is_array($data['product_option_value_id']) || !$option_id || !$product_id) {
            return null;
        }
        $language_id = $this->language->getContentLanguageID();
        foreach ($data['product_option_value_id'] as $opt_val_id => $status) {
            $option_value_data = [
                'cost' => preg_replace('/[^0-9\.\-]/','',$data['cost'][$opt_val_id])
            ];

            //Check if new, delete or update
            if ($status!=='new' && $status!=='delete') {
                //Existing need to update
                $this->updateProductOptionValueAndDescription($product_id, $opt_val_id, $option_value_data, $language_id);
            }
        }
    }

    /**
     *    Update product option value and value descriptions for set langauge
     * @param int $product_id
     * @param int $pd_opt_val_id
     * @param array $data
     * @param int $language_id
     */
    public function updateProductOptionValueAndDescription($product_id, $pd_opt_val_id, $data, $language_id) {
        $attribute_value_id = $data['attribute_value_id'];
        if (is_array($data['attribute_value_id'])) {
            $attribute_value_id = '';
        }

        $this->updateProductOptionValue($pd_opt_val_id, $attribute_value_id, $data);
    }

    /**
     * @param int $product_id
     * @param int $option_value_id
     * @return array
     */
    public function getProductOptionValue($product_id, $option_value_id) {

        $product_option_value = $this->db->query(
            "SELECT *
            FROM " . $this->db->table("product_option_values") . "
            WHERE product_id = '" . (int)$product_id . "'
                AND product_option_value_id = '" . (int)$option_value_id . "'
                AND group_id = 0
            ORDER BY sort_order");

        $option_value = $product_option_value->row;
        $result = [
            'cost' => $option_value['cost']
        ];
        return $result;
    }
}