<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
/**
 * Class ModelAdvancedReportsProduct
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelAdvancedReportsProductOptions $model_advanced_reports_product_options
 */

class ModelAdvancedReportsProduct extends Model {

	public $data = [];
	private $error = [];

    /**
     * This is for Purchased Product Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getPurchasedProduct($data = []) {
        $where = "1 ";
        $product_id = 0;
        if(isset($data['filter_product_id'])) {
            $where .= " AND op.product_id = ".(int)$data['filter_product_id'];
            $product_id = (int)$data['filter_product_id'];
        }
        $report_period = isset($data['report_period'])?$data['report_period']:'month';


        $select_datefield = ' CONCAT(MONTH(op.date_added),"/",YEAR(op.date_added)) AS datefield';
        switch ($report_period) {
            case 'day':
                $select_datefield = 'DATE(op.date_added) AS datefield';
                break;
            case 'week':
                $select_datefield = 'CONCAT(YEAR(op.date_added),"0", WEEK(op.date_added)) AS datefield';
                break;
            case 'quarter':
                $select_datefield = 'CONCAT(QUARTER(op.date_added),"/",YEAR(op.date_added)) AS datefield';
                break;
            case 'year':
                $select_datefield = 'YEAR(op.date_added) AS datefield';
                break;
        }

        $sql = "SELECT op.product_id,op.name, op.order_status_id, op.store_id, " . $select_datefield . ", op.model, op.order_id,op.base_price,op.special_price,
			IFNULL(SUM(ROUND(op.total,2)),0) AS total, IFNULL(SUM(op.quantity),0) AS orders, op.date_added, op.date_modified
			FROM (
			SELECT op.product_id,op.name,o.order_status_id, DATE(o.date_added) AS date_added_2, op.model, op.order_id,p.price as base_price,IFNULL(SUM(ps.price),0) as special_price,
			IFNULL(SUM(ROUND(op.total,2)),0) AS total,IFNULL(SUM(op.quantity),0) AS quantity, o.store_id, o.date_added, o.date_modified
			FROM " . $this->db->table("order_products") . " op
			LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id = op.order_id)
			LEFT JOIN " . $this->db->table("product_specials") . " ps ON ps.product_id = op.product_id
			LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
			WHERE " . $where . "
			GROUP BY op.order_id
			) op";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " WHERE op.order_status_id IN ( " . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " WHERE op.order_status_id > '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND op.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(op.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(op.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY datefield ";

        $query = $this->db->query($sql);

        $reports = $query->rows;

        return $reports;
    }

    /**
     * This is for Best Seller Report
     * @param array $data
     * @return array
     */
    public function getBestseller($data = []) {
        $limit = isset($data['limit'])?$data['limit']:10;

        $details = "SELECT op.order_id,op.product_id,op.order_product_id as order_product_id,p.tax_class_id,o.coupon_id,op.total,op.discount,op.tax,op.product_coupon,op.certain_product as certain_product,
                        (SELECT COUNT(*) FROM " . $this->db->table("order_products") . " ot WHERE ot.order_id=o.order_id) total_products
                        FROM " . $this->db->table("order_products") . " op
			            LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id = op.order_id)
			            LEFT JOIN " . $this->db->table("products") . " p ON (p.product_id=op.product_id)";
        if (!empty($data['filter_date_start'])) {
            $query_where = " WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $query_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }
        $query = "SELECT o.order_id, op.total as total, op.discount as discount,
                          op.product_id,op.order_product_id as order_product_id,
                          p.tax_class_id,op.tax as tax,op.product_coupon,op.certain_product as certain_product,
                          (SELECT COUNT(*) FROM " . $this->db->table("order_products") . " ot WHERE ot.order_id=o.order_id) total_products
                          FROM " . $this->db->table("orders") . " o
						  LEFT JOIN " . $this->db->table("order_products") . " op ON op.order_id = o.order_id
						  LEFT JOIN " . $this->db->table("products") . " p ON p.product_id = op.product_id
						  ";
        $query .= $query_where;
        $query .= " ORDER BY o.order_id ASC,op.order_product_id ASC";
        $queries = $this->db->query($query);
        $result = $queries->rows;
        $product_data = [];
        if ($queries->num_rows > 0) {
            foreach ($result as $key => $v) {
                $product_id = $v['product_id'];
                $product_name = $v['name'];
                $order_product_id = $v['order_product_id'];
                $disc = (float)$v['discount'];
                $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$v['order_id'] . "' ORDER BY order_product_id ASC");
                $order_product_ids = $queryOrderProducts->rows;
                $last_order_product_ids = end($order_product_ids);
                $last_order_product_id = $last_order_product_ids['order_product_id'];
                $query_order_subtotal = $this->db->query("SELECT ROUND(value,2) as order_subtotal FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='subtotal'");
                $order_subtotal = $query_order_subtotal->row['order_subtotal'];
                $query_order_discount = $this->db->query("SELECT ROUND(value,2) as order_discount FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='discount'");
                $order_discount = $query_order_discount->row['order_discount'];
                $query_order_shipping = $this->db->query("SELECT ROUND(value,2) as order_shipping FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='shipping'");
                $order_shipping = $query_order_shipping->row['order_shipping'];

                if ($this->validateTaxjar()) {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='taxjar_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax') ");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='avatax_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax') ");
                } else {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='tax'");
                }

                $order_tax = $query_order_tax->row['order_tax'];
                if ($v['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                    if ($v['tax'] != '0.0000') {
                        if ($v['product_coupon'] === '' && $v['certain_product'] === '') {
                            $count = $v['total'] / $order_subtotal;
                            $discs = [];
                            if ($count == '1') {
                                $amount = $order_tax;
                                $disc = $order_discount;
                            } else {
                                if ($order_product_id !== $last_order_product_id) {
                                    if (empty($v['tax'])) {
                                        continue;
                                    }
                                    $disc_rates = round(($v['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$v['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$v['order_id']]);
                                    $discs[$v['order_id']][] = $total;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    $ttl_discs = sizeof((array)$discs[$v['order_id']]);
                                    if ($ttl_discs > 0) {
                                        $discs_rate = end($discs[$v['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$v['order_id']];
                                    }
                                    $disc = $order_discount - $discs_rate;
                                }
                            }
                        } else {
                            $disc = $v['discount'];
                        }
                    } else {
                        if ($v['product_coupon'] === '' && $v['certain_product'] === '') {
                            if ($order_discount !== '0.0000') {
                                if ($order_product_id !== $last_order_product_id) {
                                    $disc_rates = round(($v['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$v['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$v['order_id']]);
                                    $discs[$v['order_id']][] = $total;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    $ttl_discs = sizeof((array)$discs[$v['order_id']]);
                                    if ($ttl_discs > 0) {
                                        $discs_rate = end($discs[$v['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$v['order_id']];
                                    }
                                    $disc = $order_discount - $discs_rate;
                                }
                            }
                        } else {
                            $disc = $this->rounding($v['discount']);
                        }
                    }
                    $total = $v['total'];
                } elseif ($order_subtotal === '0.00') {
                    $disc = '0';
                    $total = '0';
                }
                $product_data[$product_id]['discount'][] = $disc;
                $product_data[$product_id]['total'][] = $total;
            }
        }

        $taxes = $discs = [];

        foreach ($product_data as $key => $val) {
            $discs[$key]['discounts'][] = array_sum($val['discount']);
            $totals[$key]['total'][] = array_sum($val['total']);
        }

        $sql = "SELECT op.product_id,op.model, op.name,
                IFNULL(SUM(op.quantity),0) AS quantity,  IFNULL(SUM(ROUND(op.total,2)),0) AS total,
                o.store_id, o.date_added, COUNT(*) AS total_sale,o.coupon_id FROM " . $this->db->table("order_products") . " op
                LEFT JOIN " . $this->db->table("orders") . " o ON (op.order_id = o.order_id)
                LEFT JOIN " . $this->db->table("products") . " p ON (op.product_id = p.product_id) ";
        $sql .= " LEFT JOIN " . $this->db->table("products_to_stores") . " p2s ON (p.product_id = p2s.product_id) ";
        $sql .= " WHERE 1 ";
        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND p2s.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY p.product_id";
        $sql .= " ORDER BY quantity DESC ";
        $sql .= " LIMIT " . (int)$limit;

        $query = $this->db->query($sql);

        $reports = [];
        $sum_total = 0;
        $sum_qty = 0;
        $i = 0;
        if ($query->num_rows > 0) {
            $products = $query->rows;
            foreach ($products as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['product_id'] = $row['product_id'];
                $rows['model'] = $row['model'];
                $rows['name'] = $row['name'];
                $sum_total += (float)$row['total'];
                $sum_qty += (float)$row['quantity'];
                $rows['quantity'] = $row['quantity'];
                $disc = $discs[$row['product_id']]['discounts'][0];
                $totals = $row['total'];
                if ($disc < 0) {
                    $total = $totals + $disc;
                } else {
                    $total = $totals - $disc;
                }
                $rows['total'] = $total;
                $rows['store_id'] = $row['store_id'];
                $rows['date_added'] = $row['date_added'];
                $rows['total_sale'] = $row['total_sale'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Total Inventory Report
     * @param array $data
     * @return int
     */
    public function getTotalInventoryReport($data = []) {
        $sql = "SELECT COUNT(DISTINCT p.product_id) `total` FROM ".$this->db->table("products")." p
		   LEFT JOIN ".$this->db->table("products_to_categories")." p2c ON (p2c.product_id = p.product_id)
		   LEFT JOIN ".$this->db->table("products_to_stores")." p2s ON (p2s.product_id = p.product_id) 
		   LEFT JOIN (SELECT SUM(pov.quantity) AS option_quantity, po.product_id
            FROM ".$this->db->table("product_options")." po
            LEFT JOIN ".$this->db->table("product_option_values")." pov
                ON (po.product_id = pov.product_id) 
            WHERE po.product_id = pov.product_id AND po.status = 1 AND pov.subtract = 1 GROUP By po.product_id) as product_option ON product_option.product_id = p.product_id
		   ";

        $store_id = $this->getStoreId();
        $sql .= " WHERE 1 ";
        $sql .= " AND p2s.store_id = ".$store_id;

        if (!empty($data['filter_category_id'])) {
            $sql .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
        }

        if (!empty($data['filter_manufacturer'])) {
            $sql .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer'] . "'";
        }

        if (!empty($data['filter_product_id'])) {
            $sql .= " AND p.product_id = '" . (int)$data['filter_product_id'] . "'";
        }

        if ((int)$data['filter_quantity'] >= 0) {
            $sql .= " AND ( (product_option.option_quantity IS NOT NULL AND product_option.option_quantity < ".(int)$data['filter_quantity'].") OR (product_option.option_quantity IS NULL AND p.quantity < " . (int)$data['filter_quantity'].") )";
        }
        $query = $this->db->query($sql);
        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Product Inventory Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getInventoryReport($data = []) {
        $sql = "SELECT p.product_id, pd.name, p.model, p.sku, p.quantity, p.price, p.cost,
            p.free_shipping, p.ship_individually, p.shipping_price, p2d.downloadable, p.weight,w.weightC,p.length,p.width,p.height,l.lengthC,product_option.option_quantity as option_qty,p.quantity as base_qty
		    FROM ".$this->db->table("products")." p
			LEFT JOIN ".$this->db->table("product_descriptions")." pd ON (pd.product_id = p.product_id)
			LEFT JOIN ".$this->db->table("products_to_categories")." p2c ON (p2c.product_id = p.product_id)
		   	LEFT JOIN ".$this->db->table("products_to_stores")." p2s ON (p2s.product_id = p.product_id)
		   	LEFT JOIN (SELECT COUNT(*) AS downloadable,p2d.product_id  FROM ".$this->db->table("products_to_downloads")." p2d) AS p2d ON p2d.product_id=p.product_id
			LEFT JOIN (SELECT l.length_class_id,l.unit AS lengthC FROM ".$this->db->table("length_class_descriptions")." l) AS l ON l.length_class_id=p.length_class_id
			LEFT JOIN (SELECT w.weight_class_id,w.unit AS weightC FROM ".$this->db->table("weight_class_descriptions")." w) AS w ON w.weight_class_id=p.weight_class_id
			LEFT JOIN (SELECT SUM(pov.quantity) AS option_quantity, po.product_id
            FROM ".$this->db->table("product_options")." po
            LEFT JOIN ".$this->db->table("product_option_values")." pov
                ON (po.product_id = pov.product_id) 
            WHERE po.product_id = pov.product_id AND po.status = 1 AND pov.subtract = 1 GROUP By po.product_id) as product_option ON product_option.product_id = p.product_id
			";

        $where = "1 ";

        if (!empty($data['filter_category_id'])) {
            $where .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
        }

        if (!empty($data['filter_manufacturer'])) {
            $where .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer'] . "'";
        }

        if ((int)$data['filter_quantity'] >= 0) {
            $where .= " AND ( (product_option.option_quantity IS NOT NULL AND product_option.option_quantity < ".(int)$data['filter_quantity'].") OR (product_option.option_quantity IS NULL AND p.quantity < " . (int)$data['filter_quantity'].") )";
            //$where .= " AND p.quantity < " . (int)$data['filter_quantity'];
        }

        if (!empty($data['filter_product_id'])) {
            $where .= " AND p.product_id = '" . (int)$data['filter_product_id'] . "'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND p2s.store_id = ".$store_id." AND pd.language_id=".$this->language->getContentLanguageID();

        $sql .="WHERE ".$where."
			GROUP BY p.product_id";

        $sort_data = [
            'pd.name',
            'p.quantity',
            'p.cost',
            'p.price',
            'p.model',
            'total_cost',
            'purchases_value',
            'purchases_quantity',
            'product_value'
        ];

        $sort_field = "pd.name";
        $sort_dir = "asc";

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY pd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
            $sort_dir = "desc";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);
        $this->load->model('catalog/product');
        $reports = $query->rows;
        if ($reports) {
            $product_ids = [];
            $key_array = [];
            foreach ($reports as $key => $item) {
                $product_ids[] = (int)$item['product_id'];
                $key_array[(int)$item['product_id']] = $key;
                $this->load->model('catalog/product');

                $tmp_product_options = $this->model_catalog_product->getProductOptions($item['product_id']);
                $product_info = $this->model_catalog_product->getProduct($item['product_id']);
                $product_price = $product_info['price'];
                $product_weight = $product_info['weight'];
                $product_cost = $product_info['cost'];
                $product_options = [];
                $option_cost = 0;
                foreach ($tmp_product_options as $product_option) {
                    $product_option_value_data = [];

                    foreach ($product_option['product_option_value'] as $product_option_value) {

                        if ($product_option['sort_order'] < '3') {
                            if ($product_option_value['price']==='0.0000') {
                                $product_option_price = $product_price;
                            } else {
                                if ($product_option_value['prefix'] === '%') {
                                    $product_option_price = $product_price +($product_price * $product_option_value['price'] / 100);
                                } else {
                                    $product_option_price = $product_price + $product_option_value['price'];
                                }
                            }
                            if ($product_option_value['cost'] !== '0.0000') {
                                $total_cost = round($product_option_value['cost'], 2) * $product_option_value['quantity'];
                                $option_cost = round($product_option_value['cost'],2);
                            } else {
                                $total_cost = round($product_cost, 2) * $product_option_value['quantity'];
                                $option_cost = round($product_cost,2);
                            }
                            $product_option_price_value = round($product_option_price, 2) * $product_option_value['quantity'];
                        } else  {
                            if ($product_option_value['prefix'] === '%') {
                                $product_option_price = ($product_price * $product_option_value['price'] / 100);
                            } else {
                                $product_option_price = $product_option_value['price'];
                            }
                            $total_cost = round($product_option_value['cost'], 2) * $product_option_value['quantity'];
                            $option_cost = round($product_option_value['cost'],2);
                            $product_option_price_value = round($product_option_price, 2) * $product_option_value['quantity'];
                        }

                        if ($product_option_value['weight_type']==='%') {
                            $product_option_weight= round(($product_weight * $product_option_value['weight'] / 100),2);
                        } else {
                            $product_option_weight = round($product_option_value['weight'],2);
                        }

                        $product_option_value_data[] = [
                            'product_option_value_id' => $product_option_value['product_option_value_id'],
                            'option_value_id' => $product_option_value['option_value_id'],
                            'quantity' => $product_option_value['quantity'],
                            'subtract' => $product_option_value['subtract'],
                            'percent' => $product_option_value['prefix']==='%' ? round($product_option_value['price'],2) : '',
                            'price' => round($product_option_price,2),
                            'price2' => $this->currency->format(round($product_option_price,2), $this->config->get('config_currency')),
                            'value' => $product_option_price_value,
                            'value2' => $this->currency->format(round($product_option_price_value,2), $this->config->get('config_currency')),
                            'cost' => $option_cost,
                            'cost2' => $this->currency->format($option_cost, $this->config->get('config_currency')),
                            'price_prefix' => $product_option_value['prefix'],
                            'points' => $product_option_value['points'],
                            'points_prefix' => $product_option_value['points_prefix'],
                            'weight' => $product_option_weight,
                            'weight_type' => $product_option_value['weight_type'],
                            'total_cost' => $total_cost,
                            'total_cost2' => $this->currency->format(round($total_cost,2), $this->config->get('config_currency')),
                            'name' => $product_option_value['language'][1]['name'],
                            'sort_order' => $product_option['sort_order']
                        ];
                    }
                    $pricing_type = $this->getPricingCalcType($product_option['product_option_id']);
                    if ($pricing_type!=='') {
                        $type = $pricing_type;
                    } else {
                        switch ($product_option['element_type']) {
                            case 'I':
                                $type = 'Input';
                                break;
                            case 'T':
                                $type = 'Textarea';
                                break;
                            case 'S':
                                $type = 'Selectbox';
                                break;
                            case 'M':
                                $type = 'Multiselectbox';
                                break;
                            case 'R':
                                $type = 'Radio';
                                break;
                            case 'C':
                                $type = 'Checkbox';
                                break;
                            case 'G':
                                $type = 'Checkboxgroup';
                                break;
                            case 'U':
                                $type = 'Checkboxgroup';
                                break;
                            case 'H':
                                $type = 'Hidden';
                                break;
                            case 'B':
                                $type = 'Label';
                                break;
                            case 'B':
                                $type = 'Label';
                                break;
                        }
                    }


                    $product_options[] = [
                        'product_option_id' => $product_option['product_option_id'],
                        'product_option_value' => $product_option_value_data,
                        'name' => $product_option['language'][1]['name'],
                        'type' => $type
                    ];
                }
                $reports[$key]['options'] = $product_options;
            }
            $select = "SELECT op.product_id, o.order_status_id, IFNULL(SUM(op.quantity),0) AS purchases_quantity, IFNULL(SUM(op.total),0) as purchases_value,IFNULL(SUM(op.tax),0) as tax
						FROM " . $this->db->table("order_products") . " op
		   				LEFT JOIN " . $this->db->table("orders") . " o ON (o.order_id = op.order_id)
		   				WHERE op.product_id IN (" . implode(",", $product_ids) . ") AND (o.order_status_id >= '0' OR ISNULL(o.order_status_id))
		   				GROUP BY op.product_id
					";
            $query = $this->db->query($select);
            $rows = $query->rows;
            if ($rows) {
                foreach ($rows as $item) {
                    $key = $key_array[(int)$item['product_id']];
                    $reports[$key]['purchases_quantity'] = $item['purchases_quantity'];
                    $reports[$key]['purchases_value'] = $item['purchases_value'] + $item['tax'] ;
                    $reports[$key]['order_status_id'] = $item['order_status_id'];
                }
            }
        }

        return $reports;
    }

    /**
     * This is for Total Special Product Report
     * @param array $data
     * @return int
     */
    public function getTotalSpecialReport($data=[]) {
        $sql = "SELECT COUNT(DISTINCT p.product_id) `total`,p2d.downloads FROM ".$this->db->table("products")." p
		   LEFT JOIN ".$this->db->table("products_to_categories")." p2c ON (p2c.product_id = p.product_id)
		   LEFT JOIN ".$this->db->table("products_to_stores")." p2s ON (p2s.product_id = p.product_id)
		   LEFT JOIN (SELECT COUNT(*) AS downloads,p2d.product_id  FROM ".$this->db->table("products_to_downloads")." p2d) AS p2d ON p2d.product_id=p.product_id
			";

        $sql .= " WHERE 1 AND p.free_shipping=1 OR p.ship_individually=1 OR p2d.downloads >0 OR p.shipping_price <> 0.00 ";
        $store_id = $this->getStoreId();
        $sql .= " AND p2s.store_id = ".$store_id;

        if (!empty($data['filter_category_id'])) {
            $sql .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
        }

        if (!empty($data['filter_manufacturer'])) {
            $sql .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer'] . "'";
        }

        if (!empty($data['filter_product_id'])) {
            $sql .= " AND p.product_id = '" . (int)$data['filter_product_id'] . "'";
        }

        if ((int)$data['filter_quantity'] >= 0) {
            $sql .= " AND p.quantity <= " . (int)$data['filter_quantity'];
        }
        $query = $this->db->query($sql);
        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Special Product Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getSpecialReport($data = []) {
        $where = "1 ";

        if ($data['filter_category_id']!==0) {
            $where .= " AND p2c.category_id = '" . (int)$data['filter_category_id'] . "'";
        }

        if ($data['filter_manufacturer']!==0) {
            $where .= " AND p.manufacturer_id = '" . (int)$data['filter_manufacturer'] . "'";
        }

        if (!empty($data['filter_product_name'])) {
            $where .= " AND pd.name = '" . html_entity_decode($data['filter_product_name']) . "'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND p2s.store_id = ".$store_id;

        $where .= " AND (p.free_shipping=1 OR p.ship_individually=1 OR p2d.downloadable >0 OR p.shipping_price <> 0.0000)";

        $sql = "SELECT p.product_id, pd.name, p.model, p.sku, p.free_shipping, p.ship_individually, p.shipping_price, p2d.downloadable,
            p.weight,w.weightC,p.length,p.width,p.height,l.lengthC
		    FROM ".$this->db->table("products")." p
			LEFT JOIN ".$this->db->table("product_descriptions")." pd ON pd.product_id = p.product_id
			LEFT JOIN ".$this->db->table("products_to_categories")." p2c ON p2c.product_id = p.product_id
		   	LEFT JOIN ".$this->db->table("products_to_stores")." p2s ON p2s.product_id = p.product_id
		   	LEFT JOIN (SELECT COUNT(*) AS downloadable,p2d.product_id  FROM ".$this->db->table("products_to_downloads")." p2d) AS p2d ON p2d.product_id=p.product_id
			LEFT JOIN (SELECT l.length_class_id,l.unit AS lengthC FROM ".$this->db->table("length_class_descriptions")." l) AS l ON l.length_class_id=p.length_class_id
			LEFT JOIN (SELECT w.weight_class_id,w.unit AS weightC FROM ".$this->db->table("weight_class_descriptions")." w) AS w ON w.weight_class_id=p.weight_class_id
			WHERE ".$where."
			GROUP BY p.product_id";

        $sort_data = [
            'pd.name',
            'p.quantity',
            'p.model'
        ];

        $sort_field = "pd.name";
        $sort_dir = "asc";

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
            $sort_field = $data['sort'];
        } else {
            $sql .= " ORDER BY pd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
            $sort_dir = "desc";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if (!isset($data['start']) || $data['start'] < 0) {
                $data['start'] = 0;
            }

            if (!isset($data['limit']) || $data['limit'] < 1) {
                $data['limit'] = 20;
            }
            $start = (int)$data['start'];
            $limit = (int)$data['limit'];
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);
        if ($query->num_rows > 0) {
            $products = $query->rows;
            foreach ($products as $key => $row) {
                $rows['name'] = $row['name'];
                $rows['model'] = $row['model'];
                $rows['sku'] = $row['sku'];
                $rows['free_shipping'] = $row['free_shipping'];
                $rows['ship_individually'] = $row['ship_individually'];
                $rows['downloadable'] = $row['downloadable'];
                $rows['shipping_price'] = $row['shipping_price'];
                $rows['weight'] = $row['weight'];
                $rows['weightC'] = $row['weightC'];
                $rows['length'] = $row['length'];
                $rows['width'] = $row['width'];
                $rows['height'] = $row['height'];
                $rows['lengthC'] = $row['lengthC'];
                $rows['product_id'] = $row['product_id'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Total Ordered Product Report
     * @param array $data
     * @return int
     */
    public function getTotalProductReport($data = []) {
        $sql = "SELECT COUNT(DISTINCT op.product_id) `total` FROM ".$this->db->table("order_products")." op
		   LEFT JOIN ".$this->db->table("orders")." o ON (o.order_id = op.order_id) ";

        if ($data['filter_order_status_id']!='') {
            $sql .= " WHERE o.order_status_id IN ( " . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Product Report
     * @param array $data
     * @return array|false|mixed|null
     */
    public function getProductReport($data = []) {
        $where = "1";
        if ($data['filter_order_status_id']!='') {
            $where .= " AND o.order_status_id IN ( " . $data['filter_order_status_id'] . ")";
            $query_where = "WHERE o.order_status_id IN ( " . $data['filter_order_status_id'] . ")";
        } else {
            $where .= " AND o.order_status_id >= '0'";
            $query_where = "WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $where .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
            $query_where .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
            $query_where .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = "SELECT o.order_id, op.total as total, op.discount as discount,
                          op.product_id,op.order_product_id as order_product_id,
                          p.tax_class_id,op.tax as tax,op.product_coupon,op.certain_product as certain_product,
                          (SELECT COUNT(*) FROM ".$this->db->table("order_products")." ot WHERE ot.order_id=o.order_id) total_products
                          FROM ".$this->db->table("orders")." o
						  LEFT JOIN ".$this->db->table("order_products")." op ON op.order_id = o.order_id
						  LEFT JOIN ".$this->db->table("products")." p ON p.product_id = op.product_id
						  ";
        $query .= $query_where;
        $query .= " ORDER BY o.order_id ASC,op.order_product_id ASC";
        $queries = $this->db->query($query);
        $result=$queries->rows;
        $product_data=[];
        $discs=$taxes=[];
        if($queries->num_rows > 0) {
            foreach ($result as $key => $v) {
                $product_id = $v['product_id'];
                $product_name = $v['name'];
                $order_product_id = $v['order_product_id'];
                $disc = (float)$v['discount'];
                $queryOrderProducts = $this->db->query("SELECT order_product_id FROM " . $this->db->table("order_products") . " 
                                    WHERE order_id='" . (int)$v['order_id'] . "' ORDER BY order_product_id ASC");
                $order_product_ids = $queryOrderProducts->rows;
                $last_order_product_ids = end($order_product_ids);
                $last_order_product_id = $last_order_product_ids['order_product_id'];
                $query_order_subtotal=$this->db->query("SELECT ROUND(value,2) as order_subtotal FROM ".$this->db->table("order_totals")." where order_id='".$v['order_id']."' AND type='subtotal'");
                $order_subtotal=$query_order_subtotal->row['order_subtotal'];
                $query_order_discount=$this->db->query("SELECT ROUND(value,2) as order_discount FROM ".$this->db->table("order_totals")." where order_id='".$v['order_id']."' AND type='discount'");
                $order_discount=$query_order_discount->row['order_discount'];
                $query_order_shipping=$this->db->query("SELECT ROUND(value,2) as order_shipping FROM ".$this->db->table("order_totals")." where order_id='".$v['order_id']."' AND type='shipping'");
                $order_shipping=$query_order_shipping->row['order_shipping'];
                if ($this->validateTaxjar()) {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='taxjar_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax')");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where (order_id='" . $v['order_id'] . "' AND type='avatax_integration') OR (order_id='" . $v['order_id'] . "' AND type='tax')");
                } else {
                    $query_order_tax = $this->db->query("SELECT ROUND(value,2) as order_tax FROM " . $this->db->table("order_totals") . " where order_id='" . $v['order_id'] . "' AND type='tax'");
                }
                $order_tax=$query_order_tax->row['order_tax'];
                if ($v['total'] !== '0.0000' && $order_subtotal !== '0.00') {
                    if ($v['tax'] !== '0.0000') {
                        if ($v['product_coupon'] === '' && $v['certain_product'] === '') {
                            $count = $v['total'] / $order_subtotal;
                            if ($count == '1') {
                                $amount = $order_tax;
                                $disc = $order_discount;
                            } else {
                                if ($order_product_id !== $last_order_product_id) {
                                    if (empty($v['tax'])) {
                                        continue;
                                    }
                                    $disc_cost = explode('.', $order_discount);
                                    $ship_cost = explode('.', $order_shipping);
                                    $discCost = $disc_cost[1];
                                    $shipCost = $ship_cost[1];
                                    if ($discCost === $shipCost) {
                                        $tax_rates = round(($v['total'] / $order_subtotal) * ($order_tax / $v['total_products']), 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$v['order_id']][] = $amount;
                                    } else {
                                        $tax_rates = round(($v['total'] / $order_subtotal) * $order_tax, 4);
                                        $amount = $this->rounding($tax_rates);
                                        $tax_total[$v['order_id']][] = $amount;
                                    }
                                    //$tax_total[$r['order_id']][]=$amount;
                                    $ttl = array_sum($tax_total[$v['order_id']]);
                                    $taxes[$v['order_id']][] = $ttl;
                                    $disc_rates = round(($v['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$v['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$v['order_id']]);
                                    $discs[$v['order_id']][] = $total;
                                } elseif ($order_product_id === $last_order_product_id) {
                                    $ttl_discs = sizeof((array)$discs[$v['order_id']]);
                                    $ttl_taxes = sizeof((array)$taxes[$v['order_id']]);
                                    if ($ttl_discs > 0) {
                                        $discs_rate = end($discs[$v['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$v['order_id']];
                                    }
                                    if ($ttl_taxes > 0) {
                                        $tax_rate = end($taxes[$v['order_id']]);
                                    } else {
                                        $tax_rate = $taxes[$v['order_id']];
                                    }
                                    $amount = $order_tax - $tax_rate;
                                    $disc = $order_discount - $discs_rate;
                                }
                            }
                            $tax_amount = $amount;
                        } else {
                            $tax_amount = $this->rounding($v['tax']);
                            $disc = $v['discount'];
                        }
                    } else {
                        if ($v['product_coupon'] === '' && $v['certain_product'] === '') {
                            if ($order_discount !== '0.0000') {
                                if ($order_product_id !== $last_order_product_id) {
                                    $disc_rates = round(($v['total'] / $order_subtotal) * $order_discount, 4);
                                    $disc = $this->rounding($disc_rates);
                                    $disc_total[$v['order_id']][] = $disc;
                                    $total = array_sum($disc_total[$v['order_id']]);
                                    $discs[$v['order_id']][] = $total;
                                } elseif ($order_product_id == $last_order_product_id) {
                                    $ttl_discs = sizeof((array)$discs[$v['order_id']]);
                                    if ($ttl_discs > 0) {
                                        $discs_rate = end($discs[$v['order_id']]);
                                    } else {
                                        $discs_rate = $discs[$v['order_id']];
                                    }
                                    $disc = $order_discount - $discs_rate;
                                }
                            }
                        } else {
                            $disc = $this->rounding($v['discount']);
                        }
                        $tax_amount = '0';
                    }
                    $total=$v['total'];
                } elseif ($order_subtotal==='0.00') {
                    $tax_amount='0';
                    $disc='0';
                    $total='0';
                }
                $product_data[$product_id]['tax_rate'][] = $tax_amount;
                $product_data[$product_id]['discount'][] = $disc;
                $product_data[$product_id]['total'][] = $total;
            }
        }

        $taxes=$discs=[];

        foreach($product_data as $key=>$val) {
            $taxes[$key]['taxes'][]=array_sum($val['tax_rate']);
            $discs[$key]['discounts'][]=array_sum($val['discount']);
            $totals[$key]['total'][]=array_sum($val['total']);
        }

        $sql = "SELECT op.product_id,op.name, op.model, IFNULL(SUM(op.quantity),0) AS quantity,
                AVG(op.quantity) quantity_avg FROM ".$this->db->table("order_products")." op
			    LEFT JOIN ".$this->db->table("orders")." o ON (o.order_id = op.order_id)
			    WHERE ".$where." AND o.order_id = op.order_id 
			    GROUP BY op.product_id";

        $sort_data = [
            'op.name',
            'op.number_orders',
            'op.model',
            'product_revenue',
            'price_avg',
            'quantity_avg',
        ];

        $sort_field = "op.name";
        $sort_dir = "asc";

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
            $sort_field = $data['sort'];
        } else {
            $sql .= " ORDER BY op.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
            $sort_dir = "desc";
        } else {
            $sql .= " ASC";
        }

        $query = $this->db->query($sql);
        $products = $query->rows;
        if ($query->num_rows > 0) {
            foreach ($products as $key => $row) {
                $rows['product_id'] = $row['product_id'];
                $rows['name'] = $row['name'];
                $rows['model'] = $row['model'];
                $rows['quantity'] = $row['quantity'];
                $tax = $taxes[$row['product_id']]['taxes'][0];
                $disc = $discs[$row['product_id']]['discounts'][0];
                $total = $totals[$row['product_id']]['total'][0];
                //if ($data['include_tax'] === '1') {
                //    if ($disc < 0) {
                //        $product_revenue = ($total + $disc) + $tax;
                //    } else {
                //        $product_revenue = ($total - $disc) + $tax;
                //    }
                //    $rows['product_revenue'] = $product_revenue;
                //    if ($product_revenue !== 0 && $row['quantity'] !== '0') {
                //        $price_avg = $product_revenue / $row['quantity'];
                //    }
                //} else {
                    if ($disc < 0) {
                        $product_revenue = $total + $disc;
                    } else {
                        $product_revenue = $total - $disc;
                    }
                    if ($product_revenue !== 0 && $row['quantity'] !== '0') {
                        $price_avg = $product_revenue / $row['quantity'];
                    }
                    $rows['product_revenue'] = $product_revenue;
                //}
                $rows['unique_purchases'] = $row['unique_purchases'];
                //$rows['product_revenue']=$total;
                //$rows['product_revenue']=$product_revenue;
                $rows['tax'] = $tax;
                $rows['price_avg'] = $price_avg;
                $rows['quantity_avg'] = $row['quantity_avg'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Get Products
     * @param $data
     * @return mixed
     */
    public function getProducts($data) {
        $sql = "SELECT * FROM ".$this->db->table("products")." p 
        LEFT JOIN ".$this->db->table("product_descriptions")." pd ON (p.product_id = pd.product_id)";

        if (!empty($data['filter_category_id'])) {
            $sql .= " LEFT JOIN ".$this->db->table("products_to_categories")." p2c ON (p.product_id = p2c.product_id)";
        }

        $sql .= " WHERE pd.language_id = '" . $this->session->data['content_language_id'] . "'";

        if (!empty($data['filter_name'])) {
            $sql .= " AND pd.name LIKE '%" . $this->db->escape($data['filter_name']) . "%'";
        }

        if (!empty($data['filter_model'])) {
            $sql .= " AND p.model LIKE '%" . $this->db->escape($data['filter_model']) . "%'";
        }

        if (!empty($data['filter_price'])) {
            $sql .= " AND p.price LIKE '%" . $this->db->escape($data['filter_price']) . "%'";
        }

        if (isset($data['filter_quantity']) && !is_null($data['filter_quantity'])) {
            $sql .= " AND p.quantity = '%" . $this->db->escape($data['filter_quantity']) . "'";
        }

        if (isset($data['filter_status']) && !is_null($data['filter_status'])) {
            $sql .= " AND p.status = '%" . (int)$data['filter_status'] . "'";
        }

        $sql .= " GROUP BY p.product_id";

        $sort_data = [
            'pd.name',
            'p.model',
            'p.price',
            'p.quantity',
            'p.status',
            'p.sort_order'
        ];

        if (isset($data['sort']) && in_array($data['sort'], $sort_data)) {
            $sql .= " ORDER BY " . $data['sort'];
        } else {
            $sql .= " ORDER BY pd.name";
        }

        if (isset($data['order']) && ($data['order'] == 'DESC')) {
            $sql .= " DESC";
        } else {
            $sql .= " ASC";
        }

        if (isset($data['start']) || isset($data['limit'])) {
            if ($data['start'] < 0) {
                $data['start'] = 0;
            }

            if ($data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getManufacturer($data) {
        $sql = "SELECT m.manufacturer_id,m.name FROM ".$this->db->table("manufacturers")." m";

        if (!empty($data['filter_manufacturer'])) {
            $sql .= " WHERE m.name LIKE '%" . $data['filter_manufacturer'] . "%'";
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getCompany($data) {
        $sql = "SELECT DISTINCT(o.payment_company) as company FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_customer_company'])) {
            $sql .= " AND o.payment_company LIKE '%" . $data['filter_customer_company'] . "%'";
        }

        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getEmail($data) {
        $sql = "SELECT DISTINCT(o.email) as email FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_customer_email'])) {
            $sql .= " AND o.email LIKE '%" . $data['filter_customer_email'] . "%'";
        }

        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getRegion($data) {
        $sql = "SELECT DISTINCT(o.payment_zone) as region FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_region'])) {
            $sql .= " AND o.payment_zone LIKE '%" . $data['filter_region'] . "%'";
        }
        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getCity($data) {
        $sql = "SELECT DISTINCT(o.payment_city) as city FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_city'])) {
            $sql .= " AND o.payment_city LIKE '%" . $data['filter_city'] . "%'";
        }
        $query = $this->db->query($sql);

        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getZipCode($data) {
        $sql = "SELECT DISTINCT(o.payment_postcode) as zipcode FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_zipcode'])) {
            $sql .= " AND o.payment_postcode LIKE '%" . $data['filter_zipcode'] . "%'";
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * @param $data
     * @return mixed
     */
    public function getCountry($data) {

        $sql = "SELECT DISTINCT(o.payment_country) as country FROM ".$this->db->table("orders")." o";

        $sql .=" WHERE DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        $sql .=" AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";

        if (!empty($data['filter_country'])) {
            $sql .= " AND o.payment_country LIKE '%" . $data['filter_country'] . "%'";
        }
        $query = $this->db->query($sql);
        return $query->rows;
    }

    /**
     * Rounding Rates Function
     * @param $rate
     * @return string
     */
    private function rounding($rate) {
        $Rates = explode(".", $rate);
        $rates_len = strlen($Rates[1]);
        if ($rates_len === 4) {
            $splitRates = str_split($Rates[1], 2);
            $temp_rates = (int)$splitRates[1];
            if ($temp_rates <= 25) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0];
            } elseif ($temp_rates > 25 && $temp_rates <= 75) {
                $tmp_amount = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 75) {
                $tmp_amount = $Rates[0] . '.' . (string)((int)$splitRates[0] + 1);
            }
            $amt = explode(".", $tmp_amount);
            $amt_len = strlen($amt[1]);
            if ($amt_len === 3) {
                $splitAmt = str_split($amt[1], 1);
                $temp_amt = (int)$splitAmt[2];
                $temp_amt2 = (int)$splitAmt[1] . $splitAmt[2];
                if ($temp_amt <= 2 || $temp_amt2 <= 25) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . $splitAmt[1];
                } elseif (($temp_amt > 2 && $temp_amt <= 7) || ($temp_amt2 > 25 && $temp_amt2 <= 75)) {
                    $rates = $amt[0] . '.' . $splitAmt[0] . '5';
                } elseif ($temp_amt > 7 ||  $temp_amt2 > 75) {
                    $rates = $amt[0] . '.' . (string)((int)($splitAmt[0] . $splitAmt[1]) + 1);
                }

            } else {
                $rates = $tmp_amount;
            }
        } elseif ($rates_len === 3) {
            $splitRates = str_split($Rates[1], 1);
            $temp_rates = (int)$splitRates[2];
            if ($temp_rates <= 2) {
                $rates = $Rates[0] . '.' . $splitRates[0] . $splitRates[1];
            } elseif ($temp_rates > 2 && $temp_rates <= 7) {
                $rates = $Rates[0] . '.' . $splitRates[0] . '5';
            } elseif ($temp_rates > 7) {
                $rates = $Rates[0] . '.' . (string)((int)($splitRates[0] . $splitRates[1]) + 1);
            }
        } else {
            $rates = $rate;
        }
        return $rates;
    }

    public function getPricingCalcType($product_option_id) {
        $table_exist = "SHOW TABLES LIKE '".$this->db->table("calculator_type") ."'" ;
        $exist_query = $this->db->query($table_exist);
        if ($exist_query->row) {
            $sql = "SELECT `element_type` FROM ".$this->db->table("calculator_type") ." WHERE product_option_id=".(int)$product_option_id;
            $query = $this->db->query($sql);
            $pricing_type = $query->row['element_type'];
            switch ($pricing_type) {
                case 'Y' :
                    $type = 'Area';
                    break;
                case 'X' :
                    $type = 'Dimension';
                    break;
                case 'L' :
                    $type = 'Liquids';
                    break;
                case 'V' :
                    $type = 'Volume';
                    break;
                case 'W' :
                    $type = 'Weight';
                    break;
                default:
                    $type = '';
                    break;
            }
        } else {
            $type = '';
        }
        return $type;
    }

    private function validateTaxjar() {
        if ($this->config->get('taxjar_integration_status')==='1') {
            $this->load->model('extension/taxjar_integration_license_info');
            $license_key = $this->config->get('taxjar_integration_license_code');
            $shared_secret = 'taxjar_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxjar_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxjar_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_taxjar_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxjar_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxjar_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}