<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Ino.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelAdvancedReportsGuest
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ModelAdvancedReportsGuest extends Model {

    /**
     * This is for Guest Group Report
     * @param array $data
     * @return array
     */
    public function getGuestGroup($data = []) {

        $sql = "SELECT tmp.customer_group_id, tmp.guest_group, tmp.status, SUM(tmp.total_orders) AS orders,  SUM(tmp.customer_order_total) AS total 
        FROM (SELECT COUNT(o.order_id) total_orders, o.customer_id, cgd.customer_group_id, cgd.name AS guest_group, c.status, 
        SUM(ROUND(o.total,2)) customer_order_total FROM ".$this->db->table("orders")." o 
        LEFT JOIN ".$this->db->table("customers")." c ON (o.customer_id = c.customer_id) 
        LEFT JOIN ".$this->db->table("customer_groups")." cgd ON (c.customer_group_id = cgd.customer_group_id) WHERE o.customer_id = '0'";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id) tmp GROUP BY tmp.customer_group_id HAVING count(*) > 0 ORDER BY total DESC";

        $query = $this->db->query($sql);
        $reports = [];
        $sum_total = 0;
        $sum_qty = 0;
        if ($query->num_rows > 0) {
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $sum_total += (float)$row['total'];
                $sum_qty += (float)$row['orders'];
                $rows['guest_group'] = $row['guest_group'];
                $rows['orders'] = $row['orders'];
                $rows['total'] = $row['total'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Guest Report
     * @param array $data
     * @return array
     */
    public function getGuestReport($data = []) {
    	$this->load->model('advanced_reports/verify');
        if ($this->validateTaxjar()) {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'taxjar_integration') OR (ott.order_id = o.order_id AND ott.type='tax' )),2)),0) tax,";
        } elseif ($this->config->get('avatax_integration_status') === '1') {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'avatax_integration') OR (ott.order_id = o.order_id AND ott.type='tax' )),2)),0) tax,";
        } else {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE ott.order_id = o.order_id AND ott.type = 'tax' ),2)),0) tax,";
        }
        if (file_exists(DIR_EXT.'taxid_option') &&
            $this->model_advanced_reports_verify->verifyTaxID()=== true) {
            $sql = "SELECT o.order_id,o.customer_id, o.payment_company as `company`, o.taxid as `tax_id`,
                IFNULL(SUM((SELECT ot.value FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = o.order_id AND ot.type = 'subtotal' )) ,0) subtotal,
                IFNULL(SUM(ROUND((SELECT otd.value FROM " . $this->db->table("order_totals") . " otd WHERE otd.order_id = o.order_id AND otd.type = 'discount' ),2)) ,0) discount,
                IFNULL(SUM((SELECT ots.value FROM " . $this->db->table("order_totals") . " ots WHERE ots.order_id = o.order_id AND ots.type = 'shipping' )) ,0) shipping,
                ".$get_tax."
                IFNULL(SUM(ROUND((SELECT ottl.value FROM " . $this->db->table("order_totals") . " ottl WHERE ottl.order_id = o.order_id AND ottl.type = 'total' ),2)),0) total,
                o.firstname, o.lastname, o.email, 
                COUNT(*) AS number_order,o.payment_city, o.payment_postcode, o.store_id FROM ".$this->db->table("orders")." o
		  		";
        } else {
            $sql = "SELECT o.order_id,o.customer_id, o.payment_company as `company`,
                IFNULL(SUM((SELECT ot.value FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = o.order_id AND ot.type = 'subtotal' )) ,0) subtotal,
                IFNULL(SUM(ROUND((SELECT otd.value FROM " . $this->db->table("order_totals") . " otd WHERE otd.order_id = o.order_id AND otd.type = 'discount' ),2)) ,0) discount,
                IFNULL(SUM((SELECT ots.value FROM " . $this->db->table("order_totals") . " ots WHERE ots.order_id = o.order_id AND ots.type = 'shipping' )) ,0) shipping,
                ".$get_tax."
                IFNULL(SUM(ROUND((SELECT ottl.value FROM " . $this->db->table("order_totals") . " ottl WHERE ottl.order_id = o.order_id AND ottl.type = 'total' ),2)),0) total,
                o.firstname, o.lastname, o.email, 
                COUNT(*) AS number_order,o.payment_city, o.payment_postcode, o.store_id FROM ".$this->db->table("orders")." o
		  		";
        }

        $sql .= " WHERE 1 AND o.customer_id = 0";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (file_exists(DIR_EXT.'taxid_option') &&
            $this->model_advanced_reports_verify->verifyTaxID()===true) {
            $sql .= " GROUP BY o.taxid,o.firstname";
        } else {
            $sql .= " GROUP BY o.email,o.firstname";
        }
        $sql .= " HAVING count(*) > 0 ";
        $sql .= " ORDER BY o.firstname ASC, o.lastname ASC ";

        if (isset($data['start']) || isset($data['limit'])) {
            if (!isset($data['start']) || $data['start'] < 0) {
                $data['start'] = 0;
            }

            if (!isset($data['limit']) || $data['limit'] < 1) {
                $data['limit'] = 10;
            }
            $sql .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $i = 0;
            foreach ($orders as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['number_order'] = $row['number_order'];
                $rows['firstname'] = $row['firstname'];
                $rows['lastname'] = $row['lastname'];
                $rows['email'] = $row['email'];
                $rows['company'] = $row['company'];
                $rows['tax_id'] = $row['tax_id'];
                $rows['subtotal'] = $row['subtotal'];
                $rows['shipping'] = $row['shipping'];
                $rows['tax'] = $row['tax'];
                $rows['discount'] = $row['discount'];
                $rows['total'] = $row['total'];
                $rows['payment_city'] = $row['payment_city'];
                $rows['payment_postcode'] = $row['payment_postcode'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Guest Total Order Report
     * @param array $data
     * @return int
     */
    public function getTotalGuestReport( $data = [] ) {

        $sql = "SELECT COUNT(o.customer_id) AS `total`, o.customer_id FROM ".$this->db->table("orders")." o";

        $sql .= " WHERE 1 AND o.customer_id = 0 ";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Guest By Company Report
     * @param array $data
     * @return array
     */
    public function getReportByCompany($data = []) {

        $sql = "SELECT tmp.guest_company, SUM(tmp.total_orders) AS orders,  SUM(tmp.customer_order_total) AS total
                FROM (SELECT COUNT(o.order_id) total_orders, o.customer_id, o.payment_company AS guest_company, 
                SUM(ROUND(o.total,2)) customer_order_total FROM ".$this->db->table("orders")." o WHERE o.customer_id = 0 ";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id) tmp GROUP BY tmp.guest_company ORDER BY total DESC";

        $query = $this->db->query($sql);
        $reports = [];
        $sum_total = 0;
        $sum_qty = 0;
        if ($query->num_rows > 0) {
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $sum_total += (float)$row['total'];
                $sum_qty += (float)$row['orders'];
                $rows['guest_company'] = $row['guest_company'];
                $rows['orders'] = $row['orders'];
                $rows['total'] = $row['total'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Top Guest Report
     * @param array $data
     * @return array
     */
    public function getTopGuest($data = []) {
        $limit = isset($data['limit'])?$data['limit']:10;
        $reports = [];

        $sql = "SELECT o.customer_id, o.payment_company as `company`, o.payment_city, o.payment_postcode, CONCAT(o.firstname,' ',o.lastname) guest_name, o.email, 
                IFNULL(SUM(ot.value) ,0) subtotal, COUNT(*) AS total_sale, o.store_id FROM ".$this->db->table("orders")." o
                LEFT JOIN ".$this->db->table("order_totals")." ot ON ot.order_id=o.order_id";

        $sql .= " WHERE 1 AND o.customer_id = 0 AND ot.type='subtotal' ";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id,o.firstname";
        $sql .= " HAVING count(*) > 0 ";
        $sql .= " ORDER BY subtotal DESC";
        $sql .= " LIMIT " . (int)$limit;

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $i = 0;
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['guest_name'] = trim($row['guest_name']);
                $rows['guest_company'] = trim($row['guest_company']);
                $rows['email'] = trim($row['email']);
                $rows['total_sale'] = trim($row['total_sale']);
                $rows['subtotal'] = trim($row['subtotal']);
                $rows['customer_id'] = trim($row['customer_id']);
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Guest By City Report
     * @param array $data
     * @return array
     */
    public function getGuestByCity($data = []) {
        $where = "1 ";
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT o.order_id, o.customer_id, CONCAT(o.payment_city, ', ', o.payment_zone, ', ', o.payment_country) as city_name, o.date_added FROM ".$this->db->table("orders")." o ";

        $sql1 .= " WHERE o.customer_id = 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_city)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_zone, ', ', o.payment_country) LIKE '%".$filter_city."%'";
        }

        $sql1 .= " ORDER BY city_name ASC";

        $query = $this->db->query($sql1);
        $reports = [];

        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $city = [];

            foreach ($orders as $key => $row) {
                $row['city_name'] = trim($row['city_name']);

                if (!isset($city[$row['city_name']])) {
                    $city[$row['city_name']] = [];
                }

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `products`, SUM(op.total) as `product_total`
				 FROM " . $this->db->table("order_products") . " op WHERE op.order_id = " . $row['order_id'] . " GROUP BY op.order_id");
                if ($query_products->num_rows > 0) {
                    $row['products'] = $query_products->row['products'];
                }

                /*Get total*/
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'subtotal' GROUP BY ot.order_id");
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'taxjar_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'avatax_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax' GROUP BY ot.order_id");
                }

                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /*Get total products*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'shipping' GROUP BY ot.order_id");
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get discount total*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'discount' GROUP BY ot.order_id");
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'total' GROUP BY ot.order_id");
                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }

                $city[$row['city_name']][] = $row;
            }

            if ($city) {
                foreach ($city as $key => $val) {
                    $tmp = [];
                    $tmp['city_name'] = $key;
                    $tmp['number_orders'] = sizeof($val);
                    if ($val) {
                        $tmp2 = [];
                        foreach ($val as $k => $v) {
                            if (!in_array((int)$v['customer_id'], $tmp2))
                                $tmp['guest'] += 1;
                            $tmp['items_ordered'] += (int)$v['products'];
                            $tmp['subtotal'] += (float)$v['subtotal'];
                            $tmp['tax'] += (float)$v['tax'];
                            $tmp['shipping'] += (float)$v['shipping'];
                            $tmp['discount'] += (float)$v['discount'];
                            $tmp['total'] += (float)$v['total'];
                        }
                        unset($tmp2);
                    }
                    $reports[] = $tmp;
                    unset($tmp);
                }

            }
        }

        return $reports;
    }

    /**
     * This is for Guest By City Total Order Report
     * @param array $data
     * @return int
     */
    public function getTotalGuestCity( $data = [] ) {
        $where = "1 ";
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT COUNT(o.order_id) AS `total`, CONCAT(o.payment_city, ', ', o.payment_country) as city_name FROM ".$this->db->table("orders")." o ";

        $sql1 .= " WHERE o.customer_id = 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_city)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_country) LIKE '%".$filter_city."%'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Guest By Country Report
     * @param array $data
     * @return array
     */
    public function getGuestByCountry($data = []) {
        $where = "1 ";
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT o.order_id, o.customer_id, o.payment_country as `country_name`, o.date_added FROM ".$this->db->table("orders")." o ";

        $sql1 .= " WHERE 1 AND o.customer_id = 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($data['filter_country'])) {
            $sql1 .= " AND o.payment_country LIKE '%".$data['filter_country']."%'";
        }

        $sql1 .= " ORDER BY country_name ASC";

        if (isset($data['start']) || isset($data['limit'])) {
            if (!isset($data['start']) || $data['start'] < 0) {
                $data['start'] = 0;
            }

            if (!isset($data['limit']) || $data['limit'] < 1) {
                $data['limit'] = 20;
            }

            $sql1 .= " LIMIT " . (int)$data['start'] . "," . (int)$data['limit'];
        }

        $query = $this->db->query($sql1);
        $reports = [];

        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $city = [];

            foreach ($orders as $key => $row) {
                $row['country_name'] = trim($row['country_name']);

                if (!isset($city[$row['country_name']])) {
                    $city[$row['country_name']] = [];
                }
                $row['products'] = $row['product_total'] = $row['tax'] = $row['shipping'] = $row['discount'] = 0;

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `products`, SUM(op.total) as `product_total`
				 FROM " . $this->db->table("order_products") . " op WHERE op.order_id = " . $row['order_id'] . " GROUP BY op.order_id");
                if ($query_products->num_rows > 0) {
                    $row['products'] = $query_products->row['products'];
                }

                /*Get subtotal*/
                $row['subtotal'] = 0;
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'subtotal' GROUP BY ot.order_id");
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get total shipping*/
                $row['shipping'] = 0;
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'shipping' GROUP BY ot.order_id");
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get total discount*/
                $row['discount'] = 0;
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'discount' GROUP BY ot.order_id");
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get total tax*/
                $row['tax'] = 0;
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot 
                        WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'taxjar_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot 
                       WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'avatax_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot 
                       WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax' GROUP BY ot.order_id");
                }

                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /*Get total*/
                $row['total'] = 0;
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'total' GROUP BY ot.order_id");
                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }

                $city[$row['country_name']][] = $row;

            }

            if ($city) {
                foreach ($city as $key => $val) {
                    $tmp = [];
                    $tmp['country_name'] = $key;
                    $tmp['number_orders'] = sizeof($val);
                    if ($val) {
                        $tmp2 = [];
                        foreach ($val as $k => $v) {
                            if (!in_array((int)$v['customer_id'], $tmp2))
                                $tmp['guest'] += 1;
                            $tmp['items_ordered'] += (int)$v['products'];
                            $tmp['subtotal'] += (float)$v['subtotal'];
                            $tmp['tax'] += (float)$v['tax'];
                            $tmp['shipping'] += (float)$v['shipping'];
                            $tmp['discount'] += (float)$v['discount'];
                            $tmp['total'] += (float)$v['total'];
                        }
                        unset($tmp2);
                    }
                    $reports[] = $tmp;
                    unset($tmp);
                }

            }
        }

        return $reports;
    }

    /**
     * This is for Guest By Country Total Order Report
     * @param array $data
     * @return int
     */
    public function getTotalGuestCountry( $data = [] ) {
        $where = "1 ";
        $filter_country = isset($data['filter_country'])?$data['filter_country']:"";

        $sql1 = "SELECT COUNT(o.order_id) AS `total`, o.payment_country AS `country_name` FROM ".$this->db->table("orders")." o ";

        $sql1 .= " WHERE o.customer_id = 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_country)) {
            $sql1 .= " AND `payment_country` LIKE '%".$filter_country."%'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    private function validateTaxjar() {
        if ($this->config->get('taxjar_integration_status')==='1') {
            $this->load->model('extension/taxjar_integration_license_info');
            $license_key = $this->config->get('taxjar_integration_license_code');
            $shared_secret = 'taxjar_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxjar_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxjar_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_taxjar_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxjar_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxjar_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}