<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelAdvancedReportsCustomer
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ModelAdvancedReportsCustomer extends Model {

    public $data = [];

    public function getTotalCustomerReport( $data = [] ) {

        $sql = "SELECT COUNT(DISTINCT o.customer_id) AS `total`, o.customer_id FROM " . $this->db->table("orders") . " o
			LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id = o.customer_id";

        $sql .= " WHERE 1 AND o.customer_id > 0 ";

        if ($data['filter_order_status_id']!='') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $query = $this->db->query($sql);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Customer Report
     * @param array $data
     * @return array
     */
    public function getCustomerReport($data = []) {
    	$this->load->model('advanced_reports/verify');

        if ($this->validateTaxjar()) {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'taxjar_integration') OR (ott.order_id = o.order_id AND ott.type = 'tax')),2)),0) tax,";
        } elseif ($this->config->get('avatax_integration_status') === '1') {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE (ott.order_id = o.order_id AND ott.type = 'avatax_integration') OR (ott.order_id = o.order_id AND ott.type = 'tax')),2)),0) tax,";
        } else {
            $get_tax = "IFNULL(SUM(ROUND((SELECT ott.value FROM " . $this->db->table("order_totals") . " ott WHERE ott.order_id = o.order_id AND ott.type = 'tax' ),2)),0) tax,";
        }
        if (file_exists(DIR_EXT . 'taxid_option') &&
            $this->model_advanced_reports_verify->verifyTaxID()) {
            $sql = "SELECT o.customer_id, o.payment_company as `company`,
                (SELECT o.taxid FROM " . $this->db->table("orders") . " o WHERE o.email = c.email GROUP BY c.email ) tax_id,
                IFNULL(SUM((SELECT ot.value FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = o.order_id AND ot.type = 'subtotal' )) ,0) subtotal,
                IFNULL(SUM(ROUND((SELECT otd.value FROM " . $this->db->table("order_totals") . " otd WHERE otd.order_id = o.order_id AND otd.type = 'discount' ),2)) ,0) discount,
                IFNULL(SUM((SELECT ots.value FROM " . $this->db->table("order_totals") . " ots WHERE ots.order_id = o.order_id AND ots.type = 'shipping' )) ,0) shipping,
                ".$get_tax."
                IFNULL(SUM(ROUND((SELECT ottl.value FROM " . $this->db->table("order_totals") . " ottl WHERE ottl.order_id = o.order_id AND ottl.type = 'total' ),2)),0) total,
                c.firstname, c.lastname, c.email,
                COUNT(*) AS number_order,o.payment_city, o.payment_postcode, o.store_id FROM " . $this->db->table("orders") . " o
			LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id = o.customer_id";
        } else {
            $sql = "SELECT o.customer_id, o.payment_company as `company`,
                IFNULL(SUM((SELECT ot.value FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = o.order_id AND ot.type = 'subtotal' )) ,0) subtotal,
                IFNULL(SUM(ROUND((SELECT otd.value FROM " . $this->db->table("order_totals") . " otd WHERE otd.order_id = o.order_id AND otd.type = 'discount' ),2)) ,0) discount,
                IFNULL(SUM((SELECT ots.value FROM " . $this->db->table("order_totals") . " ots WHERE ots.order_id = o.order_id AND ots.type = 'shipping' )) ,0) shipping,
                 ".$get_tax."
                 IFNULL(SUM(ROUND((SELECT ottl.value FROM " . $this->db->table("order_totals") . " ottl WHERE ottl.order_id = o.order_id AND ottl.type = 'total' ),2)),0) total,
                c.firstname, c.lastname, c.email,
                COUNT(*) AS number_order,o.payment_city, o.payment_postcode, o.store_id FROM " . $this->db->table("orders") . " o
			LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id = o.customer_id";
        }

        $sql .= " WHERE 1 AND o.customer_id > 0 AND o.customer_id = c.customer_id";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }
        
        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id";
        $sql .= " ORDER BY c.firstname ASC, c.lastname ASC ";
        $query = $this->db->query($sql);
        $reports = [];
        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $i = 0;
            foreach ($orders as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['number_order'] = $row['number_order'];
                $rows['firstname'] = $row['firstname'];
                $rows['lastname'] = $row['lastname'];
                $rows['email'] = $row['email'];
                $rows['company'] = $row['company'];
                $rows['tax_id'] = $row['tax_id'];
                $rows['subtotal'] = $row['subtotal'];
                $rows['tax'] = $row['tax'];
                $rows['shipping'] = $row['shipping'];
                $rows['discount'] = $row['discount'];
                $rows['total'] = $row['total'];
                $rows['payment_city'] = $row['payment_city'];
                $rows['payment_postcode'] = $row['payment_postcode'];
                $rows['customer_id'] = $row['customer_id'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Customer By City Report
     * @param array $data
     * @return array
     */
    public function getCustomerByCity($data = []) {
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT o.order_id, o.customer_id, CONCAT(o.payment_city, ', ', o.payment_zone, ', ', o.payment_country) as city_name, o.date_added FROM " . $this->db->table("orders") . " o ";

        $sql1 .= " WHERE o.customer_id > 0  ";

        if ($data['filter_order_status_id'] != '') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (!empty($filter_city)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_zone, ', ', o.payment_country) LIKE '%" . $filter_city . "%'";
        }

        $sql1 .= " ORDER BY city_name ASC";

        $query = $this->db->query($sql1);
        $reports = [];
        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $city = [];

            foreach ($orders as $key => $row) {
                $row['city_name'] = trim($row['city_name']);

                if (!isset($city[$row['city_name']])) {
                    $city[$row['city_name']] = [];
                }

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `products`
				 FROM " . $this->db->table("order_products") . " op WHERE op.order_id = " . $row['order_id'] . " GROUP BY op.order_id");
                if ($query_products->num_rows > 0) {
                    $row['products'] = $query_products->row['products'];
                }

                /*Get subtotal */
                $query_subtotal = $this->db->query("SELECT SUM(ot.value) as `subtotal` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'subtotal' GROUP BY ot.order_id");
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get shipping total */
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'shipping' GROUP BY ot.order_id");
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get discount total */
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'discount' GROUP BY ot.order_id");
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'taxjar_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'avatax_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax' GROUP BY ot.order_id");
                }

                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'total' GROUP BY ot.order_id");
                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }
                $city[$row['city_name']][] = $row;
            }

            if ($city) {
                foreach ($city as $key => $val) {
                    $tmp = [];
                    $tmp['city_name'] = $key;
                    $tmp['number_orders'] = sizeof($val);
                    if ($val) {
                        $tmp2 = [];
                        foreach ($val as $k => $v) {
                            if (!in_array((int)$v['customer_id'], $tmp2)) {
                                $tmp['customers'] += 1;
                                $tmp['items_ordered'] += (int)$v['products'];
                                $tmp['subtotal'] += (float)$v['subtotal'];
                                $tmp['shipping'] += (float)$v['shipping'];
                                $tmp['discount'] += (float)$v['discount'];
                                $tmp['tax'] += (float)$v['tax'];
                                $tmp['total'] += (float)$v['total'];
                            }
                        }
                        unset($tmp2);
                    }
                    $reports[] = $tmp;
                    unset($tmp);
                }

            }
        }

        return $reports;
    }

    /**
     * This is for Customer By City Report Total Order
     * @param array $data
     * @return array
     */
    public function getTotalCustomerCity( $data = [] ) {
        $where = "1 ";
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT COUNT(o.order_id) AS `total`, CONCAT(o.payment_city, ', ', o.payment_country) as city_name FROM " . $this->db->table("orders") . " o ";

        $sql1 .= " WHERE o.customer_id > 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_city)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_country) LIKE '%".$filter_city."%'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is Customer By Company Report
     * @param array $data
     * @return array
     */
    public function getReportByCompany($data = []) {
        $sql = "SELECT tmp.customer_company, SUM(tmp.total_orders) AS orders,  SUM(tmp.customer_order_total) AS total 
       FROM (SELECT COUNT(o.order_id) total_orders, o.customer_id, o.payment_company AS customer_company, 
       SUM(ROUND(ot.value,2)) customer_order_total FROM " . $this->db->table("orders") . " o 
       LEFT JOIN " . $this->db->table("order_totals") . " ot ON ot.order_id=o.order_id
       WHERE o.customer_id > 0  AND ot.type='total'";
        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id) tmp GROUP BY tmp.customer_company ORDER BY total DESC";


        $query = $this->db->query($sql);

        $reports = [];
        if ($query->num_rows > 0) {
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $rows['customer_company'] = $row['customer_company'];
                $rows['orders'] = $row['orders'];
                $rows['total'] = $row['total'];
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Customer By Country Report
     * @param array $data
     * @return array
     */
    public function getCustomerByCountry($data = []) {
        $where = "1 ";
        $sql1 = "SELECT o.order_id, o.customer_id, o.payment_country as `country_name`, o.date_added FROM " . $this->db->table("orders") . " o ";

        $sql1 .= " WHERE 1 AND o.customer_id > 0  ";

        if ($data['filter_order_status_id'] != '') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (!empty($data['filter_country'])) {
            $sql1 .= " AND o.payment_country LIKE '%" . $data['filter_country'] . "%'";
        }

        $sql1 .= " ORDER BY country_name ASC";

        $query = $this->db->query($sql1);
        $reports = [];

        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $city = [];

            foreach ($orders as $key => $row) {
                $row['country_name'] = trim($row['country_name']);

                if (!isset($city[$row['country_name']])) {
                    $city[$row['country_name']] = [];
                }
                $row['products'] = $row['product_total'] = $row['tax'] = $row['shipping'] = $row['discount'] = 0;

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `products`
				 FROM " . $this->db->table("order_products") . " op WHERE op.order_id = " . $row['order_id'] . " GROUP BY op.order_id");
                if ($query_products->num_rows > 0) {
                    $row['products'] = $query_products->row['products'];
                }

                /* Get Subtotal */
                $row['subtotal'] = 0;
                $query_subtotal = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `subtotal` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'subtotal' GROUP BY ot.order_id");
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get shipping total */
                $row['shipping'] = 0;
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'shipping' GROUP BY ot.order_id");
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get discount total */
                $row['discount'] = 0;
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'discount' GROUP BY ot.order_id");
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get tax total*/
                $row['tax'] = 0;
                /*Get total tax*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'taxjar_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax') GROUP BY ot.order_id");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'avatax_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax') GROUP BY ot.order_id");
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax' GROUP BY ot.order_id");
                }

                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /* Get Total */
                $row['total'] = 0;
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'total' GROUP BY ot.order_id");
                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }

                $city[$row['country_name']][] = $row;

            }

            if ($city) {
                foreach ($city as $key => $val) {
                    $tmp = [];
                    $tmp['country_name'] = $key;
                    $tmp['number_orders'] = sizeof($val);
                    if ($val) {
                        $tmp2 = [];
                        foreach ($val as $k => $v) {
                            if (!in_array((int)$v['customer_id'], $tmp2))
                                $tmp['customers'] += 1;
                            $tmp['items_ordered'] += (int)$v['products'];
                            $tmp['subtotal'] += (float)$v['subtotal'];
                            $tmp['shipping'] += (float)$v['shipping'];
                            $tmp['discount'] += (float)$v['discount'];
                            $tmp['tax'] += (float)$v['tax'];
                            $tmp['total'] += (float)$v['total'];
                        }
                        unset($tmp2);
                    }
                    $reports[] = $tmp;
                    unset($tmp);
                }

            }
        }

        return $reports;
    }

    /**
     * This is for Customer By Country Report Total Order
     * @param array $data
     * @return array
     */
    public function getTotalCustomerCountry( $data = [] ) {
        $where = "1 ";
        $filter_country = isset($data['filter_country'])?$data['filter_country']:"";

        $sql1 = "SELECT COUNT(o.order_id) AS `total`, o.payment_country AS `country_name` FROM " . $this->db->table("orders") . " o ";

        $sql1 .= " WHERE o.customer_id > 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_country)) {
            $sql1 .= " AND `payment_country` LIKE '%".$filter_country."%'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for Customer Group Report
     * @param array $data
     * @return array
     */
    public function getCustomerGroup($data = []) {
        $sql = "SELECT tmp.customer_group_id, tmp.customer_group, tmp.status, SUM(tmp.total_orders) AS orders,  SUM(tmp.customer_order_total) AS total
                FROM (SELECT COUNT(o.order_id) total_orders, o.customer_id, cgd.customer_group_id, cgd.name AS customer_group, c.status, 
                SUM(ROUND(ot.value,2)) customer_order_total
                FROM " . $this->db->table("orders") . " o 
                LEFT JOIN " . $this->db->table("customers") . " c ON (o.customer_id = c.customer_id)
                LEFT JOIN " . $this->db->table("customer_groups") . " cgd ON (c.customer_group_id = cgd.customer_group_id)
                LEFT JOIN " . $this->db->table("order_totals") . " ot ON (ot.order_id = o.order_id)
                WHERE o.customer_id > '0' AND ot.type='total'";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id) tmp GROUP BY tmp.customer_group_id ORDER BY total DESC";

        $query = $this->db->query($sql);
        $reports = [];
        $sum_total = 0;
        $sum_qty = 0;
        if ($query->num_rows > 0) {
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $rows['customer_group'] = $row['customer_group'];
                $rows['orders'] = $row['orders'];
                $rows['total'] = $row['total'];
                $reports[] = $rows;
            }
        }
        return $reports;
    }

    /**
     * This is for Top Customer Report
     * @param array $data
     * @return array
     */
    public function getTopCustomer($data = []) {
        $limit = isset($data['limit'])?$data['limit']:10;
        $reports = [];

        $sql = "SELECT o.customer_id, o.payment_company as customer_company, 
                CONCAT(c.firstname,' ',c.lastname) customer_name, c.email, 
                IFNULL(SUM(ot.value) ,0) subtotal, COUNT(*) AS total_sale, o.store_id, o.date_added FROM " . $this->db->table("orders") . " o
			    LEFT JOIN " . $this->db->table("customers") . " c ON c.customer_id = o.customer_id
			    LEFT JOIN " . $this->db->table("order_totals") . " ot ON ot.order_id=o.order_id";

        $sql .= " WHERE 1 AND o.customer_id > 0 AND ot.type='subtotal' ";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " GROUP BY o.customer_id";
        $sql .= " ORDER BY subtotal DESC ";
        $sql .= " LIMIT " . (int)$limit;

        $query = $this->db->query($sql);

        if ($query->num_rows > 0) {
            $i = 0;
            $customers = $query->rows;
            foreach ($customers as $key => $row) {
                $i++;
                $rows['number'] = $i;
                $rows['customer_name'] = trim($row['customer_name']);
                $rows['customer_company'] = trim($row['customer_company']);
                $rows['email'] = trim($row['email']);
                $rows['total_sale'] = trim($row['total_sale']);
                $rows['subtotal'] = trim($row['subtotal']);
                $rows['customer_id'] = trim($row['customer_id']);
                $reports[] = $rows;
            }
        }

        return $reports;
    }

    /**
     * This is for Customer By Zip Code Report
     * @param array $data
     * @return array
     */
    public function getCustomerByZip($data = []) {
        $where = "1 ";
        $filter_zip = isset($data['filter_zip'])?$data['filter_zip']:"";

        $sql1 = "SELECT o.order_id, o.customer_id, CONCAT(o.payment_city, ', ', o.payment_country, ', ',o.payment_postcode) as postcode, o.date_added FROM " . $this->db->table("orders") . " o ";

        $sql1 .= " WHERE o.customer_id > 0  ";

        if ($data['filter_order_status_id'] != '') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if (!empty($filter_zip)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_country, ', ',o.payment_postcode) LIKE '%" . $filter_zip . "%'";
        }

        $sql1 .= " ORDER BY postcode ASC";

        $query = $this->db->query($sql1);
        $reports = [];

        if ($query->num_rows > 0) {
            $orders = $query->rows;
            $city = [];

            foreach ($orders as $key => $row) {
                $row['postcode'] = trim($row['postcode']);

                if (!isset($city[$row['postcode']])) {
                    $city[$row['postcode']] = [];
                }
                $row['products'] = $row['product_total'] = $row['tax'] = $row['shipping'] = $row['discount'] = 0;

                /*Get number products*/
                $query_products = $this->db->query("SELECT SUM(op.quantity) as `products`
				 FROM " . $this->db->table("order_products") . " op WHERE op.order_id = " . $row['order_id'] . " GROUP BY op.order_id");
                if ($query_products->num_rows > 0) {
                    $row['products'] = $query_products->row['products'];
                }

                /*Get subtotal*/
                $query_subtotal = $this->db->query("SELECT SUM(ot.value) as `subtotal` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'subtotal' GROUP BY ot.order_id");
                if ($query_subtotal->num_rows > 0) {
                    $row['subtotal'] = $query_subtotal->row['subtotal'];
                }

                /*Get tax total*/
                if ($this->validateTaxjar()) {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'taxjar_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } elseif ($this->config->get('avatax_integration_status') === '1') {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE (ot.order_id = " . $row['order_id'] . " AND ot.type = 'avatax_integration') OR (ot.order_id = " . $row['order_id'] . " AND ot.type='tax') GROUP BY ot.order_id");
                } else {
                    $query_tax = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `tax` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'tax' GROUP BY ot.order_id");
                }
                if ($query_tax->num_rows > 0) {
                    $row['tax'] = $query_tax->row['tax'];
                }

                /*Get total products*/
                $query_shipping = $this->db->query("SELECT SUM(ot.value) as `shipping` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'shipping' GROUP BY ot.order_id");
                if ($query_shipping->num_rows > 0) {
                    $row['shipping'] = $query_shipping->row['shipping'];
                }

                /*Get discount total*/
                $query_discount = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `discount` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'discount' GROUP BY ot.order_id");
                if ($query_discount->num_rows > 0) {
                    $row['discount'] = $query_discount->row['discount'];
                }

                /*Get total*/
                $query_total = $this->db->query("SELECT SUM(ROUND(ot.value,2)) as `total` FROM " . $this->db->table("order_totals") . " ot WHERE ot.order_id = " . $row['order_id'] . " AND ot.type = 'total' GROUP BY ot.order_id");
                if ($query_total->num_rows > 0) {
                    $row['total'] = $query_total->row['total'];
                }

                $city[$row['postcode']][] = $row;

            }

            if ($city) {
                foreach ($city as $key => $val) {
                    $tmp = [];
                    $tmp['number_orders'] = sizeof($val);
                    $tmp['items_ordered'] = $tmp['subtotal'] = $tmp['tax'] = $tmp['shipping'] = $tmp['discount'] = $tmp['total'] = $tmp['customers'] = 0;
                    $tmp['city_name'] = $key;
                    if ($val) {
                        $tmp2 = [];
                        foreach ($val as $k => $v) {
                            if (!in_array((int)$v['customer_id'], $tmp2))
                                $tmp['customers'] += 1;
                            $tmp['items_ordered'] += (int)$v['products'];
                            $tmp['subtotal'] += (float)$v['subtotal'];
                            $tmp['shipping'] += (float)$v['shipping'];
                            $tmp['discount'] += (float)$v['discount'];
                            $tmp['tax'] += (float)$v['tax'];
                            $tmp['total'] += (float)$v['total'];
                        }
                        unset($tmp2);
                    }
                    $reports[] = $tmp;
                    unset($tmp);
                }

            }
        }

        return $reports;
    }

    /**
     * This is for Customer By Zip Code Total Order
     * @param array $data
     * @return array
     */
    public function getTotalCustomerZip( $data = [] ) {
        $where = "1 ";
        $filter_city = isset($data['filter_city'])?$data['filter_city']:"";

        $sql1 = "SELECT COUNT(o.order_id) AS `total`, CONCAT(o.payment_city, ', ', o.payment_country) as city_name FROM " . $this->db->table("orders") . " o ";
        $sql1 .= " WHERE o.customer_id > 0  ";

        if ($data['filter_order_status_id']!='') {
            $sql1 .= " AND o.order_status_id IN (" . $data['filter_order_status_id'] . ")";
        } else {
            $sql1 .= " AND o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql1 .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql1 .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql1 .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        if(!empty($filter_city)) {
            $sql1 .= " AND CONCAT(o.payment_city, ', ', o.payment_country) LIKE '%".$filter_city."%'";
        }

        $query = $this->db->query($sql1);

        return isset($query->row['total'])?$query->row['total']:0;
    }

    /**
     * This is for User Activity Report
     * @param array $data
     * @return array
     */
    public function getUserActivity( $data = []) {
        $where = "";
        $report_period = isset($data['report_period'])?$data['report_period']:'month';
        $select_datefield = ' CONCAT(MONTH(tmp.date_added),"/",YEAR(tmp.date_added)) AS datefield';
        switch ($report_period) {
            case 'day':
                $select_datefield = 'DATE(tmp.date_added) AS datefield';
                break;
            case 'week':
                $select_datefield = 'CONCAT(YEAR(tmp.date_added),"0",WEEK(tmp.date_added)) AS datefield';
                break;
            case 'quarter':
                $select_datefield = 'CONCAT(QUARTER(tmp.date_added),"/",YEAR(tmp.date_added)) AS datefield';
                break;
            case 'year':
                $select_datefield = 'YEAR(tmp.date_added) AS datefield';
                break;
        }

        $sql = "";
        $sql .= "SELECT " . $select_datefield . ", SUM(tmp.order_id) number_orders, SUM(tmp.customer_id) number_customers, SUM(tmp.review_id) number_reviews
			FROM ( ";

        $sql .= " SELECT 1 AS order_id, 0 AS customer_id, 0 AS review_id, date_added FROM " . $this->db->table("orders") . " o ";

        if ($data['filter_order_status_id'] != '') {
            $sql .= " WHERE o.order_status_id IN ( " . $data['filter_order_status_id'] . ")";
        } else {
            $sql .= " WHERE o.order_status_id >= '0'";
        }

        $store_id = $this->getStoreId();
        $sql .= " AND o.store_id = " . $store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(o.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(o.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " UNION ";

        $sql .= " SELECT 0 AS order_id, 1 AS customer_id, 0 AS review_id, date_added FROM " . $this->db->table("customers") . " c ";

        $sql .= " WHERE c.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(c.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(c.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= " UNION ";

        $sql .= " SELECT 0 AS order_id, 0 AS customer_id, 1 AS review_id, date_added FROM " . $this->db->table("reviews") . " r ";
        $sql .= " LEFT JOIN " . $this->db->table("products_to_stores") . " p2s ON p2s.product_id = r.product_id ";

        $sql .= " WHERE p2s.store_id = ".$store_id;

        if (!empty($data['filter_date_start'])) {
            $sql .= " AND DATE(r.date_added) >= '" . $this->db->escape($data['filter_date_start']) . "'";
        }

        if (!empty($data['filter_date_end'])) {
            $sql .= " AND DATE(r.date_added) <= '" . $this->db->escape($data['filter_date_end']) . "'";
        }

        $sql .= ") tmp
			GROUP BY datefield ORDER BY datefield ";

        $query = $this->db->query($sql);
        $reports = $query->rows;

        return $reports;
    }

    private function validateTaxjar() {
        if ($this->config->get('taxjar_integration_status')==='1') {
            $this->load->model('extension/taxjar_integration_license_info');
            $license_key = $this->config->get('taxjar_integration_license_code');
            $shared_secret = 'taxjar_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxjar_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxjar_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_taxjar_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxjar_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxjar_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function getStoreId() {
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
}