<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelAdvancedReportsCategory extends Model {

    public function getCategories($parent_id) {
        $language_id = $this->session->data['content_language_id'];
            $category_data = [];

            $sql= "SELECT * FROM ".$this->db->table("categories")." c
		    			  LEFT JOIN ".$this->db->table("category_descriptions")." cd
		    			  ON (c.category_id = cd.category_id)
		    			  WHERE c.parent_id = '" . (int)$parent_id . "'
						  AND cd.language_id = '" . (int)$language_id . "'
		    			  ";

            $sql .=" ORDER BY c.sort_order, cd.name ASC";

            $query=$this->db->query($sql);

        foreach ($query->rows as $result) {
            $category_data[] = [
                'category_id' => $result['category_id'],
                'parent_id' => $result['parent_id'],
                'name'        => $this->getPath($result['category_id'], $language_id)
            ];

            $category_data = array_merge($category_data, $this->getCategories($result['category_id']));
        }

        return $category_data;
    }

    /**
     * @param int $category_id
     * @return string
     */
    public function getPath($category_id) {
        $language_id = (int)$this->session->data['content_language_id'];
        $sql = "SELECT name, parent_id
		        FROM ".$this->db->table("categories")." c
		        LEFT JOIN ".$this->db->table("category_descriptions")." cd
		        ON (c.category_id = cd.category_id)
		        WHERE c.category_id = '" . (int)$category_id . "' AND cd.language_id = '" . $language_id . "'
		        ";

        $sql .=" ORDER BY c.sort_order, cd.name ASC";

        $query=$this->db->query($sql);
        $category_info = $query->row;

        if ($category_info['parent_id']) {
            return $this->getPath($category_info['parent_id'], $language_id) . $this->language->get('text_separator') . html_entity_decode($category_info['name']);
        } else {
            return html_entity_decode($category_info['name']);
        }
    }
}