<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header('Location: static_pages/');
}

/**
 * Class ControllerResponsesAdvancedReportsAutocomplete
 * @property ModelAdvancedReportsProduct $model_advanced_reports_product
 * @property ModelAdvancedReportsCategory $model_advanced_reports_category
 */

class ControllerResponsesAdvancedReportsAutocomplete extends AController {
    /**
     * Get list of products
     */
    public function product() {
        $json = [];

            $this->load->model('advanced_reports/product');
            $params=$this->request->post['search'];

            if (isset($params['filter_name'])) {
                $filter_name = $params['filter_name'];
            } else {
                $filter_name = '';
            }

            $data = [
                'filter_name'  => $filter_name
            ];

            $results = $this->model_advanced_reports_product->getProducts($data);
            sort($results);
            foreach ($results as $result) {

                $json[] = [
                    'id'         => $result['product_id'],
                    'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
                ];
            }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of categories
     */
    public function categories() {
        $json = [];
        $this->load->model('catalog/category');
        // $this->load->model('advanced_reports/category');
        if (isset($this->request->get['filter_name'])) {
            $filter_name = $this->request->get['filter_name'];
        } else {
            $filter_name = '';
        }

        $data = [
            'filter_name'  => $filter_name
        ];

        $results=$this->model_catalog_category->getCategories(0);
        sort($results);
        //$results=$this->model_advanced_reports_category->getCategories(0,$data);
        foreach ($results as $result) {
            $json[] = [
                'id'         => $result['category_id'],
                'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
            ];
        }
        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of product models
     */
    public function product_model() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_model'])) {
            $filter_model = $params['filter_model'];
        } else {
            $filter_model = '';
        }

        $data = [
            'filter_model'  => $filter_model
        ];

        $results = $this->model_advanced_reports_product->getProducts($data);
        sort($results);
        foreach ($results as $result) {

            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['model'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of product manufacturers
     */
    public function product_manufacturer() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_manufacturer'])) {
            $filter_manufacturer = $params['filter_manufacturer'];
        } else {
            $filter_manufacturer = '';
        }
        $data = [
            'filter_manufacturer'  => $filter_manufacturer
        ];

        $results = $this->model_advanced_reports_product->getManufacturer($data);
        sort($results);
        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['name'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order postcode
     */
    public function company() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_customer_company'])) {
            $filter_customer_company = $params['filter_customer_company'];
        } else {
            $filter_customer_company = '';
        }

        $data = [
            'filter_customer_company'  => $filter_customer_company,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getCompany($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['company'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order postcode
     */
    public function email() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_customer_email'])) {
            $filter_customer_email = $params['filter_customer_email'];
        } else {
            $filter_customer_email = '';
        }

        $data = [
            'filter_customer_email'  => $filter_customer_email,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getEmail($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['email'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order region
     */
    public function region() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_region'])) {
            $filter_region = $params['filter_region'];
        } else {
            $filter_region = '';
        }

        $data = [
            'filter_region'  => $filter_region,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getRegion($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['region'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order city
     */
    public function city() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_city'])) {
            $filter_city = $params['filter_city'];
        } else {
            $filter_city = '';
        }

        $data = [
            'filter_city'  => $filter_city,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getCity($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['city'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order postcode
     */
    public function zipcode() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];

        if (isset($params['filter_zipcode'])) {
            $filter_zipcode = $params['filter_zipcode'];
        } else {
            $filter_zipcode = '';
        }

        $data = [
            'filter_zipcode'  => $filter_zipcode,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getZipCode($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['zipcode'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }

    /**
     * get list of order postcode
     */
    public function country() {
        $json = [];

        $this->load->model('advanced_reports/product');
        $params=$this->request->post['search'];
        if (isset($params['filter_country'])) {
            $filter_country = $params['filter_country'];
        } else {
            $filter_country = '';
        }

        $data = [
            'filter_country'  => $filter_country,
            'filter_date_start' => $params['filter_date_start'],
            'filter_date_end' => $params['filter_date_end']
        ];

        $results = $this->model_advanced_reports_product->getCountry($data);
        sort($results);

        foreach ($results as $result) {
            $json[] = [
                'name'       => strip_tags(html_entity_decode($result['country'], ENT_QUOTES, 'UTF-8'))
            ];
        }

        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($json));
    }
}