<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsTax
 * @property ModelAdvancedReportsTax $model_advanced_reports_tax
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */
class ControllerPagesAdvancedReportsTax extends Report_Abstract
{
    public $data = [];
    private $headers = [];
    private $totals = [];

    public function main () {
        $this->load();
        $this->processTemplate('pages/advanced_reports/tax.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/tax');

        $this->setModel( $this->model_advanced_reports_tax );

        $this->document->setTitle($this->language->get('heading_title_tax'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "day";
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        if (isset($this->request->get['filter_states']) && $this->request->get['filter_states']!='all') {
            $filter_states = $this->request->get['filter_states'];
        } else {
            $filter_states = "all";
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/tax'),
            'text'      => $this->language->get('heading_title_tax'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['reports'] = [];

        $data = [
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'report_period'			 => $report_period,
            'filter_states'          => $filter_states
        ];

        $results = $this->getModel()->getTaxReport($data);
        $sum_tax_charged = 0.00;
        $sum_non_taxable_sales = 0.00;
        $sum_tax_exempt = 0.00;
        $sum_taxable_sales = 0.00;
        $sum_total = 0.00;
        if($results) {
            foreach($results as $key=>$result) {
                if($result) {
                    $sum_total += round((float)$result['total'],2);
                    $sum_tax_charged += round((float)$result['tax_charged'],2);
                    $sum_non_taxable_sales += round((float)$result['non_taxable_sales'],2);
                    $sum_tax_exempt += round((float)$result['tax_exempt'],2);
                    $sum_taxable_sales += round((float)$result['taxable_sales'],2);
                    $tmp_total = round(isset($result['total'])?$result['total']:0,2);
                    $tmp_tax_charged = round((isset($result['tax_charged']) && $result['tax_charged'])?$result['tax_charged']:0,2);
                    $tmp_not_taxable_sales = round((isset($result['non_taxable_sales']) && $result['non_taxable_sales'])?$result['non_taxable_sales']:0,2);
                    $tmp_tax_exempt = round((isset($result['tax_exempt']) && $result['tax_exempt'])?$result['tax_exempt']:0,2);
                    $tmp_taxable_sales = round((isset($result['taxable_sales']) && $result['taxable_sales'])?$result['taxable_sales']:0,2);
                    $date_time = strtotime($result['datefield']);
                    $tmp_day = date('M d, Y', $date_time);
                    $results[$key]['datefield']=$tmp_day;
                    $results[$key]['order_id']=$result['order_id'];
                    $results[$key]['total'] = $tmp_total;
                    $results[$key]['non_taxable_sales'] = $tmp_not_taxable_sales;
                    $results[$key]['tax_exempt'] = $tmp_tax_exempt;
                    $results[$key]['taxable_sales'] = $tmp_taxable_sales;
                    $results[$key]['tax_charged'] = $tmp_tax_charged;
                    if ($tmp_total==0) {
                        $results[$key]['total2'] = '--';
                    } else {
                        $results[$key]['total2'] = $this->currency->format($tmp_total, $this->config->get('config_currency'));
                    }
                    if ($tmp_not_taxable_sales==0) {
                        $results[$key]['non_taxable_sales2'] = '--';
                    } else {
                        $results[$key]['non_taxable_sales2'] = $this->currency->format($tmp_not_taxable_sales, $this->config->get('config_currency'));
                    }
                    if ($tmp_tax_exempt==0){
                        $results[$key]['tax_exempt2'] = '--';
                    } else {
                        $results[$key]['tax_exempt2'] = $this->currency->format($tmp_tax_exempt, $this->config->get('config_currency'));
                    }
                    if ($tmp_taxable_sales==0) {
                        $results[$key]['taxable_sales2'] = '--';
                    } else {
                        $results[$key]['taxable_sales2'] = $this->currency->format($tmp_taxable_sales, $this->config->get('config_currency'));
                    }
                    $results[$key]['tax_charged2'] = $this->currency->format($tmp_tax_charged, $this->config->get('config_currency'));
                    $results[$key]['tax_rate']=$result['tax_rate'];
                    $results[$key]['zone']=(isset($result['zone']) && $result['zone'])?$result['zone']:'All';
                    $results[$key]['description']=$result['description'];
                }
            }
        }

        $this->_reports = $results;
        $this->data['report_period'] = $report_period;
        $this->data['reports'] = $results;
        $sum_orders=count($results);
        $this->data['sum_orders'] = $sum_orders;
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));
        $this->data['sum_non_taxable_sales'] = $this->currency->format($sum_non_taxable_sales, $this->config->get('config_currency'));
        $this->data['sum_tax_exempt'] = $this->currency->format($sum_tax_exempt, $this->config->get('config_currency'));
        $this->data['sum_taxable_sales'] = $this->currency->format($sum_taxable_sales, $this->config->get('config_currency'));
        $this->data['sum_tax_charged'] = $this->currency->format($sum_tax_charged, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_tax');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');

        $this->data['column_period'] = $this->language->get('column_period');
        $this->data['column_order_id'] = $this->language->get('column_order_id');
        $this->data['column_total'] = $this->language->get('column_total');
        $this->data['column_not_taxable_sales'] = $this->language->get('column_not_taxable_sales');
        $this->data['column_tax_exempt'] = $this->language->get('column_tax_exempt');
        $this->data['column_taxable_sales'] = $this->language->get('column_taxable_sales');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_tax_rate'] = $this->language->get('column_tax_rate');
        $this->data['column_location'] = $this->language->get('column_location');
        $this->data['column_zone'] = $this->language->get('column_zone');
        $this->data['column_description'] = $this->language->get('column_description');

        $this->headers = [
                'A' => $this->data['column_period'],
                'B' => $this->data['column_order_id'],
                'C' => $this->data['column_total'],
                'D' => $this->data['column_not_taxable_sales'],
                'E' => $this->data['column_tax_exempt'],
                'F' => $this->data['column_taxable_sales'],
                'G' => $this->data['column_tax'],
                'H' => $this->data['column_tax_rate'],
                'I' => $this->data['column_location'],
                'J' => $this->data['column_zone'],
                'K' => $this->data['column_description']
            ];

        $this->totals = [
                'A' => 'Total',
                'B' => (int)$sum_orders,
                'C' => (float)$sum_total,
                'D' => (float)$sum_non_taxable_sales,
                'E' => (float)$sum_tax_exempt,
                'F' => (float)$sum_taxable_sales,
                'G' => (float)$sum_tax_charged,
                'H' => '',
                'I' => '',
                'J' => '',
                'K' => ''
            ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['entry_states'] = $this->language->get('entry_states');
        $this->data['detail_key'] = $this->language->get('detail_key');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $zones=$this->getModel()->getTaxZones();
        $zone['all']='All';
        if (isset($zones)) {
            foreach ($zones as $k => $v) {
                $zone[$v] = $v;
            }
            $this->data['zones'] = $zone;
        }

        $this->data['detail_key_list'] = ["0" => $this->language->get('text_grouped'),
            "1" => $this->language->get('text_detailed')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;
        $this->data['filter_states'] = $filter_states;

        $this->load->model('localisation/order_status');

        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;

        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/tax/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/tax');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {
        $this->load();

        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/tax.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }

        $reports = [];
        $reports['name'] = 'Tax Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $reports['border']='B';
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "day";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['datefield'] = $val['datefield'];
                $tmp1['order_id'] = $val['order_id'];
                $tmp1['total'] = round((float) $val['total'],2);
                $tmp1['non_taxable_sales'] = round((float) $val['non_taxable_sales'],2);
                $tmp1['tax_exempt'] = round((float) $val['tax_exempt'],2);
                $tmp1['taxable_sales'] = round((float) $val['taxable_sales'],2);
                $tmp1['tax_charged'] = round((float) $val['tax_charged'],2);
                $tmp1['tax_rate'] = $val['tax_rate'];
                $tmp1['location'] = $val['location'];
                $tmp1['zone'] = $val['zone'];
                $tmp1['description'] = $val['description'];
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }

        $this->exportReport( $reports, [], $export_type );
    }

    protected function queryReports( $data ){
        return $this->getModel()->getTaxReport($data);
    }

}