<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsSaleStatistics
 * @property ModelAdvancedReportsSale $model_advanced_reports_sale
 * @property ModelAdvancedReportsChart $model_advanced_reports_chart
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsSaleStatistics extends Report_Abstract {

    public $data = [];
    private $headers = [];
    private $totals = [];

    public function main () {
        $this->load();
        $this->processTemplate('pages/advanced_reports/sale_statistics.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/sale');

        $this->setModel( $this->model_advanced_reports_sale );

        $this->document->setTitle($this->language->get('heading_title_sales_statistics'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));

        $this->document->addScript('https://www.google.com/jsapi');

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['filter_reload_key'])) {
            $filter_reload_key = $this->request->get['filter_reload_key'];
        } else {
            $filter_reload_key = "qty";
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "month";
        }

        if (isset($this->request->get['detail_key'])) {
            $detail_key = $this->request->get['detail_key'];
        } else {
            $detail_key = "1";
        }

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('advanced_reports/sale_statistics'),
            'text'      => $this->language->get('heading_title_sales_statistics'),
            'separator' => ' :: ',
            'current' => true
        ]);

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'filter_reload_key' 	 => $filter_reload_key,
            'report_period'			 => $report_period,
            'detail_key'			 => $detail_key
        ];

        $results = $this->getReports2( $data, $report_period);

        $sum_orders = 0;
        $sum_items_ordered = 0;
        $sum_subtotal = 0.00;
        $sum_tax = 0.00;
        $sum_shipping = 0.00;
        $sum_discount = 0.00;
        $sum_total = 0.00;

        if($results) {
            foreach($results as $key => $result) {
                if($result) {
                    $sum_orders += (int)$result['number_orders'];
                    $sum_items_ordered += (int)$result['items_ordered'];
                    $sum_total += (float)$result['total'];
                    $tmp_subtotal = $tmp_tax = $tmp_shipping = $tmp_discount = $tmp_total = 0;
                    $tmp_subtotal = isset($result['subtotal'])?$result['subtotal']:0;
                    $tmp_total = isset($result['total'])?$result['total']:0;
                    $total_avg = isset($result['total_avg'])?$result['total_avg']:0;
                    $product_total_avg = isset($result['product_total_avg'])?$result['product_total_avg']:0;
                    $results[$key]['datefield'] = $key;
                    $results[$key]['tax'] = $tmp_tax;
                    $results[$key]['total'] = $tmp_total;
                    $results[$key]['total_avg'] = round($total_avg,2);
                    $results[$key]['product_total_avg'] = round($product_total_avg,2);
                    $results[$key]['total2'] = $this->currency->format($tmp_total, $this->config->get('config_currency'));
                    $results[$key]['total_avg2'] = $this->currency->format($total_avg, $this->config->get('config_currency'));
                    $results[$key]['product_total_avg2'] = $this->currency->format($product_total_avg, $this->config->get('config_currency'));
                } else {
                    unset($results[$key]);
                }
            }
        }

        $this->_reports = $results;
        $this->data['reports'] = $results;
        $this->data['sum_items_ordered'] = $sum_items_ordered;
        $this->data['sum_orders'] = $sum_orders;
        $this->data['sum_tax'] = $sum_tax;
        $this->data['sum_shipping'] = $sum_shipping;
        $this->data['sum_discount'] = $sum_discount;
        $this->data['sum_total'] = $sum_total;
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));
        $this->data['sum_tax_with_currency'] = $this->currency->format($sum_tax, $this->config->get('config_currency'));
        $this->data['sum_shipping_with_currency'] = $this->currency->format($sum_shipping, $this->config->get('config_currency'));
        if((float)$sum_discount < 0) {
            $this->data['sum_discount_with_currency'] = "-".$this->currency->format(-$sum_discount, $this->config->get('config_currency'));
        } else {
            $this->data['sum_discount_with_currency'] = $this->currency->format($sum_discount, $this->config->get('config_currency'));
        }

        $this->data['heading_title'] = $this->language->get('heading_title_sales_statistics');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');

        $this->data['column_period'] = $this->language->get('column_period');
        $this->data['column_number_orders'] = $this->language->get('column_number_orders');
        $this->data['column_items_ordered'] = $this->language->get('column_items_ordered');
        $this->data['column_subtotal'] = $this->language->get('column_subtotal');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_shipping'] = $this->language->get('column_shipping');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_order_total'] = $this->language->get('column_order_total');
        $this->data['column_order_amount_avg'] = $this->language->get('column_order_amount_avg');
        $this->data['column_item_final_price_avg'] = $this->language->get('column_item_final_price_avg');

        $this->headers=[
            'A'=>$this->data['column_period'],
            'B'=>$this->data['column_number_orders'],
            'C'=>$this->data['column_items_ordered'],
            'D'=>$this->data['column_order_total'],
            'E'=>$this->data['column_order_amount_avg'],
            'F'=>$this->data['column_item_final_price_avg']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>(int) $sum_orders,
            'C'=>(int) $sum_items_ordered,
            'D'=>round((float) $sum_total,2),
            'E'=>'',
            'F'=>''
        ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['entry_show_by'] = $this->language->get('entry_show_by');
        $this->data['detail_key'] = $this->language->get('detail_key');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        switch ($filter_reload_key) {
            case 'total':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_total");
                $this->data['text_verticle_title'] = $this->language->get("column_order_total");
                break;
            case 'subtotal':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_subtotal");
                $this->data['text_verticle_title'] = $this->language->get("column_subtotal");
                break;
            case 'qty':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_number_orders");
                $this->data['text_verticle_title'] = $this->language->get("column_number_orders");
                break;
            case 'qty_item':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_items_ordered");
                $this->data['text_verticle_title'] = $this->language->get("column_items_ordered");
                break;
        }
        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["total" => $this->language->get('column_order_total'),
            "subtotal" => $this->language->get('column_subtotal'),
            "qty" => $this->language->get('column_number_orders'),
            "qty_item" => $this->language->get('column_items_ordered')];

        $this->data['detail_key_list'] = ["0" => $this->language->get('text_grouped'),
            "1" => $this->language->get('text_detailed')];

        $this->data['period_list'] = ["day" => $this->language->get('text_day'),
            "week" => $this->language->get('text_week'),
            "month" => $this->language->get('text_month'),
            "quarter" => $this->language->get('text_quarter'),
            "year" => $this->language->get('text_year')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;

        $chartW=$this->config->get('advanced_reports_chart_width');
        $chartH=$this->config->get('advanced_reports_chart_height');
        $this->data['chart_width'] = isset($chartW)?(int)$chartW:300;
        $this->data['chart_height'] = isset($chartH)?(int)$chartH:300;

        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;
        $this->data['filter_reload_key'] = $filter_reload_key;
        $this->data['report_period'] = $report_period;
        $this->data['detail_key'] = $detail_key;

        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/sale_statistics/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/sale_statistics');
        $this->data['url']=$this->html->getSecureURL('r/advanced_reports/chart/add');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {

        $this->load();
        $this->load->model('advanced_reports/chart');
        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $val=$this->model_advanced_reports_chart->get('sales_statistics');
            if ($export_type=='pdf'){
                $this->data['chart']="<img src='".$val['value']."' style='width:800px;height:".$this->data['chart_height']."px'>";
            }
            elseif ($export_type=='html') {
                $this->data['chart']="<img src='".$val['value']."'>";
            }
            $this->data['visible'] = 1;
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/sale_statistics.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Sales Statistic Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers'] = $this->headers;
        $reports['totals'] = $this->totals;
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A3';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['datefield'] = $key;
                $tmp1['number_orders'] = (int) $val['number_orders'];
                $tmp1['items_ordered'] = (int) $val['items_ordered'];
                $tmp1['total'] = round((float) $val['total'],2);
                $tmp1['total_avg'] = round((float) $val['total_avg'],2);
                $tmp1['product_total_avg'] = round((float) $val['product_total_avg'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
        $this->model_advanced_reports_chart->delete('sale_statistics');
    }

    protected function queryReports( $data ){
        return $this->getModel()->getSaleStatistics($data);
    }
 }