<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsSaleProfitBuildAGift
 * @property ModelAdvancedReportsSale $model_advanced_reports_sale
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsSaleProfitBuildAGift extends Report_Abstract {

    public $data = [];
    private $headers = [];
    private $totals = [];
    private $total_option='';
    private $count='';

    public function main(){
        $this->load();
        $this->processTemplate('pages/advanced_reports/sale_profit_build_a_gift.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');
        $this->language->load('build_a_gift/build_a_gift');

        $this->load->model('sale/order');
        $this->load->model('advanced_reports/sale');

        $this->setModel( $this->model_advanced_reports_sale );

        $this->document->setTitle($this->language->get('heading_title_sales_profit_build_a_gift'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.mousewheel.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/bootstrap-typeahead.min.js'));

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "day";
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        if (isset($this->request->get['filter_model'])) {
            $filter_model = $this->request->get['filter_model'];
        } else {
            $filter_model = "";
        }

        if (isset($this->request->get['filter_customer_email'])) {
            $filter_customer_email = $this->request->get['filter_customer_email'];
        } else {
            $filter_customer_email = "";
        }

        if (isset($this->request->get['filter_customer_company'])) {
            $filter_customer_company = $this->request->get['filter_customer_company'];
        } else {
            $filter_customer_company = "";
        }

        if (isset($this->request->get['filter_country'])) {
            $filter_country = $this->request->get['filter_country'];
        } else {
            $filter_country = "";
        }

        if (isset($this->request->get['filter_region'])) {
            $filter_region = $this->request->get['filter_region'];
        } else {
            $filter_region = "";
        }

        if (isset($this->request->get['filter_city'])) {
            $filter_city = $this->request->get['filter_city'];
        } else {
            $filter_city = "";
        }

        if (isset($this->request->get['filter_zipcode'])) {
            $filter_zipcode = $this->request->get['filter_zipcode'];
        } else {
            $filter_zipcode = "";
        }

        if (isset($this->request->get['filter_product_name'])) {
            $filter_product_name = $this->request->get['filter_product_name'];
        } else {
            $filter_product_name = "";
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $filter_manufacturer = $this->request->get['filter_manufacturer'];
        } else {
            $filter_manufacturer = "";
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/sale_profit_build_a_gift'),
            'text'      => $this->language->get('heading_title_sales_profit_build_a_gift'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id'     => $filter_order_status_id,
            'filter_date_start'	         => $filter_date_start,
            'filter_date_end'	         => $filter_date_end,
            'filter_model'			     => $filter_model,
            'filter_customer_email'	     => $filter_customer_email,
            'filter_customer_company'	 => $filter_customer_company,
            'filter_country'		     => $filter_country,
            'filter_region'			     => $filter_region,
            'filter_city'			     => $filter_city,
            'filter_zipcode'		     => $filter_zipcode,
            'filter_product_name'	     => $filter_product_name,
            'filter_manufacturer'	     => $filter_manufacturer,
            'report_period'			     => $report_period,
        ];

        $results = $this->getModel()->getSaleProfitBuildAGift( $data );

        $sum_quantity = 0;
        $sum_subtotal = 0.00;
        $sum_cost = 0.00;
        $sum_profit = 0.00;
        $sum_tax = 0.00;
        $sum_price = 0.00;
        $sum_original_price = 0.00;
        $sum_total = 0.00;
        $sum_total_include_tax = 0.00;
        $sum_discount=0.00;
        $tmp_results = [];
        if($results) {
            foreach($results as $key => $result) {
                if($result) {
                    //$tmp_cost = $result['cost'];
                    $cost=0;
                    if ($result['option']) {
                        foreach ($result['option'] as $k=>$v){
                            $cost+=(float)($v['cost']*$result['quantity']);
                            $price=$v['price'];
                        }
                    }
                    if ($result['cost']===0.00 && $result['cost2']!==0.00) {
                        $tmp_cost = round($result['cost2'],2);
                    }  else {
                        $tmp_cost = round($result['cost']+$cost,2);
                    }
                    $tmp_tax = round(isset($result['tax'])?$result['tax']:0,2);
                    $tmp_original_price = round(isset($result['original_price'])?$result['original_price']:0,2);
                    $tmp_original_price2=$tmp_original_price+$price;
                    $tmp_price = round(isset($result['price'])?$result['price']:0,2);
                    $tmp_total = round(isset($result['total'])?$result['total']:0,2);
                    $tmp_discount = -round(isset($result['discount'])?$result['discount']:0,2);
                    $tmp_profit = $tmp_total-$tmp_discount-$tmp_cost;
                    $tmp_clean_total=$tmp_total-$tmp_discount;
                    $tmp_total_include_tax = $tmp_clean_total+$tmp_tax;
                    $sum_quantity += (int)$result['quantity'];
                    $sum_subtotal += (float)$result['subtotal'];
                    $sum_cost += (float)$tmp_cost;
                    $sum_profit += (float)$tmp_profit;
                    $sum_discount +=(float)$tmp_discount;
                    $sum_tax += (float)$tmp_tax;
                    $sum_price += (float)$result['price'];
                    $sum_original_price += (float)$tmp_original_price2;
                    //$sum_original_price += (float)$result['original_price'];
                    $sum_total += $tmp_clean_total;
                    $sum_total_include_tax += $tmp_clean_total + $tmp_tax;
                    $results[$key]['product_name']=$result['product_name'];
                    $results[$key]['pricing_type']=$result['pricing_type'];
                    $results[$key]['total'] = (float)$tmp_clean_total;
                    $results[$key]['discount'] = (float)$tmp_discount;
                    $results[$key]['total_include_tax'] = (float)$tmp_total_include_tax;
                    $results[$key]['tax'] = (float)$tmp_tax;
                    $results[$key]['option']=$result['option'];
                    $results[$key]['cost'] = (float)$tmp_cost;
                    if ($result['cost2']!==0.00 && $result['cost']===0.00) {
                        $results[$key]['product_cost']='1';
                    } else {
                        $results[$key]['product_cost']='0';
                    }
                    $results[$key]['profit'] = (float)$tmp_profit;
                    $results[$key]['price'] = (float)$tmp_price;
                    $results[$key]['original_price'] = round((float)$tmp_original_price2,2);
                    $results[$key]['total2'] = $this->currency->format($tmp_clean_total, $this->config->get('config_currency'));
                    $results[$key]['discount2'] = $this->currency->format($tmp_discount, $this->config->get('config_currency'));
                    $results[$key]['total_include_tax2'] = $this->currency->format($tmp_total_include_tax, $this->config->get('config_currency'));
                    $results[$key]['tax2'] = $this->currency->format($tmp_tax, $this->config->get('config_currency'));
                    $results[$key]['cost2'] = $this->currency->format($tmp_cost, $this->config->get('config_currency'));
                    $results[$key]['profit2'] = $this->currency->format($tmp_profit, $this->config->get('config_currency'));
                    $results[$key]['price2'] = $this->currency->format($tmp_price, $this->config->get('config_currency'));
                    $results[$key]['original_price2'] = $this->currency->format($tmp_original_price2, $this->config->get('config_currency'));
                    $results[$key]['product_link'] = $this->html->getSecureURL('catalog/product/update',  '&product_id=' . $result['product_id']);
                    $results[$key]['order_link'] = $this->html->getSecureURL('sale/order/details','&order_id=' . $result['order_id']);
                    $tmp_results[] = $results[$key];
                }
            }
        }
        $this->_reports = $tmp_results;
        $this->data['reports'] = $tmp_results;
        $this->data['sum_quantity'] = $sum_quantity;
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));
        $this->data['sum_total_tax_with_currency'] = $this->currency->format($sum_total_include_tax, $this->config->get('config_currency'));
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));
        $this->data['sum_discount_with_currency'] = $this->currency->format($sum_discount, $this->config->get('config_currency'));
        $this->data['sum_cost_with_currency'] = $this->currency->format($sum_cost, $this->config->get('config_currency'));
        $this->data['sum_profit_with_currency'] = $this->currency->format($sum_profit, $this->config->get('config_currency'));
        $this->data['sum_tax_with_currency'] = $this->currency->format($sum_tax, $this->config->get('config_currency'));
        $this->data['sum_price_with_currency'] = $this->currency->format($sum_price, $this->config->get('config_currency'));
        $this->data['sum_original_price_with_currency'] = $this->currency->format($sum_original_price, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_sales_report');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');
        $this->data['text_view'] = $this->language->get('text_view');

        $this->data['column_order_id'] = $this->language->get('column_order_id');
        $this->data['column_pricing_type'] = $this->language->get('column_pricing_type');
        $this->data['column_invoice_no'] = $this->language->get('column_invoice_no');
        $this->data['column_order_date'] = $this->language->get('column_order_date');
        $this->data['column_model'] = $this->language->get('column_model');
        $this->data['column_customer_email'] = $this->language->get('column_customer_email');
        $this->data['column_customer_company'] = $this->language->get('column_customer_company');
        $this->data['column_customer_group'] = $this->language->get('column_customer_group');
        $this->data['column_country'] = $this->language->get('column_country');
        $this->data['column_region'] = $this->language->get('column_region');
        $this->data['column_city'] = $this->language->get('column_city');
        $this->data['column_zipcode'] = $this->language->get('column_zipcode');
        $this->data['column_product_name'] = $this->language->get('column_product_name');
        $this->data['column_manufacturer'] = $this->language->get('column_manufacturer');
        $this->data['column_qty_ordered'] = $this->language->get('column_qty_ordered');
        $this->data['column_final_price'] = $this->language->get('column_final_price');
        $this->data['column_original_price'] = $this->language->get('column_original_price');
        $this->data['column_option_price'] = $this->language->get('column_option_price');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_selling_price'] = $this->language->get('column_selling_price');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_total_include_tax'] = $this->language->get('column_total_include_tax');
        $this->data['column_cost'] = $this->language->get('column_cost');
        $this->data['column_profit'] = $this->language->get('column_profit');
        $this->data['column_view_order'] = $this->language->get('column_view_order');
        $this->data['column_view_product'] = $this->language->get('column_view_product');
        $this->data['column_coupon_name'] = $this->language->get('column_coupon_name');
        $report=$this->getReportData();
        $opt_total=$attribute=$attributes=$totals=$cols=[];
        $attr='M';
        foreach($report as $k=>$v) {
            $opt_total[]=$v['total_option'];
        }

        if ($opt_total) {
            $this->total_option = max($opt_total);
        }

        $headers=[
            'A'=>$this->data['column_order_id'],
            'B'=>$this->data['column_invoice_no'],
            'C'=>$this->data['column_order_date'],
            'D'=>$this->data['column_customer_email'],
            'E'=>$this->data['column_customer_company'],
            'F'=>$this->data['column_customer_group'],
            'G'=>$this->data['column_country'],
            'H'=>$this->data['column_region'],
            'I'=>$this->data['column_city'],
            'J'=>$this->data['column_zipcode'],
            'K'=>$this->data['column_model'],
            'L'=>$this->data['column_product_name']
        ];
        for ($i = 1; $i <= $this->total_option; $i++) {
            if ($i==$this->total_option) {
                $col=$attr;
            }
            $attribute[$attr]=$this->language->get('column_items').' '.$i;
            $attributes[$attr]='';
            ++$attr;
        }
        if ($col) {
            $col1 = ++$col;
            $col2 = ++$col;
            $col3 = ++$col;
            $col4 = ++$col;
            $col5 = ++$col;
            $col6 = ++$col;
            $col7 = ++$col;
            $col8 = ++$col;
            $col9 = ++$col;
            $col10 = ++$col;
        } else {
            $col1 = $attr;
            $col2 = ++$attr;
            $col3 = ++$attr;
            $col4 = ++$attr;
            $col5 = ++$attr;
            $col6 = ++$attr;
            $col7 = ++$attr;
            $col8 = ++$attr;
            $col9 = ++$attr;
            $col10 = ++$attr;
        }

        $headers=array_merge($headers,$attribute);
        $last=[
            $col1=>$this->data['column_pricing_type'],
            $col2=>$this->data['column_qty_ordered'],
            $col3=>$this->data['column_price'],
            $col4=>$this->data['column_coupon_name'],
            $col5=>$this->data['column_discounts'],
            $col6=>$this->data['column_selling_price'],
            $col7=>$this->data['column_tax'],
            $col8=>$this->data['column_total_include_tax'],
            $col9=>$this->data['column_cost'],
            $col10=>$this->data['column_profit']
        ];
        $headers=array_merge($headers,$last);
        $this->headers=$headers;
        $totalH=[
            'A'=>'Total',
            'B'=>'',
            'C'=>'',
            'D'=>'',
            'E'=>'',
            'F'=>'',
            'G'=>'',
            'H'=>'',
            'I'=>'',
            'J'=>'',
            'K'=>'',
            'L'=>'',
            'M'=>''];

        $totalT=array_merge($totalH,$attributes);
        $lastT=[
            $col1=>'',
            $col2=>(int) $sum_quantity,
            $col3=>'',
            $col4=>'',
            $col5=>(float) $sum_discount,
            $col6=>(float) $sum_total,
            $col7=>(float) $sum_tax,
            $col8=>(float) $sum_total_include_tax,
            $col9=>(float) $sum_cost,
            $col10=>(float) $sum_profit
        ];
        $totalT=array_merge($totalT,$lastT);
        $this->totals=$totalT;

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['entry_show_by'] = $this->language->get('entry_show_by');
        $this->data['detail_key'] = $this->language->get('detail_key');
        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');
        $this->data['token'] = $this->session->data['token'];
        $this->data['key_list'] = ["total" => $this->language->get('column_total'),
            "subtotal" => $this->language->get('column_subtotal'),
            "qty" => $this->language->get('column_number_orders'),
            "qty_item" => $this->language->get('column_items_ordered')];

        $this->data['detail_key_list'] = ["0" => $this->language->get('text_grouped'),
            "1" => $this->language->get('text_detailed')];

        $this->data['period_list'] = ["day" => $this->language->get('text_day'),
            "week" => $this->language->get('text_week'),
            "month" => $this->language->get('text_month'),
            "quarter" => $this->language->get('text_quarter'),
            "year" => $this->language->get('text_year')];

        $this->data['export_types'] = $this->get_export_types();
        $this->data['currency']=$this->config->get('config_currency');
        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;
        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;
        $this->data['filter_model'] = $filter_model;
        $this->data['filter_customer_email'] = $filter_customer_email;
        $this->data['filter_customer_company'] = $filter_customer_company;
        $this->data['filter_country'] = $filter_country;
        $this->data['filter_region'] = $filter_region;
        $this->data['filter_city'] = $filter_city;
        $this->data['filter_zipcode'] = $filter_zipcode;
        $this->data['filter_product_name'] = $filter_product_name;
        $this->data['filter_manufacturer'] = $filter_manufacturer;
        $this->data['productName']=$this->html->getSecureURL('r/advanced_reports/autocomplete/product');
        $this->data['productModel']=$this->html->getSecureURL('r/advanced_reports/autocomplete/product_model');
        $this->data['productManufacturer']=$this->html->getSecureURL('r/advanced_reports/autocomplete/product_manufacturer');
        $this->data['company']=$this->html->getSecureURL('r/advanced_reports/autocomplete/company');
        $this->data['email']=$this->html->getSecureURL('r/advanced_reports/autocomplete/email');
        $this->data['region']=$this->html->getSecureURL('r/advanced_reports/autocomplete/region');
        $this->data['city']=$this->html->getSecureURL('r/advanced_reports/autocomplete/city');
        $this->data['zipcode']=$this->html->getSecureURL('r/advanced_reports/autocomplete/zipcode');
        $this->data['country']=$this->html->getSecureURL('r/advanced_reports/autocomplete/country');
        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/sale_profit_build_a_gift/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/sale_profit_build_a_gift');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {

        $this->load();
        $export_type = $this->request->get["export_type"];
        if($export_type === "pdf" || $export_type === "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/sale_profit_build_a_gift.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Build A Gift Profit Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $reports['border']='L';
        $reports['orientation']='landscape';
        $reports['paper']='A0';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = $temp = [];
            $i = 1;

            foreach ($reports['data'] as $key => $val) {
                $tmp1 = [];
                $tmp1['order_id'] = $val['order_id'];
                $tmp1['invoice_id'] = $val['invoice_id'];
                $tmp1['order_date'] = $val['order_date'];
                $tmp1['customer_email'] = $val['customer_email'];
                $tmp1['customer_company'] = $val['customer_company'];
                $tmp1['custom_group_name'] = $val['custom_group_name'];
                $tmp1['country'] = $val['country'];
                $tmp1['region'] = $val['region'];
                $tmp1['city'] = $val['city'];
                $tmp1['zipcode'] = $val['zipcode'];
                $tmp1['model'] = $val['model'];
                $tmp1['product_name'] = $val['product_name'];
                if ($export_type === "csv" || $export_type === "xls" || $export_type === 'xlsx') {
                    $options = $val['option'];
                    $total_opts=$this->total_option;
                    if ($options) {
                        foreach ($options as $k => $option) {
                            if ($option['value']) {
                                $tmp1['item' . $k] = $option['name'] . ' - ' . $option['value'];
                            } else {
                                $tmp1['item' . $k] = $option['name'];
                            }
                        }

                        $opts=sizeof((array)$options);
                        $j=$total_opts-$opts;
                        for ($a=1;$a<=$j;++$a) {
                            $tmp1[$a]='';
                        }
                    } else {
                        for ($a=1;$a<=$total_opts;++$a) {
                            $tmp1[$a]='';
                        }
                    }
                }
                $tmp1['pricing_type'] = $val['pricing_type'];
                $tmp1['quantity'] = (int)$val['quantity'];
                $tmp1['price'] = round((float)$val['price'],2);
                $tmp1['coupon_name'] = $val['coupon_name'];
                $tmp1['discount'] = round((float)($val['discount']),2);
                $tmp1['total'] = round((float)$val['total'],2);
                $tmp1['tax'] = round((float)$val['tax'],2);
                $tmp1['total'] = round((float)$val['total'],2);
                $tmp1['total_include_tax'] = round((float)$val['total_include_tax'],2);
                $tmp1['cost'] = round((float)$val['cost'],2);
                $tmp1['profit'] = round((float)$val['profit'],2);
                $tmp[$report_period . $i] = $tmp1;
                $i++;
                if ($export_type == "pdf" || $export_type == "html") {
                    $options = $val['option'];
                    if ($options) {
                        foreach ($options as $option) {
                            $tmp1['order_id'] = '';
                            $tmp1['invoice_id'] = '';
                            $tmp1['order_date'] = '';
                            $tmp1['customer_email'] = '';
                            $tmp1['customer_company'] = '';
                            $tmp1['custom_group_name'] = '';
                            $tmp1['country'] = '';
                            $tmp1['region'] = '';
                            $tmp1['city'] = '';
                            $tmp1['zipcode'] = '';
                            $tmp1['model'] = '';
                            $tmp1['product_name'] = $option['name'] . ' - ' . $option['value'];
                            $tmp1['pricing_type'] = '';
                            $tmp1['quantity'] = '';
                            $tmp1['price'] = '';
                            $tmp1['discount'] = '';
                            $tmp1['total'] = '';
                            $tmp1['tax'] = '';
                            $tmp1['total'] = '';
                            $tmp1['total_include_tax'] = '';
                            $tmp1['cost'] = '';
                            $tmp1['profit'] = '';
                            $tmp[$report_period . $i] = $tmp1;
                            $i++;
                        }
                    }
                }
                $reports['data'] = [];
                $reports['data'] = $tmp;
            }
        }
        $this->exportReport($reports, [], $export_type);
    }

    protected function queryReports( $data ){

        return $this->getModel()->getSaleReport($data);
    }

 }