<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsProfit
 * @property ModelAdvancedReportsSale $model_advanced_reports_sale
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsProfit extends Report_Abstract
{
    public $data = [];
    private $headers = [];
    private $totals = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/profit.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('advanced_reports/advanced_reports');
        $this->load->model('sale/order');
        $this->load->model('advanced_reports/sale');

        $this->setModel( $this->model_advanced_reports_sale );

        $this->document->setTitle($this->language->get('heading_title_profit'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "day";
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/profit'),
            'text'      => $this->language->get('heading_title_profit'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'report_period'			 => $report_period
        ];

        $results = $this->getModel()->getProfit($data);
        $sum_subtotal = 0.00;
        $sum_cost = 0.00;
        $sum_profit = 0.00;
        $sum_discount =0.00;

        if($results) {
            foreach($results as $key=>$result) {
                if($result) {
                    $order_id=$result['order_id'];
                    $cost=0;
                    $tmp_cost = 0;
                    $is_default = $not_product_cost = false;
                    if ($result['option']) {
                        foreach ($result['option'] as $k=>$v){
                            if ( $v['sort_order'] < '3' && $v['cost']==='0.0000' ) {
                                $is_default = true;
                                continue;
                            } else {
                                $cost += (float)$v['cost'] * $v['quantity'];
                            }
                        }
                    }
                    if ($result['cost']===0.00 && $result['cost2']!==0.00 && !$is_default) {
                        $cost += ((float)$result['cost2'] * $result['quantity']);
                    }  else {
                        $cost += ((float)$result['cost'] * $result['quantity']);
                    }
                    $tmp_cost = round($cost,2);
                    $tmp_subtotal = round(isset($result['subtotal'])?$result['subtotal']:0,2);
                    $tmp_discount = -round(isset($result['discount'])?($result['discount']):0,2);
                    $tmp_profit=$tmp_subtotal-$tmp_discount-$tmp_cost;
                    $sum_subtotal+= $result['subtotal'];
                    $sum_discount+= $tmp_discount;
                    $sum_cost+=$tmp_cost;
                    $sum_profit=$sum_subtotal-$sum_discount-$sum_cost;
                    $date_time = strtotime($result['datefield']);
                    $tmp_day = date('M d, Y', $date_time);
                    $results[$key]['datefield']=$tmp_day;
                    $results[$key]['order_id']=$result['order_id'];
                    $results[$key]['subtotal'] = $tmp_subtotal;
                    $results[$key]['discount'] = $tmp_discount;
                    if ($result['cost2']!==0.00 && $result['cost']===0.00 && !$is_default) {
                        $results[$key]['product_cost']='1';
                    } else {
                        $results[$key]['product_cost']='0';
                    }
                    $results[$key]['cost'] = (float)$tmp_cost;
                    $results[$key]['profit'] = $tmp_profit;
                    $results[$key]['subtotal2'] = $this->currency->format($result['subtotal'], $this->config->get('config_currency'));
                    $results[$key]['discount2'] = $this->currency->format($tmp_discount, $this->config->get('config_currency'));
                    $results[$key]['cost2'] = $this->currency->format($tmp_cost, $this->config->get('config_currency'));
                    $results[$key]['profit2'] = $this->currency->format($tmp_profit, $this->config->get('config_currency'));
                    $results[$key]['order_link'] = $this->html->getSecureURL('sale/order/details','&order_id=' . $result['order_id']);
                }
            }
        }

        $this->_reports = $results;
        $this->data['report_period'] = $report_period;
        $this->data['reports'] = $results;
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));
        $this->data['sum_discount_with_currency'] = $this->currency->format($sum_discount, $this->config->get('config_currency'));
        $this->data['sum_cost_with_currency'] = $this->currency->format($sum_cost, $this->config->get('config_currency'));
        $this->data['sum_profit_with_currency'] = $this->currency->format($sum_profit, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_profit');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');

        $this->data['column_number'] = $this->language->get('column_number');
        $this->data['column_period'] = $this->language->get('column_period');
        $this->data['column_order_id'] = $this->language->get('column_order_id');
        $this->data['column_subtotal'] = $this->language->get('column_subtotal');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_cost'] = $this->language->get('column_cost');
        $this->data['column_profit'] = $this->language->get('column_profit');
        $this->data['column_coupon_name'] = $this->language->get('column_coupon_name');
        $this->data['column_view_order'] = $this->language->get('column_view_order');
        $this->headers=[
            'A'=>$this->data['column_number'],
            'B'=>$this->data['column_period'],
            'C'=>$this->data['column_order_id'],
            'D'=>$this->data['column_subtotal'],
            'E'=>$this->data['column_coupon_name'],
            'F'=>$this->data['column_discounts'],
            'G'=>$this->data['column_cost'],
            'H'=>$this->data['column_profit']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>'',
            'C'=>'',
            'D'=>round((float) $sum_subtotal,2),
            'E'=>'',
            'F'=>round((float) $sum_discount,2),
            'G'=>round((float) $sum_cost,2),
            'H'=>round((float) $sum_profit,2)
        ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['detail_key'] = $this->language->get('detail_key');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;

        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;

        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/profit/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/profit');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {
        $this->load();

        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/profit.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }

        $reports = [];
        $reports['name'] = 'Profits Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $reports['border']='B';
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "day";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['number'] = $val['number'];
                $tmp1['datefield'] = $val['datefield'];
                $tmp1['order_id'] = $val['order_id'];
                $tmp1['subtotal'] = round((float) $val['subtotal'],2);
                $tmp1['coupon_name'] = $val['coupon_name'];
                $tmp1['discount'] = round((float) abs($val['discount']),2);
                $tmp1['cost'] = round((float) $val['cost'],2);
                $tmp1['profit'] = round((float) $val['profit'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }

        $this->exportReport( $reports, [], $export_type );
    }

    protected function queryReports( $data ){
        return $this->getModel()->getProfit($data);
    }
}