<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsProductSpecial
 * @property ModelCatalogProduct $model_catalog_product
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsProductSpecial extends Report_Abstract {

    public $data = [];
    private $headers = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/product_special.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/product');

        $this->setModel( $this->model_advanced_reports_product );

        $this->load->model('catalog/manufacturer');

        $this->load->model('tool/image');

        $this->load->model("catalog/category");

        $this->document->setTitle($this->language->get('heading_title_product_special'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/bootstrap-typeahead.min.js'));

        if ($this->request->get['limit']!='')
        {
            $limit=$this->request->get['limit'];
        }
        else {
            $limit = 20;
        }

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = 0;
        }

        if (isset($this->request->get['filter_category_id'])) {
            $filter_category_id = $this->request->get['filter_category_id'];
        } else {
            $filter_category_id = 0;
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $filter_manufacturer = $this->request->get['filter_manufacturer'];
        } else {
            $filter_manufacturer = 0;
        }

        if (isset($this->request->get['filter_quantity'])) {
            $filter_quantity = trim($this->request->get['filter_quantity']);
        } else {
            $filter_quantity = "";
        }

        $filter_quantity = ($filter_quantity != "")?$filter_quantity: -1;

        if (isset($this->request->get['product_id'])) {
            $product_id = $this->request->get['product_id'];
        } else {
            $product_id = 0;
        }

        if (isset($this->request->get['product_name'])) {
            $product_name = $this->request->get['product_name'];
        } else {
            $product_name = "";
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/product_special'),
            'text'      => $this->language->get('heading_title_product_special'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_category_id'	 => $filter_category_id,
            'filter_manufacturer'	 => $filter_manufacturer,
            'filter_product_name'	 => $product_name,
            'start'                  => ($page - 1) * $limit,
            'limit'                  => $limit
        ];

        $report_total = $this->getModel()->getTotalSpecialReport($data);

        $results = $this->getModel()->getSpecialReport($data);
        if($results) {
            foreach($results as $key => $result) {
                $resource=new AResource('image');
                $thumbnail = $resource->getMainThumb('products',
                    $result['product_id'],
                    (int)$this->config->get('config_image_grid_width'),
                    (int)$this->config->get('config_image_grid_height'),
                    true);
                $image = $thumbnail['thumb_url'];
                if (HTTPS === true) {
                    $image='https:'.$image;
                } else {
                    $image='http:'.$image;
                }
                $tmp_shipping_price = isset($result['shipping_price'])?$result['shipping_price']:0;
                $result['product_id'] = isset($result['product_id'])?$result['product_id']:0;
                $results[$key]['options'] = $result['options'];
                $results[$key]['image'] = $image;
                $results[$key]['name'] = isset($result['name'])?$result['name']:"";
                $results[$key]['model'] = isset($result['model'])?$result['model']:"";
                $results[$key]['sku'] = isset($result['sku'])?$result['sku']:"";
                $results[$key]['free']= (($result['free_shipping']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['individual']= (($result['ship_individually']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['downloadable']= isset($result['downloadable'])?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['shipping_price']= $tmp_shipping_price;
                $results[$key]['shipping_price2']= $this->currency->format($tmp_shipping_price, $this->config->get('config_currency'));
                $results[$key]['weight']= $result['weight'];
                $results[$key]['weightC']= $result['weightC'];
                $results[$key]['length']= $result['length'];
                $results[$key]['width']= $result['width'];
                $results[$key]['height']= $result['height'];
                $results[$key]['lengthC']= $result['lengthC'];
                $results[$key]['link'] = $this->html->getSecureURL('catalog/product/update', '&product_id='.$result['product_id']);
            }
        }

        $this->_reports = $results;
        $this->data['reports'] = $results;
        $this->data['heading_title'] = $this->language->get('heading_title_product_special');

        $this->data['text_option_value_name'] = $this->language->get('text_option_value_name');
        $this->data['text_filter_product'] = $this->language->get('text_filter_product');
        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_product_name'] = $this->language->get('text_product_name');
        $this->data['text_type'] = $this->language->get('text_type');
        $this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
        $this->data['text_choose_a_manufacturer'] = $this->language->get('text_choose_a_manufacturer');
        $this->data['text_expand_options'] = $this->language->get('text_expand_options');

        $this->data['column_image'] = $this->language->get('column_image');
        $this->data['column_product_name'] = $this->language->get('column_product_name');
        $this->data['column_product_model'] = $this->language->get('column_product_model');
        $this->data['column_product_sku'] = $this->language->get('column_product_sku');
        $this->data['column_free_shipping'] = $this->language->get('column_free_shipping');
        $this->data['column_shipping_individually'] = $this->language->get('column_shipping_individually');
        $this->data['column_downloadable'] = $this->language->get('column_downloadable');
        $this->data['column_fixed_shipping'] = $this->language->get('column_fixed_shipping');
        $this->data['column_weight'] = $this->language->get('column_weight');
        $this->data['column_weight_class'] = $this->language->get('column_weight_class');
        $this->data['column_length'] = $this->language->get('column_length');
        $this->data['column_width'] = $this->language->get('column_width');
        $this->data['column_height'] = $this->language->get('column_height');
        $this->data['column_length_class'] = $this->language->get('column_length_class');

        $this->headers=[
            'A'=>$this->data['column_product_name'],
            'B'=>$this->data['column_product_model'],
            'C'=>$this->data['column_product_sku'],
            'D'=>$this->data['column_free_shipping'],
            'E'=>$this->data['column_shipping_individually'],
            'F'=>$this->data['column_downloadable'],
            'G'=>$this->data['column_fixed_shipping'],
            'H'=>$this->data['column_weight'],
            'I'=>$this->data['column_weight_class'],
            'J'=>$this->data['column_length'],
            'K'=>$this->data['column_width'],
            'L'=>$this->data['column_height'],
            'M'=>$this->data['column_length_class']
        ];

        $this->data['entry_show_by'] = $this->language->get('entry_show_by');

        $this->data['text_category'] = $this->language->get('text_category');
        $this->data['text_choose_a_category'] = $this->language->get('text_choose_a_category');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["qty" => $this->language->get('column_quantity'),
            "total" => $this->language->get('column_total')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $url = '';

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_category_id'])) {
            $url .= '&filter_category_id=' . $this->request->get['filter_category_id'];
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $url .= '&filter_manufacturer=' . $this->request->get['filter_manufacturer'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['product_name'])) {
            $url .= '&product_name=' . $this->encodeURI($this->request->get['product_name']);
        }

        if (isset($this->request->get['product_id'])) {
            $url .= '&product_id=' . $this->request->get['product_id'];
        }

        $this->data['pagination'] = HtmlElementFactory::create( array (
            'type' => 'Pagination',
            'name' => 'pagination',
            'text'=> $this->language->get('text_pagination'),
            'text_limit' => $this->language->get('text_per_page'),
            'total'	=> $report_total,
            'page'	=> $page,
            'limit'	=> $limit,
            'url' => $this->html->getSecureURL('advanced_reports/product_special&page={page}&limit={limit}',$url),
            'style' => 'pagination'));

        $this->data['categories'] = [];

        $this->data['categories'] = $this->model_catalog_category->getCategories([]);

        $this->data['manufacturers'] = $this->model_catalog_manufacturer->getManufacturers([]);

        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_manufacturer'] = $filter_manufacturer;
        $this->data['filter_category_id'] = $filter_category_id;
        $this->data['filter_quantity'] = (int)$filter_quantity>=0?$filter_quantity:"";
        $this->data['product_id'] = $product_id;
        $this->data['product_name'] = $product_name;
        $this->data['page'] = $page;
        $this->data['limit'] = $limit;
        $this->data['autocomplete']=$this->html->getSecureURL('r/advanced_reports/autocomplete/product');
        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/product_special/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/product_special');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {
        $this->language->load('common/header');
        $this->language->load('report/customer_orders');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load();

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/product_special.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Special Shipping Page '.$page.' Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']='A2';
        $reports['orientation']='landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['name'] =  html_entity_decode($val['name']);
                $tmp1['model'] = $val['model'];
                $tmp1['sku'] = $val['sku'];
                $tmp1['free']= (($val['free_shipping']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $tmp1['individual']= (($val['ship_individually']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $tmp1['downloadable']= $val['downloadable'];
                $tmp1['shipping_price']= round((float) isset($val['shipping_price'])?$val['shipping_price']:0,2);
                $tmp1['weight']= (float) $val['weight'];
                $tmp1['weightC']= $val['weightC'];
                $tmp1['length']= (float) $val['length'];
                $tmp1['width']= (float) $val['width'];
                $tmp1['height']= (float) $val['height'];
                $tmp1['lengthC']= $val['lengthC'];
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
    }
}