<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsProductInventory
 * @property ModelAdvancedReportsProduct $model_advanced_reports_product
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsProductInventory extends Report_Abstract {

    public $data = [];
    private $headers = [];
    private $totals = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/product_inventory.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/product');
        $this->load->model('catalog/product');

        $this->setModel( $this->model_advanced_reports_product );

        $this->load->model('catalog/manufacturer');

        $this->load->model('tool/image');

        $this->load->model("catalog/category");

        $this->document->setTitle($this->language->get('heading_title_product_inventory'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript($this->view->templateResource('/javascript/jquery.mousewheel.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/bootstrap-typeahead.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));

        $lowstock=$this->config->get('advanced_reports_number_low_stock');
        if ($this->request->get['limit']!='')
        {
            $limit=$this->request->get['limit'];
        }
        else {
            $limit = 20;
        }

        $number_lowstock = isset($lowstock)?$lowstock:10;

        if (isset($this->request->get['filter_category_id'])) {
            $filter_category_id = $this->request->get['filter_category_id'];
        } else {
            $filter_category_id = 0;
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $filter_manufacturer = $this->request->get['filter_manufacturer'];
        } else {
            $filter_manufacturer = 0;
        }

        if (isset($this->request->get['filter_quantity'])) {
            $filter_quantity = trim($this->request->get['filter_quantity']);
        } else {
            $filter_quantity = "";
        }

        $filter_quantity = ($filter_quantity != "")?$filter_quantity: -1;

        if (isset($this->request->get['product_id'])) {
            $product_id = $this->request->get['product_id'];
        } else {
            $product_id = 0;
        }

        if (isset($this->request->get['product_name'])) {
            $product_name = $this->request->get['product_name'];
        } else {
            $product_name = "";
        }

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/product_inventory'),
            'text'      => $this->language->get('heading_title_product_inventory'),
            'separator' => ' :: ',
            'current' => true
        ));

        $text_low_stock = $this->language->get("text_low_stock");
        $text_out_stock = $this->language->get("text_out_stock");
        $text_available_stock = $this->language->get("text_available_stock");

        $this->data['reports'] = [];

        $data = [
            'filter_category_id'	 => $filter_category_id,
            'filter_manufacturer'	 => $filter_manufacturer,
            'filter_quantity'		 => $filter_quantity,
            'filter_product_id'		 => $product_id,
            'start'                  => ($page - 1) * $limit,
            'limit'                  => $limit
        ];

        $report_total = $this->getModel()->getTotalInventoryReport($data);

        $results = $this->getModel()->getInventoryReport($data);
        $sum_total_price = 0;
        $sum_total_value = 0;
        $sum_total_cost = 0;
        $sum_total_total_cost = 0;
        $sum_qty = 0;
        $sum_purchases_qty = 0;
        $sum_total_purchases = 0;

        if($results) {
            foreach($results as $key => $result) {
                if($result) {
                    $has_track_options = $this->model_catalog_product->hasTrackOptions($result['product_id']);
                    if ($has_track_options) {
                        $quantity = $this->model_catalog_product->hasAnyStock($result['product_id']);
                        $results[$key]['quantity'] = $quantity;
                        $sum_qty += $quantity;
                    } else {
                        $results[$key]['quantity'] = (int)$result['quantity'];
                        $sum_qty += (int)$result['quantity'];
                    }
                    $sum_purchases_qty += isset($result['purchases_quantity'])?(int)$result['purchases_quantity']:0;
                    $sum_total_purchases += round(isset($result['purchases_value'])?(float)$result['purchases_value']:0,2);
                } else {
                    $results[$key]['price'] = 0;
                    $results[$key]['cost'] = 0;
                    $results[$key]['total_cost'] = 0;
                    $results[$key]['quantity'] = 0;
                    $results[$key]['product_value'] = 0;
                    $results[$key]['purchases_quantity'] = 0;
                    $results[$key]['purchases_value'] = 0;
                }
                if($results[$key]['quantity'] < $number_lowstock && $results[$key]['quantity'] > 0) {
                    $results[$key]['stock_status'] = $text_low_stock;
                    $results[$key]['stock_class'] = "low_stock";
                } else if($results[$key]['quantity'] <= 0 ) {
                    $results[$key]['stock_status'] = $text_out_stock;
                    $results[$key]['stock_class'] = "out_stock";
                } else {
                    $results[$key]['stock_status'] = $text_available_stock;
                    $results[$key]['stock_class'] = "available";
                }
                $resource=new AResource('image');
                $thumbnail = $resource->getMainThumb('products',
                    $result['product_id'],
                    (int)$this->config->get('config_image_grid_width'),
                    (int)$this->config->get('config_image_grid_height'),
                    true);
                $image = $thumbnail['thumb_url'];
                if (HTTPS === true) {
                    $image='https:'.$image;
                } else {
                    $image='http:'.$image;
                }
                $result['product_id'] = isset($result['product_id'])?$result['product_id']:0;
                $result['name'] = isset($result['name'])?$result['name']:"";

                $price = $result['price'];
                $cost = $result['cost'];
                if (is_null($results[$key]['option_qty'])) {
                    $total_cost = $results[$key]['cost'] * $results[$key]['quantity'];
                } else {
                    $total_cost = 0;
                }

                $sum_total_price += $result['price'];
                $sum_total_cost += $result['cost'];
                if (is_null($results[$key]['option_qty'])) {
                    $sum_total_total_cost += $result['cost'] * $results[$key]['quantity'];
                }
                if (is_null($results[$key]['option_qty'])) {
                    $product_value = $results[$key]['quantity'] * $results[$key]['price'];
                } else {
                    $product_value = 0;
                }

                $results[$key]['product_value'] = $product_value;
                $product_value = $product_value<0?0:$product_value;
                $purchases_value = round(isset($result['purchases_value'])?$result['purchases_value']:0,2);
                $tmp_shipping_price = round(isset($result['shipping_price'])?$result['shipping_price']:0,2);
                $results[$key]['options'] = $result['options'];
                if ($result['options']) {
                    foreach ($result['options'] as $options) {
                        $option_values = $options['product_option_value'];
                        foreach ($option_values as $opt_values) {
                            $product_value += $opt_values['value'];
                            $total_cost += $opt_values['total_cost'];
                            $sum_total_total_cost+= $opt_values['total_cost'];
                        }
                    }
                }
                $sum_total_value += round((float)$product_value,2);

                $results[$key]['image'] = $image;
                $results[$key]['price2'] = $this->currency->format($price, $this->config->get('config_currency'));
                $results[$key]['product_value2'] = $this->currency->format($product_value, $this->config->get('config_currency'));
                $results[$key]['purchases_value2'] = $this->currency->format($purchases_value, $this->config->get('config_currency'));
                $results[$key]['free']= (($result['free_shipping']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['individual']= (($result['ship_individually']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['downloadable']= isset($result['downloadable'])?$this->language->get('text_yes'):$this->language->get('text_no');
                $results[$key]['shipping_price']= $tmp_shipping_price;
                $results[$key]['shipping_price2']= $this->currency->format($tmp_shipping_price, $this->config->get('config_currency'));
                $results[$key]['weight']= $result['weight'];
                $results[$key]['weightC']= $result['weightC'];
                $results[$key]['length']= $result['length'];
                $results[$key]['width']= $result['width'];
                $results[$key]['height']= $result['height'];
                $results[$key]['lengthC']= $result['lengthC'];
                $results[$key]['cost2'] = $this->currency->format($cost, $this->config->get('config_currency'));
                $results[$key]['total_cost'] = $total_cost;
                $results[$key]['total_cost2'] = $this->currency->format($total_cost, $this->config->get('config_currency'));
                $results[$key]['link'] = $this->html->getSecureURL('catalog/product/update', '&product_id='.$result['product_id']);
            }
        }
        $this->_reports = $results;
        $this->data['text_available_stock'] = $text_available_stock;
        $this->data['text_out_stock'] = $text_out_stock;
        $this->data['text_low_stock'] = $text_low_stock;
        $this->data['number_lowstock'] = $number_lowstock;
        $this->data['reports'] = $results;
        $this->data['sum_total_price'] = $sum_total_price;
        $this->data['sum_total_cost'] = $sum_total_cost;
        $this->data['sum_total_total_cost'] = $sum_total_total_cost;
        $this->data['sum_qty'] = $sum_qty;
        $this->data['sum_total_value'] = $sum_total_value;
        $this->data['sum_purchases_qty'] = $sum_purchases_qty;
        $this->data['sum_total_purchases'] = $sum_purchases_qty;
        $this->data['sum_total_price_with_currency'] = $this->currency->format($sum_total_price, $this->config->get('config_currency'));
        $this->data['sum_total_value_with_currency'] = $this->currency->format($sum_total_value, $this->config->get('config_currency'));
        $this->data['sum_total_cost_with_currency'] = $this->currency->format($sum_total_cost, $this->config->get('config_currency'));
        $this->data['sum_total_total_cost_with_currency'] = $this->currency->format($sum_total_total_cost, $this->config->get('config_currency'));

        $this->data['sum_total_purchases_with_currency'] = $this->currency->format($sum_total_purchases, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_product_inventory');

        $this->data['text_option_value_name'] = $this->language->get('text_option_value_name');
        $this->data['text_filter_product'] = $this->language->get('text_filter_product');
        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_filter_quantity'] = $this->language->get('text_filter_quantity');
        $this->data['text_no_purchases'] = $this->language->get('text_no_purchases');
        $this->data['text_or'] = $this->language->get('text_or');
        $this->data['text_type'] = $this->language->get('text_type');
        $this->data['text_manufacturer'] = $this->language->get('text_manufacturer');
        $this->data['text_choose_a_manufacturer'] = $this->language->get('text_choose_a_manufacturer');
        $this->data['text_expand_options'] = $this->language->get('text_expand_options');

        if (is_null($this->config->get('show_product_name_column'))) {
            $this->data['show_product_name_column'] = '1';
            $this->data['show_product_name_column_checked'] = 'checked';
            $this->data['show_product_name_column_style'] = '';
            $this->data['show_product_name_column_header_style'] = '';
        } else {
            $this->data['show_product_name_column'] = $this->config->get('show_product_name_column');
            $this->data['show_product_name_column_checked'] = $this->config->get('show_product_name_column') ? 'checked' : '';
            $this->data['show_product_name_column_style'] = $this->config->get('show_product_name_column') ? '' : 'style="display:none"';
            $this->data['show_product_name_column_header_style'] = $this->config->get('show_product_name_column') ? '' : ';display:none';
        }

        if (is_null($this->config->get('show_model_column'))) {
            $this->data['show_model_column'] = '1';
            $this->data['show_model_column_checked'] = 'checked';
            $this->data['show_model_column_style'] = '';
            $this->data['show_model_column_header_style'] = '';
        } else {
            $this->data['show_model_column'] = $this->config->get('show_model_column');
            $this->data['show_model_column_checked'] = $this->config->get('show_model_column') ? 'checked' : '';
            $this->data['show_model_column_style'] = $this->config->get('show_model_column') ? '' : 'style="display:none"';
            $this->data['show_model_column_header_style'] = $this->config->get('show_model_column') ? '' : ';display:none';
        }

        if (is_null($this->config->get('show_sku_column'))) {
            $this->data['show_sku_column'] = '1';
            $this->data['show_sku_column_checked'] = 'checked';
            $this->data['show_sku_column_style'] = '';
            $this->data['show_sku_column_header_style'] = '';
        } else {
            $this->data['show_sku_column'] = $this->config->get('show_sku_column');
            $this->data['show_sku_column_checked'] = $this->config->get('show_sku_column') ? 'checked' : '';
            $this->data['show_sku_column_style'] = $this->config->get('show_sku_column') ? '' : 'style="display:none"';
            $this->data['show_sku_column_header_style'] = $this->config->get('show_sku_column') ? '' : ';display:none';
        }

        if (is_null($this->config->get('show_stock_status_column'))) {
            $this->data['show_stock_status_column'] = '1';
            $this->data['show_stock_status_column_checked'] = 'checked';
            $this->data['show_stock_status_column_style'] = '';
        } else {
            $this->data['show_stock_status_column'] = $this->config->get('show_stock_status_column');
            $this->data['show_stock_status_column_checked'] = $this->config->get('show_stock_status_column') ? 'checked' : '';
            $this->data['show_stock_status_column_style'] = $this->config->get('show_stock_status_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_product_qty_column'))) {
            $this->data['show_product_qty_column'] = '1';
            $this->data['show_product_qty_column_checked'] = 'checked';
            $this->data['show_product_qty_column_style'] = '';
            $this->data['show_product_qty_column_header_style'] = '';
        } else {
            $this->data['show_product_qty_column'] = $this->config->get('show_product_qty_column');
            $this->data['show_product_qty_column_checked'] = $this->config->get('show_product_qty_column') ? 'checked' : '';
            $this->data['show_product_qty_column_style'] = $this->config->get('show_product_qty_column') ? '' : 'style="display:none"';
            $this->data['show_product_qty_column_header_style'] = $this->config->get('show_product_qty_column') ? '' : 'display:none';
        }

        if (is_null($this->config->get('show_free_shipping_column'))) {
            $this->data['show_free_shipping_column'] = '1';
            $this->data['show_free_shipping_column_checked'] = 'checked';
            $this->data['show_free_shipping_column_style'] = '';
        } else {
            $this->data['show_free_shipping_column'] = $this->config->get('show_free_shipping_column');
            $this->data['show_free_shipping_column_checked'] = $this->config->get('show_free_shipping_column') ? 'checked' : '';
            $this->data['show_free_shipping_column_style'] = $this->config->get('show_free_shipping_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_individual_shipping_column'))) {
            $this->data['show_individual_shipping_column'] = '1';
            $this->data['show_individual_shipping_column_checked'] = 'checked';
            $this->data['show_individual_shipping_column_style'] = '';
        } else {
            $this->data['show_individual_shipping_column'] = $this->config->get('show_individual_shipping_column');
            $this->data['show_individual_shipping_column_checked'] = $this->config->get('show_individual_shipping_column') ? 'checked' : '';
            $this->data['show_individual_shipping_column_style'] = $this->config->get('show_individual_shipping_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_downloadable_column'))) {
            $this->data['show_downloadable_column'] = '1';
            $this->data['show_downloadable_column_checked'] = 'checked';
            $this->data['show_downloadable_column_style'] = '';
        } else {
            $this->data['show_downloadable_column'] = $this->config->get('show_downloadable_column');
            $this->data['show_downloadable_column_checked'] = $this->config->get('show_downloadable_column') ? 'checked' : '';
            $this->data['show_downloadable_column_style'] = $this->config->get('show_downloadable_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_fixed_shipping_column'))) {
            $this->data['show_fixed_shipping_column'] = '1';
            $this->data['show_fixed_shipping_column_checked'] = 'checked';
            $this->data['show_fixed_shipping_column_style'] = '';
        } else {
            $this->data['show_fixed_shipping_column'] = $this->config->get('show_fixed_shipping_column');
            $this->data['show_fixed_shipping_column_checked'] = $this->config->get('show_fixed_shipping_column') ? 'checked' : '';
            $this->data['show_fixed_shipping_column_style'] = $this->config->get('show_fixed_shipping_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_weight_column'))) {
            $this->data['show_weight_column'] = '1';
            $this->data['show_weight_column_checked'] = 'checked';
            $this->data['show_weight_column_style'] = '';
        } else {
            $this->data['show_weight_column'] = $this->config->get('show_weight_column');
            $this->data['show_weight_column_checked'] = $this->config->get('show_weight_column') ? 'checked' : '';
            $this->data['show_weight_column_style'] = $this->config->get('show_weight_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_weight_class_column'))) {
            $this->data['show_weight_class_column'] = '1';
            $this->data['show_weight_class_column_checked'] = 'checked';
            $this->data['show_weight_class_column_style'] = '';
        } else {
            $this->data['show_weight_class_column'] = $this->config->get('show_weight_class_column');
            $this->data['show_weight_class_column_checked'] = $this->config->get('show_weight_class_column') ? 'checked' : '';
            $this->data['show_weight_class_column_style'] = $this->config->get('show_weight_class_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_length_column'))) {
            $this->data['show_length_column'] = '1';
            $this->data['show_length_column_checked'] = 'checked';
            $this->data['show_length_column_style'] = '';
        } else {
            $this->data['show_length_column'] = $this->config->get('show_length_column');
            $this->data['show_length_column_checked'] = $this->config->get('show_length_column') ? 'checked' : '';
            $this->data['show_length_column_style'] = $this->config->get('show_length_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_width_column'))) {
            $this->data['show_width_column'] = '1';
            $this->data['show_width_column_checked'] = 'checked';
            $this->data['show_width_column_style'] = '';
        } else {
            $this->data['show_width_column'] = $this->config->get('show_width_column');
            $this->data['show_width_column_checked'] = $this->config->get('show_width_column') ? 'checked' : '';
            $this->data['show_width_column_style'] = $this->config->get('show_width_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_height_column'))) {
            $this->data['show_height_column'] = '1';
            $this->data['show_height_column_checked'] = 'checked';
            $this->data['show_height_column_style'] = '';
        } else {
            $this->data['show_height_column'] = $this->config->get('show_height_column');
            $this->data['show_height_column_checked'] = $this->config->get('show_height_column') ? 'checked' : '';
            $this->data['show_height_column_style'] = $this->config->get('show_height_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_length_class_column'))) {
            $this->data['show_length_class_column'] = '1';
            $this->data['show_length_class_column_checked'] = 'checked';
            $this->data['show_length_class_column_style'] = '';
        } else {
            $this->data['show_length_class_column'] = $this->config->get('show_length_class_column');
            $this->data['show_length_class_column_checked'] = $this->config->get('show_length_class_column') ? 'checked' : '';
            $this->data['show_length_class_column_style'] = $this->config->get('show_length_class_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_product_cost_column'))) {
            $this->data['show_product_cost_column'] = '1';
            $this->data['show_product_cost_column_checked'] = 'checked';
            $this->data['show_product_cost_column_style'] = '';
        } else {
            $this->data['show_product_cost_column'] = $this->config->get('show_product_cost_column');
            $this->data['show_product_cost_column_checked'] = $this->config->get('show_product_cost_column') ? 'checked' : '';
            $this->data['show_product_cost_column_style'] = $this->config->get('show_product_cost_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_product_price_column'))) {
            $this->data['show_product_price_column'] = '1';
            $this->data['show_product_price_column_checked'] = 'checked';
            $this->data['show_product_price_column_style'] = '';
        } else {
            $this->data['show_product_price_column'] = $this->config->get('show_product_price_column');
            $this->data['show_product_price_column_checked'] = $this->config->get('show_product_price_column') ? 'checked' : '';
            $this->data['show_product_price_column_style'] = $this->config->get('show_product_price_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_product_value_column'))) {
            $this->data['show_product_value_column'] = '1';
            $this->data['show_product_value_column_checked'] = 'checked';
            $this->data['show_product_value_column_style'] = '';
        } else {
            $this->data['show_product_value_column'] = $this->config->get('show_product_value_column');
            $this->data['show_product_value_column_checked'] = $this->config->get('show_product_value_column') ? 'checked' : '';
            $this->data['show_product_value_column_style'] = $this->config->get('show_product_value_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_total_cost_column'))) {
            $this->data['show_total_cost_column'] = '1';
            $this->data['show_total_cost_column_checked'] = 'checked';
            $this->data['show_total_cost_column_style'] = '';
        } else {
            $this->data['show_total_cost_column'] = $this->config->get('show_total_cost_column');
            $this->data['show_total_cost_column_checked'] = $this->config->get('show_total_cost_column') ? 'checked' : '';
            $this->data['show_total_cost_column_style'] = $this->config->get('show_total_cost_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_purchased_qty_column'))) {
            $this->data['show_purchased_qty_column'] = '1';
            $this->data['show_purchased_qty_column_checked'] = 'checked';
            $this->data['show_purchased_qty_column_style'] = '';
        } else {
            $this->data['show_purchased_qty_column'] = $this->config->get('show_purchased_qty_column');
            $this->data['show_purchased_qty_column_checked'] = $this->config->get('show_purchased_qty_column') ? 'checked' : '';
            $this->data['show_purchased_qty_column_style'] = $this->config->get('show_purchased_qty_column') ? '' : 'style="display:none"';
        }

        if (is_null($this->config->get('show_purchased_value_column'))) {
            $this->data['show_purchased_value_column'] = '1';
            $this->data['show_purchased_value_column_checked'] = 'checked';
            $this->data['show_purchased_value_column_style'] = '';
        } else {
            $this->data['show_purchased_value_column'] = $this->config->get('show_purchased_value_column');
            $this->data['show_purchased_value_column_checked'] = $this->config->get('show_purchased_value_column') ? 'checked' : '';
            $this->data['show_purchased_value_column_style'] = $this->config->get('show_purchased_value_column') ? '' : 'style="display:none"';
        }

        $this->data['column_image'] = $this->language->get('column_image');
        $this->data['column_product_name'] = $this->language->get('column_product_name');
        $this->data['column_product_model'] = $this->language->get('column_product_model');
        $this->data['column_product_sku'] = $this->language->get('column_product_sku');
        $this->data['column_stock_status'] = $this->language->get('column_stock_status');
        $this->data['column_qty_inventory'] = $this->language->get('column_qty_inventory');
        $this->data['column_free_shipping'] = $this->language->get('column_free_shipping');
        $this->data['column_shipping_individually'] = $this->language->get('column_shipping_individually');
        $this->data['column_downloadable'] = $this->language->get('column_downloadable');
        $this->data['column_fixed_shipping'] = $this->language->get('column_fixed_shipping');
        $this->data['column_weight'] = $this->language->get('column_product_inventory_weight');
        $this->data['column_weight_class'] = $this->language->get('column_weight_class');
        $this->data['column_length'] = $this->language->get('column_length');
        $this->data['column_width'] = $this->language->get('column_width');
        $this->data['column_height'] = $this->language->get('column_height');
        $this->data['column_length_class'] = $this->language->get('column_length_class');
        $this->data['column_cost'] = $this->language->get('column_product_inventory_cost');
        $this->data['column_price'] = $this->language->get('column_product_inventory_price');
        $this->data['column_value'] = $this->language->get('column_value');
        $this->data['column_total_cost'] = $this->language->get('column_total_cost');
        $this->data['column_qty_purchases'] = $this->language->get('column_qty_purchases');
        $this->data['column_purchases_value'] = $this->language->get('column_purchases_value');
        $this->data['column_product_revenue'] = $this->language->get('column_product_revenue');

        $this->data['entry_show_by'] = $this->language->get('entry_show_by');

        $this->data['text_category'] = $this->language->get('text_category');
        $this->data['text_choose_a_category'] = $this->language->get('text_choose_a_category');

        $this->data['text_export_images'] = $this->language->get('text_export_images');
        $this->data['text_yes'] = $this->language->get('text_yes');
        $this->data['text_no'] = $this->language->get('text_no');
        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["qty" => $this->language->get('column_quantity'),
            "total" => $this->language->get('column_total')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $url = '';

        if (isset($this->request->get['filter_order_status_id'])) {
            $url .= '&filter_order_status_id=' . $this->request->get['filter_order_status_id'];
        }

        if (isset($this->request->get['filter_category_id'])) {
            $url .= '&filter_category_id=' . $this->request->get['filter_category_id'];
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $url .= '&filter_manufacturer=' . $this->request->get['filter_manufacturer'];
        }

        if (isset($this->request->get['filter_quantity'])) {
            $url .= '&filter_quantity=' . $this->request->get['filter_quantity'];
        }

        if (isset($this->request->get['product_name'])) {
            $url .= '&product_name=' . $this->encodeURI($this->request->get['product_name']);
        }

        $this->data['pagination'] = HtmlElementFactory::create( array (
            'type' => 'Pagination',
            'name' => 'pagination',
            'text'=> $this->language->get('text_pagination'),
            'text_limit' => $this->language->get('text_per_page'),
            'total'	=> $report_total,
            'page'	=> $page,
            'limit'	=> $limit,
            'url' => $this->html->getSecureURL('advanced_reports/product_inventory&page={page}&limit={limit}',$url),
            'style' => 'pagination'));

        $this->data['categories'] = [];

        $this->data['categories'] = $this->model_catalog_category->getCategories([]);

        $this->data['manufacturers'] = $this->model_catalog_manufacturer->getManufacturers([]);

        $this->data['filter_manufacturer'] = $filter_manufacturer;
        $this->data['filter_category_id'] = $filter_category_id;
        $this->data['filter_quantity'] = (int)$filter_quantity>=0?$filter_quantity:"";
        $this->data['product_id'] = $product_id;
        $this->data['product_name'] = $product_name;
        $this->data['page'] = $page;
        $this->data['limit'] = $limit;
        $this->data['number_lowstock'] = $number_lowstock;
        $this->data['autocomplete']=$this->html->getSecureURL('r/advanced_reports/autocomplete/product');
        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/product_inventory/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/product_inventory');
        $this->data['save_settings_url']=$this->html->getSecureURL('r/advanced_reports/settings/saveSettings');

        $this->data['button_show_all_column'] = $this->language->get('button_show_all_column');
        $this->data['button_save_settings'] = $this->language->get('button_save_settings');

        $this->data['button_toggle_options'] = $this->language->get('button_toggle_options');

        $this->data['text_select_columns'] = $this->language->get('text_select_columns');

        $this->data['show_image'] = $this->language->get('show_image');
        $this->data['show_product_name'] = $this->language->get('show_product_name');
        $this->data['show_model'] = $this->language->get('show_model');
        $this->data['show_sku'] = $this->language->get('show_sku');
        $this->data['show_stock_status'] = $this->language->get('show_stock_status');
        $this->data['show_qty'] = $this->language->get('show_qty');
        $this->data['show_free_shipping'] = $this->language->get('show_free_shipping');
        $this->data['show_individual_shipping'] = $this->language->get('show_individual_shipping');
        $this->data['show_downloadable'] = $this->language->get('show_downloadable');
        $this->data['show_fixed_shipping'] = $this->language->get('show_fixed_shipping');
        $this->data['show_weight'] = $this->language->get('show_weight');
        $this->data['show_weight_class'] = $this->language->get('show_weight_class');
        $this->data['show_length'] = $this->language->get('show_length');
        $this->data['show_width'] = $this->language->get('show_width');
        $this->data['show_height'] = $this->language->get('show_height');
        $this->data['show_length_class'] = $this->language->get('show_length_class');
        $this->data['show_cost'] = $this->language->get('show_cost');
        $this->data['show_price'] = $this->language->get('show_price');
        $this->data['show_value'] = $this->language->get('show_value');
        $this->data['show_total_cost'] = $this->language->get('show_total_cost');
        $this->data['show_purchased_qty'] = $this->language->get('show_purchased_qty');
        $this->data['show_purchased_value'] = $this->language->get('show_purchased_value');

        $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
        $this->view->batchAssign($this->data);
    }

    public function export() {
        $this->load->model('catalog/category');
        $this->load->model('catalog/product');
        $this->load->model('catalog/manufacturer');

        $this->language->load('common/header');
        $this->language->load('report/customer_orders');
        $this->language->load('advanced_reports/advanced_reports');
        $low_stock=$this->config->get('advanced_reports_number_low_stock');
        $number_lowstock = isset($low_stock)?$low_stock:10;
        $text_low_stock = $this->language->get("text_low_stock");
        $text_out_stock = $this->language->get("text_out_stock");
        $text_available_stock = $this->language->get("text_available_stock");

        if (isset($this->request->get['filter_category_id'])) {
            $category_name = '';
            $language_id = $this->language->getLanguageID();
            $filter_category_id = $this->request->get['filter_category_id'];
            $category_info = $this->model_catalog_category->getCategory($filter_category_id);
            $first_level_name = $second_level_name ='';
            if ($category_info['parent_id'] !== 0) {
                $parent_cat_id = $this->model_catalog_category->getCategory($category_info['parent_id']);
                if ($parent_cat_id['parent_id'] !== 0) {
                    $first_level_name_info = $this->model_catalog_category->getCategoryDescriptions($parent_cat_id['parent_id']);
                    $first_level_name = html_entity_decode($first_level_name_info[$language_id]['name']);
                }
                $second_level_name_info = $this->model_catalog_category->getCategoryDescriptions($category_info['parent_id']);
                $second_level_name = html_entity_decode($second_level_name_info[$language_id]['name']);
            }
            $third_level_name_info = $this->model_catalog_category->getCategoryDescriptions($filter_category_id);
            $third_level_name = html_entity_decode($third_level_name_info[$language_id]['name']);
            if ($first_level_name) {
                $category_name.=$first_level_name.' > ';
            }
            if ($second_level_name) {
                $category_name.=$second_level_name.' > ';
            }
            $category_name .= $third_level_name;
        } else {
            $filter_category_id = 0;
            $category_name = '';
        }

        if (isset($this->request->get['filter_manufacturer'])) {
            $filter_manufacturer = $this->request->get['filter_manufacturer'];
        } else {
            $filter_manufacturer = 0;
        }

        if (isset($this->request->get['filter_quantity'])) {
            $filter_quantity = $this->request->get['filter_quantity'];
        } else {
            $filter_quantity = "";
        }

        $filter_quantity = ($filter_quantity != "")?$filter_quantity: -1;

        if (isset($this->request->get['product_id'])) {
            $product_id = $this->request->get['product_id'];
        } else {
            $product_id = 0;
        }

        if (isset($this->request->get['product_name'])) {
            $product_name = $this->request->get['product_name'];
        } else {
            $product_name = "";
        }

        $data = [
            'filter_category_id'	 => $filter_category_id,
            'filter_manufacturer'	 => $filter_manufacturer,
            'filter_quantity'		 => $filter_quantity,
            'filter_product_id'		 => $product_id,
            'filter_name'		     => $product_name,
        ];

        $sum_total_price = 0;
        $sum_total_value = 0;
        $sum_total_cost = 0;
        $sum_total_total_cost = 0;
        $sum_qty = 0;
        $sum_purchases_qty = 0;
        $sum_total_purchases = 0;

        $this->load->model('advanced_reports/product');

        $results = $this->model_advanced_reports_product->getInventoryReport($data);
        foreach ($results as $key => $result) {
            if($result) {
                $has_track_options = $this->model_catalog_product->hasTrackOptions($result['product_id']);
                if ($has_track_options) {
                    $quantity = $this->model_catalog_product->hasAnyStock($result['product_id']);
                    $results[$key]['quantity'] = $quantity;
                    $sum_qty += $quantity;
                } else {
                    $sum_qty += (int)$result['quantity'];
                }
                $sum_purchases_qty += isset($result['purchases_quantity'])?(int)$result['purchases_quantity']:0;
                $sum_total_purchases += round(isset($result['purchases_value'])?(float)$result['purchases_value']:0,2);
            } else {
                $results[$key]['price'] = 0;
                $results[$key]['cost'] = 0;
                $results[$key]['total_cost'] = 0;
                $results[$key]['quantity'] = 0;
                $results[$key]['product_value'] = 0;
                $results[$key]['purchases_quantity'] = 0;
                $results[$key]['purchases_value'] = 0;
            }
            if($results[$key]['quantity'] < $number_lowstock && $results[$key]['quantity'] > 0) {
                $results[$key]['stock_status'] = $text_low_stock;
                $results[$key]['stock_class'] = "low_stock";
            } else if($results[$key]['quantity'] <= 0 ) {
                $results[$key]['stock_status'] = $text_out_stock;
                $results[$key]['stock_class'] = "out_stock";
            } else {
                $results[$key]['stock_status'] = $text_available_stock;
                $results[$key]['stock_class'] = "available";
            }

            $resource=new AResource('image');
            $thumbnail = $resource->getMainThumb('products',
                $result['product_id'],
                (int)$this->config->get('config_image_grid_width'),
                (int)$this->config->get('config_image_grid_height'),
                true);
            $image = $thumbnail['thumb_url'];
            if (HTTPS === true) {
                $image='https:'.$image;
            } else {
                $image='http:'.$image;
            }
            $result['product_id'] = isset($result['product_id'])?$result['product_id']:0;
            $result['name'] = isset($result['name'])?$result['name']:"";

            $price = $result['price'];
            $cost = $result['cost'];
            if (is_null($results[$key]['option_qty'])) {
                $total_cost = $results[$key]['cost'] * $results[$key]['quantity'];
            } else {
                $total_cost = 0;
            }
            $sum_total_price += $result['price'];
            $sum_total_cost += $result['cost'];
            if (is_null($results[$key]['option_qty'])) {
                $sum_total_total_cost += $result['cost'] * $results[$key]['quantity'];
            }
            if (is_null($results[$key]['option_qty'])) {
                $product_value = $results[$key]['quantity'] * $results[$key]['price'];
            } else {
                $product_value = 0;
            }
            $purchases_value = round(isset($result['purchases_value'])?$result['purchases_value']:0,2);
            $tmp_shipping_price = round(isset($result['shipping_price'])?$result['shipping_price']:0,2);
            $results[$key]['options'] = $result['options'];
            if ($result['options']) {
                foreach ($result['options'] as $options) {
                    $option_values = $options['product_option_value'];
                    foreach ($option_values as $opt_values) {
                        $product_value += $opt_values['value'];
                        $total_cost += $opt_values['total_cost'];
                        $sum_total_total_cost+= $opt_values['total_cost'];
                    }
                }
            }
            $results[$key]['product_value'] = $product_value;
            $sum_total_value += round((float)$product_value,2);
            $results[$key]['image'] = $image;
            $results[$key]['price2'] = $this->currency->format($price, $this->config->get('config_currency'));
            $results[$key]['product_value2'] = $this->currency->format($product_value, $this->config->get('config_currency'));
            $results[$key]['purchases_value2'] = $this->currency->format($purchases_value, $this->config->get('config_currency'));
            $results[$key]['free']= (($result['free_shipping']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
            $results[$key]['individual']= (($result['ship_individually']=='1'))?$this->language->get('text_yes'):$this->language->get('text_no');
            $results[$key]['downloadable']= isset($result['downloadable'])?$this->language->get('text_yes'):$this->language->get('text_no');
            $results[$key]['shipping_price']= $tmp_shipping_price;
            $results[$key]['shipping_price2']= $this->currency->format($tmp_shipping_price, $this->config->get('config_currency'));
            $results[$key]['weight']= $result['weight'];
            $results[$key]['weightC']= $result['weightC'];
            $results[$key]['length']= $result['length'];
            $results[$key]['width']= $result['width'];
            $results[$key]['height']= $result['height'];
            $results[$key]['lengthC']= $result['lengthC'];
            $results[$key]['cost2'] = $this->currency->format($cost, $this->config->get('config_currency'));
            $results[$key]['total_cost'] = $total_cost;
            $results[$key]['total_cost2'] = $this->currency->format($total_cost, $this->config->get('config_currency'));
            $results[$key]['link'] = $this->html->getSecureURL('catalog/product/update', '&product_id='.$result['product_id']);
        }

        $total['sum_qty'] = $sum_qty;
        $total['sum_total_cost'] = $sum_total_cost;
        $total['sum_total_price'] = $sum_total_price;
        $total['sum_total_value'] = $sum_total_value;
        $total['sum_total_total_cost'] = $sum_total_total_cost;
        $total['sum_purchases_qty'] = $sum_purchases_qty;
        $total['sum_total_purchases'] = $sum_total_purchases;

        $export_type = $this->request->get["export_type"];

        $export_image = $this->request->get['export_image'];

        $columns = [];

        if (($export_type === 'xls' || $export_type === 'xlsx') && $export_image==='1') {
            $columns['show_image_column'] = '1';
        } else {
            $columns['show_image_column'] = '0';
        }

        $show_columns= json_decode(html_entity_decode($this->request->get['columns']),true);

        foreach ($show_columns as $key => $value) {
            $columns[$key] = $value;
        }

        $key =1;
        foreach ($columns as $column => $value) {
            if ($value==='0') {
                continue;
            }
            $headers[$key] = $column;
            $key++;
        }

        $header = 'A';
        for ($i = 1; $i <= sizeof($headers); $i++) {
            $this->data['headers'][$header] = $this->getColumnName($headers[$i]);
            if ($header === 'A') {
                $this->data['totals'][$header] = $this->language->get('column_total');
            } else {
                $this->data['totals'][$header] = $this->getFooter($headers[$i], $total);
            }
            $header++;
        }

        $this->data['show_product_name_column'] = $columns['show_product_name_column'];
        $this->data['show_product_name_column_style'] = $columns['show_product_name_column']==='1' ? '' : 'style="display:none"';
        $this->data['show_product_name_column_header_style'] = $columns['show_product_name_column']==='1' ? '' : ';display:none';

        $this->data['show_model_column'] = $columns['show_model_column'];
        $this->data['show_model_column_style'] = $columns['show_model_column']==='1' ? '' : 'style="display:none"';
        $this->data['show_model_column_header_style'] = $columns['show_model_column']==='1' ? '' : ';display:none';

        $this->data['show_sku_column'] = $columns['show_sku_column'];
        $this->data['show_sku_column_style'] = $columns['show_sku_column'] ==='1' ? '' : 'style="display:none"';
        $this->data['show_sku_column_header_style'] = $columns['show_sku_column'] ==='1' ? '' : ';display:none';

        $this->data['show_stock_status_column'] = $columns['show_stock_status_column'];
        $this->data['show_stock_status_column_style'] = $columns['show_stock_status_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_product_qty_column'] = $columns['show_product_qty_column'];
        $this->data['show_product_qty_column_style'] = $columns['show_product_qty_column'] === '1' ? '' : 'style="display:none"';
        $this->data['show_product_qty_column_header_style'] = $columns['show_product_qty_column'] === '1' ? '' : 'display:none';

        $this->data['show_free_shipping_column'] = $columns['show_free_shipping_column'];
        $this->data['show_free_shipping_column_style'] = $columns['show_free_shipping_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_individual_shipping_column'] = $columns['show_individual_shipping_column'];
        $this->data['show_individual_shipping_column_style'] = $columns['show_individual_shipping_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_downloadable_column'] = $columns['show_downloadable_column'];
        $this->data['show_downloadable_column_style'] = $columns['show_downloadable_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_fixed_shipping_column'] = $columns['show_fixed_shipping_column'];
        $this->data['show_fixed_shipping_column_style'] = $columns['show_fixed_shipping_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_weight_column'] = $columns['show_weight_column'];
        $this->data['show_weight_column_style'] = $columns['show_weight_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_weight_class_column'] = $columns['show_weight_class_column'];
        $this->data['show_weight_class_column_style'] = $columns['show_weight_class_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_length_column'] = $columns['show_length_column'];
        $this->data['show_length_column_style'] = $columns['show_length_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_width_column'] = $columns['show_width_column'];
        $this->data['show_width_column_style'] = $columns['show_width_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_height_column'] = $columns['show_height_column'];
        $this->data['show_height_column_style'] = $columns['show_height_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_length_class_column'] = $columns['show_length_class_column'];
        $this->data['show_length_class_column_style'] = $columns['show_length_class_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_product_cost_column'] = $columns['show_product_cost_column'];
        $this->data['show_product_cost_column_style'] = $columns['show_product_cost_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_product_price_column'] = $columns['show_product_price_column'];
        $this->data['show_product_price_column_style'] = $columns['show_product_price_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_product_value_column'] = $columns['show_product_value_column'];
        $this->data['show_product_value_column_style'] = $columns['show_product_value_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_total_cost_column'] = $columns['show_total_cost_column'];
        $this->data['show_total_cost_column_style'] = $columns['show_total_cost_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_purchased_qty_column'] = $columns['show_purchased_qty_column'];
        $this->data['show_purchased_qty_column_style'] = $columns['show_purchased_qty_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['show_purchased_value_column'] = $columns['show_purchased_value_column'];
        $this->data['show_purchased_value_column_style'] = $columns['show_purchased_value_column'] ==='1' ? '' : 'style="display:none"';

        $this->data['reports'] = $results;
        $this->data['sum_total_price'] = $sum_total_price;
        $this->data['sum_total_cost'] = $sum_total_cost;
        $this->data['sum_total_total_cost'] = $sum_total_total_cost;
        $this->data['sum_qty'] = $sum_qty;
        $this->data['sum_total_value'] = $sum_total_value;
        $this->data['sum_purchases_qty'] = $sum_purchases_qty;
        $this->data['sum_total_purchases'] = $sum_purchases_qty;
        $this->data['sum_total_price_with_currency'] = $this->currency->format($sum_total_price, $this->config->get('config_currency'));
        $this->data['sum_total_value_with_currency'] = $this->currency->format($sum_total_value, $this->config->get('config_currency'));
        $this->data['sum_total_cost_with_currency'] = $this->currency->format($sum_total_cost, $this->config->get('config_currency'));
        $this->data['sum_total_total_cost_with_currency'] = $this->currency->format($sum_total_total_cost, $this->config->get('config_currency'));
        $this->data['sum_total_purchases_with_currency'] = $this->currency->format($sum_total_purchases, $this->config->get('config_currency'));

        $current_datetime = date($this->language->get('date_format_short').' H:i:s');
        $heading_title = $this->language->get('advanced_reports_name').' - ';
        $sheet_title = '';
        if ($filter_category_id!==0) {
            $heading_title .= $category_name;
            $sheet_title = $category_name;
        } else {
            $heading_title .= $this->language->get('text_all_products');
            $sheet_title = $this->language->get('text_all_products');
        }

        $heading_title .= ' '.$this->language->get('text_per').' '.$current_datetime;

        $this->data['heading_title'] = $heading_title;

        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            //$this->data['reports'] = $results;
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/product_inventory.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        $search = [' > ','/',':'];
        $replace = [' - ','-','-'];
        $filename = str_replace($search,$replace,$heading_title);
        $reports['name'] = $filename;
        $reports['sheet_title'] = $sheet_title;
        $reports['data'] = [];
        $reports['data'] = $results;
        $reports['headers']=$this->data['headers'];
        $reports['totals']=$this->data['totals'];
        $reports['border']='D';
        $reports['orientation']='landscape';
        $reports['paper']='A2';
        $reports['export_image'] = $export_image;
        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                if ($export_type==='xls' ||$export_type==='xlsx') {
                    if ($export_image==='1') {
                        if (HTTPS === true) {
                            $domain = HTTPS_SERVER;
                        } else {
                            $domain = HTTP_SERVER;
                        }
                        $val['image'] = str_replace('image/', '', $val['image']);
                        $image_path = str_replace($domain, DIR_IMAGE, $val['image']);
                        $tmp1['image'] = $image_path;
                    }
                }

                if ($columns['show_product_name_column']==='1') {
                    $tmp1['name'] = html_entity_decode($val['name']);
                }
                if ($columns['show_model_column']==='1') {
                    $tmp1['model'] = $val['model'];
                }
                if ($columns['show_sku_column']==='1') {
                    $tmp1['sku'] = $val['sku'];
                }
                if ($columns['show_stock_status_column']==='1') {
                    $tmp1['stock_status'] = $val['stock_status'];
                }
                if ($columns['show_product_qty_column']==='1') {
                    $tmp1['quantity'] = (int)$val['quantity'];
                }
                if ($columns['show_free_shipping_column']==='1') {
                    $tmp1['free'] = (($val['free_shipping'] == '1')) ? $this->language->get('text_yes') : $this->language->get('text_no');
                }
                if ($columns['show_individual_shipping_column']==='1') {
                    $tmp1['individual'] = (($val['ship_individually'] == '1')) ? $this->language->get('text_yes') : $this->language->get('text_no');
                }
                if ($columns['show_downloadable_column']==='1') {
                    $tmp1['downloadable'] = $val['downloadable'];
                }
                if ($columns['show_fixed_shipping_column']==='1') {
                    $tmp1['shipping_price'] = round((float)isset($val['shipping_price']) ? $val['shipping_price'] : 0, 2);
                }
                if ($columns['show_weight_column']==='1') {
                    $tmp1['weight'] = (float)$val['weight'];
                }
                if ($columns['show_weight_class_column']==='1') {
                    $tmp1['weightC'] = $val['weightC'];
                }
                if ($columns['show_length_column']==='1') {
                    $tmp1['length'] = (float)$val['length'];
                }
                if ($columns['show_width_column']==='1') {
                    $tmp1['width'] = (float)$val['width'];
                }
                if ($columns['show_height_column']==='1') {
                    $tmp1['height'] = (float)$val['height'];
                }
                if ($columns['show_length_class_column']==='1') {
                    $tmp1['lengthC'] = $val['lengthC'];
                }
                if ($columns['show_product_cost_column']==='1') {
                    $tmp1['cost'] = round((float)$val['cost'], 2);
                }
                if ($columns['show_product_price_column']==='1') {
                    $tmp1['price'] = round((float)$val['price'], 2);
                }
                if ($columns['show_product_value_column']==='1') {
                    $tmp1['product_value'] = round((float)$val['product_value'], 2);
                }
                if ($columns['show_total_cost_column']==='1') {
                    $tmp1['total_cost'] = round((float)$val['total_cost'], 2);
                }
                if ($columns['show_purchased_qty_column']==='1') {
                    $tmp1['purchases_quantity'] = (int)$val['purchases_quantity'];
                }
                if ($columns['show_purchased_value_column']==='1') {
                    $tmp1['purchases_value'] = round((float)$val['purchases_value'], 2);
                }
                $tmp[$report_period.$i] = $tmp1;
                $i++;

                $options = $val['options'];
                if($options) {
                    foreach($options as $option) {
                        if(isset($option['product_option_value']) && $option['product_option_value']) {
                            foreach($option['product_option_value'] as $option_value) {
                                $tmp2 = $val;
                                unset($val['product_id']);
                                if ($export_type==='xls' ||$export_type==='xlsx') {
                                    if ($export_image==='1') {
                                        $tmp1['image'] = '';
                                    }
                                }
                                if ($columns['show_product_qty_column']==='1') {
                                    if ($option_value['quantity'] < $number_lowstock && $option_value['quantity'] > 0) {
                                        $option_value['stock_status'] = $text_low_stock;
                                    } else if ($option_value['quantity'] <= 0) {
                                        $option_value['stock_status'] = $text_out_stock;
                                    } else {
                                        $option_value['stock_status'] = $text_available_stock;
                                    }
                                }
                                if ($columns['show_product_name_column']==='1') {
                                    $tmp1['name'] = html_entity_decode($val['name'] . " - " .  $option['type'] . " - " . $option['name'] . " - " . $option_value["name"]);
                                }
                                if ($columns['show_model_column']==='1') {
                                    $tmp1['model'] = $option['model'];
                                }
                                if ($columns['show_sku_column']==='1') {
                                    $tmp1['sku'] = $option['sku'];
                                }
                                if ($columns['show_stock_status_column']==='1') {
                                    $tmp1['stock_status'] = $option_value['stock_status'];
                                }
                                if ($columns['show_product_qty_column']==='1') {
                                    $tmp1['quantity'] = (int)$option_value['quantity'];
                                }
                                if ($columns['show_product_price_column']==='1') {
                                    $tmp1['price'] = (float)$option_value["price"];
                                }
                                if ($columns['show_product_cost_column']==='1') {
                                    $tmp1['cost'] = (float)$option_value['cost'];
                                }
                                if ($columns['show_weight_column']==='1') {
                                    $tmp1['weight'] = (float)$option_value['weight'];
                                }
                                if ($columns['show_weight_class_column']==='1') {
                                    $tmp1['weightC'] = $option_value['weight_type'];
                                }
                                if ($columns['show_product_value_column']==='1') {
                                    $tmp1['product_value'] = (float)$option_value['value'];
                                }
                                if ($columns['show_total_cost_column']==='1') {
                                    $tmp1['total_cost'] = (float)$option_value['total_cost'];
                                }
                                if ($columns['show_purchased_qty_column']==='1') {
                                    $tmp1['purchases_quantity'] = (int)$option['purchases_quantity'];
                                }
                                if ($columns['show_purchased_value_column']==='1') {
                                    $tmp1['purchases_value'] = (float)$option['purchases_value'];
                                }

                                $tmp[$report_period.$i] = $tmp1;
                                $i++;
                            }
                        }
                    }
                }
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }

        $this->exportReport( $reports, [], $export_type );
    }

    public function getColumnName($column) {
        $this->load();

        $column_name = '';
        switch ($column) {
            case 'show_image_column':
                $column_name = $this->data['column_image'];
                break;
            case 'show_product_name_column':
                $column_name = $this->data['column_product_name'];
                break;
            case 'show_model_column' :
                $column_name = $this->data['column_product_model'];
                break;
            case 'show_sku_column':
                $column_name = $this->data['column_product_sku'];
                break;
                case 'show_stock_status_column' :
                    $column_name = $this->data['column_stock_status'];
                    break;
                case 'show_product_qty_column' :
                    $column_name = $this->data['column_qty_inventory'];
                    break;
                case 'show_free_shipping_column' :
                    $column_name = $this->data['column_free_shipping'];
                    break;
                case 'show_individual_shipping_column' :
                    $column_name = $this->data['column_shipping_individually'];
                    break;
                case 'show_downloadable_column' :
                    $column_name = $this->data['column_downloadable'];
                    break;
                case 'show_fixed_shipping_column' :
                    $column_name = $this->data['column_fixed_shipping'];
                    break;
                case 'show_weight_column' :
                    $column_name = $this->data['column_weight'];
                    break;
                case 'show_weight_class_column' :
                    $column_name = $this->data['column_weight_class'];
                    break;
                case 'show_length_column' :
                    $column_name = $this->data['column_length'];
                    break;
                case 'show_width_column' :
                    $column_name = $this->data['column_width'];
                    break;
                case 'show_height_column' :
                    $column_name = $this->data['column_height'];
                    break;
                case 'show_length_class_column' :
                    $column_name = $this->data['column_length_class'];
                    break;
                case 'show_product_cost_column' :
                    $column_name = $this->data['column_cost'];
                    break;
                case 'show_product_price_column' :
                    $column_name = $this->data['column_price'];
                    break;
                case 'show_product_value_column' :
                    $column_name = $this->data['column_value'];
                    break;
                case 'show_total_cost_column' :
                    $column_name = $this->data['column_total_cost'];
                    break;
                case 'show_purchased_qty_column' :
                    $column_name = $this->data['column_qty_purchases'];
                    break;
                case 'show_purchased_value_column' :
                    $column_name = $this->data['column_purchases_value'];
                    break;
        }
        return $column_name;
    }

    public function getFooter($column,$totals) {
        $total = '';
        switch ($column) {
            case 'show_product_qty_column' :
                $total = (int) $totals['sum_qty'];
                break;
            case 'show_product_value_column' :
                $total = round((float) $totals['sum_total_value'],2);
                break;
            case 'show_total_cost_column' :
                $total = round((float) $totals['sum_total_total_cost'],2);
                break;
            case 'show_purchased_qty_column' :
                $total = (int) $totals['sum_purchases_qty'];
                break;
            case 'show_purchased_value_column' :
                $total = round((float) $totals['sum_total_purchases'],2);
                break;
            default:
                $total = '';
        }
        return $total;
    }

}