<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsGuestCountry
 * @property ModelAdvancedReportsGuest $model_advanced_reports_guest
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsGuestCountry extends Report_Abstract {

    public $data = [];
    private $headers = [];
    private $totals = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/guest_country.tpl');
    }

    public function load() {
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/guest');

        $this->setModel( $this->model_advanced_reports_guest );

        $this->document->setTitle($this->language->get('heading_title_guest_country'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript('https://www.google.com/jsapi');

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));
        $this->document->addScript($this->view->templateResource('/javascript/bootstrap-typeahead.min.js'));

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_country'])) {
            $filter_country = $this->request->get['filter_country'];
        } else {
            $filter_country = "";
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['filter_reload_key'])) {
            $filter_reload_key = $this->request->get['filter_reload_key'];
        } else {
            $filter_reload_key = "qty";
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/guest_country'),
            'text'      => $this->language->get('heading_title_guest_country'),
            'separator' => ' :: ',
            'current' => true
        ));
        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end,
            'filter_reload_key' 	 => $filter_reload_key,
            'filter_country'         => $filter_country
        ];

        $results = $this->model_advanced_reports_guest->getGuestByCountry($data);
        $sum_orders = $sum_guest = 0;
        $sum_items_ordered = 0;
        $sum_subtotal = 0.00;
        $sum_tax = 0.00;
        $sum_shipping = 0.00;
        $sum_discount = 0.00;
        $sum_total = 0.00;

        if($results) {
            foreach($results as $key => $result) {
                $tmp_subtotal = round(isset($result['subtotal'])?$result['subtotal']:0,2);
                $tmp_shipping = round(isset($result['shipping'])?$result['shipping']:0,2);
                $tmp_discount = round(isset($result['discount'])?abs($result['discount']):0,2);
                $tmp_tax = round((isset($result['tax']) && $result['tax'])?$result['tax']:0,2);
                $tmp_total = round(isset($result['total'])?$result['total']:0,2);
                $sum_orders += (int)$result['number_orders'];
                $sum_guest += (int)$result['guest'];
                $sum_items_ordered += (int)$result['items_ordered'];
                $sum_subtotal += $tmp_subtotal;
                $sum_shipping += $tmp_shipping;
                $sum_discount += $tmp_discount;
                $sum_tax += $tmp_tax;
                $sum_total += $tmp_total;

                $results[$key]['subtotal'] = $tmp_subtotal;
                $results[$key]['shipping'] = $tmp_shipping;
                $results[$key]['discount'] = $tmp_discount;
                $results[$key]['tax'] = $tmp_tax;
                $results[$key]['total'] = $tmp_total;

                $results[$key]['subtotal2'] = $this->currency->format($tmp_subtotal, $this->config->get('config_currency'));
                $results[$key]['shipping2'] = $this->currency->format($tmp_shipping, $this->config->get('config_currency'));
                $results[$key]['discount2'] = $this->currency->format($tmp_discount, $this->config->get('config_currency'));
                $results[$key]['tax2'] = $this->currency->format($tmp_tax, $this->config->get('config_currency'));
                $results[$key]['total2'] = $this->currency->format($tmp_total, $this->config->get('config_currency'));
            }
        }

        $this->_reports = $results;
        $this->data['reports'] = $results;
        $this->data['sum_guest'] = $sum_guest;
        $this->data['sum_items_ordered'] = $sum_items_ordered;
        $this->data['sum_orders'] = $sum_orders;
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));
        $this->data['sum_tax_with_currency'] = $this->currency->format($sum_tax, $this->config->get('config_currency'));
        $this->data['sum_discount_with_currency'] = $this->currency->format($sum_discount, $this->config->get('config_currency'));
        $this->data['sum_shipping_with_currency'] = $this->currency->format($sum_shipping, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_guest_country');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');

        $this->data['column_guest_group'] = $this->language->get('column_guest_group');
        $this->data['column_percent'] = $this->language->get('column_percent');
        $this->data['column_number_orders'] = $this->language->get('column_number_orders');
        $this->data['column_items_ordered'] = $this->language->get('column_items_ordered');
        $this->data['column_subtotal'] = $this->language->get('column_subtotal');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_shipping'] = $this->language->get('column_shipping');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_order_total'] = $this->language->get('column_order_total');
        $this->data['column_period'] = $this->language->get('column_period');
        $this->data['column_country'] = $this->language->get('column_country');
        $this->data['column_guest'] = $this->language->get('column_guest');

        $this->headers=[
            'A'=>$this->data['column_country'],
            'B'=>$this->data['column_guest'],
            'C'=>$this->data['column_number_orders'],
            'D'=>$this->data['column_items_ordered'],
            'E'=>$this->data['column_subtotal'],
            'F'=>$this->data['column_shipping'],
            'G'=>$this->data['column_discounts'],
            'H'=>$this->data['column_tax'],
            'I'=>$this->data['column_order_total']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>(int) $sum_guest,
            'C'=>(int) $sum_orders,
            'D'=>(int) $sum_items_ordered,
            'E'=>round((float) $sum_subtotal,2),
            'F'=>round((float) $sum_shipping,2),
            'G'=>round((float) $sum_discount,2),
            'H'=>round((float) $sum_tax,2),
            'I'=>round((float) $sum_total,2)
        ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["qty" => $this->language->get('column_quantity'),
            "total" => $this->language->get('column_order_total')];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;
        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;
        $this->data['filter_reload_key'] = $filter_reload_key;
        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['filter_country'] = $filter_country;

        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/guest_country/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/guest_country');
        $this->data['country']=$this->html->getSecureURL('r/advanced_reports/autocomplete/country');
	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }
    public function export() {

        $this->load();

        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/customer_country.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Guest Countries Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $reports['border']="B";
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['country_name'] = $val['country_name'];
                $tmp1['guest'] = $val['guest'];
                $tmp1['number_orders'] = (int) $val['number_orders'];
                $tmp1['items_ordered'] = (int) $val['items_ordered'];
                $tmp1['subtotal'] = round((float) $val['subtotal'],2);
                $tmp1['shipping'] = round((float) $val['shipping'],2);
                $tmp1['discount'] = round((float) $val['discount'],2);
                $tmp1['tax'] = round((float) $val['tax'],2);
                $tmp1['total'] = round((float) $val['total'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
    }
}