<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}

require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsEarnings
 * @property ModelAdvancedReportsSale $model_advanced_reports_sale
 * @property ModelAdvancedReportsChart $model_advanced_reports_chart
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsEarnings extends Report_Abstract {

	public $data = [];
    private $headers = [];
    private $totals = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/earnings.tpl');
    }

    public function load() {
        $this->language->load('common/header');

        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/sale');

        $this->setModel( $this->model_advanced_reports_sale);

        $this->document->setTitle($this->language->get('heading_title_earnings'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript('https://www.google.com/jsapi');

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));

        $filter_year = $filter_month = $filter_day = "";
        $filter_query = "";

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_year'])) {
            $filter_year = $this->request->get['filter_year'];
            $filter_query = "&filter_year=".$filter_year;
            $this->data['text_date']=$this->language->get('text_month');
        }

        if (isset($this->request->get['filter_month'])) {
            $filter_month = $this->request->get['filter_month'];
            $filter_query .= "&filter_month=".$filter_month;
            $this->data['text_date']=$this->language->get('text_date');
        }

        if (isset($this->request->get['filter_day'])) {
            $filter_day = $this->request->get['filter_day'];
            $filter_query .= "&filter_day=".$filter_day;
        }

        if (isset($this->request->get['filter_reload_key'])) {
            $filter_reload_key = $this->request->get['filter_reload_key'];
        } else {
            $filter_reload_key = "total";
        }

        $is_current = 0;

        if(isset($this->request->get['current']) && $this->request->get['current']) {
            $filter_year = date("Y");
            $is_current = $this->request->get['current'];
        }

        $url_supfix = "";

        if($filter_order_status_id) {
            $url_supfix .= "&filter_order_status_id=".$filter_order_status_id;
            $filter_query .= "&filter_order_status_id=".$filter_order_status_id;
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/earnings'),
            'text'      => $this->language->get('heading_title_earnings'),
            'separator' => ' :: ',
            'current' => true
        ));

        $this->data['filter_breadcrumbs'] = [];

        $this->data['filter_breadcrumbs'][] = [
            'text'      => '<strong>'.$this->language->get('text_sales_reports').'</strong>',
            'separator' => false
        ];

        if($filter_year) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => $this->language->get('text_alltime'),
                'href'      => $this->html->getSecureURL('advanced_reports/earnings', $url_supfix),
                'separator' => ' / '
            ];
        }

        if($filter_month) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => $filter_year,
                'href'      => $this->html->getSecureURL('advanced_reports/earnings', '&filter_year='.$filter_year.$url_supfix),
                'separator' => ' / '
            ];
        }

        if($filter_day) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => date('F', mktime(0, 0, 0, $filter_month, 10)),
                'href'      => $this->html->getSecureURL('advanced_reports/earnings', '&filter_year='.$filter_year.'&filter_month='.$filter_month.$url_supfix, 'SSL'),
                'separator' => ' / '
            ];
        }

        if(!$filter_year) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => '<strong>'.$this->language->get('text_alltime').'</strong>',
                'separator' => ' / '
            ];
        } elseif($filter_year && !$filter_month) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => '<strong>'.$filter_year.'</strong>',
                'separator' => ' / '
            ];
        } elseif($filter_year && $filter_month && !$filter_day) {
            $this->data['filter_breadcrumbs'][] = [
                'text'      => '<strong>'.date('F', mktime(0, 0, 0, $filter_month, 10)).'</strong>',
                'separator' => ' / '
            ];
        } elseif($filter_year && $filter_month && $filter_day) {
            $week_day_name = $this->_getWeekDay($filter_day, $filter_month, $filter_year);
            $this->data['filter_breadcrumbs'][] = [
                'text'      => '<strong>'.$week_day_name.", ".date('F', mktime(0, 0, 0, $filter_month, 10))." ".$filter_day.'</strong>',
                'separator' => ' / '
            ];
        }

        $this->data['reports'] = [];
        $this->data['current_reports'] = $this->getModel()->getCurrentMonthReport($filter_order_status_id);
        $this->data['total_sales'] = $this->getModel()->getTotalSales($filter_order_status_id);
        $this->data['total_earnings_currency'] = "";
        $this->data['total_earnings_orders'] = "0";

        if($this->data['current_reports']) {
            $this->data['total_earnings_currency'] = $this->currency->format($this->data['current_reports']['subtotal'], $this->config->get('config_currency'));
            $this->data['total_earnings_orders'] = $this->data['current_reports']['number_orders'];
        }
        $this->data['total_sales_currency'] = $this->currency->format((float)$this->data['total_sales'], $this->config->get('config_currency'));

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_year'	     	 => $filter_year,
            'filter_month'	     	 => $filter_month,
            'filter_day'	     	 => $filter_day,
            'filter_reload_key' 	 => $filter_reload_key
        ];

        $results = $this->getModel()->getEarningsReport($data);

        $sum_orders = 0;
        $sum_items_ordered = 0;
        $sum_subtotal = 0.00;

        if($results) {
            foreach($results as $key => $result) {
                if($result) {
                    $sum_orders += (int)$result['number_orders'];
                    $sum_items_ordered += (int)$result['items_ordered'];
                    $sum_subtotal += (float)$result['subtotal'];
                    $tmp_subtotal = isset($result['subtotal'])?$result['subtotal']:0;
                    $results[$key]['subtotal']=$sum_subtotal;
                    $results[$key]['subtotal3']=round((float)$result['subtotal'],2);
                    $results[$key]['subtotal2'] = $this->currency->format($tmp_subtotal, $this->config->get('config_currency'));
                    $results[$key]['datefield'] = $key;
                    $results[$key]['action'] = "";
                    $results[$key]['date'] = $key;

                    if(!$filter_year) {
                        $results[$key]['action'] = $this->html->getSecureURL('advanced_reports/earnings', '&filter_year='.$key.$url_supfix, 'SSL');
                    } elseif($filter_year && !$filter_month) {
                        $results[$key]['action'] = $this->html->getSecureURL('advanced_reports/earnings', '&filter_year='.$filter_year.'&filter_month='.$key.$url_supfix, 'SSL');
                        $results[$key]['datefield'] = date('F', mktime(0, 0, 0, $key, 10));
                    } elseif($filter_year && $filter_month && !$filter_day) {
                        $results[$key]['action'] = $this->html->getSecureURL('advanced_reports/earnings', '&filter_year='.$filter_year.'&filter_month='.$filter_month.'&filter_day='.$key.$url_supfix, 'SSL');
                        $results[$key]['datefield'] = date('F', mktime(0, 0, 0, $filter_month, 10)).", ".$key;
                    } elseif($filter_year && $filter_month && $filter_day) {
                        $start_time = $this->_lz((int)$key-1).":00";
                        $end_time = $this->_lz((int)$key+1).":00";
                        $results[$key]['datefield'] = $start_time." - ".$end_time;
                    }
                }
            }
        }

        $this->_reports = $results;
        $current_month = date("m");
        $this->data['current_month'] = date('F', mktime(0, 0, 0, $current_month , 10));

        $this->data['current'] = $is_current;
        $this->data['filter_year'] = $filter_year;
        $this->data['filter_month'] = $filter_month;
        $this->data['filter_day'] = $filter_day;
        $this->data['filter_order_status_id'] = $filter_order_status_id;

        $chartW=$this->config->get('advanced_reports_chart_width');
        $chartH=$this->config->get('advanced_reports_chart_height');
        $this->data['chart_width'] = isset($chartW)?(int)$chartW:300;
        $this->data['chart_height'] = isset($chartH)?(int)$chartH:300;

        $this->data['reports'] = $this->getReportData();
        $this->data['sum_items_ordered'] = $sum_items_ordered;
        $this->data['sum_orders'] = $sum_orders;
        $this->data['sum_subtotal_with_currency'] = $this->currency->format($sum_subtotal, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_earnings');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');
        $this->data['text_quantity'] = $this->language->get('text_quantity');
        $this->data['text_no_found_on_period'] = $this->language->get('text_no_found_on_period');
        $this->data['text_all_status'] = $this->language->get('text_all_status');
        $this->data['text_sales_earning_this_month'] = $this->language->get('text_sales_earning_this_month');
        $this->data['text_total_earnings'] = $this->language->get('text_total_earnings');
        $this->data['text_your_balance'] = $this->language->get('text_your_balance');
        $this->data['text_total_value_of_item_sales'] = $this->language->get('text_total_value_of_item_sales');
        $this->data['text_base_on_each_item'] = $this->language->get('text_base_on_each_item');
        $this->data['text_sale_earnings'] = $this->language->get("text_sale_earnings");

        $this->data['column_date'] = $this->language->get('column_date');
        $this->data['column_sales_count'] = $this->language->get('column_sales_count');
        $this->data['column_products_ordered'] = $this->language->get('column_products_ordered');
        $this->data['column_earnings'] = $this->language->get('column_earnings');
        $this->data['column_tax'] = $this->language->get('column_tax');
        $this->data['column_shipping'] = $this->language->get('column_shipping');
        $this->data['column_discounts'] = $this->language->get('column_discounts');
        $this->data['column_total'] = $this->language->get('column_total');
        $this->data['column_period'] = $this->language->get('column_period');

        $this->headers=[
            'A'=>$this->data['column_date'],
            'B'=>$this->data['column_sales_count'],
            'C'=>$this->data['column_products_ordered'],
            'D'=>$this->data['column_earnings']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>(int) $sum_orders,
            'C'=>(int) $sum_items_ordered,
            'D'=>round((float) $sum_subtotal,2)
        ];

        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');
        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_show_by'] = $this->language->get('entry_show_by');
        $this->data['detail_key'] = $this->language->get('detail_key');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        switch ($filter_reload_key) {
            case 'total':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_total");
                $this->data['text_verticle_title'] = $this->language->get("column_total");
                break;
            case 'subtotal':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_subtotal");
                $this->data['text_verticle_title'] = $this->language->get("column_subtotal");
                break;
            case 'qty':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_type_number_orders");
                $this->data['text_verticle_title'] = $this->language->get("column_number_orders");
                break;
            case 'qty_item':
                $this->data['text_subtitle_chart'] = $this->language->get("text_report_items_ordered");
                $this->data['text_verticle_title'] = $this->language->get("column_items_ordered");
                break;
        }
        $this->data['token'] = $this->session->data['token'];

        $this->data['key_list'] = ["total" => $this->language->get('column_total'),
            "subtotal" => $this->language->get('column_subtotal'),
            "qty" => $this->language->get('column_number_orders'),
            "qty_item" => $this->language->get('column_items_ordered')];

        $this->data['export_types'] = $this->get_export_types();

        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/earnings/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/earnings');
        $this->data['url']=$this->html->getSecureURL('r/advanced_reports/chart/add');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }

    public function export() {

        $this->load();
        $this->load->model('advanced_reports/chart');
        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $val=$this->model_advanced_reports_chart->get('earnings');
            if ($export_type=='pdf'){
                $this->data['chart']="<img src='".$val['value']."' style='width:800px;height:".$this->data['chart_height']."px'>";
            }
            elseif ($export_type=='html') {
                $this->data['chart']="<img src='".$val['value']."'>";
            }
            $this->data['visible']=1;
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/earnings.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }

        $get_month=$this->request->get['filter_month'];
        $monthName='';
        $filename='';
        if ($get_month) {
            switch($get_month) {
                case '1' :
                    $monthName='Jan';
                    break;
                case '2' :
                    $monthName='Feb';
                    break;
                case '3' :
                    $monthName='March';
                    break;
                case '4' :
                    $monthName='April';
                    break;
                case '5' :
                    $monthName='May';
                    break;
                case '6' :
                    $monthName='Juny';
                    break;
                case '7' :
                    $monthName='July';
                    break;
                case '8' :
                    $monthName='Augustus';
                    break;
                case '9' :
                    $monthName='September';
                    break;
                case '10' :
                    $monthName='October';
                    break;
                case '11' :
                    $monthName='November';
                    break;
                case '12' :
                    $monthName='December';
                    break;

            }
            $filename.=$monthName.'_';
        } else {
            $filename.='';
        }

        if ($this->request->get['filter_year']) {
            $filename.=$this->request->get['filter_year'];
        } else {
            $filename.='';
        }

        $reports = [];
        $reports['name'] = 'Earnings Report_'.$filename;
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "month_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['datefield'] = $val['datefield'];
                $tmp1['number_orders'] = (int) $val['number_orders'];
                $tmp1['items_ordered'] = (int) $val['items_ordered'];
                $tmp1['subtotal'] = round((float) $val['subtotal3'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
        $this->model_advanced_reports_chart->delete('earnings');
    }

    protected function queryReports( $data ){

        return $this->getModel()->getOrderReport($data);
    }

    protected function _lz($num)
    {
        return (strlen($num) < 2) ? "0{$num}" : $num;
    }

    protected function _getWeekDay($day,$month,$year){
        return date("l",strtotime($year.'-'.$month.'-'.$day));
    }

 }