<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
header('Location: static_pages/');
}
require DIR_EXT.'advanced_reports/admin/controller/pages/advanced_reports/abstract.php';

/**
 * Class ControllerPagesAdvancedReportsCustomerGroup
 * @property ModelAdvancedReportsCustomer $model_advanced_reports_customer
 * @property ModelAdvancedReportsChart $model_advanced_reports_chart
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsCustomerGroup extends Report_Abstract {

	public $data = [];
    private $headers = [];
    private $totals = [];

    public function main() {
        $this->load();
        $this->processTemplate('pages/advanced_reports/customer_group.tpl');
    }

    public function load(){
        $this->language->load('common/header');
        $this->language->load('sale/customer');
        $this->language->load('advanced_reports/advanced_reports');

        $this->load->model('advanced_reports/customer');

        $this->setModel( $this->model_advanced_reports_customer );

        $this->document->setTitle($this->language->get('heading_title_sales_by_customer_group'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/multiple-select.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->document->addScript('https://www.google.com/jsapi');

        $this->document->addScript($this->view->templateResource('/javascript/multipleselect/jquery.multiple.select.js'));
        $this->document->addScript($this->view->templateResource('/javascript/jquery.floatThead.min.js'));

        if (isset($this->request->get['filter_order_status_id'])) {
            $filter_order_status_id = $this->request->get['filter_order_status_id'];
        } else {
            $filter_order_status_id = '';
        }

        if (isset($this->request->get['filter_date_start'])) {
            $filter_date_start = $this->request->get['filter_date_start'];
        } else {
            $filter_date_start = date("Y-m-d", strtotime(date('m').'/01/'.date('Y').' 00:00:00'));
        }

        if (isset($this->request->get['filter_date_end'])) {
            $filter_date_end = $this->request->get['filter_date_end'];
        } else {
            $filter_date_end = date("Y-m-d");
        }

        if (isset($this->request->get['range_date'])) {
            $range_date = $this->request->get['range_date'];
        } else {
            $range_date = "this_month";
        }

        $this->document->initBreadcrumb( [
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ]);
        $this->document->addBreadcrumb( [
            'href'      => $this->html->getSecureURL('advanced_reports/customer_group'),
            'text'      => $this->language->get('heading_title_sales_by_customer_group'),
            'separator' => ' :: ',
            'current' => true
        ]);

        $this->data['reports'] = [];

        $data = [
            'filter_order_status_id' => $filter_order_status_id,
            'filter_date_start'	     => $filter_date_start,
            'filter_date_end'	     => $filter_date_end
        ];

        $results = $this->model_advanced_reports_customer->getCustomerGroup($data);
        $sum_total = 0;
        $sum_qty = 0;

        if($results) {
            foreach($results as $key => $result) {
                $sum_total += round((float)$result['total'],2);
                $sum_qty += (float)$result['orders'];
                $results[$key]['total']=round((float)$result['total'],2);
                $results[$key]['total2'] = $this->currency->format($result['total'], $this->config->get('config_currency'));
            }
        }

        $this->_reports = $results;
        $this->data['reports'] = $results;
        $this->data['sum_total'] = $sum_total;
        $this->data['sum_qty'] = $sum_qty;
        $this->data['sum_total_with_currency'] = $this->currency->format($sum_total, $this->config->get('config_currency'));

        $this->data['heading_title'] = $this->language->get('heading_title_sales_by_customer_group');

        $this->data['text_no_results'] = $this->language->get('text_no_results');
        $this->data['text_default'] = $this->language->get('text_default');
        $this->data['text_range'] = $this->language->get('text_range');
        $this->data['text_export_to'] = $this->language->get('text_export_to');
        $this->data['text_show_report_for'] = $this->language->get('text_show_report_for');
        $this->data['text_select_one'] = $this->language->get('text_select_one');
        $this->data['text_order_total'] = $this->language->get('text_order_total');
        $this->data['text_order_qty'] = $this->language->get('text_order_qty');
        $this->data['text_report_total'] = $this->language->get('text_report_total');

        $this->data['column_customer_group'] = $this->language->get('column_customer_group');
        $this->data['column_percent'] = $this->language->get('column_percent');
        $this->data['column_quantity'] = $this->language->get('column_quantity');
        $this->data['column_order_total'] = $this->language->get('column_order_total');

        $this->headers=[
            'A'=>$this->data['column_customer_group'],
            'B'=>$this->data['column_quantity'],
            'C'=>$this->data['column_order_total']
        ];

        $this->totals=[
            'A'=>'Total',
            'B'=>(int) $sum_qty,
            'C'=>round((float)  $sum_total,2)
        ];

        $this->data['entry_order_status'] = $this->language->get('entry_order_status');
        $this->data['entry_date_start'] = $this->language->get('entry_date_start');
        $this->data['entry_date_end'] = $this->language->get('entry_date_end');
        $this->data['entry_range'] = $this->language->get('entry_range');

        $this->data['button_filter'] = $this->language->get('button_filter');
        $this->data['button_reset'] = $this->language->get('button_reset');
        $this->data['button_export'] = $this->language->get('button_export');

        $this->data['token'] = $this->session->data['token'];

        $this->data['export_types'] = $this->get_export_types();

        $this->data['range_list'] = [
            "today" => $this->language->get('text_today'),
            "yesterday" => $this->language->get('text_yesterday'),
            "last_7_days" => $this->language->get('text_last_seven_days'),
            "last_week" => $this->language->get('text_last_week'),
            "last_business_week" => $this->language->get('text_last_business_week'),
            "this_month" => $this->language->get('text_this_month'),
            "last_month" => $this->language->get('text_last_month'),
            "custom" => $this->language->get('text_custom_range')
        ];

        $this->data['range_date'] = $range_date;

        $chartW=$this->config->get('advanced_reports_chart_width');
        $chartH=$this->config->get('advanced_reports_chart_height');
        $this->data['chart_width'] = isset($chartW)?(int)$chartW:300;
        $this->data['chart_height'] = isset($chartH)?(int)$chartH:300;

        $this->load->model('localisation/order_status');

        $this->data['order_statuses'] = $this->model_localisation_order_status->getOrderStatuses();

        $this->data['filter_date_start'] = $filter_date_start;
        $this->data['filter_date_end'] = $filter_date_end;
        $this->data['filter_order_status_id'] = $filter_order_status_id;
        $this->data['export_url']=$this->html->getSecureURL('advanced_reports/customer_group/export');
        $this->data['filter_url']=$this->html->getSecureURL('advanced_reports/customer_group');
        $this->data['url']=$this->html->getSecureURL('r/advanced_reports/chart/add');

	    $this->load->model('advanced_reports/verify');
        $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign($this->data);
    }
    public function export() {

        $this->load();
        $this->load->model('advanced_reports/chart');
        $export_type = $this->request->get["export_type"];
        if($export_type == "pdf" || $export_type == "html") {
            /*Get page html content*/
            $this->view->assign('base', (HTTPS_SERVER) ? HTTPS_SERVER : HTTP_SERVER);
            $val=$this->model_advanced_reports_chart->get('customer_group');
            if ($export_type=='pdf'){
                $this->data['chart']="<img src='".$val['value']."' style='width:800px;height:".$this->data['chart_height']."px'>";
            }
            elseif ($export_type=='html') {
                $this->data['chart']="<img src='".$val['value']."'>";
            }
            $this->data['visible']=1;
            $this->data['export'] = 'html';
            $this->view->batchAssign($this->data);
            $this->processTemplate('pages/advanced_reports/customer_group.tpl');
            $this->_export_content_html = $this->view->getOutput();
            /*get page html content*/
        }
        $reports = [];
        $reports['name'] = 'Customer Groups Report';
        $reports['data'] = [];
        $reports['data'] = $this->getReportData();
        $reports['headers']=$this->headers;
        $reports['totals']=$this->totals;
        $reports['border']="B";
        $paper=$this->config->get('advanced_reports_export_pdf_paper');
        $orientation=$this->config->get('advanced_reports_export_pdf_orientation');
        $reports['paper']=$paper !== '' ? $paper : 'A4';
        $reports['orientation']=$orientation!=='' ? $orientation : 'landscape';

        if (isset($this->request->get['report_period'])) {
            $report_period = $this->request->get['report_period'];
        } else {
            $report_period = "item_";
        }

        if($reports['data']) {
            $tmp = [];
            $i = 1;
            foreach($reports['data'] as $key=>$val) {
                $tmp1 = [];
                $tmp1['customer_group'] = $val['customer_group'];
                $tmp1['orders'] = (int) $val['orders'];
                $tmp1['total'] = round((float) $val['total'],2);
                $tmp[$report_period.$i] = $tmp1;
                $i++;
            }
            $reports['data'] = [];
            $reports['data'] = $tmp;
        }
        $this->exportReport( $reports, [], $export_type );
        $this->model_advanced_reports_chart->delete('customer_group');
    }
 }