<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}

/**
 * Class ControllerPagesAdvancedReportsAdvancedReports
 * @property ModelAdvancedReportsVerify $model_advanced_reports_verify
 */

class ControllerPagesAdvancedReportsAdvancedReports extends AController {

	public $data = [];
    private $error=[];
	private $errors = ['chart_width','chart_height','report_limit'];
    private $fields = [
        'advanced_reports_chart_width',
        'advanced_reports_chart_height',
        'advanced_reports_number_low_stock',
        'advanced_reports_export_pdf_paper',
        'advanced_reports_export_pdf_orientation',
        'advanced_reports_sales_tab',
        'advanced_reports_gmap_key',
        'advanced_reports_first_level_color',
        'advanced_reports_second_level_color',
        'advanced_reports_third_level_color',
        'advanced_reports_fourth_level_color',
        'advanced_reports_fifth_level_color',
    ];

    public function main(){
        $this->extensions->hk_InitData($this,__FUNCTION__);
        $this->document->addScript($this->view->templateResource('/javascript/jscolor/jscolor.js'));
        $this->request->get['extension'] = 'advanced_reports';
        $this->language->load('advanced_reports/advanced_reports');
        $this->language->load('extension/extensions');
        $this->view->assign('heading_title',$this->language->get('advanced_reports_name'));
        $this->document->setTitle( $this->language->get('text_additional_settings') );

	    $this->document->addStyle(
		    [
			    'href' => $this->view->templateResource('/stylesheet/advancedreports.css'),
			    'rel' => 'stylesheet',
		    ]
	    );

        $this->load->model('setting/setting');
        if ($this->request->is_POST() && $this->_validate()) {
            $store_id = $this->getStoreId();
            $this->model_setting_setting->editSetting('advanced_reports', $this->request->post,$store_id);
            $this->session->data['success'] = $this->language->get('text_success');
            redirect($this->html->getSecureURL('advanced_reports/advanced_reports'));
        }

        if (isset($this->error['warning'])) {
            $this->data['error_warning'] = $this->error['warning'];
        } else {
            $this->data['error_warning'] = '';
        }
        if (isset($this->error['chart_width'])) {
            $this->data['error']['chart_width'] = $this->error['chart_width'];
        }
        if (isset($this->error['chart_height'])) {
            $this->data['error']['chart_height'] = $this->error['chart_height'];
        }
        if (isset($this->error['report_limit'])) {
            $this->data['error']['report_limit'] = $this->error['report_limit'];
        }

        $this->data['success'] = $this->session->data['success'];
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb( array (
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => FALSE
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('extension/extensions/extensions'),
            'text'      => $this->language->get('text_extensions'),
            'separator' => ' :: '
        ));
        $this->document->addBreadcrumb( array (
            'href'      => $this->html->getSecureURL('advanced_reports/advanced_reports'),
            'text'      => $this->language->get('heading_title'),
            'separator' => ' :: ',
            'current' => true
        ));
        $store_id = $this->getStoreId();
        $this->load->model('setting/setting');
        $settings = $this->model_setting_setting->getSetting('advanced_reports',$store_id);
        foreach ( $this->fields as $f ) {
            if (isset ( $this->request->post [$f] )) {
                $this->data [$f] = $this->request->post [$f];
            } else {
                $this->data [$f] = $settings[$f];
            }
        }

        $this->data['action'] = $this->html->getSecureURL ( 'advanced_reports/advanced_reports', '&extension=advanced_reports' );
        $this->data['cancel'] = $this->html->getSecureURL('$this->data [\'form_title\'] = $this->language->get ( \'advanced_reports_name\' );extension/extensions');
        $this->data['heading_title'] = $this->language->get ( 'text_additional_settings' );
        
        $this->data['update'] = $this->html->getSecureURL ( 'r/advanced_reports/advanced_reports_save/update' );
        $this->data['ext_man']='https://why2central.net/v1/new-report';
        $this->data['note']=$this->language->get('advanced_reports_ext_note');

        $pdfType = [
            "A1" => "A1",
            "A2" => "A2",
            "A3" => "A3",
            "A4" => "A4",
            "A5" => "A5",
            "A6" => "A6",
            "A7" => "A7",
            "A8" => "A8",
            "A9" => "A9",
            "A10" => "A10",
            "b0" => "B0",
            "b1" => "B1",
            "b2" => "B2",
            "b3" => "B3",
            "b4" => "B4",
            "b5" => "B5",
            "b6" => "B6",
            "b7" => "B7",
            "b8" => "B8",
            "b9" => "B9",
            "b10" => "B10",
            "c0" => "C0",
            "c1" => "C1",
            "c2" => "C2",
            "c3" => "C3",
            "c4" => "C4",
            "c5" => "C5",
            "c6" => "C6",
            "c7" => "C7",
            "c8" => "C8",
            "c9" => "C9",
            "c10" => "C10",
            "ra0" => "RA0",
            "ra1" => "RA1",
            "ra2" => "RA2",
            "ra3" => "RA3",
            "ra4" => "RA4",
            "sra0" => "SRA0",
            "sra1" => "SRA1",
            "sra2" => "SRA2",
            "sra3" => "SRA3",
            "sra4" => "SRA4",
            "letter" => "LETTER",
            "legal" => "LEGAL",
            "ledger" => "LEDGER",
            "tabloid" => "TABLOID",
            "executive" => "EXECUTIVE",
            "folio" => "FOLIO",
            "commercial #10 envelope" => "COMMERCIAL 10 ENVELOPE",
            "catalog #10 1/2 envelope" => "COMMERCIAL 10 1/2 ENVELOPE",
            "8.5x11" => "8.5x11",
            "8.5x14" => "8.5x14",
            "11x17"  => "11x17",
        ];

        $pdfOrientation=[
            "portrait" => $this->language->get("text_portrait"),
            "landscape" => $this->language->get("text_landscape")
        ];

        $form = new AForm ( 'HS' );
        $form->setForm ( ['form_name' => 'editFrm', 'update' => $this->data ['update']] );

        $this->data['form']['form_open'] = $form->getFieldHtml ( array (
            'type' => 'form',
            'name' => 'editFrm',
            'action' => $this->data ['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
        ) );
        $this->data['form']['submit'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get ( 'button_save' )
        ) );
        $this->data['form']['cancel'] = $form->getFieldHtml ( array (
            'type' => 'button',
            'name' => 'cancel',
            'text' => $this->language->get ( 'button_cancel' )
        ) );

        if ($this->data['advanced_reports_chart_width']!='') {
            $chart_width=$this->data['advanced_reports_chart_width'];
        } else {
            $chart_width='600';
        }

        $this->data['form']['fields']['chart_width'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'advanced_reports_chart_width',
            'value' => $chart_width,
            'required' => true,
            'style'=>'small-field',
        ]);

        if ($this->data['advanced_reports_chart_height']!='') {
            $chart_height=$this->data['advanced_reports_chart_height'];
        } else {
            $chart_height='400';
        }

        $this->data['form']['fields']['chart_height'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'advanced_reports_chart_height',
            'value' => $chart_height,
            'required' => true,
            'style'=>'small-field',
        ]);

        if ($this->data['advanced_reports_number_low_stock']!='') {
            $number_low_stock=$this->data['advanced_reports_number_low_stock'];
        } else {
            $number_low_stock='10';
        }

        $this->data['form']['fields']['number_low_stock'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'advanced_reports_number_low_stock',
            'value' => $number_low_stock,
            'style'=>'small-field',
        ]);


        if ($this->data['advanced_reports_export_pdf_paper']!='') {
            $export_pdf_paper=$this->data['advanced_reports_export_pdf_paper'];
        } else {
            $export_pdf_paper='letter';
        }

        $this->data['form']['fields']['export_pdf_paper'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'advanced_reports_export_pdf_paper',
            'options' => $pdfType,
            'value' => $export_pdf_paper,
            'style'=>'small-field',
        ]);

        if ($this->data['advanced_reports_export_pdf_orientation']!='') {
            $export_pdf_orientation=$this->data['advanced_reports_export_pdf_orientation'];
        } else {
            $export_pdf_orientation='P';
        }

        $this->data['form']['fields']['export_pdf_orientation'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'advanced_reports_export_pdf_orientation',
            'options' => $pdfOrientation,
            'value' => $export_pdf_orientation,
            'style'=>'small-field',
        ]);

        if ($this->data['advanced_reports_sales_tab']!='') {
            $product_sales_tab=$this->data['advanced_reports_sales_tab'];
        } else {
            $product_sales_tab='1';
        }

        $this->data['form']['fields']['sales_tab'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'advanced_reports_sales_tab',
            'value' => $product_sales_tab,
            'options' => array(
                1 => $this->language->get ( 'text_yes' ),
                0 => $this->language->get ( 'text_no' ),
            ),
            'style'=>'small-field',
        ]);

        if ($this->data['advanced_reports_gmap_key']!='') {
            $map_key=$this->data['advanced_reports_gmap_key'];
        } else {
            $map_key='';
        }
        $this->data['form']['fields']['gmap_key'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'advanced_reports_gmap_key',
            'value' => $map_key,
            'style'=>'medium-field',
        ]);
        
        if ($this->data['advanced_reports_first_level_color']!='') {
            $this->data['first_color']=$this->data['advanced_reports_first_level_color'];
        } else {
            $this->data['first_color']='';
        }
        $this->data['entry_first_level_color'] = $this->language->get('entry_first_level_color');

        if ($this->data['advanced_reports_second_level_color']!='') {
            $this->data['second_color']=$this->data['advanced_reports_second_level_color'];
        } else {
            $this->data['second_color']='';
        }
        $this->data['entry_second_level_color'] = $this->language->get('entry_second_level_color');

        if ($this->data['advanced_reports_third_level_color']!='') {
            $this->data['third_color']=$this->data['advanced_reports_third_level_color'];
        } else {
            $this->data['third_color']='';
        }
        $this->data['entry_third_level_color'] = $this->language->get('entry_third_level_color');

        if ($this->data['advanced_reports_fourth_level_color']!='') {
            $this->data['fourth_color']=$this->data['advanced_reports_fourth_level_color'];
        } else {
            $this->data['fourth_color']='';
        }
        $this->data['entry_fourth_level_color'] = $this->language->get('entry_fourth_level_color');

        if ($this->data['advanced_reports_fifth_level_color']!='') {
            $this->data['fifth_color']=$this->data['advanced_reports_fifth_level_color'];
        } else {
            $this->data['fifth_color']='';
        }
        $this->data['entry_fifth_level_color'] = $this->language->get('entry_fifth_level_color');
        
        $this->view->batchAssign (  $this->language->getASet () );
        $this->data['groups'][] = 'additional_settings';
        $this->data['link_additional_settings'] = $this->data['add_sett']->href;
        $this->data['active_group'] = 'additional_settings';

        $tabs_obj = $this->dispatch('pages/extension/extension_tabs', array( $this->data ) );
        $this->data['tabs'] = $tabs_obj->dispatchGetOutput();
        unset($tabs_obj);

        $obj = $this->dispatch('pages/extension/extension_summary', array( $this->data ) );
        $this->data['extension_summary'] = $obj->dispatchGetOutput();
        unset($obj);

        $this->load->model('advanced_reports/verify');
	    $this->data['license_status'] = $this->model_advanced_reports_verify->verify();
	    $this->data['text_unauthorized'] = $this->language->get('text_advanced_reports_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
	    $this->view->batchAssign( $this->data );

        $this->processTemplate('pages/advanced_reports/advanced_reports.tpl' );
    }

    private function _validate() {
        if (!$this->user->canModify('extension/advanced_reports')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }

        if (!$this->request->post['advanced_reports_chart_width']) {
            $this->error['width'] = $this->language->get('error_chart_width');
        }

        if (!$this->request->post['advanced_reports_chart_height']) {
            $this->error['height'] = $this->language->get('error_chart_height');
        }

        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }

    public function getStoreId() {
        $store_id = (int)$this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int)$this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int)$this->session->data['current_store_id'];
            }
        }
        return $store_id;
    }
 }