<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * Class ControllerPagesSaleExpiredTaxCert
 * @property ModelExtensionCustomerGroupAutoAssigned $model_extension_customer_group_auto_assigned
 * @property ModelExtensionEmailTemplates $model_extension_email_templates
 */
class ControllerPagesExtensionExpiredTaxCert extends AController {
    public $error = [];
    public $placeholders = [];

    public function verify() {
        if ( $this->config->get( 'customer_group_auto_assigned_status' ) === '1' ) {
            $this->load->model('extension/customer_group_auto_assigned_license_info');
            $license_key = $this->config->get('customer_group_auto_assigned_license_code');
            $shared_secret = 'customer_group_auto_assigned';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                    $license_key = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyEmailEditor() {
        if ( $this->config->get( 'email_editor_status' ) === '1' ) {
            $this->load->model('extension/email_editor_license_info');
            $license_key = $this->config->get('email_editor_license_code');
            $shared_secret = 'email_editor';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('email_editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_email_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_email_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_email_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_email_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }
    public function main() {
        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->document->setTitle($this->language->get('expired_tax_exempt_cert_list'));
        $this->load->model('extension/customer_group_auto_assigned');
        $this->getList();
    }

    private function getList() {
        $post = $this->request->is_POST() ? $this->request->post : $this->request->get;
        $yes_no = [
            0 => $this->language->get('text_no'),
            1 => $this->language->get('text_yes'),
        ];

        if (isset($this->request->get['page'])) {
            $page = $this->request->get['page'];
        } else {
            $page = 1;
        }

        if (isset($this->request->get['sort'])) {
            $sort = $this->request->get['sort'];
        } else {
            $sort = 'info.customer_group_auto_assigned_info_id';
        }

        if (isset($this->request->get['order'])) {
            $order = $this->request->get['order'];
        } else {
            $order = 'DESC';
        }
        if (isset($this->request->get['limit'])) {
            $limit = $this->request->get['limit'];
        } else {
            $limit = $this->config->get('config_admin_limit');
        }

        // search form
        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'expired_tax_cert_search',
            ]
        );

        $grid_search_form = [];
        $grid_search_form['id'] = 'expired_tax_cert_search';
        $grid_search_form['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'expired_tax_cert_search',
                'action' => $this->html->getSecureURL('extension/expired_tax_cert'),
            ]
        );
        $grid_search_form['submit'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'submit',
                'text'  => $this->language->get('button_go'),
                'style' => 'button1',
            ]
        );
        $grid_search_form['reset'] = $form->getFieldHtml(
            [
                'type'  => 'button',
                'name'  => 'reset',
                'text'  => $this->language->get('button_reset'),
                'style' => 'button2',
            ]
        );

        $grid_search_form['fields']['name'] = $form->getFieldHtml(
            [
                'type'        => 'input',
                'name'        => 'filter_name',
                'value'       => $post['filter_name'],
                'placeholder' => $this->language->get('search_name_placeholder'),
            ]
        );

        $companies_result = $this->model_extension_customer_group_auto_assigned->getCompanies();
        $companies = [
            '' => $this->language->get('text_select_company'),
            'empty' => $this->language->get('text_blank'),
        ];
        foreach ($companies_result as $company) {
            if ($company['company']==='') {
                continue;
            }
            $companies[$company['company']] = $company['company'];
        }

        $grid_search_form['fields']['company'] = $form->getFieldHtml(
            [
                'type'        => 'selectbox',
                'name'        => 'filter_company',
                'value'       => $post['filter_company'],
                'options'     => $companies,
                'style'       => 'chosen'
            ]
        );

        $grid_search_form['fields']['from_expired_date'] = $form->getFieldHtml(
            [
                'type'        => 'date',
                'name'        => 'filter_from_expired_date',
                'value'       => $post['filter_from_expired_date'],
                'placeholder' => $this->language->get('search_from_expired_date_placeholder'),
            ]
        );

        $grid_search_form['fields']['to_expired_date'] = $form->getFieldHtml(
            [
                'type'        => 'date',
                'name'        => 'filter_to_expired_date',
                'value'       => $post['filter_to_expired_date'],
                'placeholder' => $this->language->get('search_to_expired_date_placeholder'),
            ]
        );

        $grid_search_form['fields']['emailed'] = $form->getFieldHtml(
            [
                'type'    => 'selectbox',
                'name'    => 'filter_emailed',
                'value'   => (isset($post['filter_emailed']) ? $post['filter_emailed'] : 'FALSE'),
                'options' => array_merge([
                    'FALSE' => $this->language->get('customer_group_auto_assigned_text_show_all')],
                    $yes_no
                ),
            ]
        );

        $this->view->assign('search_form', $grid_search_form);

        $this->view->assign(
            'btn_auto_email', $this->html->buildElement(
            [
                'type' => 'button',
                'name' => 'auto_email',
                'text' => $this->language->get('customer_group_auto_assigned_button_email_auto'),
            ]
        )
        );
        $this->view->assign('email_auto', $this->html->getSecureURL('extension/expired_tax_cert/email_auto'));

        $this->view->assign(
            'btn_email_selected', $this->html->buildElement(
            [
                'type' => 'button',
                'name' => 'email_selected',
                'text' => $this->language->get('customer_group_auto_assigned_button_email_selected'),
            ]
        )
        );

        $form = new AForm();
        $form->setForm(
            [
                'form_name' => 'expiredCertFrm',
            ]
        );

        $gridform = [];
        $gridform['id'] = 'expiredCertFrm';
        $gridform['form_open'] = $form->getFieldHtml(
            [
                'type'   => 'form',
                'name'   => 'expiredCertFrm',
                'action' => $this->html->getSecureURL('extension/expired_tax_cert/email_selected'),
            ]
        );

        $this->view->assign('gridform', $gridform);

        $ranges = $this->getDateRanges();
        $options = [];
        foreach ($ranges as $k => $range) {
            $options[$k] = $range['name'];
        }

        $this->view->assign(
            'email_date_range_selectbox', $this->html->buildElement(
            [
                'type'    => 'selectbox',
                'name'    => 'email_date_range',
                'options' => $options,
            ]
        )
        );
        $url = '';

        if (isset($post['filter_customer_group_auto_assigned_info_id'])) {
            $url .= '&filter_customer_group_auto_assigned_info_id='.$post['filter_customer_group_auto_assigned_info_id'];
        }
        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }
        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }
        if (isset($post['filter_from_expired_date'])) {
            $url .= '&filter_from_expired_date='.$post['filter_from_expired_date'];
        }
        if (isset($post['filter_to_expired_date'])) {
            $url .= '&filter_to_expired_date='.$post['filter_to_expired_date'];
        }
        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        $url .= '&page='.$page;
        $url .= '&sort='.$sort;
        $url .= '&order='.$order;

        $this->document->resetBreadcrumbs();
        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('common/home'),
                'text'      => $this->language->get('text_home'),
                'separator' => false,
            ]
        );

        $this->document->addBreadcrumb(
            [
                'href'      => $this->html->getSecureURL('extension/expired_tax_cert', $url),
                'text'      => $this->language->get('expired_tax_exempt_cert_list'),
                'separator' => ' :: ',
                'current'   => true,
            ]
        );

        $modelData = [
            'filter_customer_group_auto_assigned_info_id'   => $post['filter_customer_group_auto_assigned_info_id'],
            'filter_name'       => $post['filter_name'],
            'filter_company'       => $post['filter_company'],
            'filter_from_expired_date' => $post['filter_from_expired_date']
                ? dateDisplay2ISO(
                    $post['filter_from_expired_date'],
                    $this->language->get('date_format_short')
                )
                : null,
            'filter_to_expired_date' => $post['filter_to_expired_date']
                ? dateDisplay2ISO(
                    $post['filter_to_expired_date'],
                    $this->language->get('date_format_short')
                )
                : null,
            'filter_emailed'    => $post['filter_emailed'] != 'FALSE' ? $post['filter_emailed'] : null,
            'sort'              => $sort,
            'order'             => $order,
            'start'             => ($page - 1) * $limit,
            'limit'             => $limit,
        ];

        if ($post['dryrun'] == 1 && isset($post['email_date_range'])) {
            $this->session->data['dryrun'] = $this->language->get('text_dryrun');
            $ranges = $this->getDateRanges();
            $range = $ranges[$post['email_date_range']]['mysql'];
            if ($range) {
                $modelData['filter_date_range'] = $range;
            }
        }

        $order_total = $this->model_extension_customer_group_auto_assigned->getExpiredTaxCerts($modelData,'total_only');

        $results = $this->model_extension_customer_group_auto_assigned->getExpiredTaxCerts($modelData);
        $orders_list = [];

        foreach ($results as $result) {
            $action = [];

            $action[] = [
                'text' => $this->language->get('text_edit'),
                'href' => $this->html->getSecureURL('sale/tax_certificate', '&customer_id='.$result['customer_id'].$url),
            ];

            $orders_list[] = [
                'customer_group_auto_assigned_info_id'   => $result['customer_group_auto_assigned_info_id'],
                'name'       => $result['name'],
                'company'    => $result['company'] !== '' ? $result['company'] : '-',
                'expire_date' => dateISO2Display($result['expire_date'], $this->language->get('date_format_short')),
                'emailed'    => ($result['emailed']
                    ? $this->language->get('text_yes_on').dateISO2Display(
                        $result['emailed_date'],
                        $this->language->get('date_format_short')
                    )
                    : $this->language->get('text_no')),
                'selected'   => isset($this->request->post['selected'])
                    && in_array($result['customer_group_auto_assigned_info_id'], $this->request->post['selected']),
                'action'     => $action,
            ];
        }
        $this->view->assign('heading_title', $this->document->getTitle());

        $this->view->assign('expired_info', $orders_list);
        $this->view->assign('sort', $sort);

        $this->view->assign('expired_tax_exempt_cert_list', $this->language->get('expired_tax_exempt_cert_list'));

        $this->view->assign('text_no_results', $this->language->get('text_no_results'));
        $this->view->assign('text_instructions', $this->language->get('text_instructions'));

        $this->view->assign('entry_date_range', $this->language->get('entry_date_range'));
        $this->view->assign('entry_search_from_expired_date', $this->language->get('entry_search_from_expired_date'));
        $this->view->assign('entry_search_to_expired_date', $this->language->get('entry_search_to_expired_date'));

        $this->view->assign('column_id', $this->language->get('column_id'));
        $this->view->assign('column_name', $this->language->get('column_name'));
        $this->view->assign('column_expire_date', $this->language->get('column_expire_date'));
        $this->view->assign('column_emailed', $this->language->get('column_emailed'));
        $this->view->assign('column_action', $this->language->get('column_action'));
        $this->view->assign('button_filter', $this->language->get('button_filter'));

        $this->view->assign('token', $this->session->data['token']);

        if (isset($this->error['warning'])) {
            $this->view->assign('error_warning', $this->error['warning']);
        } else {
            $this->view->assign('error_warning', '');
        }

        if (isset($this->session->data['success'])) {
            $this->view->assign('success', $this->session->data['success']);

            unset($this->session->data['success']);
        } else {
            $this->view->assign('success', '');
        }

        if (isset($this->session->data['error'])) {
            $this->view->assign('error_warning', $this->session->data['error']);
            unset($this->session->data['error']);
        } else {
            $this->view->assign('error', '');
        }

        if (isset($this->session->data['dryrun'])) {
            $this->view->assign('info', $this->session->data['dryrun']);
            unset($this->session->data['dryrun']);
        } else {
            $this->view->assign('dryrun', '');
        }

        $url = '';

        if (isset($post['filter_customer_group_auto_assigned_info_id'])) {
            $url .= '&filter_customer_group_auto_assigned_info_id='.$post['filter_customer_group_auto_assigned_info_id'];
        }

        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }

        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }

        if (isset($post['filter_from_expired_date'])) {
            $url .= '&filter_from_expired_date='.$post['filter_from_expired_date'];
        }

        if (isset($post['filter_to_expired_date'])) {
            $url .= '&filter_to_expired_date='.$post['filter_to_expired_date'];
        }

        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        if ($order == 'ASC') {
            $url .= '&order='.'DESC';
        } else {
            $url .= '&order='.'ASC';
        }

        $url .= '&page='.$page;
        $url .= '&limit='.$limit;

        $this->view->assign('sort_id', $this->html->getSecureURL('extension/expired_tax_cert', '&sort=info.customer_group_auto_assigned_info_id'.$url));
        $this->view->assign('sort_name', $this->html->getSecureURL('extension/expired_tax_cert', '&sort=name'.$url));

        $this->view->assign('sort_company', $this->html->getSecureURL('extension/expired_tax_cert', '&sort=company'.$url));

        $this->view->assign(
            'sort_expired_date', $this->html->getSecureURL('extension/expired_tax_cert', '&sort=info.expire_date'.$url)
        );
        $this->view->assign('sort_emailed', $this->html->getSecureURL('extension/expired_tax_cert', '&sort=emailed'.$url));

        $url = '';

        if (isset($post['filter_customer_group_auto_assigned_info_id'])) {
            $url .= '&filter_customer_group_auto_assigned_info_id='.$post['filter_customer_group_auto_assigned_info_id'];
        }

        if (isset($post['filter_name'])) {
            $url .= '&filter_name='.$post['filter_name'];
        }

        if (isset($post['filter_company'])) {
            $url .= '&filter_company='.$post['filter_company'];
        }

        if (isset($post['filter_from_expired_date'])) {
            $url .= '&filter_from_expired_date='.$post['filter_from_expired_date'];
        }

        if (isset($post['filter_to_expired_date'])) {
            $url .= '&filter_to_expired_date='.$post['filter_to_expired_date'];
        }

        if (isset($post['filter_total'])) {
            $url .= '&filter_total='.$post['filter_total'];
        }

        if (isset($post['filter_emailed'])) {
            $url .= '&filter_emailed='.$post['filter_emailed'];
        }

        $url .= '&sort='.$sort;
        $url .= '&order='.$order;
        $url .= '&limit='.$limit;

        if ($order_total) {
            $this->view->assign(
                'pagination', HtmlElementFactory::create(
                [
                    'type'       => 'Pagination',
                    'name'       => 'pagination',
                    'text'       => $this->language->get('text_pagination'),
                    'text_limit' => '',
                    'total'      => $order_total,
                    'page'       => $page,
                    'limit'      => $limit,
                    'url'        => $this->html->getSecureURL('extension/expired_tax_cert'.$url, '&page={page}', '&encode'),
                    'style'      => 'pagination  form-inline',
                ]
            )
            );
        }

        $this->view->assign('email_selected_url',$this->html->getSecureURL('extension/expired_tax_cert/email_selected'));
        $this->view->assign('cancel_selected_url',$this->html->getSecureURL('extension/expired_tax_cert/cancel_selected'));
        $this->view->assign('customer_group_auto_assigned_button_cancel_selected',$this->language->get('customer_group_auto_assigned_button_cancel_selected'));
        $this->view->assign('reset_url',$this->html->getSecureURL('extension/expired_tax_cert'));
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());
        $this->view->assign('license_status', $this->verify());
        $this->view->assign('sort_columns_note', $this->language->get('sort_columns_note'));

        if ($this->verifyEmailEditor()) {
            $this->load->model('extension/email_templates');
            $this->view->assign('email_editor_status', $this->verifyEmailEditor());
            $this->view->assign('text_edit_email_template',$this->language->get('text_edit_email_template'));
            $email_template_id = $this->model_extension_email_templates->getEmailTemplateId('expired_tax_exempt_certificate');
            $this->view->assign('email_template_url', $this->html->getSecureURL('extension/email_templates/edit','&id='.$email_template_id['email_template_id']));
        }
        $this->view->assign('text_unauthorized', $this->language->get('text_customer_group_auto_assigned_unauthorized'));
        $this->processTemplate('pages/extension/expired_tax_cert_list.tpl');
    }

    public function email_selected() {
        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->document->setTitle($this->language->get('expired_tax_exempt_cert_list'));
        $this->load->model('extension/customer_group_auto_assigned');

        if (isset($this->request->post['selected']) && ($this->_validateModify())) {
             foreach ($this->request->post['selected'] as $customer_group_auto_assigned_info_id) {
                $result = $this->_sendEmail($customer_group_auto_assigned_info_id);

                if (isset($result['error'])) {
                    if (isset($this->session->data['error'])) {
                        $this->session->data['error'] .= $result['error']."<br />";
                    } else {
                        $this->session->data['error'] = $result['error']."<br />";
                    }
                }

                if (isset($result['success'])) {
                    if (isset($this->session->data['success'])) {
                        $this->session->data['success'] .= $result['success']."<br />";
                    } else {
                        $this->session->data['success'] = $result['success']."<br />";
                    }
                }
            }

            $url = '';

            if (isset($post['filter_customer_group_auto_assigned_info_id'])) {
                $url .= '&filter_customer_group_auto_assigned_info_id='.$post['filter_customer_group_auto_assigned_info_id'];
            }

            if (isset($post['filter_name'])) {
                $url .= '&filter_name='.$post['filter_name'];
            }

            if (isset($post['filter_company'])) {
                $url .= '&filter_company='.$post['filter_company'];
            }

            if (isset($post['filter_from_expired_date'])) {
                $url .= '&filter_from_expired_date='.$post['filter_from_expired_date'];
            }

            if (isset($post['filter_to_expired_date'])) {
                $url .= '&filter_to_expired_date='.$post['filter_to_expired_date'];
            }

            if (isset($post['filter_emailed'])) {
                $url .= '&filter_emailed='.$post['filter_emailed'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page='.$this->request->get['page'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order='.$this->request->get['order'];
            }

            redirect($this->html->getSecureURL('extension/expired_tax_cert', $url));
        }

        $this->getList();
    }

    public function email_auto() {
        $this->loadLanguage('customer_group_auto_assigned/customer_group_auto_assigned');

        $this->document->setTitle($this->language->get('expired_tax_exempt_cert_list'));

        $this->load->model('extension/customer_group_auto_assigned');

        if ($this->_validateModify()) {
            $date_range = $this->request->post['email_date_range'];
            $ranges = $this->getDateRanges();

            if (!isset($ranges[$date_range])) {
                $this->session->data['error'] = $this->language->get('error_date_range');
            } else {
                $range = $ranges[$date_range];
                $data = [
                    'filter_date_range' => $range['mysql'],
                    'filter_emailed'    => 0,
                    'start'             => 0,
                    'sort'              => 'info.customer_id',
                    'order'             => 'DESC', // choose most recent order first
                    'limit'             => 0,
                ];

                $infos = $this->model_extension_customer_group_auto_assigned->getExpiredTaxCerts($data);
                foreach ($infos as $info) {
                    $result = $this->_sendEmail($info['customer_group_auto_assigned_info_id'], $this->request->post['dryrun']);
                    if (isset($result['error'])) {
                        if (isset($this->session->data['error'])) {
                            $this->session->data['error'] .= $result['error']."<br />";
                        } else {
                            $this->session->data['error'] = $result['error']."<br />";
                        }
                    }

                    if (isset($result['success'])) {
                        if (isset($this->session->data['success'])) {
                            $this->session->data['success'] .= $result['success']."<br />";
                        } else {
                            $this->session->data['success'] = $result['success']."<br />";
                        }
                    }
                }

                if ($this->request->post['dryrun'] && isset($this->session->data['temporary_customer_group_auto_assigned_ids'])) {
                    foreach ($this->session->data['temporary_customer_group_auto_assigned_ids'] as $temp_customer_group_auto_assigned_info_id) {
                        $this->model_extension_customer_group_auto_assigned->removeHistory($temp_customer_group_auto_assigned_info_id);
                    }
                    unset($this->session->data['temporary_customer_group_auto_assigned_ids']);
                }

                if ($this->request->post['dryrun']) {
                    $this->session->data['dryrun'] = $this->language->get('text_dryrun');
                }

                if (!isset($this->session->data['error']) && !isset($this->session->data['success'])) {
                    $this->session->data['error'] = $this->language->get('error_no_matching_expired_tax_cert');
                }
            }

            $url = '';

            if (isset($this->request->get['filter_customer_group_auto_assigned_info_id'])) {
                $url .= '&filter_customer_group_auto_assigned_info_id='.$this->request->get['filter_customer_group_auto_assigned_info_id'];
            }

            if (isset($this->request->get['filter_name'])) {
                $url .= '&filter_name='.$this->request->get['filter_name'];
            }

            if (isset($this->request->get['filter_company'])) {
                $url .= '&filter_company='.$this->request->get['filter_company'];
            }

            if (isset($this->request->get['filter_from_expired_date'])) {
                $url .= '&filter_from_expired_date='.$this->request->get['filter_from_expired_date'];
            }

            if (isset($this->request->get['filter_to_expired_date'])) {
                $url .= '&filter_to_expired_date='.$this->request->get['filter_to_expired_date'];
            }

            if (isset($this->request->get['filter_emailed'])) {
                $url .= '&filter_emailed='.$this->request->get['filter_emailed'];
            }

            if (isset($this->request->get['page'])) {
                $url .= '&page='.$this->request->get['page'];
            }

            if (isset($this->request->get['sort'])) {
                $url .= '&sort='.$this->request->get['sort'];
            }

            if (isset($this->request->get['order'])) {
                $url .= '&order='.$this->request->get['order'];
            }
            if (!$this->request->post['dryrun']) {
                redirect($this->html->getSecureURL('extension/expired_tax_cert', $url));
            }
        }

        $this->getList();
    }

    protected function getDateRanges() {
        $ranges = [
            'lastweek'  => [
                'mysql' => '7 DAY',
                'name'  => $this->language->get('entry_last_week'),
            ],
            'lastmonth' => [
                'mysql' => '1 MONTH',
                'name'  => $this->language->get('entry_last_month'),
            ],
            'lastyear'  => [
                'mysql' => '1 YEAR',
                'name'  => $this->language->get('entry_last_year'),
            ],
        ];

        return $ranges;
    }

    protected function _validateModify() {
        if (!$this->user->hasPermission('modify', 'sale/expired_tax_cert')) {
            $this->error['warning'] = $this->language->get('error_permission');
        }
        $this->extensions->hk_ValidateData($this);
        return (!$this->error);
    }

    protected function _sendEmail($customer_group_auto_assigned_info_id, $testing = false) {
        $this->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->load->model('extension/customer_group_auto_assigned');
        $expired_info = $this->model_extension_customer_group_auto_assigned->getExpiredInfo($customer_group_auto_assigned_info_id);

        if ($expired_info) {
            // check if email has already been sent
            $result = $this->model_extension_customer_group_auto_assigned->getHistory($customer_group_auto_assigned_info_id);

            if ($result) {
                return ['error' => sprintf($this->language->get('error_email_already_sent'), $customer_group_auto_assigned_info_id)];
            }

            // update history
            $this->model_extension_customer_group_auto_assigned->addHistory($customer_group_auto_assigned_info_id, $testing);

            if (!$testing) {
                // prepare data

                if ($this->verifyEmailEditor()) {
                    $details = $this->model_extension_customer_group_auto_assigned->getDetails('expired_tax_exempt_certificate');

                    $sender_name=$details['sender_name'] ? $details['sender_name']:$this->config->get('store_name');
                    $sender_email=$details['sender_email'] ? $details['sender_email']:$this->config->get('store_main_email');
                    $content = html_entity_decode($details['content']);
                    preg_match("^\[(.*?)\]^",html_entity_decode($content),$fields);
                    $signature=html_entity_decode($details['signature']);

                    $this->data['mail_template_data']['customer_name'] = $expired_info['customer_name'];
                    $this->data['mail_template_data']['expired_at'] = dateISO2Display(
                        $expired_info['expire_date'],
                        $this->language->get('date_format_short')
                    );

                    $this->data['mail_template_data']['edit_account_url'] = '<a href="'.$this->html->getCatalogURL("account/edit").'">'.$this->language->get('text_here').'</a>';

                    $store_url = HTTPS ? $this->config->get('config_ssl_url') : $this->config->get('config_url');
                    $this->data['mail_template_data']['store_url'] = '<a href="'.$store_url.'" target="_BLANK">'.$this->config->get('store_name').'</a>';

                    $mustache = new Mustache_Engine(['escape' => function ($value) {
                        return $value;
                    }]);

                    $arAllowedPlaceholders = explode(',', $details['allowed_placeholders']);

                    foreach ($arAllowedPlaceholders as &$placeholder) {
                        $placeholder = trim($placeholder);
                    }

                    foreach ( $this->data['mail_template_data'] as $key => $val) {
                        if (in_array($key, $arAllowedPlaceholders, true)) {
                            $this->placeholders[$key] = $val;
                        }
                    }

                    $subject = $mustache->render($details['subject'], $this->placeholders);
                    $content = $mustache->render($content, $this->placeholders);
                    $content = html_entity_decode($content);

                    $notify_admin = $details['notify_admin'];
                    $logos = $this->dispatch('pages/extension/email_logo',[]);
                    $logo = $logos->dispatchGetOutput();

                    $this->data['mail_template_data']['logo']=html_entity_decode($logo);
                    $this->data['mail_template_data']['signature']=$signature;
                    $this->data['mail_template_data']['content']=$content;
                    $this->data['mail_template'] = DIR_EXT.'customer_group_auto_assigned'.DIR_EXT_CORE.'lib/expired_tax_exempt_certificate.tpl';

                    $view = new AView($this->registry, 0);
                    $view->batchAssign($this->data['mail_template_data']);
                    $html_body = $view->fetch($this->data['mail_template']);
                    $config_mail_logo = $this->config->get('config_mail_logo');
                    $config_mail_logo = !$config_mail_logo ? $this->config->get('config_logo') : $config_mail_logo;
                    $this->_send_email($expired_info['email'],
                        [
                            'subject'          => $subject,
                            'sender_email'     => $sender_email,
                            'sender_name'      => $sender_name,
                            'html_body'        => $html_body,
                            'config_mail_logo' => $config_mail_logo,
                            'notify_admin'     => $notify_admin
                        ]
                    );
                } else {
                    // load customer's language
                    $this->load->model('localisation/language');
                    $language_info = $this->language->getLanguageID();
                    $this->load->language('customer_group_auto_assigned/customer_group_auto_assigned');

                    $subject = $this->language->get('expired_tax_exempt_email_subject');
                    $message = vsprintf(
                        $this->language->get('expired_tax_exempt_email_content'),[
                            $expired_info['customer_name'],
                            dateISO2Display(
                                $expired_info['expire_date'],
                                $this->language->get('date_format_short')
                            ),
                            $this->html->getCatalogURL("account/edit")
                        ]
                    );

                    $store_url = HTTPS ? $this->config->get('config_ssl_url') : $this->config->get('config_url');

                    $message .= "\n";
                    $message .= sprintf(
                        $this->language->get('expired_tax_exempt_email_footer'),
                        $this->config->get('store_name'),
                        $store_url
                    );
                    $message = str_replace('\n', "\n", $message);

                    $mail = new AMail($this->config);

                    $mail->setTo($expired_info['email']);
                    $mail->setFrom($this->config->get('store_main_email'));
                    $mail->setSender($this->config->get('store_name'));
                    $mail->setSubject($subject);
                    $mail->setText($message);
                    $mail->send();
                }
            }

            return ['success' => sprintf($this->language->get('success_emailed'), $customer_group_auto_assigned_info_id)];
        }
        return ['error' => $this->language->get('text_no_results')];
    }

    protected function _send_email($email, $data) {
        $mail = new AMail($this->config);
        $mail->setTo($email);
        $mail->setFrom($data['sender_email']);
        $mail->setSender($data['sender_name']);
        $mail->setSubject($data['subject']);
        $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

        if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
            $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
        }
        $mail->setHtml($data['html_body']);
        $mail->send();

        if ($data['notify_admin']==='1') {
            $mail = new AMail($this->config);
            if ($data['sender_email']) {
                $email_address = $data['sender_email'];
            } else {
                $email_address = $this->config->get('store_main_email');
            }
            $mail->setTo($email_address);
            $mail->setFrom($data['sender_email']);
            $mail->setSender($data['sender_name']);
            $mail->setSubject('(Copy) '.$data['subject']);
            $mail->setText(html_entity_decode($data['txt_body'], ENT_QUOTES, 'UTF-8'));

            if (is_file(DIR_RESOURCE.$data['config_mail_logo'])) {
                $mail->addAttachment(DIR_RESOURCE.$data['config_mail_logo'],
                    md5(pathinfo($data['config_mail_logo'], PATHINFO_FILENAME))
                    .'.'.pathinfo($data['config_mail_logo'], PATHINFO_EXTENSION));
            }
            $mail->setHtml($data['html_body']);
            $mail->send();
        }
    }

    protected function dispatch($dispatch_rt, $args = ['']) {
        return new ADispatcher($dispatch_rt, $args);
    }

}