<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' ) || !IS_ADMIN) {
	header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionTaxExemptCertificateList
 * @property ModelExtensionCustomerGroupAutoAssigned $model_extension_customer_group_auto_assigned
 */

class ControllerPagesExtensionTaxExemptCertificateList extends AController {

	public $data = [];
    private $error = [];
	private $errors = [];
    
    public function verify() {
        $this->load->model('extension/customer_group_auto_assigned_license_info');
        $license_key = $this->config->get('customer_group_auto_assigned_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('customer_group_auto_assigned_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_customer_group_auto_assigned_license_info->getStoreId();
                $license_key = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_customer_group_auto_assigned_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'customer_group_auto_assigned');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_customer_group_auto_assigned_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->load->language('customer_group_auto_assigned/customer_group_auto_assigned');
        $this->document->setTitle($this->language->get('customer_group_auto_assigned_heading_title'));

        $this->document->addStyle(
            [
                'href' => $this->view->templateResource('/stylesheet/custgroup.css'),
                'rel' => 'stylesheet',
            ]
        );

        $this->view->assign('error_warning', $this->session->data['warning']);
        if (isset($this->session->data['warning'])) {
            unset($this->session->data['warning']);
        }
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb([
            'href'      => $this->html->getSecureURL('index/home'),
            'text'      => $this->language->get('text_home'),
            'separator' => false,
        ]);
        $this->document->addBreadcrumb([
            'href'      => $this->html->getSecureURL('extension/tax_exempt_certificate_list'),
            'text'      => $this->language->get('customer_group_auto_assigned_heading_title'),
            'separator' => ' :: ',
            'current'   => true,
        ]);

        $grid_settings = [
            'table_id'     => 'tax_exempt_certificate_list',
            'url'          => $this->html->getSecureURL('listing_grid/tax_exempt_certificate_list'),
            'editurl'      => $this->html->getSecureURL('listing_grid/tax_exempt_certificate_list/update'),
            'sortname'     => 'customer_name',
            'sortorder'    => 'asc',
            'actions'      => [
                'view'    =>[
                  'text' => $this->language->get('tab_certificate'),
                  'href' => $this->html->getSecureURL('sale/tax_certificate','&customer_group_auto_assigned_info_id=%ID%')
                ],
                'delete' => [
                    'text' => $this->language->get('button_delete')
                ],
            ],
        ];

        $grid_settings['colNames'] = [
            $this->language->get('column_customer_name'),
            $this->language->get('column_company'),
            $this->language->get('column_upload_later'),
            $this->language->get('column_image_url'),
            $this->language->get('column_uploaded_at'),
            $this->language->get('column_expire'),
            $this->language->get('column_expire_date'),
            $this->language->get('column_verified'),
            $this->language->get('column_verified_by'),
            $this->language->get('column_verified_date'),
        ];
        $grid_settings['colModel'] = [
            [
                'name'  => 'customer_name',
                'index' => 'customer_name',
                'align' => 'center',
                'width' => 200,
                'search'   => false,
            ],
            [
                'name'  => 'company',
                'index' => 'company',
                'align' => 'center',
                'width' => 150,
                'search'   => false,
            ],
            [
                'name'  => 'upload_later',
                'index' => 'upload_later',
                'align' => 'center',
                'width' => 120,
                'search'   => false,
            ],
            [
                'name'  => 'image_url',
                'index' => 'image_url',
                'align' => 'center',
                'width' => 250,
                'search'   => false,
                'sortable'   => false,
            ],
            [
                'name'   => 'uploaded_at',
                'index'  => 'uploaded_at',
                'align'  => 'center',
                'width'  => 150,
                'search' => false,
            ],
            [
                'name'   => 'expire',
                'index'  => 'expire',
                'align'  => 'center',
                'width'  => 130,
                'search' => false,
                'sortable'   => false,
            ],
            [
                'name'   => 'expire_date',
                'index'  => 'expire_date',
                'align'  => 'center',
                'width'  => 150,
                'search' => false,
            ],
            [
                'name'     => 'verified',
                'index'    => 'verified',
                'align'    => 'center',
                'width'    => 120,
                'search'   => false,
            ],
            [
                'name'     => 'verified_by',
                'index'    => 'verified_by',
                'align'    => 'center',
                'width'    => 150,
                'search'   => false,
            ],
            [
                'name'     => 'verified_date',
                'index'    => 'verified_date',
                'align'    => 'left',
                'width'    => 150,
                'search'   => false,
            ],
        ];

        $form = new AForm();
        $form->setForm([
            'form_name' => 'tax_exempt_certificate_list_search',
        ]);

        //get search filter from cookie if required
        $search_params = [];
        if ($this->request->get['saved_list']) {
            $grid_search_form = json_decode(html_entity_decode($this->request->cookie['tax_exempt_certificate_list_search']));
            if ($grid_search_form->table_id == $grid_settings['table_id']) {
                parse_str($grid_search_form->params, $search_params);
            }
        }

        $grid_search_form = [];
        $grid_search_form['id'] = 'tax_exempt_certificate_list_search';
        $grid_search_form['form_open'] = $form->getFieldHtml([
            'type'   => 'form',
            'name'   => 'tax_exempt_certificate_list_search',
            'action' => '',
        ]);
        $grid_search_form['submit'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'submit',
            'text'  => $this->language->get('button_go'),
            'style' => 'button1',
        ]);

        $grid_search_form['export'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'submit',
            'text'  => $this->language->get('button_go'),
            'style' => 'button1',
        ]);

        $grid_search_form['reset'] = $form->getFieldHtml([
            'type'  => 'button',
            'name'  => 'reset',
            'text'  => $this->language->get('button_reset'),
            'style' => 'button2',
        ]);

        $this->load->model('extension/customer_group_auto_assigned');
        $this->load->model('sale/customer');
        $allcustomers = $this->model_extension_customer_group_auto_assigned->getCustomers();

         $customers['none']=$this->language->get('text_select');
        foreach ($allcustomers as $customer) {
            $customers[$customer['customer_id']]=$customer['customer_name'];
        }

        $grid_search_form['fields']['customer_id'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'customer_id',
            'options' => $customers,
            'style'   => 'chosen',
            'value' => $search_params['customer_id'],
        ]);

        $allcompanies = $this->model_extension_customer_group_auto_assigned->getCompanies();
        $companies['none']=$this->language->get('text_select');
        foreach ($allcompanies as $company) {
            if ($company['company']==='') {
                continue;
            }
            $companies[$company['company']] = $company['company'];
        }
        $grid_search_form['fields']['company'] = $form->getFieldHtml([
            'type'    => 'selectbox',
            'name'    => 'company',
            'options' => $companies,
            'style'   => 'chosen',
            'value' => $search_params['company'],
        ]);

        $grid_search_form['fields']['filter_date_start'] = $form->getFieldHtml(array(
            'type' => 'date',
            'name' => 'filter_date_start',
            'value' => dateISO2Display($search_params['filter_date_start'], $this->language->get('date_format_short')),
            'default' => '',
            'dateformat' => format4Datepicker($this->language->get('date_format_short')),
        ));

        $grid_search_form['fields']['filter_date_end'] = $form->getFieldHtml(array(
            'type' => 'date',
            'name' => 'filter_date_end',
            'value' => dateISO2Display($search_params['filter_date_end'], $this->language->get('date_format_short')),
            'default' => '',
            'dateformat' => format4Datepicker($this->language->get('date_format_short')),
        ));

        $this->data['entry_customer_id'] = $this->language->get('entry_customer_id');
        $this->data['entry_company'] = $this->language->get('entry_company');
        $this->data['entry_filter_date_start'] = $this->language->get('entry_filter_date_start');
        $this->data['entry_filter_date_end'] = $this->language->get('entry_filter_date_end');
        $this->data['license_status'] = $this->verify();
        $this->data['text_unauthorized'] = $this->language->get('text_customer_group_auto_assigned_unauthorized');
        $this->view->assign('form_store_switch', $this->html->getStoreSwitcher());

        $grid_settings['search_form'] = true;
        $grid_settings['multiaction_options']['delete'] = $this->language->get('text_delete_selected');
        
        $grid = $this->dispatch('common/listing_grid', [$grid_settings]);

        $this->data['listing_grid'] =  $grid->dispatchGetOutput();
        $this->data['search_form'] =  $grid_search_form;
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/tax_exempt_certificate_list.tpl');

    }

 }
