<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

class ExtensionIpCapture extends Extension {

	public $data = [];
	public $error = [];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

	private function _is_enabled() {
      	return $this->baseObject->config->get('ip_capture_status');
	}

    /** Admin Section */
    public function onControllerPagesSaleCustomer_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method==='update') {
            $that->load->model('sale/customer');
            $that->load->language('ip_capture/ip_capture');
            $customer_id = $that->request->get['customer_id'];
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $that->data['fields']['ip'] = null;
            $form = $that->view->getData('form');
            $form['fields']['details']['ip'] = $that->html->buildElement(
                [
                    'type'    => 'input',
                    'name'    => 'ip',
                    'value'   => $customer_info['ip'],
                    'attr'    => 'disabled'
                ]
            );
            $that->view->assign('entry_ip',$that->language->get('entry_ip'));
            $that->view->assign('form', $form);
        }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method==='update') {
            $that->load->model('extension/ip_capture');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids)) {
                        foreach ($ids as $id) {
                            $that->log->write($id);
                            $that->model_extension_ip_capture->deleteIPInfo($id);
                        }
                    }
                    break;
            }
        }
    }

    /** End Of Admin Section */

    /** Storefront Section */
    public function onControllerPagesAccountCreate_UpdateData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method = 'main') {
            if ($that->request->is_POST()) {
                $that->load->model('account/customer');
                $that->load->model('account/address');
                $that->load->model('extension/ip_capture');
                if ($that->data['customer_id']) {
                    $customer_id = $that->data['customer_id'];
                    $customer_info = $that->model_account_customer->getCustomer($customer_id);
                    $address_id = $customer_info['address_id'];
                    $address_info = $that->model_account_address->getAddress($address_id);
                    $ip = $that->model_extension_ip_capture->getUserIP();
                    $ipdat = $that->model_extension_ip_capture->getLocationByIp($ip);
                    $data['customer_id'] = $customer_id;
                    $data['firstname'] = $customer_info['firstname'];
                    $data['lastname'] = $customer_info['lastname'];
                    $data['company'] = $address_info['company'];
                    $data['email'] = $customer_info['email'];
                    $data['zone'] = $ipdat['zone'];
                    $data['country'] = $ipdat['country'];
                    $data['ip'] = $ip;
                    //$data['source'] = 'Register Account Page';
                    $that->model_extension_ip_capture->updateCustIp($data);
                    $that->model_extension_ip_capture->save($data);
                }
            }

            $form = $that->view->getData('form');
            $form['fields']['general']['ip'] = $that->html->buildElement(
                [
                    'type' => 'hidden',
                    'name' => 'ip',
                    'value' => $this->getUserIP(),
                ]
            );
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesContentContact_ProcessData() {
        $that =& $this->baseObject;
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'sf_contact_us_mail') {
            $that->load->model('extension/ip_capture_contact_us');
            $post_data = $that->request->post;
            $ip = $that->model_extension_ip_capture_contact_us->getUserIP();
            $ipdat = $that->model_extension_ip_capture_contact_us->getLocationByIp($ip);
            //$data['customer_id'] = 0;
            $data['firstname'] = $post_data['first_name'];
            $data['lastname'] = $post_data['last_name'];
            $data['company'] = $post_data['company'];
            $data['email'] = $post_data['email'];
            $data['zone'] = $ipdat['zone'];
            $data['country'] = $ipdat['country'];
            $data['ip'] = $ip;
            //$data['source'] = 'Contact Us Page';
            $that->model_extension_ip_capture_contact_us->save($data);
        }
    }

    /** End Of Storefront Section */
} ?>