<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelExtensionIpCapture extends Model {

    /**
     * @param array $data
     *
     * @return array|int
     * @throws AException
     */
    public function getTotalIpCapture($data = []) {
        return $this->getIpCapture($data, 'total_only');
    }

    /**
     * @param $data
     * @param $mode
     * @return int|mixed
     * @throws AException
     */
    public function getIpCapture($data = [], $mode = 'default') {
        if ($mode == 'total_only') {
            $sql = "SELECT COUNT(*) as total ";
        } else {
            $sql = "SELECT *";
        }

        $sql .= " FROM ".$this->db->table("ip_capture")." info
                 LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id = info.customer_id 
                 LEFT JOIN ".$this->db->table("customer_groups")." cg ON cg.customer_group_id = c.customer_group_id 
                 ";

        $implode = [];
        $filter = (isset($data['filter']) ? $data['filter'] : []);

        if (isset($filter['name']) && has_value($filter['name'])) {
            $implode[] = "CONCAT(info.firstname, ' ', info.lastname) 
                LIKE '%".$this->db->escape($filter['name'], true) ."%' ";
        }

        if (isset($filter['company']) && has_value($filter['company'])) {
            $implode[] = "info.company LIKE '%".$this->db->escape($filter['company'], true )."%' ";
        }

        if (isset($filter['email']) && has_value($filter['email'])) {
            $implode[] = "info.email LIKE '%".$this->db->escape($filter['email'], true )."%' ";
        }

        if (isset($filter['zone']) && has_value($filter['zone'])) {
            $implode[] = "info.zone LIKE '%".$this->db->escape($filter['zone'], true )."%' ";
        }

        if (isset($filter['country']) && has_value($filter['country'])) {
            $implode[] = "info.country LIKE '%".$this->db->escape($filter['country'], true )."%' ";
        }

        if (isset($filter['note']) && has_value($filter['note'])) {
            $implode[] = "info.note LIKE '%".$this->db->escape($filter['note'], true )."%' ";
        }

        if (isset($filter['ip']) && has_value($filter['ip'])) {
            $implode[] = "info.ip LIKE '%".$this->db->escape($filter['ip'], true )."%' ";
        }

        if (isset($filter['customer_group']) && has_value($filter['customer_group'])) {
            $implode[] = "cg.name LIKE '%".$this->db->escape($filter['customer_group'], true )."%' ";
        }

        if ($implode) {
            $sql .= " WHERE ".implode(" AND ", $implode);
        }

        //If for total, we done building the query
        if ($mode == 'total_only' && !$this->dcrypt->active) {
            $query = $this->db->query($sql);
            return $query->row['total'];
        }

        $sort_data = [
            'customer_id'    => 'info.customer_id',
            'name'           => 'info.firstname',
            'company'        => 'info.company',
            'customer_group' => 'cg.name',
            'email'          => 'info.email',
            'source'         => 'info.source',
            'ip'             => 'info.ip',
            'zone'           => 'info.zone',
            'note'           => 'info.note',
            'country'        => 'info.country',
            'date_added'     => 'info.date_added',
        ];

        //Total calculation for encrypted mode
        // NOTE: Performance slowdown might be noticed or larger search results
        if ($mode != 'total_only') {
            $sql .= " ORDER BY ".($sort_data[$data['sort']] ? $sort_data[$data['sort']] : 'name');
            if (isset($data['order']) && (strtoupper($data['order']) == 'DESC')) {
                $sql .= " DESC";
            } else {
                $sql .= " ASC";
            }

            if (isset($data['start']) || isset($data['limit'])) {
                if ($data['start'] < 0) {
                    $data['start'] = 0;
                }
                if ($data['limit'] < 1) {
                    $data['limit'] = 20;
                }
                $sql .= " LIMIT ".(int) $data['start'].",".(int) $data['limit'];
            }
        }

        $query = $this->db->query($sql);
        $result_rows = $query->rows;

        if ($mode == 'total_only') {
            //we get here only if in data encryption mode
            return count($result_rows);
        }

        return $result_rows;
    }

    /**
     * @return mixed
     * @throws AException
     */
    public function getCompanies() {
        $sql = "SELECT DISTINCT company FROM ".$this->db->table("ip_capture");
        $query = $this->db->query($sql);
        return $query->rows;
    }

    public function deleteIPInfo($customer_id) {
        $this->db->query("DELETE FROM ".$this->db->table("ip_capture")." WHERE `customer_id`=".(int)$customer_id);
    }

    public function getIpCaptureInfo($customer_id) {
        $query = $this->db->query("SELECT ip.*,c.customer_group_id FROM ".$this->db->table("ip_capture")." ip 
                         LEFT JOIN ".$this->db->table("customers")." c ON c.customer_id = ip.customer_id 
                         WHERE ip.customer_id=".(int)$customer_id);
        return $query->row;
    }

    /**
     * @param $ip_capture_id
     * @param $note
     * @return bool|stdClass|void
     * @throws AException
     */
    public function updateNote($customer_id,$note) {
        return $this->db->query('UPDATE '.$this->db->table("ip_capture").' SET note="'.$note.'" WHERE customer_id = "' . (int)$customer_id . '"');
    }

    /**
     * @param $ip_capture_id
     * @param $customer_group_id
     * @return bool|stdClass
     * @throws AException
     */
    public function updateCustomerGroup($customer_id,$customer_group_id) {
        return $this->db->query("UPDATE ".$this->db->table("customers")." SET `customer_group_id`='".$customer_group_id."' WHERE customer_id = '" . (int)$customer_id . "'");
    }

}