<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * ControllerResponsesListingGridIpCaptureContactUs
 * @property ModelExtensionIpCaptureContactUs $model_extension_ip_capture_contact_us
 */
class ControllerResponsesListingGridIpCaptureContactUs extends AController {
    public $error = '';

    public function main() {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('ip_capture/ip_capture');
        $this->loadModel('extension/ip_capture_contact_us');
        $this->load->model('sale/customer');
        $this->load->library('json');

        $page = $this->request->post['page'];  // get the requested page
        $limit = $this->request->post['rows']; // get how many rows we want to have into the grid
        $sidx = $this->request->post['sidx'];  // get index row - i.e. user click to sort
        $sord = $this->request->post['sord'];  // get the direction

        $data = [
            'sort'  => $sidx,
            'order' => $sord,
            'start' => ($page - 1) * $limit,
            'limit' => $limit,
        ];

        if (has_value($this->request->get['company'])) {
            $data['filter']['company'] = $this->request->get['company'];
        }

        if (has_value($this->request->get['email'])) {
            $data['filter']['email'] = $this->request->get['email'];
        }

        if (has_value($this->request->get['zone'])) {
            $data['filter']['zone'] = $this->request->get['zone'];
        }

        if (has_value($this->request->get['country'])) {
            $data['filter']['country'] = $this->request->get['country'];
        }

        if (has_value($this->request->get['ip'])) {
            $data['filter']['ip'] = $this->request->get['ip'];
        }

        //if (has_value($this->request->get['source'])) {
        //    $data['filter']['source'] = $this->request->get['source'];
        //}

        $allowedFields = array_merge([ 'name', 'company','email','zone','country','ip','note'], (array) $this->data['allowed_fields']);

        if (isset($this->request->post['_search']) && $this->request->post['_search'] == 'true') {
            $searchData = AJson::decode(htmlspecialchars_decode($this->request->post['filters']), true);

            foreach ($searchData['rules'] as $rule) {
                if (!in_array($rule['field'], $allowedFields)) {
                    continue;
                }
                $data['filter'][$rule['field']] = trim($rule['data']);
            }
        }

        $total = $this->model_extension_ip_capture_contact_us->getTotalIpCapture($data);
        if ($total > 0) {
            $total_pages = ceil($total / $limit);
        } else {
            $total_pages = 0;
        }

        if ($page > $total_pages) {
            $page = $total_pages;
            $data['start'] = ($page - 1) * $limit;
        }

        $response = new stdClass();
        $response->page = $page;
        $response->total = $total_pages;
        $response->records = $total;
        $orders_count = 0;

        if ($sidx == 'orders_count') {
            $mode = '';
        } else {
            $mode = 'quick';
        }

        $results = $this->model_extension_ip_capture_contact_us->getIpCapture($data, $mode);

        $i = 0;
        foreach ($results as $result) {
            $response->rows[$i]['id'] = $result['ip_capture_contact_us_id'];
            $response->rows[$i]['cell'] = [
                $result['ip_capture_contact_us_id'],
                $result['firstname'].' '.$result['lastname'],
                $result['company'],
                '<a href="'.$this->html->getSecureURL('sale/contact', '&email[]='.$result['email']).'">'
                    .$result['email'].'</a>',
                $result['zone'],
                $result['country'],
                $result['ip'],
                //$result['source'],
                $result['note'],
                $result['date_added'],
            ];
            $i++;
        }
        $this->data['response'] = $response;

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->load->library('json');
        $this->response->addJSONHeader();
        $this->response->setOutput(AJson::encode($this->data['response']));
    }

}