<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2023 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

include_once DIR_EXT . 'ups_integration' . DIR_EXT_CORE . 'lib/autoload.php';

class ControllerResponsesExtensionUpsTest extends AController {
    private $cfg = [];

    public function test() {
        $this->loadLanguage('ups_integration/ups_integration');
        $this->loadModel('setting/setting');
        $store_id = (int) $this->config->get('config_store_id');
        if (has_value($this->request->get_or_post('store_id'))) {
            $store_id = (int) $this->request->get_or_post('store_id');
        } else {
            if ($this->session->data['current_store_id']) {
                $store_id = (int) $this->session->data['current_store_id'];
            }
        }
        $this->cfg = $this->model_setting_setting->getSetting('ups_integration',(int)$store_id);

        $json = [];
        $required_fields = [
            'client_id'      => 'ups_integration_client_id',
            'client_secret'  => 'ups_integration_client_secret',
            'pass'       	 => 'ups_integration_password',
            'city'       	 => 'ups_integration_city',
            'postcode'   	 => 'ups_integration_postcode',
            'state'   		 => 'ups_integration_state',
            'origin'	 	 => 'ups_integration_country',
            'classification' => 'ups_integration_classification',
            'packaging'		 => 'ups_integration_packaging',
            'pickup'		 => 'ups_integration_pickup',
        ];
        $address = [];
        foreach ($required_fields as $k => $fld){
            if (!$this->cfg[$fld]){
                $json['error'] = true;
                $json['message'] = 'Error: Please fill and save all required fields and try again.';
                break;
            }
            $address[$k] = $this->cfg[$fld];
        }

        if ($json['error'] != true){

            $test_result = $this->_processRequest($address);
            $test_mode = $this->cfg['ups_integration_test'] ? 'ON' : 'OFF';
            if (!$test_result){
                $json['error'] = true;
                $json['message'] = 'UPS Error: Wrong data was given. Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';
            } else if ($test_result['error']){
                $json['error'] = true;
                $json['message'] = 'UPS Error: ' . $test_result['error'] . "\n" . 'Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';

            } else{
                $json['message'] = $this->language->get('text_connection_success');
                $json['error'] = false;
            }
        }
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    private function _processRequest($address){
        $endpoint_url = $this->cfg['ups_integration_test'] ? 'https://wwwcie.ups.com/' : 'https://onlinetools.ups.com/' ;
        //ups Account
        $ups_account = $this->cfg['ups_integration_account'];
        $ups_classification = $this->cfg['ups_integration_classification'];
        $ups_packaging = $this->cfg['ups_integration_packaging'];
        $ups_pickup = $this->cfg['ups_integration_pickup'];
        $ups_city = $this->cfg['ups_integration_city'];
        $ups_state = $this->cfg['ups_integration_state'];
        $ups_postcode = $this->cfg['ups_integration_postcode'];
        $ups_origin = $this->cfg['ups_integration_country'];

        $token = $this->getAccessToken();

        if ($token['response']['errors']) {
            $error_msg = $token['response']['errors']['message'];
            return ['error' => $error_msg];
        }

        $access_token = $token['access_token'];

        if ($this->config->get('config_weight_class') == 'lb') {
            $weightUnit = 'lbs';
        } elseif ($this->config->get('config_weight_class') == 'kg') {
            $weightUnit = 'kgs';
        }

        $this->load->model('extension/ups_order');
        $weightDesc = $this->model_extension_ups_order->getVolumeDescription($this->config->get('config_weight_class'));

        $lengthUnit = $this->config->get('config_length_class');
        $lengthDesc= $this->model_extension_ups_order->getDimDescription($lengthUnit);

        //Recepient Info

        $request = [
            'RateRequest' => [
                'Request' => [
                    'TransactionReference' => [
                        'CustomerContext' => 'CustomerContext'
                    ]
                ],
                'PickupType' => [
                    'Code' => $ups_pickup
                ],
                'CustomerClassification' => [
                    'Code' => $ups_classification
                ],
                'Shipment' => [
                    'Shipper' => [
                        'Name' => 'ShipperName',
                        'ShipperNumber' => $ups_account,
                        'Address' => [
                            'City' => $ups_city,
                            'StateProvinceCode' => $ups_state,
                            'PostalCode' => $ups_postcode,
                            'CountryCode' => $ups_origin
                        ]
                    ],
                    'ShipTo' => [
                        'Name' => 'ShipperName',
                        'Address' => [
                            'City' => $ups_city,
                            'StateProvinceCode' => $ups_state,
                            'PostalCode' => $ups_postcode,
                            'CountryCode' => $ups_origin
                        ]
                    ],
                    'ShipFrom' => [
                        'Name' => 'ShipperName',
                        'Address' => [
                            'City' => $ups_city,
                            'StateProvinceCode' => $ups_state,
                            'PostalCode' => $ups_postcode,
                            'CountryCode' => $ups_origin
                        ]
                    ],
                    'PaymentDetails' => [
                        'ShipmentCharge' => [
                            'Type' => '01',
                            'BillShipper' => [
                                'AccountNumber' => $ups_account
                            ]
                        ],
                    ],
                    'Package' => [
                        'PackagingType' => [
                            'Code' => $ups_packaging
                        ],
                        'Dimensions' => [
                            'UnitOfMeasurement' => [
                                'Code' => $lengthUnit,
                                'Description' => $lengthDesc
                            ],
                            'Length' => '5',
                            'Width' => '5',
                            'Height' => '5'
                        ],
                        'PackageWeight' => [
                            'UnitOfMeasurement' => [
                                'Code' => $weightUnit,
                                'Description' => $weightDesc
                            ],
                            'Weight' => '1'
                        ]
                    ]
                ]
            ]
        ];

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'api/rating/v1/shop',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($request),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: text/plain',
                'Authorization: Bearer '.$access_token
            ),
        ));

        $response = json_decode(curl_exec($curl),true);

        curl_close($curl);
        if ($response['response']['errors']) {
            $error_msg = $response['response']['errors']['message'];
        }

        if ($this->config->get('ups_integration_debug')) {
            $this->log->write('UPS Integration Testing Result: '.var_export($response,true));
        }

        return ['error' => $error_msg];
    }

    public function getAccessToken() {
        $endpoint_url = $this->cfg['ups_integration_test'] ? 'https://wwwcie.ups.com/' : 'https://onlinetools.ups.com/' ;
        $client_id = $this->cfg['ups_integration_client_id'];
        $client_secret = $this->cfg['ups_integration_client_secret'];

        $curl = curl_init();

        $auth = base64_encode($client_id.":".$client_secret);

        curl_setopt_array($curl, array(
            CURLOPT_URL => $endpoint_url.'security/v1/oauth/token',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => 'grant_type=client_credentials',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/x-www-form-urlencoded',
                'Authorization: Basic '.$auth,
            ),
        ));

        $response = json_decode(curl_exec($curl),true);
        $curl_error = curl_error($curl);

        curl_close($curl);

        if ($this->config->get('ups_integration_debug')) {
            $this->log->write('UPS Integration Obtain Access Token: '.var_export($response,true));
        }

        return $response;
    }

}