<?php
if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

class ExtensionWhitelabel extends Extension {

        public function  __construct() {
                $this->registry = Registry::getInstance();
        }

        public function onControllerCommonHeader_UpdateData(){
        	$dir = HTTPS===true ? HTTPS_DIR_RESOURCE : HTTP_DIR_RESOURCE;
			$config = $this->registry->get('config');
			$logo = $config->get('whitelabel_admin_logo');
			if(IS_ADMIN && $logo) {
				if ( preg_match('/(http:\/\/|https:\/\/)/', $logo) ) {
					$img_src = $logo;
				} else {
					$img_src = $dir.$config->get('whitelabel_admin_logo');
				}
				$logo = '<img src="'.$img_src.'" title="new logo"/>';
				$this->baseObject->view->addHookVar('logoimage_hookvar', $logo);
			}
        }

        public function onControllerCommonFooter_UpdateData(){
        	$config = $this->registry->get('config');
			if(IS_ADMIN && $config->get('whitelabel_status')) {
				$this->baseObject->view->assign('text_footer', html_entity_decode($config->get('whitelabel_bottom_adm_right'), ENT_COMPAT, 'UTF-8'));
				$this->baseObject->view->assign('text_footer_left', html_entity_decode($config->get('whitelabel_bottom_adm_left'), ENT_COMPAT, 'UTF-8'));
				$this->baseObject->view->assign('doc_menu',	array());
				$this->baseObject->view->assign('support_menu',	array());
				$this->baseObject->view->assign('mp_menu',	array());
				$this->baseObject->view->assign('doc_menu_text',	'');			
				$this->baseObject->view->assign('support_menu_text',	'');			
				$this->baseObject->view->assign('mp_menu_text',	'');			
			} else {
				$this->baseObject->view->assign('text_project_label', html_entity_decode($config->get('whitelabel_bottom_sf'), ENT_COMPAT, 'UTF-8'));
			}
        }

    	public function beforeModelCheckoutOrder_confirm() {
    		$config = $this->registry->get('config');
    		// deprecated since 1.2.8
			$this->baseObject->data['text_project_label'] = html_entity_decode($config->get('whitelabel_bottom_email'), ENT_COMPAT, 'UTF-8');

			$this->baseObject->data['mail_template_data']['text_project_label'] = html_entity_decode($config->get('whitelabel_bottom_email'), ENT_COMPAT, 'UTF-8');
        }
}
