<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

include_once DIR_EXT.'usps_integration'.DIR_EXT_CORE.'lib/autoload.php';
require_once DIR_SYSTEM . "lib/vendor/autoload.php";

/**
 * ModelExtensionUspsIntegration
 * @property ModelExtensionUspsVerify $model_extension_usps_verify
 */

class ModelExtensionUspsIntegration extends Model {

	public $data=[];

    /**
     * @param $address
     * @return array
     * @throws AException
     */
    public function getQuote($address) {
        $this->load->model('extension/usps_verify');
        $verify = $this->model_extension_usps_verify->verify();
        if ($verify===true) {
            $cart = $this->cart;

            $userId = $this->config->get('usps_integration_user_id');
            $pwd = $this->config->get('usps_integration_user_password');

            $this->load->language('usps_integration/usps_integration');
            $id = 'usps_integration.usps_integration';
            $status = $this->status($address);
            $method_data = [];

            if (!$status) {
                return $method_data;
            }

            $quote_data = [];

            $generic_product_ids = $free_shipping_ids = $shipping_price_ids = []; // ids of products without special shipping cost
            $shipping_price_cost = 0; // total shipping cost of product with fixed shipping price
            $cart_products = $cart->getProducts();

            foreach ($cart_products as $product) {
                //(exclude free shipping products)
                if ($product['free_shipping'] || $product['download']) {
                    $free_shipping_ids[] = $product['product_id'];
                    continue;
                }
                if ($product['shipping_price'] > 0) {
                    $shipping_price_ids[] = $product['product_id'];
                    $shipping_price_cost += $product['shipping_price'] * $product['quantity'];
                }
                $generic_product_ids[] = $product['product_id'];
            }
            //convert fixed prices to USD
            $shipping_price_cost = $this->currency->convert($shipping_price_cost, $this->config->get('config_currency'), 'USD');

            if ($generic_product_ids) {
                $api_weight_product_ids = array_diff($generic_product_ids, $shipping_price_ids);

                //WHEN ONLY PRODUCTS WITH FIXED SHIPPING PRICES ARE IN BASKET
                if (!$api_weight_product_ids) {
                    $cost = $shipping_price_cost;
                    $quote_data = [
                        'usps_integration' => [
                            'id' => $id,
                            'title' => $this->language->get('text_title'),
                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                            'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                            'text' => $this->currency->format(
                                $this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $this->config->get('usps_integration_tax_class_id'),
                                    $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        ]
                    ];

                    $method_data = [
                        'id' => 'usps_integration',
                        'title' => $this->language->get('text_title'),
                        'quote' => $quote_data,
                        'sort_order' => $this->config->get('usps_integration_sort_order'),
                        'error' => ''
                    ];

                    return $method_data;
                }
            } else {
                $api_weight_product_ids = $shipping_price_ids;
            }
            $basic_products = $cart->basicShippingProducts();
            $basic_products_subtotal = 0;
            $product_ids = [];
            foreach ($basic_products as $product) {
                $product_ids[] = $product['product_id'];
                $basic_products_subtotal += $product['total'];
            }
            $weight = $this->weight->convert($cart->getWeight($product_ids), $this->config->get('config_weight_class'), 'lb') + number_format((float)$this->config->get('usps_integration_additional_weight'), 2, '.', '');
            $weight = ($weight < 0.1 ? 0.1 : $weight);
            $pounds = floor($weight);
            $ounces = round(16 * ($weight - $pounds), 2); // max 5 digits
            $to_postcode = str_replace(' ', '', $address['postcode']);
            $postcode = substr($to_postcode, 0, 5);
            $usa = ['US', 'AS', 'GU', 'PR', 'VI', 'FM', 'MH', 'PW', 'MP', 'WS'];
            if (!$api_weight_product_ids && $free_shipping_ids) {
                $cost = 0.0;
                if (in_array($address['iso_code_2'], $usa) && $this->config->get('usps_integration_free_domestic_method') !== 'NONE') {
                    $quote_data = [
                        'usps_integration' => [
                            'id' => $id,
                            'title' => $this->language->get('text_' . $this->config->get('usps_integration_free_domestic_method')),
                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                            'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                            'text' => $this->currency->format(
                                $this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $this->config->get('usps_integration_tax_class_id'),
                                    $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        ]
                    ];
                } elseif (!in_array($address['iso_code_2'], $usa) && $this->config->get('usps_integration_free_international_method') !== 'NONE') {
                    $quote_data = [
                        'usps_integration' => [
                            'id' => $id,
                            'title' => $this->language->get('text_' . $this->config->get('usps_integration_free_international_method')),
                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                            'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                            'text' => $this->currency->format(
                                $this->tax->calculate($this->currency->convert($cost,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $this->config->get('usps_integration_tax_class_id'),
                                    $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        ]
                    ];
                }

                $method_data = [
                    'id' => 'usps_integration',
                    'title' => $this->language->get('text_title'),
                    'quote' => $quote_data,
                    'sort_order' => $this->config->get('usps_integration_sort_order'),
                    'error' => ''
                ];

                return $method_data;
            }

            (($this->config->get('usps_integration_length') == "") ? $defaultLength = "5" : $defaultLength = $this->config->get('usps_integration_length'));
            (($this->config->get('usps_integration_width') == "") ? $defaultWidth = "5" : $defaultWidth = $this->config->get('usps_integration_width'));
            (($this->config->get('usps_integration_height') == "") ? $defaultHeight = "5" : $defaultHeight = $this->config->get('usps_integration_height'));

            $length = $this->length->convert($defaultLength, $this->config->get('config_length_class'), 'in');
            $width = $this->length->convert($defaultWidth, $this->config->get('config_length_class'), 'in');
            $height = $this->length->convert($defaultHeight, $this->config->get('config_length_class'), 'in');

            $shipCode = substr($this->config->get('usps_integration_postcode'), 0, 5);

            $avg = $wt = $top = $wt_pounds = $wt_ounces = 0;
            $avg_quote_data = [];
            $avg_weight = (float)$this->config->get('usps_integration_weight');
            $avg_pounds = floor($avg_weight);
            $avg_ounces = round(16 * ($avg_weight - $avg_pounds), 2);
            if ($avg_weight !== 0.00 && $weight > $avg_weight) {
                $avg = floor($weight / (int)$avg_weight);
                $wt = fmod($weight, $avg_weight);
                $wt_pounds = floor($wt);
                $wt_ounces = round(16 * ($wt - $wt_pounds), 2);
            }

            $usa = ['US', 'AS', 'GU', 'PR', 'VI', 'FM', 'MH', 'PW', 'MP', 'WS'];
            if (in_array($address['iso_code_2'], $usa)) {
                if ($basic_products) {
                    if ($avg !== 0) {
                        if ($wt !== 0) {
                            $loop = $avg + 1;
                            $top = $avg + 1;
                        } else {
                            $loop = $avg;
                        }
                        $j = 1;
                        for ($i = 1; $i <= $loop; $i++) {
                            if ($j == $top) {
                                $rateService = $this->_domesticRate($userId, $pwd, $shipCode, $postcode, $wt_pounds, $wt_ounces, $length, $width, $height);
                            } else {
                                $rateService = $this->_domesticRate($userId, $pwd, $shipCode, $postcode, $avg_pounds, $avg_ounces, $length, $width, $height);
                            }
                            if ($rateService) {
                                $avg_quote_data = $this->processRate($address, $rateService, '', '');
                                $error_msg = $avg_quote_data['error_msg'];
                                $avg_quote_data = $avg_quote_data['quote_data'];
                            }
                            if ($quote_data) {
                                foreach ($quote_data as $key => $value) {
                                    $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $avg_quote_data[$key]['cost'];
                                    $quote_data[$key]['text'] = $this->currency->format(
                                        $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                            $this->config->get('config_currency'),
                                            $this->currency->getCode()),
                                            $this->config->get('usps_integration_tax_class_id'),
                                            $this->config->get('config_tax')),
                                        $this->currency->getCode(),
                                        1.0000000);
                                }
                            } else if ($avg_quote_data) {
                                $quote_data = $avg_quote_data;
                            }
                            $j++;
                        }
                    } else {
                        $rateService = $this->_domesticRate($userId, $pwd, $shipCode, $postcode, $pounds, $ounces, $length, $width, $height);
                        $quote_data = $this->processRate($address, $rateService, '', '');
                        $error_msg = $quote_data['error_msg'];
                        $quote_data = $quote_data['quote_data'];
                    }
                }

                foreach ($cart_products as $product) {
                    if ($product['ship_individually'] && $product['shipping_price'] == '0.00') {
                        $individualWeight = $this->weight->convert($this->getIndividualWeight([$product['product_id']]), $this->config->get('config_weight_class'), 'lb') + number_format((float)$this->config->get('usps_integration_additional_weight'), 2, '.', '');
                        $individualWeight = ($individualWeight < 0.1 ? 0.1 : $individualWeight);
                        $individualPounds = floor($individualWeight);
                        $individualOunces = round(16 * ($individualWeight - $individualPounds), 2); // max 5 digits
                        $length_class_id = $this->length->getClassID($this->config->get('config_length_class'));
                        $use_width = (($product['width'] != '0.00') ? $this->length->convertByID($product['width'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));
                        $use_length = (($product['length'] != '0.00') ? $this->length->convertByID($product['length'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));
                        $use_height = (($product['height'] != '0.00') ? $this->length->convertByID($product['height'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));

                        $qty = $product['quantity'];
                        $request = $this->_domesticRate($userId, $pwd, $shipCode, $postcode, $individualPounds, $individualOunces, $use_length, $use_width, $use_height);
                        $new_quote_data = $this->processRate($address, $request, '', $qty);
                        $error_msg = $new_quote_data['error_msg'];
                        $new_quote_data = $new_quote_data['quote_data'];

                        if ($quote_data) {
                            foreach ($quote_data as $key => $value) {
                                $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $new_quote_data[$key]['cost'];
                                $quote_data[$key]['text'] = $this->currency->format(
                                    $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $this->config->get('usps_integration_tax_class_id'),
                                        $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000);
                            }
                        } else if ($new_quote_data) {
                            $quote_data = $new_quote_data;
                        }
                    }
                }

                if ($quote_data) {
                    foreach ($quote_data as $key => $value) {
                        $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $shipping_price_cost;
                        $quote_data[$key]['text'] = $this->currency->format(
                            $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                $this->config->get('config_currency'),
                                $this->currency->getCode()),
                                $this->config->get('usps_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                            $this->currency->getCode(),
                            1.0000000);
                    }
                }
            } else {
                if ($basic_products) {
                    //load all countries and codes
                    if ($avg !== 0) {
                        if ($wt !== 0) {
                            $loop = $avg + 1;
                            $top = $avg + 1;
                        } else {
                            $loop = $avg;
                        }
                        $j = 1;
                        for ($i = 1; $i <= $loop; $i++) {
                            if ($j == $top) {
                                $intlService = $this->_intlRate($address, $userId, $pwd, $wt_pounds, $wt_ounces, $ounces, $length, $width, $height, $basic_products_subtotal);
                            } else {
                                $intlService = $this->_intlRate($address, $userId, $pwd, $postcode, $avg_pounds, $avg_ounces, $length, $width, $height, $basic_products_subtotal);
                            }
                            if ($intlService) {
                                $avg_quote_data = $this->processRate($address, '', $intlService, '');
                                $error_msg = $avg_quote_data['error_msg'];
                                $avg_quote_data = $avg_quote_data['quote_data'];
                            }
                            if ($quote_data) {
                                foreach ($quote_data as $key => $value) {
                                    $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $avg_quote_data[$key]['cost'];
                                    $quote_data[$key]['text'] = $this->currency->format(
                                        $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                            $this->config->get('config_currency'),
                                            $this->currency->getCode()),
                                            $this->config->get('usps_integration_tax_class_id'),
                                            $this->config->get('config_tax')),
                                        $this->currency->getCode(),
                                        1.0000000);
                                }
                            } else if ($avg_quote_data) {
                                $quote_data = $avg_quote_data;
                            }
                            $j++;
                        }
                    } else {
                        $intlService = $this->_intlRate($address, $userId, $pwd, $pounds, $ounces, $length, $width, $height, $basic_products_subtotal);
                        $quote_data = $this->processRate($address, '', $intlService, '');
                        $error_msg = $quote_data['error_msg'];
                        $quote_data = $quote_data['quote_data'];
                    }
                }

                foreach ($cart_products as $product) {
                    if ($product['ship_individually'] && $product['shipping_price'] == '0.00') {
                        $individualWeight = $this->weight->convert($this->getIndividualWeight([$product['product_id']]), $this->config->get('config_weight_class'), 'lb') + number_format((float)$this->config->get('usps_integration_additional_weight'), 2, '.', '');
                        $individualWeight = ($individualWeight < 0.1 ? 0.1 : $individualWeight);
                        $individualPounds = floor($individualWeight);
                        $individualOunces = round(16 * ($individualWeight - $individualPounds), 2); // max 5 digits
                        $length_class_id = $this->length->getClassID($this->config->get('config_length_class'));
                        $use_width = (($product['width'] != '0.00') ? $this->length->convertByID($product['width'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));
                        $use_length = (($product['length'] != '0.00') ? $this->length->convertByID($product['length'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));
                        $use_height = (($product['height'] != '0.00') ? $this->length->convertByID($product['height'], $product['length_class'], $length_class_id) : $this->length->convertByID('5', $product['length_class'], $length_class_id));

                        $qty = $product['quantity'];
                        $request = $this->_intlRate($address, $userId, $pwd, $individualPounds, $individualOunces, $use_length, $use_width, $use_height, $product['price']);
                        $new_quote_data = $this->processRate($address, '', $request, $qty);
                        $error_msg = $new_quote_data['error_msg'];
                        $new_quote_data = $new_quote_data['quote_data'];

                        if ($quote_data) {
                            foreach ($quote_data as $key => $value) {
                                $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $new_quote_data[$key]['cost'];
                                $quote_data[$key]['text'] = $this->currency->format(
                                    $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $this->config->get('usps_integration_tax_class_id'),
                                        $this->config->get('config_tax')),
                                    $this->currency->getCode(),
                                    1.0000000);
                            }
                        } else if ($new_quote_data) {
                            $quote_data = $new_quote_data;
                        }
                    }
                }

                if ($quote_data) {
                    foreach ($quote_data as $key => $value) {
                        $quote_data[$key]['cost'] = $quote_data[$key]['cost'] + $shipping_price_cost;
                        $quote_data[$key]['text'] = $this->currency->format(
                            $this->tax->calculate($this->currency->convert($quote_data[$key]['cost'],
                                $this->config->get('config_currency'),
                                $this->currency->getCode()),
                                $this->config->get('usps_integration_tax_class_id'),
                                $this->config->get('config_tax')),
                            $this->currency->getCode(),
                            1.0000000);
                    }
                }
            }

            $title = $this->language->get('text_title');

            $method_data = [
                'id' => 'usps_integration',
                'title' => $title,
                'quote' => $quote_data,
                'sort_order' => $this->config->get('usps_integration_sort_order'),
                'error' => $error_msg
            ];

            return $method_data;
        }
    }

    public function getLocalDelivery($address) {
        $this->load->model('extension/usps_verify');
        $verify = $this->model_extension_usps_verify->verify();
    	if ($verify===true) {
		    $to_postcode         = str_replace( ' ', '', $address['postcode'] );
		    $postcode = substr($to_postcode,0,5);
		    $exclude_zipcodes = $this->config->get( 'usps_integration_local_zipcodes' );
		    $fee              = $this->config->get( 'usps_integration_local_delivery_fee' );
		    $this->load->language( 'usps_integration/usps_integration' );
		    $valid = '';
		    if ( $fee ) {
			    $cost  = $fee;
			    $title = $this->language->get( 'text_local_delivery_fee', 'usps_integration/usps_integration' );
		    } else {
			    $cost  = 0;
			    $title = $this->language->get( 'text_free_local_delivery', 'usps_integration/usps_integration' );
		    }

		    $zipcodes_list = explode( ',', $exclude_zipcodes );
		    if ( $zipcodes_list ) {
			    foreach ( $zipcodes_list as $zipcodes ) {
				    if ( fnmatch( $zipcodes, $postcode ) ) {
					    $valid = '1';
					    break;
				    }
			    }
		    } else {
			    if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				    $valid = '1';
			    }
		    }
		    if ( $exclude_zipcodes && $valid ) {
			    $local_delivery = [
				    'usps_integration_local' => [
					    'id'           => 'usps_integration_local.usps_integration_local',
					    'title'        => $title,
					    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get('config_currency') ),
					    'tax_class_id' => $this->config->get( 'usps_integration_tax_class_id' ),
					    'text'         => $this->currency->format(
						    $this->tax->calculate( $this->currency->convert( $cost,
							    $this->config->get( 'config_currency' ),
							    $this->currency->getCode() ),
							    $this->config->get( 'usps_integration_tax_class_id' ),
							    $this->config->get( 'config_tax' ) ),
						    $this->currency->getCode(),
						    1.0000000 )
				    ]
			    ];
		    }

		    if ( $local_delivery ) {
			    $quote_data = $local_delivery;
		    }
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'];
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                            $this->config->get( 'usps_integration_tax_class_id' ),
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
                }
		    }

		    $title = $this->language->get( 'text_usps_local_delivery', 'usps_integration/usps_integration' );

		    $method_data = [
			    'id'         => 'usps_integration_local',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $this->config->get( 'usps_integration_sort_order' ),
		    ];

		    return $method_data;
	    }
    }

    /**
     * @param $userId
     * @param $password
     * @param $shipCode
     * @param $postcode
     * @param $pounds
     * @param $ounces
     * @param $length
     * @param $width
     * @param $height
     * @return mixed
     * @throws AException
     */
    private function _domesticRate($userId,$password,$shipCode,$postcode,$pounds,$ounces,$length,$width,$height) {
        $this->load->model('localisation/country');
        $this->load->model('localisation/zone');
        $country=$this->model_localisation_country->getCountry($this->config->get('config_country_id'));
        $f = new \RocketShipItUsps\Rate('usps');
        $f->setParameter('userid', $userId);
        $f->setParameter('password', $password);
        $f->setParameter('shipCode', $shipCode);
        $f->setParameter('toCode', $postcode);

        if ($this->config->get('usps_integration_domestic_77')==='1') {
            $f->setParameter('service','ONLINE');
        } else {
            $f->setParameter('service','ALL');
        }
		if ($pounds=="") {
            $f->setparameter('weightPounds', '0');
        } else {
            $f->setparameter('weightPounds', $pounds);
        }
        $f->setParameter('shipCountry',  $country['iso_code_2']);
        if ($ounces=="") {
            $f->setparameter('weightOunces', '0');
        } else {
            $f->setparameter('weightOunces', $ounces);
        }
        $f->setparameter('length',$length);
        $f->setparameter('width',$width);
        $f->setparameter('height',$height);
        if ($this->config->get('usps_integration_machinable')==='1') {
            $machinable='true';
        } else {
            $machinable='false';
        }
        $f->setParameter('machinable',$machinable);
        $f->setParameter('packagingType','VARIABLE');
        $response = $f->getAllRates();
		if ($this->config->get('usps_integration_debug')) {
			$this->log->write('USPS Integration Debug: '.html_entity_decode(var_export($f->debug(),true)));
		}
        return $response['RateV4Response'];
    }

    /**
     * @param string $address
     * @param string $userId
     * @param string $pwd
     * @param string $pounds
     * @param string $ounces
     * @param string $length
     * @param string $width
     * @param string $height
     * @param string $subtotal
     * @return mixed
     * @throws AException
     */
    private function _intlRate($address,$userId,$pwd,$pounds,$ounces,$length,$width,$height,$subtotal) {
        $rate = new \RocketShipItUsps\Rate('usps');
        $rate->setParameter('userid',$userId);
        $rate->setParameter('password',$pwd);
        $rate->setParameter('toCountry',$address['iso_code_2']);
        if ($pounds=="") {
            $rate->setparameter('weightPounds', '0');
        } else {
            $rate->setparameter('weightPounds', $pounds);
        }
        if ($ounces=="") {
            $rate->setparameter('weightOunces', '0');
        } else {
            $rate->setparameter('weightOunces', $ounces);
        }
        $rate->setparameter('length',$length);
        $rate->setparameter('width',$width);
        $rate->setparameter('height',$height);
        if ($this->config->get('usps_integration_machinable')=='1') {
            $machinable='true';
        } else {
            $machinable='false';
        }
        $rate->setParameter('machinable',$machinable);
        $rate->setParameter('container','rectangular');
        $rate->setParameter('insuredCurrency','USD');
        $rate->setParameter('insuredValue',$subtotal);
        $response = $rate->getAllRates();
	    if ($this->config->get('usps_integration_debug')) {
		    $this->log->write('USPS Integration Debug: '.html_entity_decode(var_export($rate->debug(),true)));
	    }
        return $response['IntlRateV2Response'];
    }

	/**
	 * @param $address
	 * @param string $rateService
	 * @param string $intlService
	 * @param string $qty
	 *
	 * @return array
	 */
    public function processRate($address,$rateService="",$intlService="",$qty="") {
	    $this->load->language('usps_integration/usps_integration','storefront');
	    $cart = $this->cart;

	    $this->extensions->hk_InitData($this, __FUNCTION__);
        $status=$this->status($address);
        $method_data = [];
        $quote_data = [];
        if (!$status) {
            return $method_data;
        }
        if ($status) {
            if ($rateService) {
            	$usa=['US','AS','GU','PR','VI','FM','MH','PW','MP','WS'];
                if (in_array($address['iso_code_2'],$usa)) {
                    $allowed = [0, 1, 2, 3, 4, 5, 6, 7, 12, 13, 16, 17, 18, 19, 22, 23, 25, 27, 28,77];
                    $package = $rateService['Package'];
                    $postages = $package['Postage'];

                    $newClassId='';
                    if ($postages) {
                        if (sizeof($postages)!==sizeof($postages,COUNT_RECURSIVE)) {
                            foreach ($postages as $postage) {
                                if (isset($postage['CLASSID'])) {
                                    $classid = $postage['CLASSID'];
                                    if ($classid==='4') {
                                        $title ='';
                                    } else {
                                        $title = $this->language->get('text_usps_title'). ' ';
                                    }
                                    if ($this->config->get('usps_integration_display_weight')) {
                                        $titleWeight = $title.html_entity_decode(strip_tags($postage['MailService'], '<sup>')) . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                                    } else {
                                        $titleWeight = $title.html_entity_decode(strip_tags($postage['MailService'], '<sup>'));
                                    }
                                    $type = $this->config->get('usps_integration_type');
                                    $fee_rate = (float)$this->config->get('usps_integration_additional_fee');
                                    $rate = $postage['Rate'];
                                    if ($type == 'percent' && $fee_rate != '0') {
                                        $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                                    } elseif ($type == 'fixed' && $fee_rate != '0') {
                                        $fee = number_format($fee_rate, 2, '.', '');
                                    }

                                    if (($this->config->get('usps_integration_domestic_' . $classid))) {
                                        //this is for adding the additional fee
                                        if ($qty == '') {
                                            $cost = $rate + $fee;
                                        } else {
                                           $cost = ($rate + $fee) * $qty;
                                        }
                                        if (stripos($postage['MailService'], 'Stamped') !== false) {
                                            $newClassId = $classid . '_stamp';
                                        } else {
                                            $newClassId = $classid;
                                        }
                                        $quote_data[$newClassId] = [
                                            'id' => 'usps_integration.' . $newClassId,
                                            'title' => $titleWeight,
                                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                            'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                                            'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                                $this->config->get('config_currency'),
                                                $this->currency->getCode()),
                                                $this->config->get('usps_integration_tax_class_id'),
                                                $this->config->get('config_tax')),
                                                $this->currency->getCode(),
                                                1.0000000)
                                        ];
                                    }
                                } else {
                                    $classid = $postages['CLASSID'];
                                    if ($classid==='4') {
                                        $title ='';
                                    } else {
                                        $title = $this->language->get('text_usps_title'). ' ';
                                    }
                                    if ($this->config->get('usps_integration_display_weight')) {
                                        $titleWeight = $title. html_entity_decode(strip_tags($postages['MailService'], '<sup>')) . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                                    } else {
                                        $titleWeight = $title. html_entity_decode(strip_tags($postages['MailService'], '<sup>'));
                                    }
                                    $type = $this->config->get('usps_integration_type');
                                    $fee_rate = (float)$this->config->get('usps_integration_additional_fee');
                                    $rate = $postages['Rate'];
                                    if ($type == 'percent' && $fee_rate != '0') {
                                        $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                                    } elseif ($type == 'fixed' && $fee_rate != '0') {
                                        $fee = number_format($fee_rate, 2, '.', '');
                                    }

                                    if (($this->config->get('usps_integration_domestic_' . $classid))) {
                                        //this is for adding the additional fee
                                        if ($qty == '') {
                                            $cost = $rate + $fee;
                                        } else {
                                            $cost = ($rate + $fee) * $qty;
                                        }
                                        if (stripos($postages['MailService'], 'Stamped') !== false) {
                                            $newClassId = $classid . '_stamp';
                                        } else {
                                            $newClassId = $classid;
                                        }
                                        $quote_data[$newClassId] = [
                                            'id' => 'usps_integration.' . $newClassId,
                                            'title' => $titleWeight,
                                            'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                            'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                                            'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                                $this->config->get('config_currency'),
                                                $this->currency->getCode()),
                                                $this->config->get('usps_integration_tax_class_id'),
                                                $this->config->get('config_tax')),
                                                $this->currency->getCode(),
                                                1.0000000)
                                        ];
                                    }
                                }
                            }
                        } else {
                            $classid = $postages['CLASSID'];
                            if ($classid==='4') {
                                $title ='';
                            } else {
                                $title = $this->language->get('text_usps_title'). ' ';
                            }
                            if ($this->config->get('usps_integration_display_weight')) {
                                $titleWeight = $title. html_entity_decode(strip_tags($postages['MailService'], '<sup>')) . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                            } else {
                                $titleWeight = $title. html_entity_decode(strip_tags($postages['MailService'], '<sup>'));
                            }
                            $type = $this->config->get('usps_integration_type');
                            $fee_rate = (float)$this->config->get('usps_integration_additional_fee');
                            $rate = $postages['Rate'];
                            if ($type == 'percent' && $fee_rate != '0') {
                                $fee = number_format($rate * ($fee_rate / 100), 2, '.', '');
                            } elseif ($type == 'fixed' && $fee_rate != '0') {
                                $fee = number_format($fee_rate, 2, '.', '');
                            }

                            if (($this->config->get('usps_integration_domestic_' . $classid))) {
                                //this is for adding the additional fee
                                if ($qty == '') {
                                    $cost = $rate + $fee;
                                } else {
                                    $cost = ($rate + $fee) * $qty;
                                }
                                if (stripos($postages['MailService'], 'Stamped') !== false) {
                                    $newClassId = $classid . '_stamp';
                                } else {
                                    $newClassId = $classid;
                                }
                                $quote_data[$newClassId] = [
                                    'id' => 'usps_integration.' . $newClassId,
                                    'title' => $titleWeight,
                                    'cost' => $this->currency->convert($cost, $this->config->get('config_currency'), $this->config->get('config_currency')),
                                    'tax_class_id' => $this->config->get('usps_integration_tax_class_id'),
                                    'text' => $this->currency->format($this->tax->calculate($this->currency->convert($cost,
                                        $this->config->get('config_currency'),
                                        $this->currency->getCode()),
                                        $this->config->get('usps_integration_tax_class_id'),
                                        $this->config->get('config_tax')),
                                        $this->currency->getCode(),
                                        1.0000000)
                                ];
                            }
                        }
                    } else {
                        $error = $package['Error']['Description'];
                    }
                }
            } elseif ($intlService) {
                $allowed = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 21];
                $package = $intlService['Package'];
                $services = $package['Service'];
                if (isset($services['ID'])) {
	                $id       = $services['ID'];
	                $type     = $this->config->get( 'usps_integration_type' );
	                $fee_rate = (float) $this->config->get( 'usps_integration_additional_fee' );
	                $rate     = $services['Postage'];
	                if ( $type == 'percent' && $fee_rate != '0' ) {
		                $fee = number_format( $rate * ( $fee_rate / 100 ), 2, '.', '' );
	                } elseif ( $type == 'fixed' && $fee_rate != '0' ) {
		                $fee = number_format( $fee_rate, 2, '.', '' );
	                }
	                if ( in_array( $id, $allowed ) && $this->config->get( 'usps_integration_international_' . $id ) ) {
		                if ( $this->config->get( 'usps_integration_display_time' ) && $this->config->get( 'usps_integration_display_weight' ) == '1' ) {
			                $titleweightIntl = $this->language->get( 'text_usps_title' ) . ' ' . html_entity_decode( strip_tags( $services['SvcDescription'], '<sup>' ) ) . '(' . $this->language->get( 'text_weight' ) . ' ' . $this->weight->format( $cart->getWeight(), $this->config->get( 'config_weight_class' ) ) . ') (' . $this->language->get( 'text_eta' ) . ' ' . html_entity_decode( strip_tags( $services['SvcCommitments'], '<sup>' ) ) . ' )';
		                } elseif ( $this->config->get( 'usps_integration_display_time' ) && $this->config->get( 'usps_integration_display_weight' ) == '0' ) {
			                $titleweightIntl = $this->language->get( 'text_usps_title' ) . ' ' . html_entity_decode( strip_tags( $services['SvcDescription'], '<sup>' ) ) . ' (' . $this->language->get( 'text_eta' ) . ' ' . html_entity_decode( strip_tags( $services['SvcCommitments'], '<sup>' ) ) . ')';
		                }
		                if ( $qty == '' ) {
			                $cost = $rate + $fee;
		                } else {
			                $cost = ( $rate + $fee ) * $qty;
		                }

		                $quote_data[ $id ] = [
			                'id'           => 'usps_integration.' . $id,
			                'title'        => $titleweightIntl,
			                'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get('config_currency') ),
			                'tax_class_id' => $this->config->get( 'usps_integration_tax_class_id' ),
			                'text'         => $this->currency->format( $this->tax->calculate( $this->currency->convert( $cost,
                                $this->config->get( 'config_currency' ),
                                $this->currency->getCode() ),
                                $this->config->get( 'usps_integration_tax_class_id' ),
                                $this->config->get( 'config_tax' ) ),
                                $this->currency->getCode(),
                                1.0000000 )
		                ];
	                }
                } else {
	                if ( $services ) {
		                foreach ( $services as $service ) {
			                $id       = $service['ID'];
			                $type     = $this->config->get( 'usps_integration_type' );
			                $fee_rate = (float) $this->config->get( 'usps_integration_additional_fee' );
			                $rate     = $service['Postage'];
			                if ( $type == 'percent' && $fee_rate != '0' ) {
				                $fee = number_format( $rate * ( $fee_rate / 100 ), 2, '.', '' );
			                } elseif ( $type == 'fixed' && $fee_rate != '0' ) {
				                $fee = number_format( $fee_rate, 2, '.', '' );
			                }
			                if ( in_array( $id, $allowed ) && $this->config->get( 'usps_integration_international_' . $id ) ) {
				                if ( $this->config->get( 'usps_integration_display_time' ) && $this->config->get( 'usps_integration_display_weight' ) == '1' ) {
					                $titleweightIntl = $this->language->get( 'text_usps_title' ) . ' ' . html_entity_decode( strip_tags( $service['SvcDescription'], '<sup>' ) ) . '(' . $this->language->get( 'text_weight' ) . ' ' . $this->weight->format( $cart->getWeight(), $this->config->get( 'config_weight_class' ) ) . ') (' . $this->language->get( 'text_eta' ) . ' ' . html_entity_decode( strip_tags( $service['SvcCommitments'], '<sup>' ) ) . ' )';
				                } elseif ( $this->config->get( 'usps_integration_display_time' ) && $this->config->get( 'usps_integration_display_weight' ) == '0' ) {
					                $titleweightIntl = $this->language->get( 'text_usps_title' ) . ' ' . html_entity_decode( strip_tags( $service['SvcDescription'], '<sup>' ) ) . ' (' . $this->language->get( 'text_eta' ) . ' ' . html_entity_decode( strip_tags( $service['SvcCommitments'], '<sup>' ) ) . ')';
				                }
				                if ( $qty == '' ) {
					                $cost = $rate + $fee;
				                } else {
					                $cost = ( $rate + $fee ) * $qty;
				                }

				                $quote_data[ $id ] = [
					                'id'           => 'usps_integration.' . $id,
					                'title'        => $titleweightIntl,
					                'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ),$this->config->get('config_currency')),
					                'tax_class_id' => $this->config->get( 'usps_integration_tax_class_id' ),
					                'text'         => $this->currency->format( $this->tax->calculate( $this->currency->convert( $cost,
                                        $this->config->get( 'config_currency' ),
                                        $this->currency->getCode() ),
                                        $this->config->get( 'usps_integration_tax_class_id' ),
                                        $this->config->get( 'config_tax' ) ),
                                        $this->currency->getCode(),
                                        1.0000000 )
				                ];
			                }
		                }
	                } else {
		                $error = $package['Error']['Description'];
	                }
                }
            }
        }
        return ['quote_data'=>$quote_data, 'error_msg'=>$error];
    }

    private function status($address) {
        if ($this->config->get('usps_integration_status')) {
            $this->load->model('localisation/country');
            if (!$this->config->get('usps_integration_location_id')) {
                $status = TRUE;
            }else {
                $query = $this->db->query("SELECT *
											FROM " . $this->db->table('zones_to_locations') . "
											WHERE location_id = '" . (int)$this->config->get('usps_integration_location_id') . "'
												AND country_id = '" . (int)$address['country_id'] . "'
												AND (zone_id = '" . (int)$address['zone_id'] . "' OR zone_id = '0')");
                if ($query->num_rows) {
                    $status = TRUE;
                } else {
                    $status = FALSE;
                }
            }

            //load all countries and codes
            $countries = $this->model_localisation_country->getCountries();
            foreach ($countries as $item) {
                $country[$item['iso_code_2']] = $item['name'];
            }

            if($status && !has_value($country[$address['iso_code_2']])){
                $status = FALSE;
            }

        } else {
            $status = FALSE;
        }

        return $status;
    }

	/**
	 * @param array $product_ids
	 *
	 * @return float|int
	 */
    public function getIndividualWeight( $product_ids = []) {
        $weight = 0;
        $cart = $this->cart;

	    $this->extensions->hk_InitData($this, __FUNCTION__);
	    foreach ($cart->getProducts() as $product) {
            if (sizeof($product_ids) > 0 && !in_array((string)$product['product_id'], $product_ids) ) {
                continue;
            }

            if ($product['shipping']) {
                $product_weight = $product['weight'];
                // if product_option has weight value
                if($product['option']){
                    $hard = false;
                    foreach($product['option'] as $option){
                        if($option['weight'] == 0) continue; // if weight not set - skip
                        if($option['weight_type'] != '%'){
                            //If weight was set by option hard and other option sets another weight hard - ignore it
                            //skip negative weight. Negative allowed only for % based weight
                            if ($hard || $option['weight'] < 0) {
                                continue;
                            }

                            //$hard = true;
                            $product_weight = $cart->weight->convert($option['weight'], $option['weight_type'], $product['weight_class']);
                        }else{
                            //We need product base weight for % calculation
                            $temp = ($option['weight'] * $product['weight']/100) + $product['weight'];
                            $product_weight = $cart->weight->convert($temp, $option['weight_type'], $this->config->get('config_weight_class'));
                        }
                    }
                }
                $weight = $cart->weight->convert($product_weight, $product['weight_class'], $this->config->get('config_weight_class'));
            }
        }
        return $weight;
    }

    private function getCountryNameById($country_id) {
    	$sql = "SELECT `name` as country_name FROM ".$this->db->table('country_descriptions')." WHERE country_id=".(int)$country_id;
    	$query = $this->db->query($sql);
    	return $query->row['country_name'];
    }
}