<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

if(!class_exists('')){
    include_once('core/usps_integration_hook.php');
}

$controllers = [
    'storefront' => [],
    'admin' => [ 'pages/extension/usps_integration',
                     'pages/extension/usps_integration_updater',
		              'responses/extension/usps_test',
                      'responses/extension/usps_integration_save'
    ],
];

$models = [
    'storefront' => [ 'extension/usps_integration',
        'extension/usps_order',
        'extension/usps_verify',
        'extension/usps_integration_license_info'
        ],
    'admin' => [
        'extension/usps_integration_updater',
	    'extension/usps_order',
        'extension/usps_integration_license_info'
    ],
];

$languages = [
    'storefront' => [
	    'usps_integration/usps_integration'],
    'admin' => [
        'usps_integration/usps_integration']
];

$templates = [
    'storefront' => [
        'common/head.post.tpl',
        'embed/head.post.tpl'
    ],
    'admin' => [
        'pages/extension/usps_integration.tpl',
        'pages/extension/usps_integration_updater.tpl',
        'pages/extension/usps_integration_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/extensions_edit.post.tpl',
    ]
];