<?php

/*------------------------------------------------------------------------------
  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)
------------------------------------------------------------------------------*/

if ( ! defined( 'DIR_CORE' ) ) {
	header( 'Location: static_pages/' );
}

include_once DIR_EXT . 'usps_integration' . DIR_EXT_CORE . 'lib/autoload.php';

class ControllerResponsesExtensionUspsTest extends AController {

	private $cfg = [];

	public function test() {

		$this->loadLanguage( 'usps_integration/usps_integration' );

		$this->loadModel( 'setting/setting' );

		$this->cfg = $this->model_setting_setting->getSetting( 'usps_integration', (int) $this->session->data['current_store_id'] );

		$json = [];

		$required_fields = [
			'userid' => 'usps_integration_user_id',
			'postcode' => 'usps_integration_postcode'
		];
		$address = [];

		foreach ( $required_fields as $k => $fld ) {

			if ( ! $this->cfg[ $fld ] ) {
				$json['error'] = true;
				$json['message'] = 'Error: Please fill and save all required fields and try again.';
				break;
			}
			$address[ $k ] = $this->cfg[ $fld ];
		}

		if ( $json['error'] != true ) {
			$test_result = $this->_processRequest();
			if ( ! $test_result ) {
				$json['error'] = true;
				$json['message'] = 'usps Error: Wrong data was given. Please check your API Credentials and try again.';
			} else if ( $test_result['error'] ) {
				$json['error'] = true;
				$json['message'] = 'usps Error: ' . $test_result['error'] . "\n" . 'Please check your API Credentials and try again.';
			} else {
				$json['message'] = $this->language->get( 'text_connection_success' );
				$json['error'] = false;
			}
		}
		$this->load->library( 'json' );
		$this->response->setOutput( AJson::encode( $json ) );
	}


	private function _processRequest() {

		//usps Key

		$usps_key = $this->cfg['usps_integration_user_id'];

		//usps Password

		$usps_password = $this->cfg['usps_integration_password'];

		//usps origin postcode

		$usps_postcode = $this->cfg['usps_integration_postcode'];


		$this->load->model( 'localisation/country' );

		$country = $this->model_localisation_country->getCountry( $this->config->get( 'config_country_id' ) );

		$this->load->model( 'localisation/zone' );

		$f = new \RocketShipItUsps\Rate( 'usps' );

		$f->setParameter( 'userid', $usps_key );
		$f->setParameter( 'password', $usps_password );
		$f->setParameter( 'toCode', $usps_postcode );
		$f->setParameter( 'fromCode', $usps_postcode );
		$f->setParameter( 'shipCountry', $country['iso_code_2'] );
		$f->setparameter( 'length', '1' );
		$f->setparameter( 'width', '1' );
		$f->setparameter( 'height', '1' );
		$f->setparameter( 'weightPounds', '1' );
		$f->setparameter( 'weightOunces', '0' );
		$f->setParameter( 'machinable', 'true' );
		$f->setParameter( 'packagingType', 'VARIABLE' );
		$error_msg = '';

		$response = $f->getAllRates();
		if ( $response['Error'] != '' ) {
			$error_msg = $response['Error']['Description'];
		} elseif ( $response['RateV4Response']['Package']['Error'] != '' ) {
			$error_msg = $response['RateV4Response']['Package']['Error']['Description'];
		}
		return ['error' => $error_msg];
	}
}