<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ControllerPagesExtensionUspsIntegration
 * @property ModelExtensionUspsIntegrationLicenseInfo $model_extension_usps_integration_license_info
 */

class ControllerPagesExtensionUspsIntegration extends AController {
	private $error = [];
	private $errors = ['user_id', 'postcode'];
	public $data = [];
	private $fields = [
		'usps_integration_debug',
		'usps_integration_user_id',
		'usps_integration_password',
		'usps_integration_postcode',
		'usps_integration_domestic_0',
		'usps_integration_domestic_1',
		'usps_integration_domestic_2',
		'usps_integration_domestic_3',
		'usps_integration_domestic_4',
		'usps_integration_domestic_5',
		'usps_integration_domestic_6',
		'usps_integration_domestic_7',
		'usps_integration_domestic_12',
		'usps_integration_domestic_13',
		'usps_integration_domestic_16',
		'usps_integration_domestic_17',
		'usps_integration_domestic_18',
		'usps_integration_domestic_19',
		'usps_integration_domestic_22',
		'usps_integration_domestic_23',
		'usps_integration_domestic_25',
		'usps_integration_domestic_27',
		'usps_integration_domestic_28',
        'usps_integration_domestic_77',
        'usps_integration_local_zipcodes',
        'usps_integration_local_delivery_fee',
        'usps_integration_local_delivery_only',
        'usps_integration_local_delivery_message',
		'usps_integration_free_domestic_method',
		'usps_integration_international_1',
		'usps_integration_international_2',
		'usps_integration_international_4',
		'usps_integration_international_5',
		'usps_integration_international_6',
		'usps_integration_international_7',
		'usps_integration_international_8',
		'usps_integration_international_9',
		'usps_integration_international_10',
		'usps_integration_international_11',
		'usps_integration_international_12',
		'usps_integration_international_13',
		'usps_integration_international_14',
		'usps_integration_international_15',
		'usps_integration_international_16',
		'usps_integration_international_21',
		'usps_integration_free_international_method',
		'usps_integration_size',
		'usps_integration_container',
		'usps_integration_machinable',
		'usps_integration_length',
		'usps_integration_width',
		'usps_integration_height',
		'usps_integration_weight',
		'usps_integration_girth',
		'usps_integration_display_time',
		'usps_integration_display_weight',
		'usps_integration_weight_class',
		'usps_integration_length_class',
		'usps_integration_tax_class_id',
		'usps_integration_location_id',
		'usps_integration_type',
		'usps_integration_additional_fee',
		'usps_integration_additional_weight'
	];

	public function verify() {
		if ($this->config->get('usps_integration_status')==='1') {
            $this->load->model('extension/usps_integration_license_info');
            $license_key = $this->config->get('usps_integration_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('usps_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_usps_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_usps_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_usps_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'usps_integration');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_usps_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

	public function verifyEditor() {
		if ( $this->config->get( 'editor_status' ) === '1' ) {
            $this->load->model('extension/editor_license_info');
            $license_key = $this->config->get('editor_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('editor_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_editor_license_info->getStoreId();
                    $license_key = $this->model_extension_editor_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_editor_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'editor');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_editor_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
		} else {
			return false;
		}
	}

	public function main() {
		//init controller data
		$this->extensions->hk_InitData($this,__FUNCTION__);
		$this->request->get['extension'] = 'usps_integration';
		$this->loadLanguage('extension/extensions');
		$this->loadLanguage('usps_integration/usps_integration');
		$this->document->setTitle( $this->language->get('text_additional_settings') );
		$this->load->model('setting/setting');

		if ( $this->request->is_POST() && $this->_validate() ) {
			$this->model_setting_setting->editSetting('usps_integration', $this->request->post);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->loadModel('localisation/country');
			$country=$this->model_localisation_country->getCountry($this->config->get('config_country_id'));
			$content = '<?php'."\n";
			$content .= 'return array('."\n";
			$content .= '"generic" => array('."\n";
			$content .= '"debugMode" => 0,'."\n";
			$content .= '"timezone" => "'. date_default_timezone_get().'",'."\n";
			$content .= '"shipper" => "' . addslashes($this->config->get('store_name')).'",'."\n";
			$content .= '"shipContact" => "' . $this->config->get('config_owner').'",'."\n";
			$content .= '"shipAddr1" =>"' . $this->config->get('config_address').'",'."\n";
			$content .= '"shipCode" =>"' . $this->request->post['usps_integration_postcode'].'",'."\n";
			$content .= '"shipCountry" =>"' . $country['iso_code_2'].'",'."\n";
			$content .= '"shipPhone" =>"' . $this->config->get('config_telephone').'",'."\n";
			$content .= '"currency" =>"' . $this->config->get('config_currency').'",'."\n";
			$content .='),'."\n";
			$content .=');';
			$file = fopen(DIR_EXT.'usps_integration'.DIR_EXT_CORE.'lib/config.php', 'w');
			fwrite($file, $content);
			fclose($file);
			$this->redirect($this->html->getSecureURL('extension/usps_integration'));
		}

		if (isset($this->error['warning'])) {
			$this->data['error_warning'] = $this->error['warning'];
		} else {
			$this->data['error_warning'] = '';
		}
		if (isset($this->error['user_id'])) {
			$this->data['error']['user_id'] = $this->error['user_id'];
		}
		if (isset($this->error['postcode'])) {
			$this->data['error']['postcode'] = $this->error['postcode'];
		}
		if (isset($this->error['length'])) {
			$this->data['error']['length'] = $this->error['length'];
		}
		if (isset($this->error['width'])) {
			$this->data['error']['width'] = $this->error['width'];
		}
		if (isset($this->error['height'])) {
			$this->data['error']['height'] = $this->error['height'];
		}
		$this->data['success'] = $this->session->data['success'];
		if (isset($this->session->data['success'])) {
			unset($this->session->data['success']);
		}

		$this->document->initBreadcrumb( [
			'href'      => $this->html->getSecureURL('index/home'),
			'text'      => $this->language->get('text_home'),
			'separator' => FALSE
		]);
		$this->document->addBreadcrumb( [
			'href'      => $this->html->getSecureURL('extension/extensions/shipping'),
			'text'      => $this->language->get('text_shipping'),
			'separator' => ' :: '
		]);
		$this->document->addBreadcrumb( [
			'href'      => $this->html->getSecureURL('extension/usps_integration'),
			'text'      => $this->language->get('usps_integration_name'),
			'separator' => ' :: ',
			'current'   => true
		]);

		$this->view->assign('addition_note',$this->language->get('usps_integration_addition_note'));
		$this->view->assign('ext_text',$this->language->get('usps_integration_ext_man'));
		$this->view->assign('ext_man','https://why2central.net/v1/usps');

		$this->load->model('localisation/tax_class');
		$results = $this->model_localisation_tax_class->getTaxClasses();
		$tax_classes = [ 0 => $this->language->get ( 'text_none' )];
		foreach ( $results as $k => $v ) {
			$tax_classes[ $v['tax_class_id'] ] = $v['title'];
		}

		$this->load->model('localisation/location');
		$results = $this->model_localisation_location->getLocations();
		$locations = [ 0 => $this->language->get ( 'text_all_zones' )];
		foreach ( $results as $k => $v ) {
			$locations[ $v['location_id'] ] = $v['name'];
		}

		foreach ( $this->fields as $f ) {
			if (isset ( $this->request->post [$f] )) {
				$this->data [$f] = $this->request->post [$f];
			} else {
				$this->data [$f] = $this->config->get($f);
			}
		}

		$this->data ['action'] = $this->html->getSecureURL ( 'extension/usps_integration', '&extension=usps_integration' );
		$this->data['cancel'] = $this->html->getSecureURL('extension/shipping');
		$this->data ['heading_title'] = $this->language->get ( 'text_additional_settings' );
		$this->data ['form_title'] = $this->language->get ( 'usps_integration_name' );
		$this->data ['update'] = $this->html->getSecureURL ( 'r/extension/usps_integration_save/update' );

		$form = new AForm ( 'HS' );
		$form->setForm ( array ('form_name' => 'editFrm', 'update' => $this->data ['update'] ) );

		$this->data['form']['form_open'] = $form->getFieldHtml ( array (
			'type' => 'form',
			'name' => 'editFrm',
			'action' => $this->data ['action'],
			'attr' => 'data-confirm-exit="true" class="aform form-horizontal"'
		) );
		$this->data['form']['submit'] = $form->getFieldHtml ( array (
			'type' => 'button',
			'name' => 'submit',
			'text' => $this->language->get ( 'button_save' )
		) );
		$this->data['form']['cancel'] = $form->getFieldHtml ( array (
			'type' => 'button',
			'name' => 'cancel',
			'text' => $this->language->get ( 'button_cancel' )
		) );
		$this->data['form']['fields']['debug'] = $form->getFieldHtml([
			'type' => 'checkbox',
			'name' => 'usps_integration_debug',
			'value' => $this->data['usps_integration_debug'],
			'style'  => 'btn_switch',
		]);
		$this->data['form']['fields']['user_id'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_user_id',
			'value' => $this->data['usps_integration_user_id'],
			'required' => true,
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['password'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_password',
			'value' => $this->data['usps_integration_password'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['postcode'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_postcode',
			'value' => $this->data['usps_integration_postcode'],
			'required' => true,
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['test_connection'] = $form->getFieldHtml([
			'type' => 'button',
			'name' => 'test_connection',
			'title' => $this->language->get('entry_test_connect'),
			'text' => $this->language->get('entry_test_connect'),
			'required' => true,
			'style' => 'btn btn-info lock-on-click',
		]);
		$this->data['test']=$this->language->get(('entry_test'));
		$this->data['test_url']=$this->html->getSecureURL('r/extension/usps_test/test');
		$domestic = [0, 1, 2, 3, 4, 5, 6, 7, 12, 13, 16, 17, 18, 19, 22, 23, 25, 27, 28,77];

		$this->data['form']['fields']['domestic'] = [];
		$options = [];
		foreach ( $domestic as $i ) {
			$title = 'domestic_'.$i;
			$name = 'usps_integration_domestic_'.$i;
			$this->data['form']['fields']['domestic'][$title] = $form->getFieldHtml([
				'type' => 'checkbox',
				'name' => $name,
				'style' => 'btn_switch',
				'value' => $this->data[$name],
			]);
			$options['NONE']="NONE";
			$options[$title] = $this->language->get('text_' . $title);
		}

        $this->data['form']['fields']['local_zipcodes'] = $form->getFieldHtml([
            'type'    => 'textarea',
            'name'    => 'usps_integration_local_zipcodes',
            'value'   => $this->data['usps_integration_local_zipcodes'],
        ]);

        $this->data['form']['fields']['local_delivery_fee'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'usps_integration_local_delivery_fee',
            'value' => $this->data['usps_integration_local_delivery_fee'],
            'required' => true,
            'style' => 'small-field',
        ]);

        $this->data['form']['fields']['local_delivery_only'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'usps_integration_local_delivery_only',
            'value' => $this->data['usps_integration_local_delivery_only'],
            'style'  => 'btn_switch',
        ]);

        $this->data['form']['fields']['local_delivery_message'] = $form->getFieldHtml([
            'type' => 'texteditor',
            'name' => 'usps_integration_local_delivery_message',
            'value' => $this->config->get('usps_integration_local_delivery_message'),
            'style' => 'xl-field',
        ]);

		$this->data['form']['fields']['free_domestic_method'] = $form->getFieldHtml([
			'type'    => 'selectbox',
			'name'    => 'usps_integration_free_domestic_method',
			'options' => $options,
			'value'   => $this->data['usps_integration_free_domestic_method'],
			'style' => 'small-field',
		]);

		$international = [1, 2, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 21];
		$this->data['form']['fields']['international'] = [];
		$options = [];
		foreach ( $international as $i ) {
			$title = 'international_'.$i;
			$name = 'usps_integration_international_'.$i;
			$this->data['form']['fields']['international'][$title] = $form->getFieldHtml([
				'type' => 'checkbox',
				'name' => $name,
				'style' => 'btn_switch',
				'value' => $this->data[$name],
			]);
			$options['NONE']="NONE";
			$options[$title] = $this->language->get('text_' . $title);
		}

		$this->data['form']['fields']['free_international_method'] = $form->getFieldHtml([
			'type'    => 'selectbox',
			'name'    => 'usps_integration_free_international_method',
			'options' => $options,
			'value'   => $this->data['usps_integration_free_international_method'],
			'style' => 'small-field',
		]);

		$this->data['form']['fields']['machinable'] = $form->getFieldHtml([
			'type' => 'selectbox',
			'name' => 'usps_integration_machinable',
			'options' => [
				1 => $this->language->get ( 'text_yes' ),
				0 => $this->language->get ( 'text_no' ),
			],
			'value' => $this->data['usps_integration_machinable'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['length'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_length',
			'value' => $this->data['usps_integration_length'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['width'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_width',
			'value' => $this->data['usps_integration_width'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['height'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_height',
			'value' => $this->data['usps_integration_height'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['weight'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_weight',
			'value' => $this->data['usps_integration_weight'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['display_time'] = $form->getFieldHtml([
			'value' => $this->data['usps_integration_display_time'],
			'type' => 'selectbox',
			'name' => 'usps_integration_display_time',
			'options' => [
				1 => $this->language->get ( 'text_yes' ),
				0 => $this->language->get ( 'text_no' ),
			],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['display_weight'] = $form->getFieldHtml([
			'type' => 'selectbox',
			'name' => 'usps_integration_display_weight',
			'value' => $this->data['usps_integration_display_weight'],
			'options' => [
				1 => $this->language->get ( 'text_yes' ),
				0 => $this->language->get ( 'text_no' ),
			],
			'style' => 'small-field',
		]);

		$this->load->model('localisation/length_class');
		$results = $this->model_localisation_length_class->getLengthClasses();
		$length_classes = [];
		foreach ( $results as $k => $v ) {
			$length_classes[ $v['unit'] ] = $v['title'];
		}

		$this->data['form']['fields']['tax'] = $form->getFieldHtml([
			'type' => 'selectbox',
			'name' => 'usps_integration_tax_class_id',
			'options' => $tax_classes,
			'value' => $this->data['usps_integration_tax_class_id'],
		]);
		$this->data['form']['fields']['location'] = $form->getFieldHtml([
			'type' => 'selectbox',
			'name' => 'usps_integration_location_id',
			'options' => $locations,
			'value' => $this->data['usps_integration_location_id'],
		]);
		$optType=[];
		$opt=['fixed','percent'];
		foreach ($opt as $ot)
		{
			$title=$ot;
			$optType[$title]=$this->language->get('text_' . $ot);
		}
		$this->data['form']['fields']['type'] = $form->getFieldHtml([
			'type'    => 'selectbox',
			'name'    => 'usps_integration_type',
			'options' => $optType,
			'value'   => $this->data['usps_integration_type'],
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['additional_fee'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_additional_fee',
			'value' => moneyDisplayFormat($this->config->get('usps_integration_additional_fee')),
			'style' => 'small-field',
		]);
		$this->data['form']['fields']['additional_weight'] = $form->getFieldHtml([
			'type' => 'input',
			'name' => 'usps_integration_additional_weight',
			'value' => preformatFloat($this->config->get('usps_integration_additional_weight'),$this->language->get('decimal_point')),
			'style' => 'small-field',
		]);

		//load tabs controller
		$this->data['editorLicense'] = $this->verifyEditor();
		$this->data['editor'] = $this->config->get('editor_status');
		$this->data['license_status'] = $this->verify();
		$this->data['text_unauthorized'] = $this->language->get( 'text_usps_integration_unauthorized' );

		$this->data['groups'][] = 'additional_settings';
		$this->data['link_additional_settings'] = '';
		$this->data['active_group'] = 'additional_settings';

		$tabs_obj = $this->dispatch('pages/extension/extension_tabs', [$this->data] );
		$this->data['tabs'] = $tabs_obj->dispatchGetOutput();
		unset($tabs_obj);

		$obj = $this->dispatch('pages/extension/extension_summary', [$this->data] );
		$this->data['extension_summary'] = $obj->dispatchGetOutput();
		unset($obj);

		$this->view->batchAssign( $this->data );
		$this->processTemplate('pages/extension/usps_integration.tpl' );


		//update controller data
		$this->extensions->hk_UpdateData($this,__FUNCTION__);
	}

	private function _validate() {
		if (!$this->user->canModify('extension/usps_integration')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->request->post['usps_integration_user_id']) {
			$this->error['user_id'] = $this->language->get('error_user_id');
		}

		if (!$this->request->post['usps_integration_postcode']) {
			$this->error['postcode'] = $this->language->get('error_postcode');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

}
