<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";

/**
 * Class ModelExtensionUpsVerify
 * @property ModelExtensionUpsIntegrationLicenseInfo $model_extension_ups_integration_license_info
 */

class ModelExtensionUpsVerify extends Model {

    public function verify() {
        $this->load->model('extension/ups_integration_license_info');
        $license_key = $this->config->get('ups_integration_license_code');
        if ($license_key) {
            $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ups_integration_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $this->model_extension_ups_integration_license_info->getStoreId();
                $license_key = $this->model_extension_ups_integration_license_info->getLicenseCode($store_id);
                $license_info = $this->model_extension_ups_integration_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], 'ups_integration');
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $this->model_extension_ups_integration_license_info->getLicensedStoreStatus();
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                }
            }
        }
    }

    public function verifyTaxID() {
        if ($this->config->get('taxid_option_status')==='1') {
            $this->load->model('extension/taxid_option_license_info');
            $license_key = $this->config->get('taxid_option_license_code');
            $shared_secret = 'taxid_option';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('taxid_option_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_taxid_option_license_info->getStoreId();
                    $license_key = $this->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_taxid_option_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            }
        } else {
            return false;
        }
    }

    public function verifyAdvancedReportsStatus() {
        if ( $this->config->get( 'advanced_reports_status' ) === '1' ) {
            $this->load->model('extension/advanced_reports_license_info');
            $license_key = $this->config->get('advanced_reports_license_code');
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('advanced_reports_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_advanced_reports_license_info->getStoreId();
                    $license_key = $this->model_extension_advanced_reports_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_advanced_reports_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], 'advanced_reports');
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_advanced_reports_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyPricingCalc() {
        if ($this->config->get('pricing_calculator_status')==='1') {
            $this->load->model('extension/pricing_calculator_license_info');
            $license_key = $this->config->get('pricing_calculator_license_code');
            $shared_secret = 'pricing_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('pricing_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_pricing_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_pricing_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_pricing_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_pricing_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLink() {
        if ($this->config->get('option_price_link_pro_status')==='1') {
            $this->load->model('extension/option_price_link_pro_license_info');
            $license_key = $this->config->get('option_price_link_pro_license_code');
            $shared_secret = 'option_price_link_pro';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_link_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_link_pro_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_link_pro_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_link_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_link_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionPro() {
        if ($this->config->get('option_price_pro_status')==='1') {
            $this->load->model('extension/option_price_pro_license_info');
            $license_key = $this->config->get('option_price_pro_license_code');
            $shared_secret = 'option_price_pro';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_pro_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_pro_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_pro_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_pro_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_pro_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyOptionLite() {
        if ($this->config->get('option_price_status')==='1') {
            $this->load->model('extension/option_price_license_info');
            $license_key = $this->config->get('option_price_license_code');
            $shared_secret = 'option_price';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('option_price_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_option_price_license_info->getStoreId();
                    $license_key = $this->model_extension_option_price_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_option_price_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_option_price_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyUpsPlus() {
        if ($this->config->get('ups_integration_plus_status')==='1') {
            $this->load->model('extension/ups_integration_license_info');
            $license_key = $this->config->get('ups_integration_license_code');
            $shared_secret = 'ups_integration';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('ups_integration_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_ups_integration_license_info->getStoreId();
                    $license_key = $this->model_extension_ups_integration_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_ups_integration_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_ups_integration_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyAreaCalc() {
        if ($this->config->get('area_calculator_status')==='1') {
            $this->load->model('extension/area_calculator_license_info');
            $license_key = $this->config->get('area_calculator_license_code');
            $shared_secret = 'area_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('area_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_area_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_area_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_area_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_area_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLengthCalc() {
        if ($this->config->get('length_calculator_status')==='1') {
            $this->load->model('extension/length_calculator_license_info');
            $license_key = $this->config->get('length_calculator_license_code');
            $shared_secret = 'length_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('length_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_length_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_length_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_length_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_length_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyVolumeCalc() {
        if ($this->config->get('volume_calculator_status')==='1') {
            $this->load->model('extension/volume_calculator_license_info');
            $license_key = $this->config->get('volume_calculator_license_code');
            $shared_secret = 'volume_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('volume_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_volume_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_volume_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_volume_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_volume_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyWeightCalc() {
        if ($this->config->get('weight_calculator_status')==='1') {
            $this->load->model('extension/weight_calculator_license_info');
            $license_key = $this->config->get('weight_calculator_license_code');
            $shared_secret = 'weight_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('weight_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_weight_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_weight_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_weight_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_weight_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyLiquidsCalc() {
        if ($this->config->get('liquids_calculator_status')==='1') {
            $this->load->model('extension/liquids_calculator_license_info');
            $license_key = $this->config->get('liquids_calculator_license_code');
            $shared_secret = 'liquids_calculator';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('liquids_calculator_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_liquids_calculator_license_info->getStoreId();
                    $license_key = $this->model_extension_liquids_calculator_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_liquids_calculator_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_liquids_calculator_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function verifyBuildAGift() {
        if ($this->config->get('build_a_gift_status')==='1') {
            $this->load->model('extension/build_a_gift_license_info');
            $license_key = $this->config->get('build_a_gift_license_code');
            $shared_secret = 'build_a_gift';
            if ($license_key) {
                $exist = $this->db->query("SHOW TABLES LIKE '" . $this->db->table('build_a_gift_license_info') . "'");
                if ($exist->num_rows === 1) {
                    $store_id = $this->model_extension_build_a_gift_license_info->getStoreId();
                    $license_key = $this->model_extension_build_a_gift_license_info->getLicenseCode($store_id);
                    $license_info = $this->model_extension_build_a_gift_license_info->getLicenseData($store_id);
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    $license_manager->setKeys($license_key, $license_info['public_key'], $shared_secret);
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_info['license_data'], $ttl);
                    $store_status = $this->model_extension_build_a_gift_license_info->getLicensedStoreStatus();
                    if ($validate['status'] === 'valid' && $store_status == 1) {
                        return true;
                    } else {
                        return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }
}