<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

class ControllerResponsesExtensionUpsIntegrationSave extends AController {
	private $required_fields = [
			'ups_integration_key',
			'ups_integration_username',
			'ups_integration_password',
            'ups_integration_country',
		];
    public function main(){}
    public function update() {

        $this->loadLanguage('extension/extensions');

        if (!$this->user->canModify('extension/extensions')) {
            $this->response->setOutput( sprintf($this->language->get('error_permission_modify'), 'extension/extensions') );
            return null;
        }
        foreach($this->required_fields as $fld){
            if( isset( $this->request->post[$fld] ) && trim($this->request->post[$fld])==''){
                $this->response->setOutput( sprintf($this->language->get('error_required_field'), 'extension/extensions') );
                return null;
            }
        }

        $store_id = isset($this->request->post['store_id']) ? (int)$this->request->post['store_id'] : $this->request->get['store_id'];
        $store_id = is_null($store_id) ? $this->config->get('config_store_id') : $store_id;
        $this->request->post['store_id'] = $store_id;


        if(isset($this->request->post['ups_integration_weight_code']) && !in_array($this->request->post['ups_integration_weight_code'], ['lb','kgs'])){
            $this->response->setOutput( 'Error: kgs or lb only!' );
            return null;
        }
        $this->extension_manager->editSetting('ups_integration', $this->request->post);

    }
}
