<?php
/* Hooks */
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionTrackShipments extends Extension
{
    public $data = array();

    public function __construct()
    {
        $this->registry  = Registry::getInstance();
    }

    public function onControllerPagesAccountInvoice_InitData()
    {
        $this->baseObject->loadLanguage('track_shipments/track_shipments');
        $this->baseObject->loadModel('track_shipments/track_shipments');
        $data['ordertrack'] = $this->baseObject->model_track_shipments_track_shipments->getTrack($this->baseObject->request->get['order_id']);
        //$data['language_id'] = $this->baseObject->config->get('storefront_language_id');
        //$data['tab_weight'] = $this->baseObject->language->get('track_shipments_name');
        $data['tracking_number'] = $this->baseObject->language->get('tracking_number');
        $data['track_shipments_uni_url'] = $this->baseObject->config->get('track_shipments_uni_url');
        $data['shipping_company'] = $this->baseObject->language->get('shipping_company');
        $data['url_shipping_company'] = $this->baseObject->language->get('url_shipping_company');
        $data['tracking_text'] = $this->baseObject->language->get('tracking_text');
        $data['tracking_head_text'] = $this->baseObject->language->get('tracking_head_text');

        /* */
        //$data['close_button'] = $this->baseObject->config->get('close_button');

        /* */
        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('order_attributes', $view->fetch('pages/track_shipments/track_shipments_invoice.tpl'));
    }




    public function onControllerPagesSaleOrder_InitData()
    {
        $this->baseObject->loadLanguage('track_shipments/track_shipments');
        $this->baseObject->loadModel('extension/track_shipments');
        $data['ordertrack'] = $this->baseObject->model_extension_track_shipments->getTrack($this->baseObject->request->get['order_id']);


        $data['trsave_action'] = $this->baseObject->html->getSecureURL(
            'r/extension/track_shipments/tracksave',
            $params
        );
        //$data['language_id'] = $this->baseObject->config->get('storefront_language_id');
        $data['tracking_number'] = $this->baseObject->language->get('tracking_number');
        $data['track_shipments_uni_url'] = $this->baseObject->config->get('track_shipments_uni_url');
        $data['shipping_company'] = $this->baseObject->language->get('shipping_company');
        $data['url_shipping_company'] = $this->baseObject->language->get('url_shipping_company');
        $data['tracking_text'] = $this->baseObject->language->get('tracking_text');
        $data['tracking_save_text'] = $this->baseObject->language->get('tracking_save_text');
        $data['tracking_head_text'] = $this->baseObject->language->get('tracking_head_text');


        /* */
        $view = new AView($this->registry, 0);
        $view->batchAssign($data);
        $this->baseObject->view->addHookVar('order_details', $view->fetch('pages/extension/track_data.tpl'));
    }
}
