<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

if(!class_exists('ExtensionTaxidOption')){
    include_once('core/taxid_option.php');
}

$controllers = [
    'storefront' => [],
    'admin' => [
        'pages/extension/taxid_option_updater',
        'responses/listing_grid/taxid']
];

$models = [
    'storefront' => [
        'account/taxid_option',
        'account/taxid_order',
	    'extension/taxid_option_verify',
	    'extension/taxid_option_license_info'
	    ],
    'admin' => [
        'extension/taxid_option_updater',
    	'sale/taxid_option',
	    'extension/taxid_option_verify',
	    'extension/taxid_option_license_info'
	    ]
];

$templates = [
    'storefront' => [
        'embed/account/address.tpl',
        'pages/account/fc_guest_fields.tpl',
        'pages/account/fc_payment_fields.tpl',
        'pages/account/fields_create.tpl',
        'pages/account/fields_edit.tpl',
        'pages/account/seller_info.tpl',
        'pages/checkout/confirm_additional_info.tpl',
        'pages/checkout/confirm_fax.tpl',
        'pages/checkout/confirm_taxid.tpl',
        'pages/checkout/fields_create.tpl',
        'pages/checkout/fields_edit.tpl',
        'responses/checkout/main.post.tpl',
        ],
    'admin' => [
        'pages/sale/seller_info.tpl',
        'pages/sale/order_details_taxid_info.tpl',
        'pages/extension/taxid_option_manual.tpl',
        'pages/extension/taxid_option_updater.tpl',
        'pages/extension/extension_summary_button.tpl',
	'pages/extension/extensions_edit.post.tpl',
	]
];

$languages = [
    'storefront' => ['account/taxid_option'],
    'admin' => ['taxid_option/taxid_option']
];