<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

require_once DIR_SYSTEM . "lib/vendor/autoload.php";
require_once DIR_SYSTEM . "lib/license.php";
require_once DIR_EXT. "taxid_option" . DIR_EXT_CORE ."updater.php";

/**
 * Class ExtensionTaxidOption
 * @property AController baseObject
 * @property  ModelSaleTaxidOption $model_sale_taxid_option
 * @property  ModelAccountTaxidOption $model_account_taxid_option
 * @property  ModelAccountTaxidOrder $model_account_taxid_order
 */

class ExtensionTaxidOption extends Extension {
    public $data = [];
    public $errors = [];
    private $error=[];
    protected $registry;
    private $mc_server_url = "https://abantecartplus.com/clientarea/plugin/license_manager/validate/";
    private $diy_server_url = "https://wehearyou2.com/clientarea/plugin/license_manager/validate/";
    private $shared_secret = "taxid_option";
    private $fields = [
        'loginname',
        'firstname',
        'lastname',
        'email',
        'newsletter',
        'customer_group_id',
        'status',
        'approved',
        'password'];

    private $address_fields = [
        'firstname' => [
            'type' => 'input',
            'required' => true
        ],
        'lastname' => [
            'type' => 'input',
            'required' => true
        ],
        'company' => [
            'type' => 'input',
            'required' => false
        ],
        'taxid' => [
            'type' => 'input',
            'required' => false
        ],
        'address_1' => [
            'type' => 'input',
            'required' => true
        ],
        'address_2' => [
            'type' => 'input',
            'required' => false
        ],
        'city' => [
            'type' => 'input',
            'required' => true
        ],
        'postcode' => [
            'type' => 'input',
            'required' => false
        ],
        //note! this field is pair of country_id and zone_id
        'country_id' => [
            'type' => 'zones',
            'required' => true]
    ];

    public function __construct() {
        $this->registry = Registry::getInstance();
    }

    private function _is_enabled() {
       return $this->baseObject->config->get('taxid_option_status') && $this->verify();
    }

    public function verify() {
        $that =& $this->baseObject;
        $that->load->model('extension/taxid_option_license_info');
        $license_key = $that->config->get('taxid_option_license_code');
        if ($license_key) {
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);
                $store_status = $that->model_extension_taxid_option_license_info->getLicensedStoreStatus();
                if ($validate['status']==='expired') {
                    $that->load->model('extension/taxid_option_license_info');
                    $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }

                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/taxid_option_license_info');
                    $current_version = $that->model_extension_taxid_option_license_info->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/taxid_option_license_info');
                            $that->model_extension_taxid_option_license_info->saveLicenseData($data);
                        } elseif ($validate['status'] === 'valid' && $store_status == 1) {
                            return true;
                        } else {
                            return false;
                        }
                    }
                } else {
                if ($validate['status'] === 'valid' && $store_status == 1) {
                    return true;
                } else {
                    return false;
                    }
                }
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public function onControllerPagesIndexLogin_InitData() {
        $that =& $this->baseObject;
        if ($that->request->is_POST()) {
            $logged_in = $that->session->data['LAST_ACTIVITY'];
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                if (isset($logged_in)) {
                    $that->load->model('extension/taxid_option_license_info');
                    $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                    $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                    $last_check = $license_info['last_check'];
                    $daily_check = 86400;
                    if (time() > $daily_check + $last_check) {
                        $public_key = "";
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        if (stripos($license_key,'mc-')!==false) {
                            $server_url = $this->mc_server_url;
                        } else {
                            $server_url = $this->diy_server_url;
                        }

                        $license_manager->setLicenseServerUrl($server_url);
                        $license_manager->setKeys($license_key, "", $this->shared_secret);
                        $public_key = $license_manager->requestKey();
                        $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                        $that->load->model('extension/taxid_option_updater');
                        $current_version = $that->model_extension_taxid_option_updater->getCurrentVersion();
                        $custom_data = ['version' => $current_version];
                        $license_data = $license_manager->requestData($custom_data);
                        if (!is_null($license_data)) {
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $ttl = 1209600;
                            $validate = $license_manager->validate($license_data, $ttl);
                            if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                                $data['public_key'] = $public_key;
                                $data['license_data'] = $license_data;
                                $data['store_id'] = $store_id;
                                $data['last_check'] = time();
                                $that->load->model('extension/taxid_option_license_info');
                                $that->model_extension_taxid_option_license_info->saveLicenseData($data);
                            }
                        }
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_InitData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'edit') {
            $extension = $that->request->get['extension'];
            if ($extension === 'taxid_option') {
                if ($that->request->is_POST()) {
                    $public_key = "";
                    $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                    $license_key = trim($that->request->post['taxid_option_license_code']);
                    $license = new License($path_to_phpseclib);
                    $license_manager = $license->getManager();
                    if (stripos($license_key,'mc-')!==false) {
                        $server_url = $this->mc_server_url;
                    } else {
                        $server_url = $this->diy_server_url;
                    }
                    $license_manager->setLicenseServerUrl($server_url);
                    $license_manager->setKeys($license_key, "", $this->shared_secret);
                    $public_key = $license_manager->requestKey();
                    $that->load->model('extension/taxid_option_license_info');

                    $store_id = (int)$that->config->get('config_store_id');
                    if (has_value($that->request->get_or_post('store_id'))) {
                        $store_id = (int)$that->request->get_or_post('store_id');
                    } else {
                        if ($that->session->data['current_store_id']) {
                            $store_id = (int)$that->session->data['current_store_id'];
                        }
                    }

                    $installed_store_id = $that->model_extension_taxid_option_license_info->getInstalledLicense($license_key);

                    if ($installed_store_id !== '' && !is_null($installed_store_id)) {
                        $that->model_extension_taxid_option_license_info->deleteLicenseInfo($installed_store_id);
                    }
                    $existing_license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                    $data['multi'] = false;
                    $split_existing_license_key = explode('-', $existing_license_key);
                    $split_license_key = explode('-', $license_key);
                    if ($existing_license_key && $split_existing_license_key[0] !== $split_license_key[0]) {
                        $data['multi'] = true;
                    }

                    $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                    $that->load->model('extension/taxid_option_updater');
                    $current_version = $that->model_extension_taxid_option_updater->getCurrentVersion();
                    $custom_data = ['version' => $current_version];
                    $license_data = $license_manager->requestData($custom_data);
                    if (!is_null($license_data)) {
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_data, $ttl);

                        $that->load->model('setting/setting');
                        $that->load->model('extension/taxid_option_license_info');
                        $data['taxid_option_licensed_store_id_' . $store_id] = 1;

                        $that->model_setting_setting->editSetting('taxid_option', $data);
                        if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                            if (file_exists(DIR_EXT . 'taxid_option/core/helpers.php')) {
                                unlink(DIR_EXT . 'taxid_option/core/helpers.php');
                            }
                            $data['public_key'] = $public_key;
                            $data['license_data'] = $license_data;
                            $data['license_key'] = $license_key;
                            $data['store_id'] = $store_id;
                            $data['last_check'] = time();
                            $that->load->model('extension/taxid_option_license_info');
                            $that->model_extension_taxid_option_license_info->saveLicenseData($data);
                        }
                    } else {
                        $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                    }
                }
            }
        }
    }

    public function onControllerPagesExtensionExtensions_UpdateData() {
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'edit' ) {
            $extension = $that->request->get['extension'];
            $that->load->language('taxid_option/taxid_option');
            if ( $extension === 'taxid_option' ) {
                $latestVersion = $this->getVersion();
                $that->loadLanguage('extension/extensions');
                if (!is_null($latestVersion) && $latestVersion!=='') {
                    $info = sprintf(
                        $that->language->get('text_update_taxid_option_available'),
                        $latestVersion,
                        $that->html->getSecureURL('extension/taxid_option_updater','&version='.str_replace('.', '-', $latestVersion))
                    );
                    $that->view->assign('info',$info);
                } else {
                    $that->view->assign('info','');
                }
                $view = new AView($this->registry, 0);
                $data['manual_url'] = 'https://why2central.net/v1/tax-id';
                $data['manual_title'] = $that->language->get('taxid_option_name').' Manual';
                $view->batchAssign($data);
                $that->view->addHookVar('extension_toolbar_buttons', $view->fetch('pages/extension/taxid_option_manual.tpl'));
                $that->load->model('extension/taxid_option_license_info');
                $license_key = $that->config->get('taxid_option_license_code');
                if ($license_key) {
                    $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
                    if ($exist->num_rows === 1) {
                        $store_id = $that->model_extension_taxid_option_license_info->getStoreId();
                        $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                        $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                        $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                        $license = new License($path_to_phpseclib);
                        $license_manager = $license->getManager();
                        $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                        $ttl = 1209600;
                        $validate = $license_manager->validate($license_info['license_data'], $ttl);
                        $message = '';
                        if ($validate['status']==='expired') {
                            $message = $that->language->get('taxid_option_license_expired');
                        }
                        $that->view->assign('message',$message);
                    }
                }
                $that->processTemplate();
            }
        }
    }

    public function onControllerResponsesListingGridExtension_InitData() {
        if ($this->baseObject_method != 'update') {
            return false;
        }
        $that =& $this->baseObject;
        if ($that->request->get['id'] != 'taxid_option') {
            return false;
        }
        if (isset($that->request->post['taxid_option_license_code'])) {
            $that->request->post['taxid_option_license_code'] = trim($that->request->post['taxid_option_license_code']);
        }
    }

    public function onControllerResponsesListingGridExtension_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $store_id = (int)$that->config->get('current_store_id');
            if ($that->request->get_or_post('store_id')) {
                $store_id = $that->request->get_or_post('store_id');
            }
            $that->load->language('taxid_option/taxid_option');
            $response = json_decode(json_encode($that->data['response']), true);
            $extension_rows = $response['rows'];
            $ext_name = $that->language->get('taxid_option_name');
            foreach ($extension_rows as $k => $extensions) {
                if ($extensions['id'] === 'taxid_option_' . $store_id) {
                    $cells = $extensions['cell'];
                    foreach ($cells as $key => $cell) {
                        if ($cell===$ext_name || strpos($cell,'<p class="alert-info">'.$ext_name)!==false) {
                            $latestVersion = $this->getVersion();
                            if (!is_null($latestVersion) && $latestVersion!=='') {
                                $update_now_url = $that->html->getSecureURL('extension/taxid_option_updater','&version='.str_replace('.', '-', $latestVersion));
                                $cells[$key] = '<p class="alert-info">'
                                    .$ext_name.' (WHY2)'
                                    .'<br>'
                                    .sprintf(
                                        $that->language->get('text_update_taxid_option_available'),
                                        $latestVersion,
                                        $update_now_url
                                    )
                                    .'</p>';
                                $that->data['response']->rows[$k]['cell'][$key] = $cells[$key];
                            } else {
                                $that->data['response']->rows[$k]['cell'][$key] = $ext_name;
                            }
                        }
                    }
                }
            }
        } elseif ($this->baseObject_method==='update') {
            if ($that->request->post['taxid_option_license_code']) {
                $public_key = "";
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";

                $license_key = trim($that->request->post['taxid_option_license_code']);
                if (stripos($license_key,'mc-')!==false) {
                    $server_url = $this->mc_server_url;
                } else {
                    $server_url = $this->diy_server_url;
                }
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setLicenseServerUrl($server_url);
                $license_manager->setKeys($license_key, "", $this->shared_secret);
                $public_key = $license_manager->requestKey();

                $store_id = (int) $that->config->get('config_store_id');
                if ($that->request->get_or_post('store_id')) {
                    $store_id = $that->request->get_or_post('store_id');
                }

                $that->load->model('extension/taxid_option_license_info');

                $installed_store_id = $that->model_extension_taxid_option_license_info->getInstalledLicense($license_key);

                if ($installed_store_id!=='' && !is_null($installed_store_id)) {
                    $that->model_extension_taxid_option_license_info->deleteLicenseInfo($installed_store_id);
                }

                $license_manager->setKeys($license_key, $public_key, $this->shared_secret);
                $that->load->model('extension/taxid_option_updater');
                $current_version = $that->model_extension_taxid_option_updater->getCurrentVersion();
                $custom_data = ['version' => $current_version];
                $license_data = $license_manager->requestData($custom_data);
                if (!is_null($license_data)) {
                    $ttl = 1209600;
                    $validate = $license_manager->validate($license_data, $ttl);

                    $that->load->model('setting/setting');
                    $that->load->model('extension/taxid_option_license_info');

                    if ($validate['status'] !== 'unknown' && $validate['status'] !== 'invalid_location') {
                        $data['public_key'] = $public_key;
                        $data['license_data'] = $license_data;
                        $data['license_key'] = $license_key;
                        $data['store_id'] = $store_id;
                        $data['last_check'] = time();
                        $that->load->model('extension/taxid_option_license_info');
                        $that->model_extension_taxid_option_license_info->saveLicenseData($data);
                    }
                } else {
                    $that->session->data['error'] = "We are unable to install the license key. Please make sure you are using the correct license key!";
                }
            }
        }
    }
    
    public function onControllerPagesExtensionExtensionSummary_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $extension = $that->request->get['extension'];
            if ($extension==='taxid_option') {
                $that->load->language('taxid_option/taxid_option');
                $extension_info = $that->extensions->getExtensionInfo($extension);
                $support_expiration_int =  strtotime($extension_info['support_expiration']);
                if ($extension_info['support_expiration'] && $support_expiration_int !== 0) {
                    if ($support_expiration_int < time()) {
                        if ($that->data['text_support_expiration']) {
                            $that->view->assign('text_support_expired', $that->language->get('text_support_by_why2'));
                        } else {
                            $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                        }
                    }
                } else {
                    $data['text_support_expired'] = $that->language->get('text_support_by_why2');
                }
                $that->view->assign('get_support_button', '');
                $data['get_diy_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'diy_support',
                        'target' => "_new",
                        'href'   => 'https://wehearyou2.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_diy_support_by_why2'),
                    ]
                );
                $data['get_mc_support_button'] = $that->html->buildElement(
                    [
                        'type'   => 'button',
                        'name'   => 'btn_get_diy_support',
                        'id'     => 'mc_support',
                        'target' => "_new",
                        'href'   => 'https://abantecartplus.com/clientarea/client/login/',
                        'text'   => $that->language->get('button_mc_support_by_why2'),
                    ]
                );
                $view = new AView(Registry::getInstance(), 0);
                $view->batchAssign($data);
                $that->view->addHookVar('extension_summary_item', $view->fetch('pages/extension/extension_summary_buttons.tpl'));
                $that->view->batchAssign($this->data);
                $that->processTemplate();
            }
        }
    }

    public function onControllerPagesSaleCustomer_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;
        $that->loadLanguage('taxid_option/taxid_option');
        $that->loadModel('sale/taxid_option');
        $that->loadModel( 'extension/taxid_option_verify' );
        $mc_status      = $that->model_extension_taxid_option_verify->verifyMailchimp();
        $mc_plus_status = $that->model_extension_taxid_option_verify->verifyMailchimpPlus();
        $ctct_status    = $that->model_extension_taxid_option_verify->verifyCtct();

        if ( $this->baseObject_method === 'insert' ) {
            if ( $that->request->is_POST() ) {
                $that->load->language( 'taxid_option/taxid_option' );
                $errors = $this->_validateForm( $that->request->post );
                if ( ! empty( $errors['warning'] ) ) {
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect( $that->html->getSecureURL( 'sale/customer/insert' ) );
                } else {
                    if ( $ctct_status === true ) {
                        $that->load->model( 'extension/constantcontact_integration' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $firstname = $that->request->post['firstname'];
                            $lastname  = $that->request->post['lastname'];
                            $email     = $that->request->post['email'];
                            $exist     = $that->model_extension_constantcontact_integration->getContact( $email );
                            if ( empty( $exist ) ) {
                                $that->model_extension_constantcontact_integration->Subscribe( $email, $firstname, $lastname, 0 );
                            }
                        }
                    } elseif ( $mc_status === true ) {
                        $that->load->model( 'extension/integration_mailchimp' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $that->model_extension_integration_mailchimp->Subscribe( $that->request->post );
                        }
                    } elseif ( $mc_plus_status === true ) {
                        $that->load->model( 'extension/integration_mailchimp_plus' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $that->model_extension_integration_mailchimp_plus->Subscribe( $that->request->post );
                        }
                    }
                    $customer_id = $that->model_sale_customer->addCustomer( $that->request->post );
                    $that->model_sale_taxid_option->addCustomerAdditionalValues( $customer_id, $that->request->post );
                    $redirect_url                   = $that->html->getSecureURL( 'sale/customer/insert_address', '&customer_id=' . $customer_id );
                    $that->session->data['success'] = $that->language->get( 'text_success' );
                    redirect( $redirect_url );
                }
            }
        } elseif ( $this->baseObject_method === 'update' ) {
            if ( $that->request->is_POST() ) {
                $that->load->language( 'taxid_option/taxid_option' );
                $customer_id = $that->request->get['customer_id'];
                $errors      = $this->_validateForm( $that->request->post, $customer_id );
                if ( ! empty( $errors['warning'] ) ) {
                    $that->loadModel( 'sale/taxid_option' );
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    $fields                              = [ 'telephone', 'fax' ];
                    $additional                          = [
                        'registration',
                        'bank_name',
                        'bank_address',
                        'iban',
                        'swift'
                    ];
                    foreach ( $additional as $v ) {
                        if ( $that->config->get( 'show_' . $v ) === '1' ) {
                            array_push( $fields, $v );
                        }
                    }
                    redirect( $that->html->getSecureURL( 'sale/customer/update' . '&customer_id=' . $customer_id ) );
                } else {
                    $exist = $that->model_sale_taxid_option->getCustomerId( $that->request->get['customer_id'] );
                    if ( $exist ) {
                        $that->model_sale_taxid_option->updateCustomerAdditionalValues(
                            $that->request->get['customer_id'],
                            $that->request->post
                        );
                    } else {
                        $that->model_sale_taxid_option->addCustomerAdditionalValues(
                            $that->request->get['customer_id'],
                            $that->request->post
                        );
                    }
                }
            }
        } elseif ( $this->baseObject_method === 'insert_address' ) {
            if ( $that->request->is_POST() ) {
                $errors = $this->_validateCustomerAddress( $that->request->post, '0' );
                if ( ! empty( $errors['warning'] ) ) {
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect( $that->html->getSecureURL( 'sale/customer/insert_address' . '&customer_id=' . $that->request->get['customer_id'] ) );
                } else {
                    $address_id   = $that->model_sale_taxid_option->addAddress( $that->request->get['customer_id'], $that->request->post );
                    $redirect_url = $that->html->getSecureURL( 'sale/customer/update', '&customer_id=' . $that->request->get['customer_id'] . '&address_id=' . $address_id );
                    //do we need to update default address?
                    if ( $that->request->post['default'] ) {
                        $that->model_sale_customer->setDefaultAddress( $that->request->get['customer_id'], $address_id );
                    }
                    $that->session->data['success'] = $that->language->get( 'text_success' );
                    redirect( $redirect_url );
                }
            }
        } elseif ( $this->baseObject_method === 'update_address' ) {
            if ( $that->request->is_POST() ) {
                $errors = $this->_validateCustomerAddress( $that->request->post, '0' );
                if ( ! empty( $errors['warning'] ) ) {
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    $customer_id                         = $that->request->get['customer_id'];
                    $address_id                          = $that->request->get['address_id'];
                    redirect( $that->html->getSecureURL( 'sale/customer/update_address' . '&customer_id=' . $customer_id . '&address_id=' . $address_id ) );
                } else {
                    $that->model_sale_taxid_option->editAddress( $that->request->get['customer_id'], $that->request->get['address_id'], $that->request->post );
                    $redirect_url                   = $that->html->getSecureURL( 'sale/customer/update_address', '&customer_id=' . $that->request->get['customer_id'] . '&address_id=' . $that->request->get['address_id'] );
                    $that->session->data['success'] = $that->language->get( 'text_success' );
                    redirect( $redirect_url );
                }
            }
        }
        if ( isset( $that->session->data['base_post'] ) ) {
            $that->request->post = $that->session->data['base_post'];
            unset( $that->session->data['base_post'] );
        }
    }

    public function onControllerPagesSaleCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ( $this->baseObject_method === 'insert' ) {
            $this->_getForm();
        } elseif ( $this->baseObject_method === 'update' ) {
            $this->_getForm( $that->session->data['viewport_mode'] );
        } elseif ( $this->baseObject_method === 'insert_address' ) {
            $this->_getAdressForm();
        } elseif ( $this->baseObject_method === 'update_address' ) {
            $this->_getAdressForm();
        }
    }

    public function onControllerPagesAccountCreate_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/taxid_option');

        if ($this->baseObject_method === 'main') {
            if ( $that->request->is_POST() ) {
                $that->loadModel( 'account/taxid_option' );
                $errors = $that->model_account_taxid_option->validateAdditionalValuesForCreate( $that->request->post );
                if ( ! empty( $errors ) ) {
                    $that->loadModel( 'account/customer' );
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect( $that->html->getSecureURL( 'account/create' ) );
                } else {
                    $that->loadModel( 'account/customer' );
                    //if allow login as email, need to set loginname = email
                    $request_data = $that->request->post;
                    if ( ! $that->config->get( 'prevent_email_as_login' ) ) {
                        $request_data['loginname'] = $request_data['email'];
                    }
                    $that->loadModel( 'extension/taxid_option_verify' );
                    $mc_status      = $that->model_extension_taxid_option_verify->verifyMailchimp();
                    $mc_plus_status = $that->model_extension_taxid_option_verify->verifyMailchimpPlus();
                    $ctct_status    = $that->model_extension_taxid_option_verify->verifyCtct();
                    if ( $ctct_status === true ) {
                        $that->load->model( 'extension/ctct' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $firstname = $that->request->post['firstname'];
                            $lastname  = $that->request->post['lastname'];
                            $email     = $that->request->post['email'];
                            $exist     = $that->model_extension_ctct->getContact( $email );
                            if ( empty( $exist ) ) {
                                $that->model_extension_ctct->Subscribe( $email, $firstname, $lastname, 0 );
                            }
                        }
                    } elseif ( $mc_status === true ) {
                        $that->load->model( 'extension/mc_integration' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $that->model_extension_mc_integration->Subscribe( $that->request->post );
                        }
                    } elseif ( $mc_plus_status === true ) {
                        $that->load->model( 'extension/mc_integration_plus' );
                        if ( $that->request->post['newsletter'] == 1 ) {
                            $that->model_extension_mc_integration_plus->Subscribe( $that->request->post );
                        }
                    }

                    $that->data['customer_id'] = $that->model_account_taxid_option->addCustomer( $request_data );
                    $that->model_account_customer->editCustomerNotifications( $request_data, $that->data['customer_id'] );
                    $that->model_account_taxid_option->addCustomerAdditionalValues( $that->data['customer_id'], $request_data );
                    unset( $that->session->data['guest'] );

                    if ( ! $that->config->get( 'config_customer_approval' ) ) {
                        //add and send account activation link if required
                        if ( ! $that->config->get( 'config_customer_email_activation' ) ) {
                            //send welcome email
                            $that->model_account_customer->sendWelcomeEmail( $that->request->post['email'], true );
                            //login customer after create account is approvement and email activation are disabled in settings
                            $that->customer->login( $request_data['loginname'], $request_data['password'] );
                        } else {
                            //send activation email request and wait for confirmation
                            $that->model_account_customer->emailActivateLink( $this->data['customer_id'] );
                        }
                    } else {
                        //send welcome email, but need manual approval
                        $that->model_account_customer->sendWelcomeEmail( $that->request->post['email'], false );
                    }

                    //set success text for non-approved customers on login page after redirect
                    if ( $that->config->get( 'config_customer_approval' ) ) {
                        $that->loadLanguage( 'account/success' );
                        $that->session->data['success'] = sprintf( $that->language->get( 'text_approval', 'account/success' ),
                            $that->config->get( 'store_name' ),
                            $that->html->getSecureURL( 'content/contact' ) );
                    }

                    if ( $that->config->get( 'config_customer_email_activation' ) || ! $that->session->data['redirect'] ) {
                        $redirect_url = $that->html->getSecureURL( 'account/success' );
                    } else {
                        $redirect_url = $that->session->data['redirect'];
                    }

                    redirect( $redirect_url );
                }
            }

            if ( isset( $that->session->data['base_post'] ) ) {
                $that->request->post = $that->session->data['base_post'];
                unset( $that->session->data['base_post'] );
            }
        }
    }

    public function onControllerPagesAccountCreate_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that =& $this->baseObject;
            $data = [];

            $that->loadModel('account/taxid_option');
            $that->loadLanguage('account/taxid_option');

            $field_errors = $that->session->data['field_errors'];
            if ($field_errors) {
                foreach ($field_errors as $key => $field_error) {
                    $that->view->assign('error_' . $key, $field_error);
                    $data['errors'][$key] = $field_error;
                }
                unset($that->session->data['field_errors']);
            }

            $fields = ['telephone', 'fax', 'company', 'taxid'];
            $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            foreach ($additional as $v) {
                if ($that->config->get('show_' . $v) === '1') {
                    array_push($fields, $v);
                }
            }
            foreach ($fields as $v) {
                $option_data = [
                    'type' => 'input',
                    'name' => $v,
                    'value' => $that->request->post[$v],
                    'placeholder' => $that->config->get($v . '_placeholder'),
                    'required' => ($that->config->get($v . '_option_mandatory_status') === '1') ? true : false
                ];
                $data['entry_' . $v] = $that->language->get('entry_' . $v);
                $data['additional'][$v] = $that->html->buildElement($option_data);
            }

            $data['text_additional_fields'] = $that->language->get('text_additional_fields');
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_attributes', $view->fetch('pages/account/fields_create.tpl'));

            $form = $that->view->getData('form');
            unset( $form['fields']['general']['telephone']);
            unset( $form['fields']['general']['fax']);
            unset( $form['fields']['address']['company']);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesAccountEdit_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/taxid_option');
        if ($this->baseObject_method === 'main') {
            if ( $that->request->is_POST() ) {
                $that->loadModel( 'account/taxid_option' );
                $that->loadModel( 'account/customer' );
                $errors = $that->model_account_taxid_option->validateAdditionalValuesForEdit( $that->request->post );
                if ( ! empty( $errors ) ) {
                    $that->session->data['base_post']    = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect( $that->html->getSecureURL( 'account/edit' ) );
                } else {
                    $exist = $that->model_account_taxid_option->getCustomerAdditionalValues( $that->session->data['customer_id'] );
                    if ( $exist ) {
                        $that->model_account_taxid_option->updateCustomerAdditionalValues(
                            $that->session->data['customer_id'],
                            $that->request->post
                        );
                    } else {
                        $that->model_account_taxid_option->addCustomerAdditionalValues(
                            $that->session->data['customer_id'],
                            $that->request->post
                        );
                    }
                }
            }

            if ( isset( $that->session->data['base_post'] ) ) {
                $that->request->post = $that->session->data['base_post'];
                unset( $that->session->data['base_post'] );
            }
        }
    }

    public function onControllerPagesAccountEdit_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $data = [];
        if ($this->baseObject_method === 'main') {
            $that->loadModel( 'account/taxid_option' );
            $that->loadLanguage( 'account/taxid_option' );
            $that->load->model( 'account/customer' );
            $datas    = $that->model_account_taxid_option->getCustomerAdditionalValues( $that->customer->getId() );
            $customer = $that->model_account_customer->getCustomer( $that->customer->getId() );
            $datas    = array_merge( $datas, $customer );
            $field_errors = $that->session->data['field_errors'];
            if ( $field_errors ) {
                foreach ( $field_errors as $key => $field_error ) {
                    $that->view->assign( 'error_' . $key, $field_error );
                    $data['errors'][ $key ] = $field_error;
                }
                unset( $that->session->data['field_errors'] );
            }

            $fields     = [ 'telephone', 'fax' ];
            $additional = [ 'registration', 'bank_name', 'bank_address', 'iban', 'swift' ];
            foreach ( $additional as $v ) {
                if ( $that->config->get( 'show_' . $v ) === '1' ) {
                    array_push( $fields, $v );
                }
            }

            foreach ( $fields as $v ) {
                if ( isset( $that->request->post[ $v ] ) && $that->request->post[ $v ] === '' ) {
                    $val = '';
                } elseif ( isset( $that->request->post[ $v ] ) && $that->request->post[ $v ] != '' ) {
                    $val = $that->request->post[ $v ];
                } else {
                    if ($v==='telephone') {
                        $val = $customer['telephone'];
                    } elseif ($v==='fax') {
                        $val = $customer['fax'];
                    } else {
                        $val = $datas[$v];
                    }
                }
                $option_data              = [
                    'type'        => 'input',
                    'name'        => $v,
                    'value'       => $val,
                    'placeholder' => $that->config->get( $v . '_placeholder' ),
                    'required'    => ( $that->config->get( $v . '_option_mandatory_status' ) === '1' ) ? true : false
                ];
                $data[ 'entry_' . $v ]    = $that->language->get( 'entry_' . $v );
                $data['additional'][ $v ] = $that->html->buildElement( $option_data );
            }
            $data['text_additional_fields'] = $that->language->get( 'text_additional_fields' );

            $view = new AView( $this->registry, 0 );
            $view->batchAssign( $data );
            $that->view->addHookVar( 'customer_attributes', $view->fetch( 'pages/account/fields_edit.tpl' ) );

            $form = $that->view->getData('form');
            unset( $form['fields']['telephone']);
            unset( $form['fields']['fax']);
            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesAccountAddress_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->load->model('account/taxid_option');
        if ($this->baseObject_method === 'insert') {
            if ($that->request->is_POST()) {
                $errors = $this->_validateCustomerAddress($that->request->post, '1', 'payment');
                if (!empty($errors['warning'])) {
                    $that->session->data['base_post'] = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect($that->html->getSecureURL('account/address/insert'));
                } else {
                    $that->model_account_taxid_option->addAddress($that->request->post);
                    $that->session->data['success'] = $that->language->get('text_insert');
                    redirect($that->html->getSecureURL('account/address'));
                }
            }
        } elseif ($this->baseObject_method === 'update') {
            if ($that->request->is_POST()) {
                $errors = $this->_validateCustomerAddress($that->request->post, '1', 'payment');
                if (!empty($errors['warning'])) {
                    $that->session->data['base_post'] = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    $address_id = $that->request->get['address_id'];
                    redirect($that->html->getSecureURL('account/address/update' . '&address_id=' . $address_id));
                } else {
                    $that->model_account_taxid_option->editAddress($that->request->get['address_id'], $that->request->post);
                    if (isset($that->session->data['shipping_address_id']) && ($that->request->get['address_id'] == $that->session->data['shipping_address_id'])) {
                        unset($that->session->data['shipping_methods']);
                        unset($that->session->data['shipping_method']);

                        $that->tax->setZone($that->request->post['country_id'], $that->request->post['zone_id']);
                    }

                    if (isset($that->session->data['payment_address_id']) && ($that->request->get['address_id'] == $that->session->data['payment_address_id'])) {
                        unset($that->session->data['payment_methods']);
                        unset($that->session->data['payment_method']);
                    }

                    $that->session->data['success'] = $that->language->get('text_update');
                    redirect($that->html->getSecureURL('account/address'));
                }
            }
        }
        if (isset($that->session->data['base_post'])) {
            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }
    }

    public function onControllerPagesAccountAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $this->getList();
        } elseif ($this->baseObject_method === 'insert') {
            $this->_getStorefrontAddressForm();
        } elseif ($this->baseObject_method === 'update') {
            $this->_getStorefrontAddressForm();
        }
    }

    public function onControllerPagesCheckoutGuestStep1_ValidateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->loadLanguage('account/taxid_option');
        $fields = ['telephone', 'fax', 'company', 'taxid'];
        $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
        $default_local_delivery_status = $that->config->get('default_local_delivery_status');
        $data = $that->request->post;
        foreach ($additional as $v) {
            if ($that->config->get('show_' . $v) === '1') {
                array_push($fields, $v);
            }
        }

        foreach ($fields as $v) {
            if ($v==='telephone') {
                if ($default_local_delivery_status) {
                    $that->error[$v] = $that->error['telephone'];
                } else if ($that->config->get($v . '_option_mandatory_status') === '1') {
                    $pattern = $that->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
                    $phone = $data['telephone'] ?? '';
                    if (empty($phone)
                        && (mb_strlen($phone) < 3
                            || mb_strlen($phone) > 32
                            || !preg_match($pattern, $phone))
                    ) {
                        $that->error[$v] = $that->language->get($v . '_error');
                    }
                }
            } else {
                if ($that->config->get($v . '_option_mandatory_status') === '1') {
                    if ($v === 'fax') {
                        if (empty($data[$v]) || ((mb_strlen($data[$v]) > 32) && strtolower($data[$v]) != 'na' && strtolower($data[$v]) != 'none')) {
                            $that->error[$v] = $that->language->get($v . '_error');
                        }
                    } elseif ($v == 'taxid' || $v === 'iban' || $v === 'swift') {
                        $str = strtolower($data[$v]);
                        if ($that->config->get($v . '_option_mandatory_status') === '1') {
                            if (empty($data[$v]) && $str !== 'na' && $str !== 'none') {
                                $that->error[$v] = $that->language->get($v . '_error');
                            }
                        }
                    } elseif ($v === 'shipping_company') {
                        if (empty($data[$v])) {
                            $that->error[$v] = $that->language->get('company_error');
                        }
                    } else {
                        if (empty($data[$v])) {
                            $that->error[$v] = $that->language->get($v . '_error');
                        }
                    }
                }
            }
        }
        if ($data['shipping_indicator']) {
            if ($that->config->get('company_option_mandatory_status') === '1') {
                if ($data['shipping_company'] === '') {
                    $that->error['shipping_company'] = $that->language->get('company_error');
                }
            }
        }
    }

    public function onControllerPagesCheckoutGuestStep1_ProcessData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
            $that->loadModel( 'account/taxid_option' );
            $exist = $that->model_account_taxid_option->countCustomerAdditionalValuesByEmail( $that->request->post['email'], 0 );
            if ( $exist == 1 ) {
                $that->model_account_taxid_option->updateCustomerAdditionalValuesByEmail( $that->request->post['email'], '0', $that->request->post );
            } else {
                $customer_id = 0;
                $that->model_account_taxid_option->addCustomerAdditionalValues( $customer_id, $that->request->post );
            }
            $fields     = ['telephone', 'fax', 'company', 'taxid'];
            $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            foreach ( $additional as $v ) {
                if ( $that->config->get( 'show_' . $v ) === '1' ) {
                    array_push( $fields, $v );
                }
            }
            foreach ( $fields as $v ) {
                $that->session->data['guest'][ $v ] = $that->request->post[ $v ];
            }
            $that->session->data['shipping_indicator'] = $that->request->post['shipping_indicator'];
    }

    public function onControllerPagesCheckoutGuestStep1_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
	        $that =& $this->baseObject;
	        $data = [];
	        $default_local_delivery_status = $that->config->get('default_local_delivery_status');
	        $that->loadModel( 'account/taxid_option' );
	        $that->loadLanguage( 'account/taxid_option' );

	        $field_errors = $that->error;
	        if ( $field_errors ) {
		        foreach ( $field_errors as $key => $field_error ) {
			        $that->view->assign( 'error_' . $key, $field_error );
			        $data['errors'][ $key ] = $field_error;
		        }
	        }

	        $fields     = [ 'telephone', 'fax', 'company', 'taxid' ];
	        $additional = [ 'registration', 'bank_name', 'bank_address', 'iban', 'swift' ];
	        foreach ( $additional as $v ) {
		        if ( $that->config->get( 'show_' . $v ) === '1' ) {
			        array_push( $fields, $v );
		        }
	        }

	        foreach ( $fields as $v ) {
		        if ( isset( $that->request->post[ $v ] ) ) {
			        $val = $that->request->post[ $v ];
		        } elseif ( isset( $that->session->data['guest'][ $v ] ) ) {
			        $val = $that->session->data['guest'][ $v ];
		        } else {
			        $val = '';
		        }
		        if ($v==='telephone') {
                    $required = $that->config->get($v . '_option_mandatory_status') === '1' || $default_local_delivery_status ? true : false;
                } else {
		            $required = $that->config->get($v . '_option_mandatory_status') === '1' ? true : false;
                }
		        $option_data              = [
			        'type'        => 'input',
			        'name'        => $v,
			        'value'       => $val,
			        'placeholder' => $that->config->get( $v . '_placeholder' ),
			        'required'    => $required
		        ];
		        $data[ 'entry_' . $v ]    = $that->language->get( 'entry_' . $v );
		        $data['additional'][ $v ] = $that->html->buildElement( $option_data );
	        }

	        $view = new AView( $this->registry, 0 );
	        $view->batchAssign( $data );
	        if ( $that->config->get( 'embed_mode' ) == true ) {
		        $that->view->addHookVar( 'guest_details_attributes', $view->fetch( 'embed/checkout/fields_create.tpl' ) );
	        } else {
		        $that->view->addHookVar( 'guest_details_attributes', $view->fetch( 'pages/checkout/fields_create.tpl' ) );
	        }
	        $form = $that->view->getData('form');
            unset( $form['fields']['general']['telephone']);
            unset( $form['fields']['general']['fax']);
            unset( $form['fields']['address']['company']);

            $that->view->assign('form', $form);
        }
    }

    public function onControllerPagesCheckoutAddress_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }

        $that =& $this->baseObject;
        $that->loadLanguage('account/taxid_option');
        $that->loadModel('account/address');
        $that->loadModel('account/taxid_option');
        if ($this->baseObject_method === 'shipping') {
            if ($that->request->is_POST() && isset($that->request->post['address_id'])) {
                $that->session->data['shipping_address_id'] = $that->request->post['address_id'];

                unset($that->session->data['shipping_methods']);
                unset($that->session->data['shipping_method']);

                if ($that->cart->hasShipping()) {
                    $address_info = $that->model_account_taxid_option->getAddress($that->request->post['address_id']);
                    if ($address_info) {
                        $that->tax->setZone($address_info['country_id'], $address_info['zone_id']);
                    }
                }
                unset($that->session->data['shipping_methods'], $that->session->data['shipping_method']);
                redirect($that->html->getSecureURL('checkout/shipping'));
            }

            if ($that->request->is_POST()) {
                $that->loadModel('account/taxid_option');
                $errors = $this->_validateCustomerAddress($that->request->post, '1');
                if (!empty($errors['warning'])) {
                    $that->loadModel('account/customer');
                    $that->session->data['base_post'] = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect($that->html->getSecureURL('checkout/address/shipping'));
                } else {
                    $that->session->data['shipping_address_id']=$that->model_account_taxid_option->addAddress($that->request->post);
                    unset($that->session->data['shipping_methods'], $that->session->data['shipping_method']);

                    if ($that->cart->hasShipping()) {
                        $that->tax->setZone($that->request->post['country_id'], $that->request->post['zone_id']);
                    }
                    redirect($that->html->getSecureURL('checkout/shipping'));
                    unset($that->session->data['field_errors']);
                }
            }
        } elseif ($this->baseObject_method === 'payment') {
            if ($that->request->is_POST() && isset($that->request->post['address_id'])) {
                $that->session->data['payment_address_id'] = $that->request->post['address_id'];
                unset($that->session->data['payment_methods']);
                unset($that->session->data['payment_method']);
                redirect($that->html->getSecureURL('checkout/payment'));
            }
            if ($that->request->is_POST()) {
                $errors = $this->_validateCustomerAddress($that->request->post, '1', 'payment');
                if (!empty($errors['warning'])) {
                    $that->loadModel('account/customer');
                    $that->session->data['base_post'] = $that->request->post;
                    $that->session->data['field_errors'] = $errors;
                    redirect($that->html->getSecureURL('checkout/address/payment'));
                } else {
                    $that->session->data['payment_address_id']=$that->model_account_taxid_option->addAddress($that->request->post);
                    unset($that->session->data['payment_methods']);
                    unset($that->session->data['payment_method']);
                    unset($that->session->data['field_errors']);
                    redirect($that->html->getSecureURL('checkout/payment'));
                }
            }
        }
        if (isset($that->session->data['base_post'])) {
            $that->request->post = $that->session->data['base_post'];
            unset($that->session->data['base_post']);
        }
    }

    public function onControllerPagesCheckoutAddress_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'shipping') {
            $this->_getCheckoutAddressForm('shipping');
        } elseif ($this->baseObject_method === 'payment') {
            $this->_getCheckoutAddressForm('payment');
        }
    }

    public function onControllerPagesCheckoutConfirm_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'main') {
            $that =& $this->baseObject;
            $that->load->model('account/taxid_option');
            $that->load->model('account/taxid_order');

            $info = $that->model_account_taxid_option->getCustomerAdditionalValues($that->session->data['customer_id']);
            $payment_address = $that->model_account_taxid_option->getAddress($that->session->data['payment_address_id']);
            $payment_address=array_merge($info,$payment_address);

            $taxid=[];
            if ($that->config->get('taxid_show_order_confirm') === '1' && $payment_address['taxid'] !== strtolower('none') && $payment_address['taxid'] !== strtolower('na')) {
                $taxid['payment_company'] = $payment_address['company'];
                $taxid['taxid'] = $payment_address['taxid'];
                $taxid['taxid_confirm'] = $that->config->get('taxid_order_confirm');
                $taxid['taxid_show_order_confirm'] = $that->config->get('taxid_show_order_confirm');
            }

            $view = new AView($this->registry, 0);
            $view->batchAssign($taxid);
            $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $view->fetch('pages/checkout/confirm_taxid.tpl'));

            $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            $add=[];
            foreach ($additional as $v) {
                if ($that->config->get($v . '_show_order_confirm') === '1' && $payment_address[$v] !== strtolower('none') && $payment_address[$v] !== strtolower('na')) {
                    $add[$v] = $payment_address[$v];
                    $add[$v . '_confirm'] = $that->config->get($v . '_order_confirm');
                    $add[$v . '_show_order_confirm'] = $that->config->get($v . '_show_order_confirm');
                }
            }
            if (sizeof($add) > 0) {
                $add['exist']='1';
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($add);
            $that->view->addHookVar('checkout_confirm_payment_info_post_2', $view->fetch('pages/checkout/confirm_additional_info.tpl'));
            if ($payment_address) {
                $that->view->assign('payment_address' , $this->getFormattedAddress($payment_address, 'payment'));
            } else {
                $that->view->assign('payment_address' , '');
            }

            $order_id = $that->session->data['order_id'];
            $taxid_info=$that->model_account_taxid_option->getAddress($that->customer->getAddressId());
            $infos['taxid'] = $taxid_info['taxid'];
            $infos['registration'] = $info['registration'];
            $infos['bank_name'] = $info['bank_name'];
            $infos['bank_address'] = $info['bank_address'];
            $infos['iban'] = $info['iban'];
            $infos['swift'] = $info['swift'];
            $that->model_account_taxid_order->updateTaxIDInfo($order_id,$infos);
        }
    }

    public function onControllerPagesCheckoutGuestStep3_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->session->data['is_fast_checkout'] === '0';
            $that->load->model('extension/taxid_option_verify');

            $payment_address = $that->session->data['guest'];

            $taxid=[];
            if ($that->config->get('taxid_show_order_confirm') === '1' && $that->session->data['guest']['taxid'] !== strtolower('none') && $that->session->data['guest']['taxid'] !== strtolower('na')) {
                $taxid['payment_company'] = $payment_address['company'];
                $taxid['taxid'] = $payment_address['taxid'];
                $taxid['taxid_confirm'] = $that->config->get('taxid_order_confirm');
                $taxid['taxid_show_order_confirm'] = $that->config->get('taxid_show_order_confirm');
            }

            $view = new AView($this->registry, 0);
            $view->batchAssign($taxid);
            $that->view->addHookVar('checkout_confirm_payment_info_pre_2', $view->fetch('pages/checkout/confirm_taxid.tpl'));

            $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            $add=[];
            foreach ($additional as $v) {
                if ($that->config->get($v . '_show_order_confirm') === '1' && $that->session->data['guest'][$v] !== strtolower('none') && $that->session->data['guest'][$v] !== strtolower('na')) {
                    $add[$v] = $that->session->data['guest'][$v];
                    $add[$v . '_confirm'] = $that->config->get($v . '_order_confirm');
                    $add[$v . '_show_order_confirm'] = $that->config->get($v . '_show_order_confirm');
                }
            }
            if (sizeof($add) > 0) {
                $add['exist']='1';
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($add);
            $that->view->addHookVar('checkout_confirm_payment_info_post_2', $view->fetch('pages/checkout/confirm_additional_info.tpl'));
            if ($payment_address) {
                $that->view->assign('payment_address' , $this->getFormattedAddress($payment_address, 'payment'));
            } else {
                $that->view->assign('payment_address' , '');
            }

            $taxid_info['taxid']=$that->session->data['guest']['taxid'];
            $taxid_info['registration']=$that->session->data['guest']['registration'];
            $taxid_info['bank_name']=$that->session->data['guest']['bank_name'];
            $taxid_info['bank_address']=$that->session->data['guest']['bank_address'];
            $taxid_info['iban']=$that->session->data['guest']['iban'];
            $taxid_info['swift']=$that->session->data['guest']['swift'];
            $order_id = $that->session->data['order_id'];
            $that->model_account_taxid_order->updateTaxIDInfo($order_id,$taxid_info);
        }
    }

    public function afterModelCheckoutOrder_create($data,$set_order_id) {
        if ( !$this->_is_enabled() ) {
            return null;
        }
        $that  =& $this->baseObject;
        $that->load->model('account/taxid_order');
        $that->load->model('account/taxid_option');

        if ($that->customer->isLogged()) {
            $taxid_info=$that->model_account_taxid_option->getCustomerAdditionalValues($that->customer->getId());
            if (isset($that->session->data['fc']) && $that->config->get('fast_checkout_status')) {
                $payment_address = $that->model_account_taxid_option->getAddress($that->session->data['fc']['payment_address_id']);
            } else {
                $payment_address = $that->model_account_taxid_option->getAddress($that->session->data['payment_address_id']);
            }
            $taxid_info=array_merge($taxid_info,$payment_address);

        } elseif (isset($that->session->data['guest'])) {
            $taxid_info['fax']=$that->session->data['guest']['fax'];
            $taxid_info['telephone']=$that->session->data['guest']['telephone'];
            $taxid_info['company']=$that->session->data['guest']['company'];
            $taxid_info['taxid']=$that->session->data['guest']['taxid'];
            $taxid_info['registration']=$that->session->data['guest']['registration'];
            $taxid_info['bank_name']=$that->session->data['guest']['bank_name'];
            $taxid_info['bank_address']=$that->session->data['guest']['bank_address'];
            $taxid_info['iban']=$that->session->data['guest']['iban'];
            $taxid_info['swift']=$that->session->data['guest']['swift'];
        }
        $order_id = $that->session->data['order_id'];
        $that->model_account_taxid_order->updateTaxIDInfo($order_id,$taxid_info);
    }

    public function onControllerResponsesQuickCheckoutCheckout_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'save') {
            $that =& $this->baseObject;
            $additional = ['taxid','registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            foreach ($additional as $v) {
                if ($that->config->get('show_' . $v) === '1') {
                    $that->session->data[$v]=$that->request->post[$v];
                }
            }
        }
    }

    public function onControllerResponsesCommonViewPort_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'modal') {
            $page_rt = $that->request->get['viewport_rt'];
            if ($page_rt) {
                $that->session->data['viewport_mode']='modal';
            }
        }
    }

    public function onControllerPagesAccountInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }
            $that->loadModel('account/customer');
            $that->load->model('account/order');
            $that->load->model('account/taxid_order');
            $enc = new AEncryption($that->config->get('encryption_key'));
            $guest = false;

            if ($that->config->get('taxid_show_seller_info') === '1') {
                $that->load->language('account/taxid_option');
                $seller_info['text_ordered'] = $that->language->get('text_ordered');
                $seller_info['seller_info'] = html_entity_decode(nl2br($that->config->get('taxid_seller_info')));
                $view = new AView($this->registry, 0);
                $view->batchAssign($seller_info);
                $that->view->addHookVar('pre_shipping_address', $view->fetch('pages/account/seller_info.tpl'));
            }

            if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                //try to decrypt order token
                $order_token = $that->request->get['ot'];
                if ($order_token) {
                    list($order_id, $email) = $that->model_account_customer->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $guest = true;
                        $order_info = $that->model_account_taxid_order->getOrder($order_id);
                    }
                }
            }

            if ($that->request->is_POST() && $this->_validate()) {
                $guest = true;
                $order_id = $that->request->post['order_id'];
                $email = $that->request->post['email'];
                $order_token = $enc->encrypt($order_id . '::' . $email);
                $order_info = $that->model_account_taxid_order->getOrder($order_id);

                //compare emails
                if ($order_info['email'] != $email) {
                    unset($order_info, $order_id, $email);
                }
            }

            if (!$that->customer->isLogged() && !$guest) {
                $that->session->data['redirect'] = $that->html->getSecureURL('account/invoice', '&order_id=' . $order_id);
                $this->getInvoiceForm();
                return null;
            }

            if (!$order_id && $that->customer->isLogged()) {
                redirect($that->html->getSecureURL('account/history'));
            }

            //get info for registered customers
            if (!$order_info) {
                $order_info = $that->model_account_taxid_order->getOrder($order_id);
            }

            if ($order_info) {
                $that->load->model('account/order');
                $order_products = $that->model_account_order->getOrderProducts($order_id);
                foreach ($order_products as $product) {
                    //$that->view->addHookVar('product_'.$product['product_id'].'_additional_info_2','<tr><td>aaaa</td></tr>');
                }

                $fax = $order_info['fax'] && strtolower($order_info['fax'])!='na' && strtolower($order_info['fax'])!='none' ? $order_info['fax'] : '';
                $that->view->assign('fax',$fax);

                $that->load->model('extension/taxid_option_verify');
                $ups_plus_status = $that->model_extension_taxid_option_verify->verifyUpsPlus();
                if ($ups_plus_status === '1') {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country'],
                        'location_phone' => $order_info['location_phone']
                    ];
                } else {
                    $shipping_data = [
                        'firstname' => $order_info['shipping_firstname'],
                        'lastname' => $order_info['shipping_lastname'],
                        'company' => $order_info['shipping_company'],
                        'address_1' => $order_info['shipping_address_1'],
                        'address_2' => $order_info['shipping_address_2'],
                        'city' => $order_info['shipping_city'],
                        'postcode' => $order_info['shipping_postcode'],
                        'zone' => $order_info['shipping_zone'],
                        'zone_code' => $order_info['shipping_zone_code'],
                        'country' => $order_info['shipping_country']
                    ];
                }

                $that->view->assign('shipping_address', $this->getFormattedAddress($shipping_data));
                $that->view->assign('shipping_method', $order_info['shipping_method']);

                $payment_data = [
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'taxid' => $order_info['taxid'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country'],
                    'registration' => $order_info['registration'],
                    'bank_name' => $order_info['bank_name'],
                    'bank_address' => $order_info['bank_address'],
                    'iban' => $order_info['iban'],
                    'swift' => $order_info['swift']
                ];
                $that->view->assign('payment_address', $this->getFormattedAddress($payment_data, 'payment'));
                $that->view->assign('payment_method', $order_info['payment_method']);
            }
        }
    }

    public function onControllerPagesCheckoutShipping_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/shipping';
            $that->loadModel('account/taxid_option');
            if (!isset($that->session->data[ 'shipping_address_id' ])) {
                $that->session->data[ 'shipping_address_id' ] = $that->customer->getAddressId();
            }
            $shipping_address = $that->model_account_taxid_option->getAddress($that->session->data['shipping_address_id']);

            //something wrong with shipping address go to address selection page
            if (!$shipping_address) {
                redirect($that->html->getSecureURL($address_rt));
            }
            $that->view->assign('address',$this->getFormattedAddress($shipping_address));
        }
    }

    public function onControllerPagesCheckoutPayment_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $address_rt = 'checkout/address/payment';
            $that->loadModel('account/taxid_option');
            $payment_address = $that->model_account_taxid_option->getAddress($that->session->data['payment_address_id']);
            if (!$payment_address){
                redirect($that->html->getSecureURL($address_rt));
            }
            $that->view->assign('address',$this->getFormattedAddress($payment_address,'payment'));
        }
    }

    //Fast Checkout Section
    public function onControllerResponsesCheckoutPay_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method==='address') {
            if (!$that->customer->isLogged() && $that->request->is_POST()) {
                $that->session->data['fc']['fax'] = $that->request->post['fax'] ?? '';
                $that->session->data['fc']['telephone'] = $that->request->post['telephone'] ?? '';
                $that->session->data['fc']['company'] = $that->request->post['company'] ?? '';
                $that->session->data['fc']['taxid'] = $that->request->post['taxid'] ?? '';
                $that->session->data['fc']['registration'] = $that->request->post['registration'] ?? '';
                $that->session->data['fc']['bank_name'] = $that->request->post['bank_name'] ?? '';
                $that->session->data['fc']['bank_address'] = $that->request->post['bank_address'] ?? '';
                $that->session->data['fc']['iban'] = $that->request->post['iban'] ?? '';
                $that->session->data['fc']['swift'] = $that->request->post['swift'] ?? '';
            }
        }
    }

    public function onControllerResponsesCheckoutPay_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if ($that->customer->isLogged()) {
                $that->load->model('account/taxid_option');
                $that->data['all_addresses']=$that->model_account_taxid_option->getAddresses();
                $additional = ['fax','company','registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            } else {
                $that->session->data['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['guest']['company'] = $that->session->data['fc']['company'];
                $that->session->data['guest']['taxid'] = $that->session->data['fc']['taxid'];
                $that->session->data['guest']['registration'] = $that->session->data['fc']['registration'];
                $that->session->data['guest']['bank_name'] = $that->session->data['fc']['bank_name'];
                $that->session->data['guest']['bank_address'] = $that->session->data['fc']['bank_address'];
                $that->session->data['guest']['iban'] = $that->session->data['fc']['iban'];
                $that->session->data['guest']['swift'] = $that->session->data['fc']['swift'];

                $that->session->data['fc']['guest']['fax'] = $that->session->data['fc']['fax'];
                $that->session->data['fc']['guest']['company'] = $that->session->data['fc']['company'];
                $that->session->data['fc']['guest']['taxid'] = $that->session->data['fc']['taxid'];
                $that->session->data['fc']['guest']['registration'] = $that->session->data['fc']['registration'];
                $that->session->data['fc']['guest']['bank_name'] = $that->session->data['fc']['bank_name'];
                $that->session->data['fc']['guest']['bank_address'] = $that->session->data['fc']['bank_address'];
                $that->session->data['fc']['guest']['iban'] = $that->session->data['fc']['iban'];
                $that->session->data['fc']['guest']['swift'] = $that->session->data['fc']['swift'];

                $additional = ['fax','company','taxid','registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            }

            $that->loadLanguage('account/taxid_option');
            $that->load->model('account/taxid_option');
            $fields = [];

            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                    || ($that->config->get('show_' . $v) === '1')) {
                    array_push($fields, $v);
                }
            }

            if ($that->customer->isLogged()) {
                $taxid_info = $that->model_account_taxid_option->getCustomerAdditionalValues($that->customer->getId());
                $payment_address = $that->model_account_taxid_option->getAddress($that->session->data['fc']['payment_address_id']);
                $taxid_info=array_merge($taxid_info,$payment_address);
            } else {
                $taxid_info = $that->session->data['fc'];
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $taxid_info[$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('customer_additional_attributes', $view->fetch('pages/account/fc_payment_fields.tpl'));
        } elseif ($this->baseObject_method === '_addressForm') {
            $that->loadLanguage('account/taxid_option');
            $fields = [];
            $additional = ['fax','company','taxid','registration', 'bank_name', 'bank_address', 'iban', 'swift'];
            foreach ($additional as $v) {
                if ($that->config->get($v.'_option_mandatory_status')
                   || ($that->config->get('show_' . $v) === '1')) {
                    array_push($fields, $v);
                }
            }
            foreach ($fields as $v) {
                $data['additional'][$v] = $v;
                $data[$v.'_data'] = $that->session->data['fc'][$v];
                $data[$v.'_placeholder'] = $that->language->get('fc_'.$v.'_placeholder').': '.$that->config->get($v.'_placeholder');
            }
            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('address_attributes', $view->fetch('pages/account/fc_guest_fields.tpl'));
        } elseif ($this->baseObject_method==='_process_success') {
            $that->load->model('account/taxid_order');
            if (isset($that->session->data['order_id'])) {
                $that->model_account_taxid_order->updateCustomerAdditionalInfo($that->session->data['order_id']);
            }
        }
    }

    public function onControllerPagesAccountOrderDetails_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='main') {
            $that->loadModel('account/order');
            $that->loadModel('extension/fast_checkout');

            if ($that->config->get('taxid_show_seller_info') === '1') {
                $that->load->language('account/taxid_option');
                $seller_info['text_ordered'] = $that->language->get('text_ordered');
                $seller_info['seller_info'] = html_entity_decode(nl2br($that->config->get('taxid_seller_info')));
                $view = new AView($this->registry, 0);
                $view->batchAssign($seller_info);
                $that->view->addHookVar('pre_shipping_address', $view->fetch('pages/account/seller_info.tpl'));
            }

            $order_id = 0;
            $order_token = '';
            $that->loadModel('account/taxid_order');
            $that->loadModel('extension/fast_checkout');

            //validate input and re-route
            if ($that->customer->isLogged()) {
                //logged in customer, missing order ID?
                $order_id = (int) $that->request->get['order_id'];
                if (!$order_id) {
                    redirect($that->html->getSecureURL('account/history'));
                    return;
                }
                $order_info = $that->model_account_taxid_order->getOrder($order_id);
            } else {
                if (isset($that->request->get['ot']) && $that->config->get('config_guest_checkout')) {
                    //try to decrypt order token
                    $order_token = $that->request->get['ot'];
                    list($order_id, $email) = $that->model_extension_fast_checkout->parseOrderToken($order_token);
                    if ($order_id && $email) {
                        $that->data['order_token'] = $order_token;
                        $that->data['guest'] = $guest = true;
                        $order_info = $that->model_account_taxid_order->getOrder($order_id, '', 'view');
                    } else {
                        redirect($that->html->getSecureURL('account/history'));
                        return;
                    }
                }
            }

            if ($order_info) {
                //validate input and re-route
                $shipping_address = $that->data['shipping_address'];
                $find_shipping_address = ["na<br />", "none<br />", "NA<br />", "None<br />", "NONE<br />"];
                $replace_shipping_address = ["", "", "", "", ""];
                $that->view->assign('shipping_address', str_replace($find_shipping_address, $replace_shipping_address, $shipping_address));

                $payment_data = [
                    'firstname' => $order_info['payment_firstname'],
                    'lastname' => $order_info['payment_lastname'],
                    'company' => $order_info['payment_company'],
                    'taxid' => $order_info['taxid'],
                    'address_1' => $order_info['payment_address_1'],
                    'address_2' => $order_info['payment_address_2'],
                    'city' => $order_info['payment_city'],
                    'postcode' => $order_info['payment_postcode'],
                    'zone' => $order_info['payment_zone'],
                    'zone_code' => $order_info['payment_zone_code'],
                    'country' => $order_info['payment_country'],
                    'registration' => $order_info['registration'],
                    'bank_name' => $order_info['bank_name'],
                    'bank_address' => $order_info['bank_address'],
                    'iban' => $order_info['iban'],
                    'swift' => $order_info['swift']
                ];

                $payment_address = $this->getFormattedAddress($payment_data,'payment');
                $that->view->assign('payment_address', $payment_address);
            }
        }
    }
   //End Of Fast Checkout Section

    private function getInvoiceForm() {
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/invoice'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        $this->data['back'] = $that->html->getHomeURL();

        $form = new AForm();
        $form->setForm(['form_name' => 'CheckOrderFrm']);

        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'CheckOrderFrm',
                'action' => $that->html->getSecureURL('account/invoice'),
                'csrf' => true
            ]);

        $order_id = (int)$that->request->post['order_id'] ? (int)$that->request->post['order_id'] : '';
        $this->data['form']['order_id'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'order_id',
                'value' => $order_id,
                'required' => true]);

        $this->data['entry_order_id'] = $that->language->get('text_order_id');

        $this->data['form']['email'] = $form->getFieldHtml(
            [
                'type' => 'input',
                'name' => 'email',
                'value' => $that->request->post['email'],
                'required' => true]);

        $this->data['entry_email'] = $that->language->get('text_email');

        $this->data['form']['back'] = $form->getFieldHtml(
            [
                'type' => 'button',
                'name' => 'back',
                'text' => $that->language->get('button_back'),
                'icon' => 'fa fa-arrow-left',
                'style' => 'button']);

        $this->data['form']['submit'] = $form->getFieldHtml(
            [
                'type' => 'submit',
                'icon' => 'fa fa-check',
                'name' => $that->language->get('button_continue')
            ]);

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/order.tpl');
    }

    public function onControllerPagesSaleOrder_InitData()
    {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'address') {
            $that =& $this->baseObject;
            if ($that->request->is_POST()) {
                $that->loadModel('sale/taxid_option');
                $that->model_sale_taxid_option->updateOrder($that->request->get['order_id'], $that->request->post);
            }
        }
    }

    public function onControllerPagesSaleOrder_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        if ($this->baseObject_method === 'details') {
            $that =& $this->baseObject;
            $that->loadModel('sale/taxid_option');
            $order_id = (int)$that->request->get['order_id'];
            $order_info = $that->model_sale_taxid_option->getOrder($order_id);
            $that->loadLanguage('taxid_option/taxid_option');
            $data['taxid'] = $order_info['taxid'];
            $data['entry_taxid'] = $that->language->get('entry_taxid');
            $data['registration'] = $order_info['registration'];
            $data['entry_registration'] = $that->language->get('entry_registration');
            $data['bank_name'] = $order_info['bank_name'];
            $data['entry_bank_name'] = $that->language->get('entry_bank_name');
            $data['bank_address'] = $order_info['bank_address'];
            $data['entry_bank_address'] = $that->language->get('entry_bank_address');
            $data['iban'] = $order_info['iban'];
            $data['entry_iban'] = $that->language->get('entry_iban');
            $data['swift'] = $order_info['swift'];
            $data['entry_swift'] = $that->language->get('entry_swift');

            $view = new AView($this->registry, 0);
            $view->batchAssign($data);
            $that->view->addHookVar('order_details_left_attributes', $view->fetch('pages/sale/order_details_taxid_info.tpl'));
        } elseif ($this->baseObject_method === 'address') {
            $that =& $this->baseObject;
            $that->loadModel('sale/taxid_option');
            $that->loadLanguage('taxid_option/taxid_option');

            $fields = [
                'taxid',
                'registration',
                'bank_name',
                'bank_address',
                'iban',
                'swift',
            ];

            if (isset($that->request->get['order_id'])) {
                $order_id = (int)$that->request->get['order_id'];
            } else {
                $order_id = 0;
            }
            $order_info = $that->model_sale_taxid_option->getOrder($order_id);
            foreach ($fields as $f) {
                if (isset ($that->request->post [$f])) {
                    $this->data [$f] = $that->request->post [$f];
                } elseif (isset($order_info[$f])) {
                    $this->data[$f] = $order_info[$f];
                }
            }

            $form=$that->view->getData('form');

            foreach ($fields as $f) {
                $name = str_replace('payment_', '', $f);
                $form['payment_fields'][$name] = $that->html->buildInput([
                    'name' => $f,
                    'value' => $this->data[$f],
                ]);
            }

            $that->view->assign('form',$form);
        }
    }

    public function onControllerResponsesListingGridOrder_InitData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'update_field') {
            $that->loadModel('sale/taxid_option');
            $order_id = $that->request->get['id'];
            foreach ($that->request->post as $field => $value) {
                $data['column'] = $field;
                $data['value'] = $value;
                $that->model_sale_taxid_option->updateOrderTaxIdInfo($order_id, $data);
            }
        }
    }

    public function onControllerResponsesListingGridCustomer_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;

        if ($this->baseObject_method === 'update') {
            $that->loadModel('sale/taxid_option');
            switch ($that->request->post['oper']) {
                case 'del':
                    $ids = explode(',', $that->request->post['id']);
                    if (!empty($ids))
                        foreach ($ids as $id) {
                            $that->model_sale_taxid_option->deleteCustomer($id);
                        }
                    break;
                default:
                    break;
            }
        }
    }

    public function beforeModelCheckoutOrder_ProcessData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method==='sf_order_confirm_mail') {
            $fast_checkout=$that->session->data['is_fast_checkout'];
            $that->load->model('extension/taxid_option_verify');
            $ups_plus_status=$that->model_extension_taxid_option_verify->verifyUpsPlus();
            $order_id=$that->data['mail_template_data']['order_id'];
            if ( $ups_plus_status === true ) {
                $order_query = $that->db->query( "SELECT o.*,
												l.filename AS filename,
												l.directory AS directory,
												ap.location_phone
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 LEFT JOIN " . $that->db->table( "ap_address_phone" ) . " ap ON ap.order_id=o.order_id
										 WHERE o.order_id = " . (int)$order_id);
            } else {
                $order_query = $that->db->query( "SELECT *,
												l.filename AS filename,
												l.directory AS directory
										 FROM `" . $that->db->table( "orders" ) . "` o
										 LEFT JOIN " . $that->db->table( "languages" ) . " l ON (o.language_id = l.language_id)
										 WHERE o.order_id = " . (int)$order_id);
            }
            if ( ! $order_query->num_rows ) {
                return false;
            }
            $order_row = $that->dcrypt->decrypt_data( $order_query->row, 'orders' );

            $taxShow = $that->config->get('taxid_show_order_confirm');
            if ($taxShow === '1' && strtolower($order_row['taxid']) !== 'none' && strtolower($order_row['taxid']) !== 'na' && $order_row['taxid'] !== '') {
                $vat = $that->config->get('taxid_order_confirm') . ' '. $order_row['taxid']."\n";
            } else {
                $vat = "";
            }

            $registrationShow = $that->config->get('registration_show_order_confirm');
            if ($registrationShow === '1' && strtolower($order_row['registration']) !== 'none' && strtolower($order_row['registration']) !== 'na' && $order_row['registration'] !== '') {
                $registration = $that->config->get('registration_order_confirm') . ' ' . $order_row['registration']. "\n";
            } else {
                $registration = "";
            }

            $bankNameShow = $that->config->get('bank_name_show_order_confirm');
            if ($bankNameShow === '1' &&  strtolower($order_row['bank_name']) !== 'none' && strtolower($order_row['bank_name']) !== 'na' && $order_row['bank_name'] !== '') {
                $bankName = $that->config->get('bank_name_order_confirm') . ' '.$order_row['bank_name']. "\n";
            } else {
                $bankName = "";
            }

            $bankAddressShow = $that->config->get('bank_address_show_order_confirm');
            if ($bankAddressShow === '1' &&  strtolower($order_row['bank_address']) !== 'none' && strtolower($order_row['bank_address']) !== 'na' && $order_row['bank_address'] !== '') {
                $bankAddress = $that->config->get('bank_address_order_confirm') . ' '.$order_row['bank_address']. "\n";
            } else {
                $bankAddress = "";
            }

            $ibanShow = $that->config->get('iban_show_order_confirm');
            if ($ibanShow === '1' && strtolower($order_row['iban']) !== 'none' && strtolower($order_row['iban']) !== 'na' && $order_row['iban'] !== '') {
                $iban = $that->config->get('iban_order_confirm') . ' '.$order_row['iban']. "\n";
            } else {
                $iban = "";
            }

            $swiftShow = $that->config->get('swift_show_order_confirm');
            if ($swiftShow === '1' && strtolower($order_row['swift']) !== 'none' && strtolower($order_row['swift']) !== 'na' && $order_row['swift'] !== '') {
                $swift = $that->config->get('swift_order_confirm') . ' '.$order_row['swift'];
            } else {
                $swift = "";
            }
            $that->load->model('localisation/zone');

            $shipping_zone_row = $that->model_localisation_zone->getZone($order_row['shipping_zone_id']);
            if ($shipping_zone_row) {
                $shipping_zone_code = $shipping_zone_row['code'];
            } else {
                $shipping_zone_code = '';
            }
            $shipping_data = [
                'firstname' => $order_row['shipping_firstname'],
                'lastname'  => $order_row['shipping_lastname'],
                'company'   => strtolower($order_row['shipping_company'])==='na' || strtolower($order_row['shipping_company'])==='none' ? "" : $order_row['shipping_company'],
                'address_1' => $order_row['shipping_address_1'],
                'address_2' => $order_row['shipping_address_2'],
                'city'      => $order_row['shipping_city'],
                'postcode'  => $order_row['shipping_postcode'],
                'zone'      => $order_row['shipping_zone'],
                'zone_code' => $shipping_zone_code,
                'country'   => $order_row['shipping_country'],
            ];

            $that->data['mail_template_data']['shipping_data'] = $shipping_data;

            $payment_zone_row = $that->model_localisation_zone->getZone($order_row['payment_zone_id']);
            if ($payment_zone_row) {
                $payment_zone_code = $payment_zone_row['code'];
            } else {
                $payment_zone_code = '';
            }

            if ($fast_checkout==='1') {
                $payment_data = [
                    'firstname' => $order_row['payment_firstname'],
                    'lastname' => $order_row['payment_lastname'],
                    'company' => $order_row['payment_company'],
                    'address_1' => $order_row['payment_address_1'],
                    'address_2' => $order_row['payment_address_2'],
                    'city' => $order_row['payment_city'],
                    'postcode' => $order_row['payment_postcode'],
                    'zone' => $order_row['payment_zone'],
                    'zone_code' => $payment_zone_code,
                    'country' => $order_row['payment_country'],
                ];
            } else {
                $payment_data = [
                    'firstname' => $order_row['payment_firstname'],
                    'lastname' => $order_row['payment_lastname'],
                    'company' => strtolower($order_row['payment_company']) === 'na' || strtolower($order_row['payment_company']) === 'none' ? "" : $order_row['payment_company'],
                    'taxid' => $vat,
                    'address_1' => $order_row['payment_address_1'],
                    'address_2' => $order_row['payment_address_2'],
                    'city' => $order_row['payment_city'],
                    'postcode' => $order_row['payment_postcode'],
                    'zone' => $order_row['payment_zone'],
                    'zone_code' => $payment_zone_code,
                    'country' => $order_row['payment_country'],
                    'registration' => $registration,
                    'bank_name' => $bankName,
                    'bank_address' => $bankAddress,
                    'iban' => $iban,
                    'swift' => $swift
                ];
            }

            if ( $that->config->get( 'taxid_show_seller_info' ) === '1' ) {
                $that->data['mail_template_data']['seller_info']  = html_entity_decode( nl2br( $that->config->get( 'taxid_seller_info' ) ) );
            } else {
                $that->data['mail_template_data']['seller_info']  = "";
            }

            $that->data['mail_template_data']['customer_fax'] = $order_row['fax']==='na' || $order_row['fax']==='none' ? '' : $order_row['fax'];
            $that->data['mail_template_data']['payment_data'] = $payment_data;
            $that->data['mail_template_data']['payment_address'] = $this->getFormattedAddress( $payment_data, 'payment' );
        }
    }

    public function afterModelCheckoutOrder_confirm($order_id, $order_status_id, $comment = '') {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        $that->load->model( 'account/taxid_option' );
	    $that->model_account_taxid_option->deleteAdditionalValuesById( 0 );
    }

    public function onControllerResponsesSaleInvoice_UpdateData() {
        if (!$this->_is_enabled()) {
            return null;
        }
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            $that->loadModel('sale/order');
            $that->loadModel('sale/taxid_option');
	        $that->loadModel('extension/taxid_option_verify');

            $orders_data = $that->data['orders'];
            $orders=[];
            $that->load->model('extension/taxid_option_verify');
            foreach ($orders_data as $v) {
                $order_info = $that->model_sale_taxid_option->getOrder($v['order_id']);
                if ($order_info) {
                    $payment_data = [
                        'firstname' => $order_info['payment_firstname'],
                        'lastname' => $order_info['payment_lastname'],
                        'company' => $order_info['payment_company'],
                        'taxid' => $order_info['taxid'],
                        'address_1' => $order_info['payment_address_1'],
                        'address_2' => $order_info['payment_address_2'],
                        'city' => $order_info['payment_city'],
                        'postcode' => $order_info['payment_postcode'],
                        'zone' => $order_info['payment_zone'],
                        'zone_code' => $order_info['payment_zone_code'],
                        'country' => $order_info['payment_country'],
                        'registration' => $order_info['registration'],
                        'bank_name' => $order_info['bank_name'],
                        'bank_address' => $order_info['bank_address'],
                        'iban' => $order_info['iban'],
                        'swift' => $order_info['swift']
                    ];

                    $payment_address = $this->getFormattedAddress($payment_data,'payment');

                    $orders[] = [
                        'order_id' => $v['order_id'],
                        'invoice_id' => $v['invoice_id'],
                        'date_added' => $v['date_added'],
                        'store_name' => $v['store_name'],
                        'store_url' => $v['store_url'],
                        'address' => $v['address'],
                        'telephone' => $v['telephone'],
                        'fax' => $v['fax'],
                        'taxid' => $order_info['taxid'],
                        'email' => $v['email'],
                        'shipping_address' => $v['shipping_address'],
                        'payment_address' => $payment_address,
                        'customer_email' => $v['customer_email'],
                        'ip' => $v['ip'],
                        'customer_telephone' => $v['customer_telephone'],
                        'customer_fax' => $order_info['fax']==='na' || $order_info['fax']==='none' ? '' : $order_info['fax'],
                        'comment' =>$v['comment'],
                        'product' => $v['product'],
                        'total' => $v['total']
                    ];

                    if ($that->config->get('taxid_show_seller_info') === '1') {
                        $that->load->language('taxid_option/taxid_option');
                        $seller_info['text_ordered'] = $that->language->get('text_ordered');
                        $seller_info['seller_info'] = html_entity_decode(nl2br($that->config->get('taxid_seller_info')));
                        $view = new AView($this->registry, 0);
                        $view->batchAssign($seller_info);
                        $that->view->addHookVar('order_invoice_'.$order_info['order_id'].'_more_order_info', $view->fetch('pages/sale/seller_info.tpl'));
                    }
                }
            }
            $that->view->assign('orders',$orders);
        }
    }

    private function _getStorefrontAddressForm() {
        $that =& $this->baseObject;
        $that->document->resetBreadcrumbs();
        $that->load->model('account/taxid_option');
        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('index/home'),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/account'),
            'text' => $that->language->get('text_account'),
            'separator' => $that->language->get('text_separator')
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getURL('account/address'),
            'text' => $that->language->get('heading_title'),
            'separator' => $that->language->get('text_separator')
        ]);

        if (!isset($that->request->get['address_id'])) {
            $that->document->addBreadcrumb([
                'href' => $that->html->getURL('account/address/insert'),
                'text' => $that->language->get('text_edit_address'),
                'separator' => $that->language->get('text_separator')
            ]);
        } else {
            $that->document->addBreadcrumb([
                'href' => $that->html->getURL('account/address/update', 'address_id=' . $that->request->get['address_id']),
                'text' => $that->language->get('text_edit_address'),
                'separator' => $that->language->get('text_separator')
            ]);
        }

        $that->view->assign('error_warning', $that->session->data['field_errors']['warning']);
        $that->view->assign('error_firstname', $that->session->data['field_errors']['firstname']);
        $that->view->assign('error_lastname', $that->session->data['field_errors']['lastname']);
        $that->view->assign('error_company', $that->session->data['field_errors']['company']);
        $that->view->assign('error_taxid', $that->session->data['field_errors']['taxid']);
        $that->view->assign('error_address_1', $that->session->data['field_errors']['address_1']);
        $that->view->assign('error_city', $that->session->data['field_errors']['city']);
        $that->view->assign('error_postcode', $that->session->data['field_errors']['postcode']);
        $that->view->assign('error_country', $that->session->data['field_errors']['country']);
        $that->view->assign('error_zone', $that->session->data['field_errors']['zone']);

        unset($that->session->data['field_errors']);

        if (isset($that->request->get['address_id']) && $that->request->is_GET()) {
            $address_info = $that->model_account_taxid_option->getAddress($that->request->get['address_id']);
        }

        $this->data['back'] = $that->html->getSecureURL('account/address');

        $form = new AForm();
        $form->setForm(['form_name' => 'AddressFrm']);

        if (!isset($that->request->get['address_id'])) {
            $action = $that->html->getSecureURL('account/address/insert');
        } else {
            $action = $that->html->getSecureURL('account/address/update', '&address_id=' . $that->request->get['address_id']);
        }
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'AddressFrm',
                'action' => $action,
                'csrf' => true
            ]);

        if (isset($that->request->post['firstname'])) {
            $firstname = $that->request->post['firstname'];
        } elseif (isset($address_info)) {
            $firstname = $address_info['firstname'];
        } else {
            $firstname = '';
        }
        $this->data['form']['fields']['firstname'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'firstname',
            'value' => $firstname,
            'required' => true]);

        if (isset($that->request->post['lastname'])) {
            $lastname = $that->request->post['lastname'];
        } elseif (isset($address_info)) {
            $lastname = $address_info['lastname'];
        } else {
            $lastname = '';
        }
        $this->data['form']['fields']['lastname'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'lastname',
            'value' => $lastname,
            'required' => true]);

        if (isset($that->request->post['company'])) {
            $company = $that->request->post['company'];
        } elseif (isset($address_info)) {
            $company = $address_info['company'];
        } else {
            $company = '';
        }
        $this->data['form']['fields']['company'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'company',
            'value' => $company,
            'placeholder' => $that->config->get('company_placeholder'),
            'required' => ($that->config->get('company_option_mandatory_status') === '1') ? true : false]);

        $that->load->language('account/taxid_option');
        if (isset($that->request->post['taxid'])) {
            $taxid = $that->request->post['taxid'];
        } elseif (isset($address_info)) {
            $taxid = $address_info['taxid'];
        } else {
            $taxid = '';
        }
        $this->data['entry_taxid']=$that->language->get('entry_taxid');
        $this->data['form']['fields']['taxid'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'taxid',
            'value' => $taxid,
            'placeholder' => $that->config->get('taxid_placeholder'),
            'required' => ($that->config->get('taxid_option_mandatory_status') === '1') ? true : false]);

        if (isset($that->request->post['address_1'])) {
            $address_1 = $that->request->post['address_1'];
        } elseif (isset($address_info)) {
            $address_1 = $address_info['address_1'];
        } else {
            $address_1 = '';
        }
        $this->data['form']['fields']['address_1'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'address_1',
            'value' => $address_1,
            'required' => true]);

        if (isset($that->request->post['address_2'])) {
            $address_2 = $that->request->post['address_2'];
        } elseif (isset($address_info)) {
            $address_2 = $address_info['address_2'];
        } else {
            $address_2 = '';
        }
        $this->data['form']['fields']['address_2'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'address_2',
            'value' => $address_2,
            'required' => false]);

        if (isset($that->request->post['city'])) {
            $city = $that->request->post['city'];
        } elseif (isset($address_info)) {
            $city = $address_info['city'];
        } else {
            $city = '';
        }
        $this->data['form']['fields']['city'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'city',
            'value' => $city,
            'required' => true]);

        if (isset($that->request->post['zone_id'])) {
            $this->data['zone_id'] = $that->request->post['zone_id'];
        } elseif (isset($address_info)) {
            $this->data['zone_id'] = $address_info['zone_id'];
        } else {
            $this->data['zone_id'] = 'FALSE';
        }

        $this->data['form']['fields']['zone'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'zone_id',
            'value' => $this->data['zone_id'],
            'required' => true]);

        if (isset($that->request->post['postcode'])) {
            $postcode = $that->request->post['postcode'];
        } elseif (isset($address_info)) {
            $postcode = $address_info['postcode'];
        } else {
            $postcode = '';
        }
        $this->data['form']['fields']['postcode'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'postcode',
            'value' => $postcode,
            'required' => true])
        ;
        if (isset($that->request->post['country_id'])) {
            $country_id = $that->request->post['country_id'];
        } elseif (isset($address_info)) {
            $country_id = $address_info['country_id'];
        } else {
            $country_id = $that->config->get('config_country_id');
        }

        $that->loadModel('localisation/country');
        $countries = $that->model_localisation_country->getCountries();
        $options = ["false" => $that->language->get('text_select')];
        foreach ($countries as $item) {
            $options[$item['country_id']] = $item['name'];
        }
        $this->data['form']['fields']['country'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'country_id',
            'options' => $options,
            'value' => $country_id,
            'required' => true]);
        if (isset($that->request->post['default'])) {
            $default = $that->request->post['default'];
        } elseif (isset($that->request->get['address_id'])) {
            $default = $that->customer->getAddressId() == $that->request->get['address_id'];
        } else {
            $default = false;
        }
        $this->data['form']['default'] = $form->getFieldHtml([
            'type' => 'radio',
            'name' => 'default',
            'value' => $default,
            'options' => [
                '1' => $that->language->get('text_yes'),
                '0' => $that->language->get('text_no'),
            ]]);
        $this->data['form']['back'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button']);
        $this->data['form']['submit'] = $form->getFieldHtml([
            'type' => 'submit',
            'icon' => 'fa fa-check',
            'name' => $that->language->get('button_continue')
        ]);

        //TODO: REMOVE THIS IN 1.3!!!
        // backward compatibility code
        $deprecated = array_keys($this->data['form']['fields']);
        foreach($deprecated as $name){
            $fld = $this->data['form']['fields'][$name];
            if(in_array($name, ['country','zone'])){
                $name .= '_id';
            }
            $this->data['form'][$name] = $fld;
        }
        //end of trick

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/account/address.tpl');
    }

    private function _getCheckoutAddressForm($type) {
        $that =& $this->baseObject;
        $that->load->model('account/taxid_option');
        $field_errors = $that->session->data['field_errors'];
        if (isset($field_errors)) {
            foreach ($field_errors as $key => $field_error) {
                $that->view->assign('error_' . $key, $field_error);
            }
            unset($that->session->data['field_errors']);
        }

        $this->data['default'] = $that->session->data[$type . '_address_id'];

        $form = new AForm();
        $form->setForm(['form_name' => 'address_1']);
        $this->data['form0']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'address_1',
                'action' => $that->html->getSecureURL('checkout/address/' . $type),
                'csrf' => true
            ]);

        $addresses = [];
        $results = $that->model_account_taxid_option->getAddresses();

        foreach ($results as $result) {
            $addresses[] = [
                'address_id' => $result['address_id'],
                'address' => $result['firstname'] . ' ' . $result['lastname'] . ', ' . $result['address_1'] . ', ' . $result['city'] . ', ' . (($result['zone']) ? $result['zone'] . ', ' : false) . (($result['postcode']) ? $result['postcode'] . ', ' : false) . $result['country'],
                'href' => $that->html->getSecureURL('account/address/' . $type, 'address_id=' . $result['address_id']),
                'radio' => $form->getFieldHtml(['type' => 'radio',
                    'id' => 'a_' . $result['address_id'],
                    'name' => 'address_id',
                    'options' => [$result['address_id'] => ''],
                    'value' => ($result['address_id'] == $this->data['default'] ? $result['address_id'] : ''),
                ]),
            ];
        }
        $this->data['addresses'] = $addresses;

        $this->data['form0']['continue'] = $form->getFieldHtml([
            'type' => 'submit',
            'name' => $that->language->get('button_continue')]);

        $form = new AForm();
        $form->setForm(['form_name' => 'Address2Frm']);
        $this->data['form']['form_open'] = $form->getFieldHtml(
            [
                'type' => 'form',
                'name' => 'Address2Frm',
                'action' => $that->html->getSecureURL('checkout/address/' . $type),
                'csrf' => true]);

        $this->data['form']['firstname'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'firstname',
            'value' => $that->request->post['firstname'],
            'required' => true]);
        $this->data['form']['lastname'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'lastname',
            'value' => $that->request->post['lastname'],
            'required' => true]);
        $this->data['form']['company'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'company',
            'value' => $that->request->post['company'],
            'placeholder' => $that->config->get('company_placeholder'),
            'required' => ($that->config->get('company_option_mandatory_status') === '1') ? true : false]);

        if ($type=='payment') {
            $this->data['form']['taxid'] = $form->getFieldHtml([
                'type' => 'input',
                'name' => 'taxid',
                'value' => $that->request->post['taxid'],
                'placeholder' => $that->config->get('taxid_placeholder'),
                'required' => ($that->config->get('taxid_option_mandatory_status') === '1') ? true : false]);
        }
        $this->data['form']['address_1'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'address_1',
            'value' => $that->request->post['address_1'],
            'required' => true]);
        $this->data['form']['address_2'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'address_2',
            'value' => $that->request->post['address_2'],
            'required' => false]);
        $this->data['form']['city'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'city',
            'value' => $that->request->post['city'],
            'required' => true]);
        $this->data['form']['postcode'] = $form->getFieldHtml([
            'type' => 'input',
            'name' => 'postcode',
            'value' => $that->request->post['postcode'],
            'required' => true]);
        $that->loadModel('localisation/country');
        $countries = $that->model_localisation_country->getCountries();
        $options = ["false" => $that->language->get('text_select')];
        foreach ($countries as $item) {
            $options[$item['country_id']] = $item['name'];
        }
        $this->data['form']['country_id'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'country_id',
            'options' => $options,
            'value' => (isset($that->request->post['country_id']) ? $that->request->post['country_id'] : $that->config->get('config_country_id')),
            'required' => true]);

        $this->data['form']['zone'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'zone_id',
            'required' => true]);

        $this->data['form']['continue'] = $form->getFieldHtml([
            'type' => 'submit',
            'name' => $that->language->get('button_continue')]);


        $this->data['zone_id'] = isset($that->request->post['zone_id']) ? $that->request->post['zone_id'] : 'FALSE';

        $that->loadModel('localisation/country');
        $this->data['countries'] = $that->model_localisation_country->getCountries();
        $this->data['type']=$type;

        $that->view->batchAssign($this->data);
        if ($that->config->get('embed_mode') == true) {
            //load special headers
            $that->addChild('responses/embed/head', 'head');
            $that->addChild('responses/embed/footer', 'footer');
            $that->processTemplate('embed/checkout/address.tpl');
        } else {
            $that->processTemplate('pages/checkout/address.tpl');
        }
    }

    private function _getForm($viewport_mode='') {
        $that =& $this->baseObject;
        $field_errors = $that->session->data['field_errors'];
        if ($field_errors) {
            foreach ($field_errors as $key => $field_error) {
                $this->data['error'][$key] = $field_error;
            }
            unset($that->session->data['field_errors']);
        }
        $customer_id = $that->request->get['customer_id'];

        $this->data['token'] = $that->session->data['token'];

        $that->document->initBreadcrumb([
            'href' => $that->html->getHomeURL(),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getSecureURL('sale/customer'),
            'text' => $that->language->get('heading_title'),
            'separator' => ' :: '
        ]);

        $this->data['addresses'] = [];

        if ($customer_id) {
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $this->data['button_orders_count'] = $that->html->buildElement(
                [
                    'type' => 'button',
                    'name' => 'view orders',
                    'text' => $that->language->get('text_order') . ': ' . $customer_info['orders_count'],
                    'style' => 'button2',
                    'href' => $that->html->getSecureURL('sale/order', '&customer_id=' . $customer_id),
                    'title' => $that->language->get('text_view') . ' ' . $that->language->get('tab_history')
                ]
            );
            $this->data['addresses'] = $that->model_sale_customer->getAddressesByCustomerId($customer_id);
        }

        foreach ($this->data['addresses'] as &$a) {
            $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
            $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
            //mark default address
            if ($customer_info['address_id'] == $a['address_id']) {
                $a['default'] = 1;
            }
        }
        $this->data['add_address_url'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id);

        $this->data['fields'] = array_merge([
            'loginname' => 'required',
            'firstname' => 'required',
            'lastname' => 'required',
            'email' => 'required',
            'telephone' => 'required',
            'fax' => 'required',
            'sms' => null,
            'newsletter' => null,
            'customer_group_id' => null,
            'status' => null,
            'approved' => null,
            'password' => 'required'],
            (array)$this->data['fields']);

        $post = $that->request->post;
        $fields = array_keys($this->data['fields']);

        $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
        foreach ($additional as $v) {
            if ($v === 'taxid') {
                array_push($fields, $v);
            } elseif ($that->config->get('show_' . $v) === '1') {
                array_push($fields, $v);
            }
        }
        foreach ($fields as $f) {
            if (isset($post[$f])) {
                $this->data[$f] = $post[$f];
            } elseif (isset($customer_info)) {
                $this->data[$f] = $customer_info[$f];
            } else {
                $this->data[$f] = '';
            }
        }

        if (!isset($this->data['customer_group_id']) || empty($this->data['customer_group_id'])) {
            $this->data['customer_group_id'] = $that->config->get('config_customer_group_id');
        }
        if (!isset($this->data['status']) || empty($this->data['status'])) {
            $this->data['status'] = 1;
        }
        if (!isset($this->data['password']) && isset($that->request->post['password'])) {
            $this->data['password'] = $that->request->post['password'];
        } else {
            $this->data['password'] = '';
        }

        //new customer or new address
        if (!isset($customer_id)) {
            $this->data['action'] = $that->html->getSecureURL('sale/customer/insert');
            $this->data['heading_title'] = $that->language->get('text_insert') . $that->language->get('text_customer');
            $this->data['update'] = '';
            $form = new AForm('ST');
        } else {
            $this->data['customer_id'] = $customer_id;
            $this->data['action'] = $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id);
            $this->data['heading_title'] = $that->language->get('text_edit') . $that->language->get('text_customer') . ' - ' . $this->data['firstname'] . ' ' . $this->data['lastname'];
            $this->data['update'] = $that->html->getSecureURL('listing_grid/taxid/update_field', '&id=' . $customer_id);
            $form = new AForm('HS');
        }

        $that->document->addBreadcrumb([
            'href' => $this->data['action'],
            'text' => $this->data['heading_title'],
            'separator' => ' :: ',
            'current' => true
        ]);

        $this->data['tabs']['general'] = [
            'href' => $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id),
            'text' => $that->language->get('tab_customer_details'),
            'active' => true
        ];
        if (has_value($customer_id)) {
            $this->data['tabs'][] = [
                'href' => $that->html->getSecureURL('sale/customer_transaction', '&customer_id=' . $customer_id),
                'text' => $that->language->get('tab_transactions')
            ];
        }

        $that->load->model('setting/store');
        if (!$that->model_setting_store->isDefaultStore()) {
            $this->data['warning_actonbehalf'] = htmlspecialchars($that->language->get('warning_actonbehalf_additional_store'), ENT_QUOTES, 'UTF-8');
        }

        $this->data['actas'] = $that->html->buildElement([
            'type' => 'button',
            'text' => $that->language->get('button_actas'),
            'href' => $that->html->getSecureURL('sale/customer/actonbehalf', '&customer_id=' . $customer_id),
            'target' => 'new'
        ]);

        $form->setForm([
            'form_name' => 'cgFrm',
            'update' => $this->data['update'],
        ]);

        $this->data['form']['id'] = 'cgFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml([
            'type' => 'form',
            'name' => 'cgFrm',
            'attr' => 'data-confirm-exit="true" class="form-horizontal"',
            'action' => $this->data['action'],
        ]);
        $this->data['form']['submit'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'submit',
            'text' => $that->language->get('button_save')
        ]);
        $this->data['form']['reset'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'reset',
            'text' => $that->language->get('button_reset')
        ]);

        $this->data['form']['fields']['details']['status'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'status',
            'value' => $this->data['status'],
            'style' => 'btn_switch',
        ]);
        $this->data['form']['fields']['details']['approved'] = $form->getFieldHtml([
            'type' => 'checkbox',
            'name' => 'approved',
            'value' => $this->data['approved'],
            'style' => 'btn_switch',
        ]);

        $required_input = [];
        foreach ($this->data['fields'] as $field_name => $required) {
            if ($required) {
                $required_input[] = $field_name;
            }
        }

        foreach ($required_input as $f) {
            if($viewport_mode=='modal' && in_array($f, ['password'])){
                continue;
            }
            if ($f=='telephone') {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml([
                    'type' => ($f === 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => '',
                    'required' => ($that->config->get('telephone_option_mandatory_status')==='1') ? true : false,
                    'style' => ($f === 'password' ? 'small-field' : '')
                ]);
            } elseif($f=='fax') {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml([
                    'type' => ($f === 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => $that->config->get('fax_option_placeholder'),
                    'required' => ($that->config->get('fax_option_mandatory_status')==='1') ? true : false,
                    'style' => ($f === 'password' ? 'small-field' : '')
                ]);
            } else {
                $this->data['form']['fields']['details'][$f] = $form->getFieldHtml([
                    'type' => ($f === 'password' ? 'passwordset' : 'input'),
                    'name' => $f,
                    'value' => $this->data[$f],
                    'placeholder' => '',
                    'required' => (in_array($f, ['password']) ? false : true),
                    'style' => ($f === 'password' ? 'small-field' : '')
                ]);
            }
        }

        $this->data['form']['fields']['details']['newsletter'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'newsletter',
            'value' => $this->data['newsletter'],
            'options' => [
                1 => $that->language->get('text_enabled'),
                0 => $that->language->get('text_disabled'),
            ],
        ]);

        $that->loadModel('sale/customer_group');
        $results = $that->model_sale_customer_group->getCustomerGroups();
        $groups = ['' => $that->language->get('text_select_group'),];
        foreach ($results as $item) {
            $groups[$item['customer_group_id']] = $item['name'];
        }

        $this->data['form']['fields']['details']['customer_group'] = $form->getFieldHtml([
            'type' => 'selectbox',
            'name' => 'customer_group_id',
            'value' => $this->data['customer_group_id'],
            'options' => $groups,
        ]);

        $that->loadModel('sale/taxid_option');
        $datas = $that->model_sale_taxid_option->getCustomerAdditionalValues($that->request->get['customer_id']);
        $field_errors = $that->session->data['field_errors'];
        if ($field_errors) {
            foreach ($field_errors as $key => $field_error) {
                $this->data['error'][$key] = $field_error;
            }
            unset($that->session->data['field_errors']);
        }

        $fields = [];
        $additional = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
        foreach ($additional as $v) {
            if ($that->config->get('show_' . $v) === '1') {
                array_push($fields, $v);
            }
        }

        if (sizeof((array)$datas)) {
            foreach ($datas as $k => $v) {
                if (in_array($k, $fields)) {
                    $val = '';
                    if (isset($post[$k])) {
                        $val = $post[$k];
                    } else {
                        $val = $v;
                    }
                    $option_data = [
                        'type' => 'input',
                        'name' => $k,
                        'value' => $val,
                        'placeholder' => $that->config->get($k . '_placeholder'),
                        'required' => ($that->config->get($k . '_option_mandatory_status') === '1') ? true : false
                    ];
                    $this->data['form']['fields']['details'][$k] = $that->html->buildElement($option_data);
                }
            }
        } else {
            foreach ($fields as $k => $v) {
                $val = $post[$v];
                $option_data = [
                    'type' => 'input',
                    'name' => $v,
                    'value' => $val,
                    'placeholder' => $that->config->get($v . '_placeholder'),
                    'required' => ($that->config->get($v . '_option_mandatory_status') === '1') ? true : false
                ];
                $this->data['form']['fields']['details'][$v] = $that->html->buildElement($option_data);
            }
        }

        $this->data['tab_customer_attributes'] = $that->language->get('text_additional_values');

        $this->data['section'] = 'details';
        $this->data['tabs']['general']['active'] = true;

        $that->view->assign('help_url', $that->gen_help_url('customer_edit'));
        $that->loadModel('sale/customer_transaction');
        $balance = $that->model_sale_customer_transaction->getBalance($customer_id);
        $this->data['balance'] = $that->language->get('text_balance') . ' ' . $that->currency->format($balance, $that->config->get('config_currency'));
        $that->view->batchAssign($this->data);

        if ($viewport_mode === 'modal') {
            unset($that->session->data['viewport_mode']);
            $tpl = 'responses/viewport/modal/sale/customer_form.tpl';
        } else {
            $tpl = 'pages/sale/customer_form.tpl';
        }

        $that->processTemplate($tpl);
    }

    private function _getAdressForm() {
        $that =& $this->baseObject;
        $address_id = $that->request->get['address_id'];
        $customer_id = $that->request->get['customer_id'];
        $that->load->model('sale/taxid_option');
        $this->data['token'] = $that->session->data['token'];
        $this->data['error'] = $that->session->data['field_errors'];
        unset($that->session->data['field_errors']);
        $that->document->initBreadcrumb([
            'href' => $that->html->getHomeURL(),
            'text' => $that->language->get('text_home'),
            'separator' => false
        ]);

        $that->document->addBreadcrumb([
            'href' => $that->html->getSecureURL('sale/customer'),
            'text' => $that->language->get('heading_title'),
            'current' => true
        ]);

        $this->data['addresses'] = [];

        if (has_value($customer_id)) {
            $customer_info = $that->model_sale_customer->getCustomer($customer_id);
            $this->data['button_orders_count'] = $that->html->buildElement(
                [
                    'type' => 'button',
                    'name' => 'view orders',
                    'text' => $that->language->get('text_order') . ': ' . $customer_info['orders_count'],
                    'style' => 'button2',
                    'href' => $that->html->getSecureURL('sale/order', '&customer_id=' . $customer_id),
                    'title' => $that->language->get('text_view') . ' ' . $that->language->get('tab_history')
                ]
            );
            $this->data['addresses'] = $that->model_sale_taxid_option->getAddressesByCustomerId($customer_id);
        }

        //current edited address
        $current_address = [];
        if ($this->data['addresses']) {
            foreach ($this->data['addresses'] as &$a) {
                $a['href'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $a['address_id']);
                $a['title'] = $a['address_1'] . ' ' . $a['address_2'];
                //mark default address
                if ($customer_info['address_id'] == $a['address_id']) {
                    $a['default'] = 1;
                }
                if ($address_id == $a['address_id']) {
                    $current_address = $a;
                    $this->data['current_address'] = $a['title'];
                }
            }
        }
        if ($that->request->post) {
            $current_address = $that->request->post;
        }
        $that->loadModel('localisation/country');
        $this->data['countries'] = $that->model_localisation_country->getCountries();
        $this->data['customer_id'] = $customer_id;

        $this->data['add_address_url'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id);
        $this->data['category_products'] = $that->html->getSecureURL('product/product/category');
        $this->data['common_zone'] = $that->html->getSecureURL('common/zone');

        if (!has_value($address_id)) {
            //new address
            $this->data['action'] = $that->html->getSecureURL('sale/customer/insert_address', '&customer_id=' . $customer_id);
            $this->data['tab_customer_address'] = $that->language->get('text_add_address');
            $this->data['heading_title'] = $that->language->get('text_insert') . $that->language->get('text_customer');
            $this->data['update'] = '';
            $form = new AForm('ST');
        } else {
            //edit address
            $this->data['heading_title'] = $that->language->get('text_edit_address');
            $this->data['action'] = $that->html->getSecureURL('sale/customer/update_address', '&customer_id=' . $customer_id . '&address_id=' . $address_id);
            $this->data['update'] = $that->html->getSecureURL('listing_grid/taxid/update_field', '&id=' . $customer_id . '&address_id=' . $address_id);
            $this->data['tab_customer_address'] = $that->language->get('text_edit_address');
            $form = new AForm('HS');
        }

        $that->document->addBreadcrumb([
            'href' => $this->data['action'],
            'text' => $this->data['heading_title'],
            'current' => true
        ]);

        $this->data['tabs']['general'] = [
            'href' => $that->html->getSecureURL('sale/customer/update', '&customer_id=' . $customer_id),
            'text' => $that->language->get('tab_customer_details'),
            'active' => true
        ];

        if (has_value($customer_id)) {
            $this->data['tabs'][] = [
                'href' => $that->html->getSecureURL('sale/customer_transaction', '&customer_id=' . $customer_id),
                'text' => $that->language->get('tab_transactions')
            ];
        }

        $this->data['actas'] = $that->html->buildElement([
            'type' => 'button',
            'text' => $that->language->get('button_actas'),
            'href' => $that->html->getSecureURL('sale/customer/actonbehalf', '&customer_id=' . $customer_id),
            'target' => 'new'
        ]);

        $form->setForm([
            'form_name' => 'cgFrm',
            'update' => $this->data['update'],
        ]);

        $this->data['form']['id'] = 'cgFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml([
            'type' => 'form',
            'name' => 'cgFrm',
            'attr' => 'data-confirm-exit="true" class="form-horizontal"',
            'action' => $this->data['action'],
        ]);
        $this->data['form']['submit'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'submit',
            'text' => $that->language->get('button_save')
        ]);
        $this->data['form']['reset'] = $form->getFieldHtml([
            'type' => 'button',
            'name' => 'reset',
            'text' => $that->language->get('button_reset')
        ]);

        foreach ($current_address as $name => $value) {
            $this->data['address'][$name] = $value;
        }

        $this->data['section'] = 'address';

        $that->view->assign('help_url', $that->gen_help_url('customer_edit'));
        $that->loadModel('sale/customer_transaction');
        $balance = $that->model_sale_customer_transaction->getBalance($customer_id);

        $this->data['balance'] = $that->language->get('text_balance') . ' ' . $that->currency->format($balance, $that->config->get('config_currency'));

        //note: Only allow to delete or change if not default
        if (!$current_address['default']) {
            if (has_value($address_id)) {
                $this->data['form']['delete'] = $form->getFieldHtml([
                    'type' => 'button',
                    'name' => 'delete',
                    'href' => $that->html->getSecureURL('sale/customer/delete_address',
                        '&customer_id=' . $customer_id . '&address_id=' . $address_id),
                    'text' => $that->language->get('button_delete')
                ]);
            }

            $this->data['form']['fields']['address']['default'] = $form->getFieldHtml(['type' => 'checkbox',
                'name' => 'default',
                'value' => $current_address['default'],
                'style' => 'btn_switch']);
        }
        foreach ($this->address_fields as $name => $desc) {
            if ($name === 'company') {
                $fld_array = [
                    'type' => $desc['type'],
                    'name' => $name,
                    'value' => $this->data['address'][$name],
                    'placeholder' => $that->config->get('company_placeholder'),
                    'required' => ($that->config->get('company_option_mandatory_status') === '1') ? true : false
                ];
            } elseif ($name === 'taxid') {
                $fld_array = [
                    'type' => $desc['type'],
                    'name' => $name,
                    'value' => $this->data['address'][$name],
                    'placeholder' => $that->config->get('taxid_placeholder'),
                    'required' => ($that->config->get('taxid_option_mandatory_status') === '1') ? true : false
                ];
            } else {
                $fld_array = [
                    'type' => $desc['type'],
                    'name' => $name,
                    'value' => $this->data['address'][$name],
                    'required' => $desc['required']
                ];
            }
            if ($desc['type'] === 'zones') {
                $fld_array['submit_mode'] = 'id';
                $fld_array['zone_name'] = $this->data['address']['zone'];
                $fld_array['zone_value'] = $this->data['address']['zone_id'];
            }
            $this->data['form']['fields']['address'][$name] = $form->getFieldHtml($fld_array);
        }

        $that->view->batchAssign($this->data);
        $that->processTemplate('pages/sale/customer_form.tpl');
    }

    /**
     * @param array $data
     * @param string $sf
     * @param string type
     * @return array|bool
     */
    private function _validateCustomerAddress($data, $sf, $type='') {
        $errors = [];
        $that =& $this->baseObject;

        if ($sf === '0') {
            $that->loadLanguage('sale/customer');
            $that->loadLanguage('taxid_option/taxid_option');
        } elseif ($sf === '1') {
            $that->loadLanguage('account/address');
            $that->loadLanguage('account/taxid_option');
        }
        if (mb_strlen($data['firstname']) < 1 || mb_strlen($data['firstname']) > 32) {
            $errors['firstname'] = $that->language->get('error_firstname');
        }

        if (mb_strlen($data['lastname']) < 1 || mb_strlen($data['lastname']) > 32) {
            $errors['lastname'] = $that->language->get('error_lastname');
        }

        if ($that->config->get('company_option_mandatory_status')) {
            if (mb_strlen($data['company']) < 1) {
                $errors['company'] = $that->language->get('company_error');
            }
        }
        if ($type==='payment' || $sf==='0') {
            if ($that->config->get('taxid_option_mandatory_status')) {
                if (mb_strlen($data['taxid']) < 1  && strtolower($data['taxid']) !== 'na' && strtolower($data['taxid']) !== 'none' ) {
                    $errors['taxid'] = $that->language->get('taxid_error');
                }
            }
        }

        if ($sf==='1') {
            if (mb_strlen($data['postcode']) < 3 || mb_strlen($data['postcode']) > 10) {
                $errors['postcode'] = $that->language->get('error_postcode');
            }
        }
        if (mb_strlen($data['address_1']) < 1) {
            $errors['address_1'] = $that->language->get('error_address_1');
        }
        if (mb_strlen($data['city']) < 1) {
            $errors['city'] = $that->language->get('error_city');
        }

        if (empty($data['country_id']) || $data['country_id'] === 'FALSE') {
            $errors['country_id'] = $that->language->get('error_country');
        }

        if ($sf === '0') {
            if (!$data['zone_id']) {
                if($data['country_id']){
                    /** @var ModelLocalisationZone $mdl */
                    $mdl = $that->loadModel('localisation/zone');
                    $zones = $mdl->getZonesByCountryId($data['country_id']);
                    if($zones){
                        $errors['zone_id'] = $that->language->get('error_zone');
                    }
                }else {
                    $errors['zone_id'] = $that->language->get('error_zone');
                }
            }
        } else {
            if ($data['zone_id'] == 'FALSE') {
                $errors['zone'] = $that->language->get('error_zone');
            }

            if (!$errors && (int) $data['zone_id'] !== 0) {
                $sql = "SELECT * 
                    FROM ".$that->db->table("zones")."
                    WHERE country_id = '".(int) $data['country_id']."'
                        AND zone_id = '".(int) $data['zone_id']."';";
                $result = $that->db->query($sql);
                if (!$result->num_rows) {
                    $errors['zone'] = $that->language->get('error_zone');
                }
            }
        }

        if (empty($data['zone_id']) || $data['zone_id'] === 'FALSE') {
            if ($sf === '0') {
                $errors['zone_id'] = $that->language->get('error_zone');
            } else {
                $errors['zone'] = $that->language->get('error_zone');
            }
        }

        if ($sf === '0') {
            if (sizeof((array)$errors)) {
                $errors['warning'] = implode('<br>', $errors);
            }
        } else {
            if (sizeof((array)$errors)) {
                $errors['warning'] = $that->language->get('gen_data_entry_error');
            }
        }
        return $errors;
    }

    /**
     * @param $data
     * @param null $customer_id
     * @return bool
     */
    private function _validateForm($data, $customer_id = null) {
        $that =& $this->baseObject;
        $that->load->language('sale/customer');
        $that->load->language('taxid_option/taxid_option');

        $login_name_pattern = '/^[\w._-]+$/i';
        if ((mb_strlen($data['loginname']) < 5 || mb_strlen($data['loginname']) > 64)
            || (!preg_match($login_name_pattern, $data['loginname']) && $that->config->get('prevent_email_as_login'))
        ) {
            $errors['loginname'] = $that->language->get('error_loginname');
            //check uniqunes of login name
        } else if (!$that->model_sale_customer->is_unique_loginname($data['loginname'], $customer_id)) {
            $errors['loginname'] = $that->language->get('error_loginname_notunique');
        }


        if (mb_strlen($data['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $data['email'])) {
            $errors['email'] = $that->language->get('error_email');
        } else {
            //check for customer with given email
            $exists = $that->model_sale_customer->getCustomersByEmails([$data['email']]);
            foreach ($exists as $item) {
                if ($customer_id === null) {
                    $errors['email'] .= $that->language->get('error_email_exists');
                    break;
                }
                if ($customer_id == $item['customer_id']) {
                    continue;
                } else {
                    $errors['email'] .= $that->language->get('error_email_exists');
                    break;
                }
            }
        }

        if ($that->config->get('telephone_option_mandatory_status') === '1') {
            $pattern = $that->config->get('config_phone_validation_pattern') ?: '/^[0-9]{3,32}$/';
            $phone = $data['telephone'] ?? '';
            if (empty($phone)
                && (mb_strlen($phone) < 3
                    || mb_strlen($phone) > 32
                    || !preg_match($pattern, $phone))
            ) {
                $errors['telephone'] = $that->language->get('telephone_error');
            }
        }

        if ($that->config->get('fax_option_mandatory_status') === '1') {
            if (empty($data['fax']) || (mb_strlen($data['fax']) > 32 && strtolower($data['fax']) != 'na' && strtolower($data['fax']) != 'none')) {
                $errors['fax'] = $that->language->get('fax_error');
            }
        }

        if (($data['password']) || (!isset($that->request->get['customer_id']))) {
            if (mb_strlen($data['password']) < 4) {
                $errors['password'] = $that->language->get('error_password');
            }

            if (!$errors['password'] && $data['password'] != $data['password_confirm']) {
                $errors['password'] = $that->language->get('error_confirm');
            }
        }

        if (mb_strlen($data['firstname']) < 1 || mb_strlen($data['firstname']) > 32) {
            $errors['firstname'] = $that->language->get('error_firstname');
        }

        if (mb_strlen($data['lastname']) < 1 || mb_strlen($data['lastname']) > 32) {
            $errors['lastname'] = $that->language->get('error_lastname');
        }

        $fields = ['registration', 'bank_name', 'bank_address', 'iban', 'swift'];
        foreach ($fields as $k) {
            if ($that->config->get($k . '_option_mandatory_status') === '1') {
                if ($data[$k]==='iban' || $data[$k]==='swift') {
                    if (empty($data[$k]) && strtolower($data[$k]) != 'na' && strtolower($data[$k]) != 'none') {
                        $errors[$k] = $that->language->get($k . '_error');
                    }
                } elseif (empty($data[$k])) {
                    $errors[$k] = $that->language->get($k . '_error');
                }
            }
        }

        //validate IM URIs
        //get only active IM drivers
        $im_drivers = $that->im->getIMDriverObjects();
        if ($im_drivers) {
            foreach ($im_drivers as $protocol => $driver_obj) {
                /**
                 * @var AMailIM $driver_obj
                 */
                if (!is_object($driver_obj) || $protocol === 'email') {
                    continue;
                }
                $result = $driver_obj->validateURI($data[$protocol]);
                if (!$result) {
                    $errors[$protocol] = implode('<br>', $driver_obj->errors);
                }
            }
        }

        if (sizeof((array)$errors)) {
            $errors['warning'] = implode('<br>', $errors);
        }
        return $errors;
    }

    /**
     * @param $data_array
     * @param string $type
     * @param array $locate
     * @return mixed
     */
    private function getFormattedAddress($data_array, $type = '', $locate=[]) {
        $that =& $this->baseObject;
        $format = '';
        $data_array = (array)$data_array;
        $that->load->model('extension/taxid_option_verify');
        $ups_plus_status=$that->model_extension_taxid_option_verify->verifyUpsPlus();
        $vat=$registration=$bankName=$bankAddress=$iban=$swift='';
        if ($ups_plus_status) {
            $that->load->language('ups_integration_plus/ups_integration_plus');
        }

        if (strtolower($data_array['company']) != 'none' && strtolower($data_array['company']) != 'na' && $data_array['company'] != '') {
            $company = ' {company} ';
        }
        $taxShow = $that->config->get('taxid_show_order_confirm');
        if ($taxShow === '1' && strtolower($data_array['taxid']) !== 'none' && strtolower($data_array['taxid']) !== 'na' && $data_array['taxid'] !== '') {
            $vat = $that->config->get('taxid_order_confirm') . ' {taxid}'. "\n";
        }

        $registrationShow = $that->config->get('registration_show_order_confirm');
        if ($registrationShow === '1' && isset($data_array['registration']) && strtolower($data_array['registration']) !== 'none' && strtolower($data_array['registration']) !== 'na' && $data_array['registration'] !== '') {
            $registration = $that->config->get('registration_order_confirm') . ' {registration}'. "\n";
        }
        $bankNameShow = $that->config->get('bank_name_show_order_confirm');
        if ($bankNameShow === '1' && isset($data_array['bank_name']) && strtolower($data_array['bank_name']) !== 'none' && strtolower($data_array['bank_name']) !== 'na' && $data_array['bank_name'] !== '') {
            $bankName = $that->config->get('bank_name_order_confirm') . ' {bank_name}'. "\n";
        }
        $bankAddressShow = $that->config->get('bank_address_show_order_confirm');
        if ($bankAddressShow === '1' && isset($data_array['bank_address']) && strtolower($data_array['bank_address']) !== 'none' && strtolower($data_array['bank_address']) !== 'na' && $data_array['bank_address'] !== '') {
            $bankAddress = $that->config->get('bank_address_order_confirm') . ' {bank_address}'. "\n";
        }
        $ibanShow = $that->config->get('iban_show_order_confirm');
        if ($ibanShow === '1' && isset($data_array['iban']) && strtolower($data_array['iban']) !== 'none' && strtolower($data_array['iban']) !== 'na' && $data_array['iban'] !== '') {
            $iban = $that->config->get('iban_order_confirm') . ' {iban}'. "\n";
        }
        $swiftShow = $that->config->get('swift_show_order_confirm');
        if ($swiftShow === '1' && isset($data_array['swift']) && strtolower($data_array['swift']) !== 'none' && strtolower($data_array['swift']) !== 'na' && $data_array['swift'] !== '') {
            $swift = $that->config->get('swift_order_confirm') . ' {swift}';
        }
        // Set default format
        if ($type === 'payment') {
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . $vat  . '{address_1}' . "\n" . '{address_2}' . "\n"
                . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}' . "\n" . $registration  . $bankName . $bankAddress . $iban . $swift;
        } else {
            if ($data_array['location_phone'] !== '' && !empty($data_array['location_phone']) && $type !== 'payment') {
                $location_phone="\n" .$that->language->get('text_ups_plus_telephone') . ' {location_phone}';
            } else {
                $location_phone="";
            }
            $format = '{firstname} {lastname}' . "\n" . $company . "\n" . '{address_1}' . "\n" . '{address_2}' . "\n" . '{city} {postcode}' . "\n" . '{zone}' . "\n" . '{country}'.$location_phone;
        }
        //Set default variable to be set for address based on the data

        if ( sizeof( $locate ) <= 0 ) {
            $locate = [];
            foreach ( $data_array as $key => $value ) {
                $locate[] = "{" . $key . "}";
            }
        }
        return str_replace(["\r\n", "\r", "\n"], '<br />', preg_replace([
            "/\s\s+/",
            "/\r\r+/",
            "/\n\n+/"
        ], '<br />', trim(str_replace($locate, $data_array, $format))));
    }

    private function _validate() {
        $that =& $this->baseObject;
        if (!(int)$that->request->post['order_id']){
            $this->error['order_id'] = $that->language->get('error_order_id');
        }

        if (mb_strlen($that->request->post['email']) > 96 || !preg_match(EMAIL_REGEX_PATTERN, $that->request->post['email'])){
            $this->error['email'] = $that->language->get('error_email');
        }

        $that->extensions->hk_ValidateData($this);

        return !$this->error ? true : false;

    }

    private function getList() {
        $that =& $this->baseObject;

        $that->view->assign('error_warning', $this->error['warning']);
        $that->view->assign('success', $that->session->data['success']);

        $addresses = [];
        $that->load->model('account/taxid_option');
        $results = $that->model_account_taxid_option->getAddresses();
         foreach ($results as $result) {
            $formated_address = $this->getFormattedAddress($result, 'payment');

            $edit = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_edit'),
                'style' => 'button btn-primary',
                'icon' => 'fa-edit fa',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/update', '&address_id=' . $result['address_id']) . '\'" ']);
            $delete = HtmlElementFactory::create([
                'type' => 'button',
                'text' => $that->language->get('button_delete'),
                'style' => '',
                'icon' => 'fa fa-remove',
                'attr' => 'onclick="location = \'' . $that->html->getSecureURL('account/address/delete', '&address_id=' . $result['address_id']) . '\'" ']);

            $addresses[] = [
                'address_id' => $result['address_id'],
                'address' => $formated_address,
                'button_edit' => $edit,
                'button_delete' => $delete,
                'default' => $that->customer->getAddressId() == $result['address_id'] ? true : false,
            ];
        }

        $that->view->assign('addresses', $addresses);

        $that->view->assign('insert', $that->html->getSecureURL('account/address/insert'));

        $insert = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'insert',
            'text' => $that->language->get('button_new_address'),
            'icon' => 'fa fa-plus',
            'style' => 'button']);
        $that->view->assign('button_insert', $insert);

        $back = HtmlElementFactory::create([
            'type' => 'button',
            'name' => 'back',
            'text' => $that->language->get('button_back'),
            'icon' => 'fa fa-arrow-left',
            'style' => 'button']);
        $that->view->assign('button_back', $back);
        $that->view->assign('back', $that->html->getSecureURL('account/account'));

        $that->processTemplate('pages/account/addresses.tpl');
    }

    public function onControllerCommonHead_UpdateData() {
        $that =& $this->baseObject;
        if ($this->baseObject_method === 'main') {
            if (IS_ADMIN) {
                $latestVersion = $this->getVersion();
                if ($latestVersion) {
                    $that->load->language('taxid_option/taxid_option');
                    $that->load->model('extension/taxid_option_updater');
                    $total = $that->model_extension_taxid_option_updater->getTotalMsgIds();
                    if ($total > '0') {
                        $msg_ids = $that->model_extension_taxid_option_updater->getMsgIdsByCartVersions();
                        foreach ($msg_ids as $msg_id) {
                            $that->messages->deleteMessage($msg_id['msg_id']);
                            $that->model_extension_taxid_option_updater->deleteMsgID($msg_id['msg_id']);
                        }
                    }
                    $msg_title = str_replace('[new_version]', $latestVersion, $that->language->get('text_new_taxid_option_version_title'));
                    $msg = str_replace('[version_number]', str_replace('.', '-', $latestVersion), $that->language->get('text_new_taxid_option_version_description'));
                    $that->messages->saveNotice($msg_title, $msg);
                    $msg_info = $that->messages->getLikeMessage($msg_title);
                    $that->model_extension_taxid_option_updater->saveMessageId($msg_info['msg_id'], $latestVersion);
                }
            }
        }
    }

    private function getVersion() {
        $that =& $this->baseObject;
        $latestVersion = '';
        $license_key = $that->config->get('taxid_option_license_code');
        if ($license_key) {
            $valid = false;
            $exist = $that->db->query("SHOW TABLES LIKE '" . $that->db->table('taxid_option_license_info') . "'");
            if ($exist->num_rows === 1) {
                $that->load->model('extension/taxid_option_license_info');
                $store_id = $that->model_extension_taxid_option_license_info->getStoreId();

                $license_key = $that->model_extension_taxid_option_license_info->getLicenseCode($store_id);
                $license_info = $that->model_extension_taxid_option_license_info->getLicenseData($store_id);
                $path_to_phpseclib = DIR_SYSTEM . "lib/vendor/phpseclib/phpseclib/phpseclib/";
                $license = new License($path_to_phpseclib);
                $license_manager = $license->getManager();
                $license_manager->setKeys($license_key, $license_info['public_key'], $this->shared_secret);
                $ttl = 1209600;
                $validate = $license_manager->validate($license_info['license_data'], $ttl);

                if ($validate['status'] === 'valid') {
                    if (stripos($license_key, 'rent-') !== false || stripos($license_key, 'mc-') !== false) {
                        $valid = true;
                    } elseif (stripos($license_key, 'own-') !== false) {
                        $today = date("Y-m-d H:i:s");
                        $support_date = date('Y-m-d H:i:s', strtotime($validate['updates']));
                        if ($today <= $support_date) {
                            $valid = true;
                        }
                    }
                }
            }
            if ($valid) {
                $that->load->language('taxid_option/taxid_option');
                $getVersions = taxidOptionUpdaterGetAllVersions();
                $that->load->model('extension/taxid_option_updater');
                $current_version = $that->model_extension_taxid_option_updater->getCurrentVersion();
                if ($getVersions['notification_case'] !== 'notification_product_no_versions') {
                    $versions = $getVersions['notification_data']['product_versions'];
                    if ($versions) {
                        $latestVersions = [];
                        foreach ($versions as $version) {
                            if (strpos($version['version_number'], VERSION) !== false) {
                                $latestVersions[] = $version['version_number'];
                            }
                        }
                        usort($latestVersions, 'version_compare');
                        $latestVersion = end($latestVersions);
                        if (version_compare($current_version, $latestVersion, '<') === true) {
                            $msg_ids = $that->model_extension_taxid_option_updater->getMsgIdsByCurrentCartVersion();
                            foreach ($msg_ids as $msg_id) {
                                $that->messages->deleteMessage($msg_id['msg_id']);
                                $that->model_extension_taxid_option_updater->deleteMsgID($msg_id['msg_id']);
                            }
                            return $latestVersion;
                        }
                    }
                } else {
                    return '';
                }
            } else {
                return '';
            }
        }
    }
}