<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ModelSuperMenuSuperMenu extends Model
{
    public function editSuperMenu($super_menu_id, $data)
    {
        $super_menu_id = (int) $super_menu_id;
        $language_id = (int) $this->language->getContentLanguageID();

        if (isset($data['start_date'])) {
            $data['start_date'] = $data['start_date'] ? dateDisplay2ISO($data['start_date'], $this->language->get('date_format_short')) : date('Y-m-d');
        }
        if (isset($data['end_date'])) {
            $data['end_date'] = $data['end_date'] ? dateDisplay2ISO($data['end_date'], $this->language->get('date_format_short')) : '';
        }

        $update_arr = array();
        $allowed_fields = array('name', 'description', 'description_short');
        foreach ($allowed_fields as $field_name) {
            if (isset($data[$field_name])) {
                $update_arr[$field_name] = $data[$field_name];
            }
        }

        if ($update_arr) {
            $update_arr['date_added'] = dateInt2ISO(time());
            $this->language->replaceDescriptions('super_menu_descriptions',
                    array('super_menu_id' => (int) $super_menu_id),
                    array($language_id => $update_arr));
        }

        $allowed_fields = array(
    'items' => '',
    'start_date' => '',
    'end_date' => '',
    'skin' => '',
    'maxwidth' => '',
    'drop_slide' => '',
    'viewtext' => '',
    'css' => '',
    'hide' => 'int',
    'moretext' => '',
    'mname' => '',
    'mobminwidth' => '',
    'topfont' => '',
    'topsize' => '',
    'dropfont' => '',
    'dropsize' => '',
    'dropsize2' => '',
    'topcolor' => '',
    'topbgcolor' => '',
    'toppattern' => '',
    'topborder' => '',
    'topitemcolor' => '',
    'topshadcolor' => '',
    'tophovcolor' => '',
    'dropbggrad1' => '',
    'dropbggrad2' => '',
    'dropbgtype' => '',
    'dropitemcolor' => '',
    'dropshadcolor' => '',
    'drophovcolor' => '',
    'droptitlecolor' => '',
    'droptitlehovcolor' => '',
    'pricecolor' => '',
    'flycolor' => '',
    'flybgcolor' => '',
    'round' => 'int',
);
        $sql = 'UPDATE `'.$this->db->table('super_menus').'`
				SET ';
        $tmp = array();
        foreach (array_keys($allowed_fields) as $field_name) {
            if (isset($data[$field_name])) {
                $data[$field_name] = in_array($field_name, array('items')) ? serialize($data[$field_name]) : $data[$field_name];
                $tmp[] = '`'.$field_name."` = '".('int' == $allowed_fields[$field_name] ? (int) $data[$field_name] : $this->db->escape($data[$field_name]))."'\n";
            }
        }
        $sql .= implode(', ', $tmp);
        $sql .= " WHERE super_menu_id='".$super_menu_id."'";
        if ($tmp) {
            $this->db->query($sql);
        }
        $this->cache->delete('super_menus');
    }

    public function getSuperMenu($super_menu_id, $language_id = '')
    {
        $super_menu_id = (int) $super_menu_id;
        $language_id = (int) $language_id;
        if (!$language_id) {
            $language_id = (int) $this->language->getContentLanguageID();
        }

        $sql = 'SELECT  pd.*, p.*
				FROM `'.$this->db->table('super_menus').'` p
				LEFT JOIN `'.$this->db->table('super_menu_descriptions')."` pd
					ON (pd.super_menu_id = p.super_menu_id AND pd.language_id = '".$language_id."')
				WHERE p.super_menu_id='".$super_menu_id."'";
        $result = $this->db->query($sql);

        return $result->row;
    }
}
