<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

/**
 * @property ModelSuperMenuSuperMenu $model_super_menu_super_menu
 */
class ControllerPagesSuperMenuSuperMenu extends AController
{
    public $data = array();
    private $error = array();

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('super_menu/super_menu');

        $this->document->setTitle($this->language->get('super_menu_name'));
        $this->view->assign('help_url', $this->gen_help_url('super_menu_super_menu'));

        $this->document->initBreadcrumb(array(
                'href' => $this->html->getSecureURL('index/home'),
                'text' => $this->language->get('text_home'),
                'separator' => false,
        ));
        $this->document->addBreadcrumb(array(
                'href' => $this->html->getSecureURL('super_menu/super_menu'),
                'text' => $this->language->get('super_menu_name'),
                'separator' => ' :: ',
                'current' => true,
        ));

        $this->view->assign('error_warning', $this->error['warning']);
        $this->view->assign('success', $this->session->data['success']);
        $this->view->assign('heading_title', $this->language->get('super_menu_name'));
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->setTitle($this->language->get('super_menu_name'));

        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function edit()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);
        $this->loadLanguage('super_menu/super_menu');

        $this->document->setTitle($this->language->get('super_menu_name'));
        $this->data['heading_title'] = $this->language->get('super_menu_name');
        $super_menu_id = (int) $this->request->get['super_menu_id'];

        //need to reset exclude list for multivalue list which can be set by other multivalue lists (for ex. form of downloads for products)
        $this->session->data['multivalue_excludes'] = array();

        $this->loadModel('super_menu/super_menu');
        // saving
        if ($this->request->is_POST()) {//&& $this->_validateForm() && $super_menu_id) {
            if (isset($this->request->post['items']['items'])) {
                foreach ($this->request->post['items']['items'] as $k => $rule) {
                }
            }

            if ('items' == $this->request->get['tab'] && !has_value($this->request->post['items']['items'])) {
                $this->session->data['warning'] = $this->language->get('super_menu_error_empty_items');
            } else {
                $this->model_super_menu_super_menu->editSuperMenu($super_menu_id, $this->request->post);
                $this->session->data['success'] = $this->language->get('super_menu_text_success_edit');
            }

            $this->redirect($this->html->getSecureURL('super_menu/super_menu/edit', '&tab='.$this->request->get['tab'].'&super_menu_id='.$super_menu_id));
        }

        $info = $this->model_super_menu_super_menu->getSuperMenu($super_menu_id);
        foreach ($info as $k => $v) {
            $this->data[$k] = $v;
        }

        $this->data['tabs']['general'] = array(
                'href' => $this->html->getSecureURL('super_menu/super_menu/edit', '&tab=general&super_menu_id='.$super_menu_id),
                'text' => $this->language->get('super_menu_settings'),
                'active' => '', );
        $this->data['tabs']['items'] = array(
                'href' => $this->html->getSecureURL('super_menu/super_menu/edit', '&tab=items&super_menu_id='.$super_menu_id),
                'text' => $this->language->get('super_menu_items'),
                'active' => '', );

        switch ($this->request->get['tab']) {
            case 'items':
                $this->data['tabs']['items']['active'] = true;
                $this->data['items'] = $this->data['items'] ? unserialize($this->data['items']) : array();
                $this->_getFormItems();
                break;
            default:
                $this->data['tabs']['general']['active'] = true;
                $this->_createSettingsForm();
                break;
        }

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }

    public function delete()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $super_menu_id = (int) $this->request->get['super_menu_id'];
        $this->loadModel('super_menu/super_menu');
        $this->model_super_menu_super_menu->deleteSuperMenu($super_menu_id);
        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
        $this->redirect($this->html->getSecureURL('super_menu/super_menu'));
    }

    private function _createSettingsForm()
    {
        if (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data['error_warning'] = '';
        }

        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(array('href' => $this->html->getSecureURL('index/home'),
                                              'text' => $this->language->get('text_home'),
                                              'separator' => false, ));
        $this->document->addBreadcrumb(array('href' => $this->html->getSecureURL('super_menu/super_menu'),
                                             'text' => $this->language->get('super_menu_name'),
                                             'separator' => ' :: ', ));

        $this->data['cancel_href'] = $this->html->getSecureURL('super_menu/super_menu');
        if (!isset($this->request->get['super_menu_id'])) {
            $this->data['action'] = $this->html->getSecureURL('super_menu/super_menu/insert', '&tab=general');
            $this->data['form_title'] = $this->language->get('super_menu_text_create');
            $this->data['heading_title'] = $this->language->get('super_menu_text_create');
            $this->data['update'] = '';
            $form = new AForm('ST');
        } else {
            $this->data['action'] = $this->html->getSecureURL('super_menu/super_menu/edit', '&tab=general&super_menu_id='.$this->request->get['super_menu_id']);
            $this->data['form_title'] = $this->language->get('text_edit').' '.$this->data['name'];
            $this->data['update'] = $this->html->getSecureURL('itemslist/super_menu/update_field', '&super_menu_id='.$this->request->get['super_menu_id']);
            $form = new AForm('HS');
        }

        $this->document->addBreadcrumb(array('href' => $this->data['action'],
                                             'text' => $this->data['form_title'],
                                             'separator' => ' :: ',
                                             'current' => true,
        ));

        $form->setForm(
            array(
                        'form_name' => 'super_menuFrm',
                        'update' => $this->data['update'],
                )
        );

        $this->data['form']['form_open'] = $form->getFieldHtml(
            array('type' => 'form',
                'name' => 'super_menuFrm',
                        'action' => $this->data['action'],
                'attr' => 'data-confirm-exit="true" class="aform form-horizontal"', )
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            array(
                        'type' => 'button',
                        'name' => 'submit',
                        'text' => $this->language->get('button_save'),
                )
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            array(
                        'type' => 'button',
                        'name' => 'cancel',
                        'text' => $this->language->get('button_cancel'),
                )
        );
        $this->data['form_title'] = $this->language->get('super_menu_settings');

        $this->data['form']['fields']['name']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'name',
                        'value' => $this->data['name'],
                        'attr' => ' readonly ',
                        'required' => false, )
        );
        $this->data['form']['fields']['name']['text'] = $this->language->get('config_super_menu_name');

        /*$this->data['form']['fields']['skin']['field'] = $form->getFieldHtml(
                array(
                        'type'  => 'selectbox',
                        'name'  => 'skin',
                        'value' => (has_value($this->data['skin']) ? $this->data['skin'] : '' ),
                        'attr' => ' readonly ',
                        'options' => array (
                '' => $this->language->get('text_select'),
                0  => $this->language->get('config_super_menu_skin_0'),
                1  => $this->language->get('config_super_menu_skin_1'),
            ),
            'style' => 'small-field',
                ));
        $this->data['form']['fields']['skin']['text'] = $this->language->get('config_super_menu_skin');*/

        $this->data['form']['fields']['maxwidth']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'maxwidth',
                        'value' => $this->data['maxwidth'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['maxwidth']['text'] = $this->language->get('config_super_menu_maxwidth');

        $this->data['form']['fields']['drop_slide']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'selectbox',
                        'name' => 'drop_slide',
                        'value' => (has_value($this->data['drop_slide']) ? $this->data['drop_slide'] : ''),
                        'options' => array(
                                '' => $this->language->get('text_select'),
                                0 => $this->language->get('config_super_menu_drop_slide_0'),
                                'bounce' => $this->language->get('config_super_menu_drop_slide_1'),
                                'fly' => $this->language->get('config_super_menu_drop_slide_2'),
                                'radial' => $this->language->get('config_super_menu_drop_slide_3'),
                                'pop' => $this->language->get('config_super_menu_drop_slide_4'),
                                'winding' => $this->language->get('config_super_menu_drop_slide_5'),
                                'shield' => $this->language->get('config_super_menu_drop_slide_6'),
                                'helix' => $this->language->get('config_super_menu_drop_slide_7'),
                                'fan' => $this->language->get('config_super_menu_drop_slide_8'),
                                'zipper' => $this->language->get('config_super_menu_drop_slide_9'),
                                'fence' => $this->language->get('config_super_menu_drop_slide_10'),
                        ),
                        'style' => 'small-field',
                )
        );
        $this->data['form']['fields']['drop_slide']['text'] = $this->language->get('config_super_menu_drop_slide');

        $this->data['form']['fields']['css']['field'] = $form->getFieldHtml(array('type' => 'textarea',
             'name' => 'css',
             'value' => $this->data['css'],
        ));
        $this->data['form']['fields']['css']['text'] = $this->language->get('config_super_menu_css');

        $this->data['form']['fields']['hide']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'checkbox',
                        'name' => 'hide',
                        'value' => $this->data['hide'],
                        'style' => 'btn_switch',
                )
        );
        $this->data['form']['fields']['hide']['text'] = $this->language->get('config_super_menu_hide');

        $this->data['form']['fields']['viewtext']['field'] = $form->getFieldHtml(
            array(
                                'type' => 'input',
                                'name' => 'viewtext',
                                'value' => $this->data['viewtext'],
                                'style' => 'small-field',
                                'required' => true, )
        );
        $this->data['form']['fields']['viewtext']['text'] = $this->language->get('config_super_menu_viewtext');

        /*$this->data['form']['fields']['moretext']['field'] = $form->getFieldHtml(
                array(
                        'type'     => 'input',
                        'name'     => 'moretext',
                        'value'    => $this->data['moretext'],
                        'style' => 'small-field',
                        'required' => true));
        $this->data['form']['fields']['moretext']['text'] = $this->language->get('config_super_menu_moretext');*/

        $this->data['form']['fields']['mname']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'mname',
                        'value' => $this->data['mname'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['mname']['text'] = $this->language->get('config_super_menu_mname');

        $this->data['form']['fields']['mobminwidth']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'mobminwidth',
                        'value' => $this->data['mobminwidth'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['mobminwidth']['text'] = $this->language->get('config_super_menu_mobminwidth');

        $this->data['form']['fields']['topfont']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topfont',
                        'value' => $this->data['topfont'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['topfont']['text'] = $this->language->get('config_super_menu_topfont');

        $this->data['form']['fields']['topsize']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topsize',
                        'value' => $this->data['topsize'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['topsize']['text'] = $this->language->get('config_super_menu_topsize');

        $this->data['form']['fields']['dropfont']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropfont',
                        'value' => $this->data['dropfont'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropfont']['text'] = $this->language->get('config_super_menu_dropfont');

        $this->data['form']['fields']['dropsize']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropsize',
                        'value' => $this->data['dropsize'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropsize']['text'] = $this->language->get('config_super_menu_dropsize');

        $this->data['form']['fields']['dropsize2']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropsize2',
                        'value' => $this->data['dropsize2'],
                        'style' => 'small-field',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropsize2']['text'] = $this->language->get('config_super_menu_dropsize2');

        $this->data['form']['fields']['topcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topcolor',
                        'value' => $this->data['topcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['topcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['topcolor']['text'] = $this->language->get('config_super_menu_topcolor');

        $this->data['form']['fields']['topbgcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topbgcolor',
                        'value' => $this->data['topbgcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['topbgcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['topbgcolor']['text'] = $this->language->get('config_super_menu_topbgcolor');

        $this->data['form']['fields']['toppattern']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'resource',
                        'name' => 'toppattern',
                        'value' => $this->data['toppattern'],
                        'resource_path' => htmlspecialchars($this->data['toppattern'], ENT_COMPAT, 'UTF-8'),
                        'resource_id' => $this->data['item_icon_rl_id'],
                        'rl_type' => 'image',
                        //'style' => 'small-field',
                        //'attr'     => ' maxlength="64" ',
                        //'required' => true
                    )
        );
        $this->data['form']['fields']['toppattern']['text'] = $this->language->get('config_super_menu_toppattern');

        //adds scripts for RL work
        $resources_scripts = $this->dispatch(
            'responses/common/resource_library/get_resources_scripts',
            array(
                        'object_name' => 'toppattern',
                        'object_id' => (int)$this->request->get['item_id'],
                        'types' => array('image'),
                        'onload' => true,
                        'mode' => 'single',
                )
        );

        $this->data['form']['fields']['topborder']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topborder',
                        'value' => $this->data['topborder'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['topborder'].'" ',
                        'required' => false, )
        );
        $this->data['form']['fields']['topborder']['text'] = $this->language->get('config_super_menu_topborder');

        $this->data['form']['fields']['topitemcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topitemcolor',
                        'value' => $this->data['topitemcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['topitemcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['topitemcolor']['text'] = $this->language->get('config_super_menu_topitemcolor');

        $this->data['form']['fields']['topshadcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'topshadcolor',
                        'value' => $this->data['topshadcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['topshadcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['topshadcolor']['text'] = $this->language->get('config_super_menu_topshadcolor');

        $this->data['form']['fields']['tophovcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'tophovcolor',
                        'value' => $this->data['tophovcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['tophovcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['tophovcolor']['text'] = $this->language->get('config_super_menu_tophovcolor');

        $this->data['form']['fields']['dropbggrad1']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropbggrad1',
                        'value' => $this->data['dropbggrad1'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['dropbggrad1'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropbggrad1']['text'] = $this->language->get('config_super_menu_dropbggrad1');

        $this->data['form']['fields']['dropbggrad2']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropbggrad2',
                        'value' => $this->data['dropbggrad2'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['dropbggrad2'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropbggrad2']['text'] = $this->language->get('config_super_menu_dropbggrad2');

        $this->data['form']['fields']['dropbgtype']['field'] = $form->getFieldHtml(
            array(
                    'type' => 'input',
                    'name' => 'dropbgtype',
                    'value' => $this->data['dropbgtype'],
                    'style' => 'small-field',
                    'required' => true, )
        );
        $this->data['form']['fields']['dropbgtype']['text'] = $this->language->get('config_super_menu_dropbgtype');

        $this->data['form']['fields']['round']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'checkbox',
                        'name' => 'round',
                        'value' => $this->data['round'],
                        'style' => 'btn_switch',
                )
        );
        $this->data['form']['fields']['round']['text'] = $this->language->get('config_super_menu_round');

        $this->data['form']['fields']['dropitemcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropitemcolor',
                        'value' => $this->data['dropitemcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['dropitemcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropitemcolor']['text'] = $this->language->get('config_super_menu_dropitemcolor');

        $this->data['form']['fields']['dropshadcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'dropshadcolor',
                        'value' => $this->data['dropshadcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['dropshadcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['dropshadcolor']['text'] = $this->language->get('config_super_menu_dropshadcolor');

        $this->data['form']['fields']['drophovcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'drophovcolor',
                        'value' => $this->data['drophovcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['drophovcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['drophovcolor']['text'] = $this->language->get('config_super_menu_drophovcolor');

        $this->data['form']['fields']['droptitlecolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'droptitlecolor',
                        'value' => $this->data['droptitlecolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['droptitlecolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['droptitlecolor']['text'] = $this->language->get('config_super_menu_droptitlecolor');

        $this->data['form']['fields']['pricecolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'pricecolor',
                        'value' => $this->data['pricecolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['pricecolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['pricecolor']['text'] = $this->language->get('config_super_menu_pricecolor');

        $this->data['form']['fields']['flycolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'flycolor',
                        'value' => $this->data['flycolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['flycolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['flycolor']['text'] = $this->language->get('config_super_menu_flycolor');

        $this->data['form']['fields']['flybgcolor']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'input',
                        'name' => 'flybgcolor',
                        'value' => $this->data['flybgcolor'],
                        'style' => 'small-field',
                        'attr' => ' id="colorSelector" maxlength="64" style="background-color:#'.$this->data['flybgcolor'].'" ',
                        'required' => true, )
        );
        $this->data['form']['fields']['flybgcolor']['text'] = $this->language->get('config_super_menu_flybgcolor');

        //end config fields
        $this->data['super_menu_id'] = $this->request->get['super_menu_id'] ? $this->request->get['super_menu_id'] : '-1';

        $this->data['subform_url'] = $this->html->getSecureURL('itemslist/super_menu/getsubform', '&super_menu_id='.$this->data['super_menu_id']);

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->assign('language_code', $this->session->data['language']);
        $this->view->assign('help_url', $this->gen_help_url('super_menu_edit'));
        $this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&object_name=super_menus&type=image&mode=url'));

        //$this->addChild('responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl');

        $this->view->assign('resources_scripts', $resources_scripts->dispatchGetOutput());

        $this->processTemplate('pages/super_menu/super_menu_form.tpl');
    }

    private function _getFormItems()
    {
        if (isset($this->session->data['warning'])) {
            $this->data['error_warning'] = $this->session->data['warning'];
            $this->session->data['warning'] = '';
        } else {
            $this->data['error_warning'] = '';
        }

        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }
        $this->document->initBreadcrumb(array('href' => $this->html->getSecureURL('index/home'),
                                              'text' => $this->language->get('text_home'),
                                              'separator' => false, ));
        $this->document->addBreadcrumb(array('href' => $this->html->getSecureURL('super_menu/super_menu'),
                                             'text' => $this->language->get('super_menu_name'),
                                             'separator' => ' :: ', ));

        $this->document->addStyle(
            array(
                        'href' => HTTPS_EXT.'super_menu/admin/view/default/css/super_menu.css',
                        'rel' => 'stylesheet',
                        'media' => 'screen', )
        );

        //resources for ITEMS
        //$this->addChild('responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl');
        /*$resources_scripts = $this->dispatch(
                                 'responses/common/resource_library/get_resources_scripts',
                                 array(
                                         'object_name' => '',
                                         'object_id' => '',
                                         'types' => array('image'),
                                 )
                        );*/

        $this->data['cancel_href'] = $this->html->getSecureURL('super_menu/super_menu');

        $this->data['action'] = $this->html->getSecureURL('super_menu/super_menu/edit', '&tab=items&super_menu_id='.$this->request->get['super_menu_id']);
        $this->data['form_title'] = $this->language->get('text_edit').' '.$this->data['name'];
        $this->data['update'] = $this->html->getSecureURL('itemslist/super_menu/update_field', '&super_menu_id='.$this->request->get['super_menu_id']);
        $form = new AForm('HT');

        $this->document->addBreadcrumb(array('href' => $this->data['action'],
                                             'text' => $this->data['form_title'],
                                             'separator' => ' :: ',
                                             'current' => true,
        ));

        $form->setForm(
            array(
                        'form_name' => 'super_menuFrm',
                        'update' => $this->data['update'],
                )
        );
        $this->data['form']['form_open'] = $form->getFieldHtml(
            array(
                        'type' => 'form',
                        'name' => 'super_menuFrm',
                        'action' => $this->data['action'],
                        'attr' => 'data-confirm-exit="true" class="aform form-horizontal"', )
        );
        $this->data['form']['submit'] = $form->getFieldHtml(
            array(
                        'type' => 'button',
                        'name' => 'submit',
                        'text' => $this->language->get('button_save'),
                )
        );
        $this->data['form']['cancel'] = $form->getFieldHtml(
            array(
                        'type' => 'button',
                        'name' => 'cancel',
                        'text' => $this->language->get('button_cancel'),
                )
        );
        $this->data['form_title'] = $this->language->get('super_menu_items');

        //get items values to display
        $this->data['form']['fields'] = array();
        if (isset($this->data['items']['items'])) {
            $i = 0;
            $this->load->library('json');

            foreach ($this->data['items']['items'] as $rule) {
                $this->request->post['idx'] = $i;
                $this->request->post['item_object'] = $rule['object'];
                //$this->log->write(print_r($rule, true).' $rule to be displayed');
                /*Array
                (
                    [object] => brands
                )*/

                $args = array();
                foreach ($rule as $key => $arg) {
                    if ('object' != $key) {
                        $args[0][$key] = $arg;
                    }
                }
                /*$args = array(
                        array(
                                'name' => $rule['name'],
                                'style' => $rule['style'],
                                'value' => $rule['value']
                        )
                );*/

                //$this->log->write(print_r($args, true).' $args');
                $fields = $this->dispatch('responses/itemslist/super_menu/getFieldsByItemObject', $args);

                $fields = AJson::decode($fields->dispatchGetOutput(), true);
                $this->data['form']['fields'][$i]['id'] = $rule['object'];
                $this->data['form']['fields'][$i]['text'] = $fields['text'];
                $this->data['form']['fields'][$i]['field'] = $fields['fields'];
                ++$i;
            }

            //$this->log->write(print_r($this->data['items'], true).' $this->data[/items/]');
            $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl');

            $this->addChild('responses/common/resource_library/get_resources_html', 'resources_html', 'responses/common/resource_library_scripts.tpl');
            $resources_scripts = $this->dispatch(
                'responses/common/resource_library/get_resources_scripts',
                array(
                            'object_name' => '',
                            'object_id' => '',
                            'types' => array('image'),
                    )
            );
            $this->view->assign('resources_scripts', $resources_scripts->dispatchGetOutput());
            $this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&action=list_library&object_name=&object_id&type=image&mode=single'));
        }

        // selectbox with item's objects list

        $cond_objects = array(
                'home',
                'categories',
                'brands',
                'products',
                'wishlist',
                'contents',
                'account',
                'customhtml',
                'menu',
                'customurl',
                //'customers',
                //'product_price',
                //'customer_groups',
                //'customer_country',
                //'customer_postcode',
                //'order_subtotal',
                //'order_product_count',
                //'order_product_weight',
                //'payment_method',
                //'shipping_method',
                //'coupon_code'
        );

        foreach ($cond_objects as $obj) {
            $this->data['item_objects'][$obj] = $this->language->get('super_menu_text_'.$obj);
        }
        array_unshift($this->data['item_objects'], $this->language->get('text_select'));
        $this->data['item_object']['field'] = $form->getFieldHtml(
            array(
                        'type' => 'selectbox',
                    'name' => 'item_object',
                    'options' => $this->data['item_objects'],
                    'value' => $this->data['super_menu_type'],
                    )
        );
        $this->data['item_object']['text'] = $this->language->get('super_menu_add_items');

        $this->data['item_url'] = $this->html->getSecureURL('itemslist/super_menu/getFieldsByItemObject', '&super_menu_id='.$this->data['super_menu_id']);

        $this->view->batchAssign($this->language->getASet());
        $this->view->batchAssign($this->data);
        //$this->view->assign('language_code', $this->session->data['language']);
        $this->view->assign('help_url', $this->gen_help_url('super_menu_edit'));
        //$this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&action=list_object&object_name=categories&object_id&type=image&mode'));
        //$this->view->assign('rl', $this->html->getSecureURL('common/resource_library', '&object_name=super_menus&type=image&mode=url'));
        //$this->data['rl'] = $this->html->getSecureURL('common/resource_library', '&action=list_library&object_name=&object_id&type=image&mode=single');
        $this->processTemplate('pages/super_menu/super_menu_form_items.tpl');
    }

    private function _validateForm()
    {
        if (!$this->user->hasPermission('modify', 'super_menu/super_menu')) {
            $this->session->data['warning'] = $this->error['warning'] = $this->language->get('error_permission');
        }

        if ($this->request->post) {
            $required = array('name', 'start_date');

            foreach ($this->request->post as $name => $value) {
                if (in_array($name, $required) && empty($value)) {
                    $this->error['warning'] = $this->language->get('error_empty');
                    $this->session->data['warning'] = $this->language->get('error_empty');
                    break;
                }
            }
        }

        foreach ($required as $name) {
            if (!in_array($name, array_keys($this->request->post))) {
                return false;
            }
        }
        if (!$this->error) {
            return true;
        } else {
            return false;
        }
    }
}
