<?php

if (!IS_ADMIN || !defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ControllerResponsesExtensionSeoImages extends AController
{
    public $data = array();

    //generate_seo_name?
    public function generate_seo_link($input, $replace = '-', $remove_words = true, $words_array = array())
    {
        // _
        $input = str_replace('_', ' ', $input);
        $input = str_replace('-', ' ', $input);
        $input = str_replace('"', '', $input);
        $input = str_replace(',', ' ', $input); // tags list
        $translt = $this->cleanUTF($input);

        //make it lowercase, remove punctuation, remove multiple/leading/ending spaces
        //$return = trim(preg_replace('/ +/', ' ', preg_replace('/[^a-zA-Z0-9\s]/', '', strtolower($translt))));
        $return = trim(preg_replace('/ +/', ' ', preg_replace('/[^\pL\p{Zs}0-9\s\-_]+/u', '', mb_strtolower($translt, 'UTF-8'))));

        //remove words, if not helpful to seo
        //i like my defaults list in remove_words(), so I wont pass that array
        if ($remove_words) {
            $return = $this->remove_words($return, $replace, $words_array);
        }

        //convert the spaces to whatever the user wants
        //usually a dash or underscore..
        //...then return the value.
        return str_replace(' ', $replace, $return);
    }

    public function cleanUTF($name)
    { //translit
        $name = str_replace(array('š', 'č', 'đ', 'č', 'ć', 'ž', 'ñ'), array('s', 'c', 'd', 'c', 'c', 'z', 'n'), $name);
        $name = str_replace(array('Š', 'Č', 'Đ', 'Č', 'Ć', 'Ž', 'Ñ'), array('S', 'C', 'D', 'C', 'C', 'Z', 'N'), $name);
        $name = str_replace(array('а', 'б', 'в', 'ґ', 'г', 'д', 'е', 'ё', 'ж', 'з', 'ї', 'и', 'і', 'й', 'к', 'л', 'љ', 'м', 'н', 'њ', 'о', 'п', 'р', 'с', 'т', 'у', 'ф', 'х', 'ц', 'ч', 'џ', 'ш', 'щ', 'ъ', 'ы', 'ь', 'э', 'є',   'ю', 'я', 'А', 'Б', 'В', 'Г', 'Ґ', 'Д', 'Е', 'Ё', 'Ж', 'З', 'Ї', 'І', 'И', 'Й', 'К', 'Л', 'Љ', 'М', 'Н', 'Њ', 'О', 'П', 'Р', 'С', 'Т', 'У', 'Ф', 'Х', 'Ц', 'Ч', 'Џ', 'Ш', 'Щ', 'Ъ', 'Ы', 'Ь', 'Э', 'Ю', 'Я'),
                                    array('a', 'b', 'v', 'g', 'g', 'd', 'e', 'e', 'z', 'z', 'i', 'i', 'i', 'j', 'k', 'l', 'lj', 'm', 'n', 'nj', 'o', 'p', 'r', 's', 't', 'u', 'f', 'h', 'c', 'c', 'dz', 's', 's', 'i', 'j', 'j', 'e', 'e', 'ju', 'ja', 'A', 'B', 'V', 'G', 'G', 'D', 'E', 'E', 'Z', 'Z', 'I', 'I', 'I', 'J', 'K', 'L', 'Lj', 'M', 'N', 'Nj', 'O', 'P', 'R', 'S', 'T', 'U', 'F', 'H', 'C', 'C', 'Dz', 'S', 'S', 'I', 'J', 'J', 'E', 'Ju', 'Ja'), $name);

        return $name;
    }

    /* takes an input, scrubs unnecessary words */
    public function remove_words($input, $replace, $words_array = array(), $unique_words = false)
    {
        //separate all words based on spaces
        $input_array = explode(' ', $input);

        //create the return array
        $return = array();

        //loops through words, remove bad words, keep good ones
        foreach ($input_array as $word) {
            //if it's a word we should add...
            if (!in_array($word, $words_array) && ($unique_words ? !in_array($word, $return) : true)) {
                $return[] = $word;
            }
        }

        //return good words separated by dashes
        return implode($replace, $return);
    }

    public function get_seo_images2()
    {
        $this->loadModel('extension/seo_images');
        $this->loadModel('catalog/product');
        $default_lang_id = $this->config->get('storefront_language_id');
        $languages = $this->language->getActiveLanguages();

        if (0 == $_SESSION['sucsess_part']) {
            //$this->log->write(' DETECTED SUCCESS PARTS=0');
            //clean session
            unset($this->session->data['myarray']);
            $_SESSION['sucsess_part'] = 0;
            $_SESSION['parts'] = 0;
            $_SESSION['myarray'] = 0;
            $_SESSION['process'] = 0;

            $rm = new AResourceManager();
            $resources = $rm->getResourcesList(array(
                            'object_name' => 'products',
                            'type_id' => '1',
                        ));
            $rmopt = new AResourceManager();
            $resourcesopt = $rmopt->getResourcesList(array(
                            'object_name' => 'product_option_value',
                            'type_id' => '1',
                        ));
            $newArray = array_merge($resources, $resourcesopt);

            foreach ($newArray as $index => $row) {
                //get product id
                $rmobj = new AResourceManager();
                $resourcesobj = $rmobj->getResourceObjects($row['resource_id'], $language_id = 0);
                if ($resourcesobj['text_products']) {
                    $product_id = $resourcesobj['text_products'][0]['object_id'];
                    $un_id = '-'.$row['resource_id'];
                } elseif ($resourcesobj['text_product_option_value']) {
                    $compose_array = $resourcesobj['text_product_option_value'];
                    $first_value = reset($compose_array);
                    $str = $first_value['url'];
                    parse_str($str, $output);
                    $parse_id = $output['product_id'];

                    if ($parse_id > 0 and strlen($parse_id) > 1) {
                        $un_id = '_'.$first_value['name'].'-'.$first_value['object_id'].'-'.$row['resource_id'];
                        //$un_id = '_'.$first_value['name'].'-'.$row['object_id'];
                        $product_id = $parse_id;
                    }
                }

                $bad_word_config = explode(',', str_replace(', ', ',', $this->config->get('seo_images_badwords')));
                //$bad_word_config = 	explode(',', $this->config->get('seo_images_badwords'));
                $bad_words_in = array("'", '.'); //"'"
                $bad_words = array_merge($bad_word_config, $bad_words_in);
                if ('underscore' == $this->config->get('seo_images_delim')) {
                    $replace = '_';
                } else {
                    $replace = '-';
                }

                //multi lang support
                foreach ($languages as $lkey => $lng) {
                    $process_language_id = $lng['language_id'];
                    $product_info = $this->model_extension_seo_images->getProduct((int) $product_id, (int) $process_language_id);
                    if ($this->config->get('seo_images_skey_status')) {
                        $seokey = $this->generate_seo_link($product_info['keyword'], $replace, true, $bad_words);
                    }

                    $seo = (string) $seokey.(string) $un_id;
                    //$this->log->write('1 prepare:'.print_r($seokey, true).' $seokey before save');
                    if (mb_strlen($seokey) < 2) {
                        $seo = $this->generate_seo_link($product_info['name'], $replace, true, $bad_words).$un_id;
                    }
                    $newArray[$index]['seo'][$process_language_id] = $seo;
                    //$this->log->write('2 prepare:'.print_r($newArray[$index]['seo'], true).' saved data+ for index'.$index);
                }
                //print_r ($resourcesobj); //$warning->toLog()->toDebug()->toMessages();
                $uri = DIR_RESOURCE.'image/'.$row['resource_path'];
                $time = microtime(true);
            }

            $_SESSION['myarray'] = $newArray;
            $part = $_SESSION['parts'] = sizeof($_SESSION['myarray']);
        }

        $part = sizeof($_SESSION['myarray']);
        $value = $_SESSION['myarray'][($_SESSION['sucsess_part'])];
        ++$_SESSION['sucsess_part'];
        $info = pathinfo($value['resource_path']);
        $extension = $info['extension'];
        $filename = $info['filename'];
        $dirname = $info['dirname'];

        //		print_r($value);
        if (false === strpos($value['resource_path'], '.x__.')) {
            if ($this->config->get('seo_images_flname_status')) {
                $targetFile = DIR_RESOURCE.'image/'.$value['resource_path'];
                $targetCopy1 = DIR_RESOURCE.'image/'.$dirname.'/'.$filename.'.original.'.$extension;
                $targetCopy2 = DIR_RESOURCE.'image/'.$dirname.'/'.$filename.'.x__.'.$value['seo'][$default_lang_id].'.'.$extension;
                copy($targetFile, $targetCopy1);
                copy($targetFile, $targetCopy2);
                if (file_exists($targetCopy2)) {
                    $newpath = $dirname.'/'.$filename.'.x__.'.$value['seo'][$default_lang_id].'.'.$extension;
                    $this->model_extension_seo_images->updatetablepath('resource_descriptions', 'resource_path', $newpath, 'resource_id', (int) $value['resource_id']);
                    $this->cache->delete('*');
                } else {
                }
            }

            foreach ($languages as $lkey => $lng) {
                $process_language_id = $lng['language_id'];

                $clean_name_id = str_replace('-'.(int) $value['resource_id'], '', $value['seo'][$process_language_id]);
                $clean_name = str_replace(array('-', '_', 'quot'), ' ', $clean_name_id);
                if ($this->config->get('seo_images_rlname_status')) {
                    //$this->log->write('1 DONE:'.print_r($clean_name, true).' saved to rName');
                    $this->model_extension_seo_images->updatetable('resource_descriptions', 'name', $clean_name, 'resource_id', (int) $value['resource_id'], $process_language_id);
                }
                // AbanteCart thumnails bug thumb name always underscore
                if ($this->config->get('seo_images_rltitle_status')) {
                    $this->model_extension_seo_images->updatetable('resource_descriptions', 'title', $clean_name, 'resource_id', (int) $value['resource_id'], $process_language_id);
                }
            }

            //clear caches to see changes in RL and StoreFront
            $this->cache->delete('*');
        } elseif (true == strpos($value['resource_path'], '.x__.')) {
            //$this->log->write(' TRUE FOR x__ in '.$value['resource_path']);
            if ($this->config->get('seo_images_new_only')) {
                //skip
            } else {
                if ($this->config->get('seo_images_flname_status')) {
                    $filename = strtok($filename, '.').'.'.strtok('.');
                    $originalfilename = str_replace('.x__', '.original', $filename);
                    $originalfile = DIR_RESOURCE.'image/'.$dirname.'/'.$originalfilename.'.'.$extension;
                    $targetCopy2 = DIR_RESOURCE.'image/'.$dirname.'/'.$filename.'.'.$value['seo'][$default_lang_id].'.'.$extension;
                    copy($originalfile, $targetCopy2);
                    if (file_exists($targetCopy2)) {
                        $newpath = $dirname.'/'.$filename.'.'.$value['seo'][$default_lang_id].'.'.$extension;
                        $this->model_extension_seo_images->updatetablepath('resource_descriptions', 'resource_path', $newpath, 'resource_id', (int) $value['resource_id']);
                        //$this->cache->delete('*');
                    }
                }

                foreach ($languages as $lkey => $lng) {
                    $process_language_id = $lng['language_id'];
                    // UPDATE TABLE
                    $clean_name_id = str_replace('-'.(int) $value['resource_id'], '', $value['seo'][$process_language_id]);
                    $clean_name = str_replace(array('-', '_', 'quot'), ' ', $clean_name_id);

                    if ($this->config->get('seo_images_rlname_status')) {
                        //$this->log->write(' else in TRUE $clean_name= '.$clean_name);
                        $this->model_extension_seo_images->updatetable('resource_descriptions', 'name', $clean_name, 'resource_id', (int) $value['resource_id'], $process_language_id);
                    }
                    // AbanteCart thumnails bug thumb name always underscore
                    if ($this->config->get('seo_images_rltitle_status')) {
                        $this->model_extension_seo_images->updatetable('resource_descriptions', 'title', $clean_name, 'resource_id', (int) $value['resource_id'], $process_language_id);
                    }
                }
            }
            //clear caches to see changes in RL and StoreFront
            $this->cache->delete('*');
        }

        $total = count($newArray);
        $_SESSION['process'] = (($_SESSION['sucsess_part'] * 100) / $part);
        echo $_SESSION['process'];
    }

    public function get_seo_images3()
    {
        $_SESSION['sucsess_part'] = 0;
        $_SESSION['parts'] = 0;
        $_SESSION['myarray'] = 0;
        $_SESSION['process'] = 0;
        $this->cache->delete('*');
    }

    public function get_seo_images4()    //restore
    {
        $this->loadModel('extension/seo_images');
        $default_lang_id = $this->config->get('storefront_language_id');
        $languages = $this->language->getActiveLanguages();

        if (0 == $_SESSION['sucsess_part']) {
            $rm = new AResourceManager();
            $resources = $rm->getResourcesList(array(
                                                'object_name' => 'products',
                                                'type_id' => '1',
                                    ));
            $rmopt = new AResourceManager();
            $resourcesopt = $rmopt->getResourcesList(array(
                                                'object_name' => 'product_option_value',
                                                'type_id' => '1',
                                    ));
            $newArray = array_merge($resources, $resourcesopt);

            //print_r ($newArray);
            foreach ($newArray as $index => $row) {
                //echo DIR_RESOURCE . 'image/' . $row['resource_path'];
                $uri = DIR_RESOURCE.'image/'.$row['resource_path'];
                $time = microtime(true);
                //skip  warning: AbanteCart core v.1.2.2 fopen(//resources/image/18/6f/a.jpg): failed to open stream:
                                    //$tmpimage = new FastImage($uri);
                                    //list($width, $height) = $tmpimage->getSize();
                                    //echo "Width: ". $width . "px Height: ". $height . "px in " . (microtime(true)-$time) . " seconds \n";
                                    //$sqd = $width * $height;
                                    //echo "sortsqd".$sqd."Width: ". $width . "px Height: ". $height . "px in " . (microtime(true)-$time) . " seconds <br>";

                                    //$newArray[$index][imsiz] = $sqd;
            }
            /*function u_compare($a, $b) {
            $adist = intval($a['imsiz']);
            $bdist = intval($b['imsiz']);
            if ($adist == $bdist) {
            return 0;}
            return ($adist < $bdist) ? -1 : 1;
            }
            usort($newArray,"u_compare"); */
            //print_r ($newArray);
            $_SESSION['myarray'] = $newArray;
            $part = $_SESSION['parts'] = sizeof($_SESSION['myarray']);
        }
        $part = sizeof($_SESSION['myarray']);

        $value = $_SESSION['myarray'][($_SESSION['sucsess_part'])];
        ++$_SESSION['sucsess_part'];
        $info = pathinfo($value['resource_path']);
        $extension = $info['extension'];
        $filename = $info['filename'];
        $dirname = $info['dirname'];
        //$this->loadModel('extension/seo_images');
        if (true == strpos($value['resource_path'], '.x__.')) {
            //if ($this->config->get('seo_images_new_only') == 0) {
            //remove after second .
            $filename = strtok($filename, '.').'.'.strtok('.');

            $originalfilename = str_replace('.x__', '', $filename);
            $originalfile = DIR_RESOURCE.'image/'.$dirname.'/'.$originalfilename.'.'.$extension;

            if (file_exists($originalfile)) {
                $newpathraw = $dirname.'/'.$originalfilename.'.'.$extension;
                //	echo $newpathraw." ";
                $this->model_extension_seo_images->updatetablepath('resource_descriptions', 'resource_path', $newpathraw, 'resource_id', (int) $value['resource_id']);
                //$this->cache->delete('*');
            }
            //}
        }
        $total = count($newArray);
        $_SESSION['process'] = (($_SESSION['sucsess_part'] * 100) / $part);
        $this->cache->delete('*');
        echo $_SESSION['process'];
    }
}
