<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
class ControllerPagesCatalogProductSeoPack extends AController
{
    private $error = array();
    private $attribute_manager;
    public $data = array();

    public function main()
    {
        //init controller data
        $this->extensions->hk_InitData($this, __FUNCTION__);

        $this->loadLanguage('catalog/product');
        $this->loadLanguage('seo_pack/seo_pack');
        $this->document->setTitle($this->language->get('heading_title'));
        $this->loadModel('catalog/product');
        $this->loadModel('seo_pack/product');

        if (isset($this->request->get['product_id']) && ($this->request->is_GET())) {
            $product_info = $this->model_catalog_product->getProduct($this->request->get['product_id']);
            if (!$product_info) {
                $this->session->data['warning'] = $this->language->get('error_product_not_found');
                $this->redirect($this->html->getSecureURL('catalog/product'));
            }
        }

        if ($this->request->is_POST()) {
            $this->model_seo_pack_product->updateProductSeo($this->request->get['product_id'], $this->request->post);
            $this->session->data['success'] = $this->language->get('text_success');
            $this->redirect($this->html->getSecureURL('catalog/product_seo_pack', '&product_id='.$this->request->get['product_id']));
        }

        // $this->data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id']);

        //$content_language_id = $this->language->getContentLanguageID();

        $this->view->assign('error_warning', $this->error['warning']);
        $this->view->assign('success', $this->session->data['success']);
        if (isset($this->session->data['success'])) {
            unset($this->session->data['success']);
        }

        $this->document->initBreadcrumb(array(
            'href' => $this->html->getSecureURL('index/home'),
            'text' => $this->language->get('text_home'),
            'separator' => false,
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/product'),
            'text' => $this->language->get('heading_title'),
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/product/update', '&product_id='.$this->request->get['product_id']),
            'text' => $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product').' - '.$this->data['product_description'][$this->session->data['content_language_id']]['name'],
            'separator' => ' :: ',
        ));
        $this->document->addBreadcrumb(array(
            'href' => $this->html->getSecureURL('catalog/product_seo_pack', '&product_id='.$this->request->get['product_id']),
            'text' => $this->language->get('entry_admin_seo_tab_name'),
            'separator' => ' :: ',
            'current' => true,
        ));

        /* $this->loadModel('catalog/category');
         $this->data['categories'] = array();
         $results = $this->model_catalog_category->getCategories(0);
         foreach ($results as $r) {
             $this->data['categories'][$r['category_id']] = $r['name'];
         }

         $this->loadModel('setting/store');
         $this->data['stores'] = array(0 => $this->language->get('text_default'));
         $results = $this->model_setting_store->getStores();
         foreach ($results as $r) {
         	$this->data['stores'][$r['store_id']] = $r['name'];
         }

         $this->data['product_category'] = $this->model_catalog_product->getProductCategories($this->request->get['product_id']);
         $this->data['product_store'] = $this->model_catalog_product->getProductStores($this->request->get['product_id']);
         $this->data['product_related'] = $this->model_catalog_product->getProductRelated($this->request->get['product_id']);
         */

        $this->data['product_seo'] = $this->model_seo_pack_product->getProductSeo($this->request->get['product_id']);
        $this->data['product_description'] = $this->model_catalog_product->getProductDescriptions($this->request->get['product_id'], $this->session->data['content_language_id']);

        //load tabs controller
        $tabs_obj_seo = $this->dispatch('pages/catalog/product_tabs', array($this->data));
        $this->data['product_tabs'] = $tabs_obj_seo->dispatchGetOutput();
        unset($tabs_obj_seo);

        // $this->data['category_products'] = $this->html->getSecureURL('product/product/category');
        //$this->data['related_products'] = $this->html->getSecureURL('product/product/related');
        $this->data['action'] = $this->html->getSecureURL('catalog/product_seo_pack', '&product_id='.$this->request->get['product_id']);
        $this->data['form_title'] = $this->language->get('text_edit').'&nbsp;'.$this->language->get('text_product');
        //$this->data['update'] = $this->html->getSecureURL('listing_grid/product/update_relations_field', '&id=' . $this->request->get['product_id']);
        $this->data['update'] = $this->html->getSecureURL('seo_pack/product/update_seo_pack', '&id='.$this->request->get['product_id']);
        //$this->data['update'] = $this->model_seo_pack_product->updateProductSeo($this->request->get['product_id'], $this->request->post);
        $form = new AForm('HS');

        $form->setForm(array(
            'form_name' => 'productFrm',
            'update' => $this->data['update'],
        ));

        $this->data['form']['id'] = 'productFrm';

        $this->data['form']['form_open'] = $form->getFieldHtml(array(
            'type' => 'form',
            'name' => 'productFrm',
            'action' => $this->data['action'],
            'attr' => 'data-confirm-exit="true" class="aform form-horizontal"',
        ));

        $this->data['form']['seosubmit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get('button_seo_submit'),
            'style' => 'button1',
        ));

        $this->data['form']['submit'] = $form->getFieldHtml(array(
            'type' => 'button',
            'name' => 'submit',
            'text' => $this->language->get('button_save'),
            'style' => 'button1',
        ));
        $this->data['form']['cancel'] = $form->getFieldHtml(array(
            'type' => 'button',
            'href' => $this->html->getSecureURL('catalog/product/update', '&product_id='.$this->request->get['product_id']),
            'name' => 'cancel',
            'text' => $this->language->get('button_cancel'),
            'style' => 'button2',
        ));
        $this->data['cancel'] = $this->html->getSecureURL('catalog/product');

        /*$this->loadModel('catalog/category');
        $this->data['categories'] = array();
        $results = $this->model_catalog_category->getCategories(0);

        foreach( $results as $r ) {
            $this->data['categories'][ $r['category_id'] ] = $r['name'];
        }

        $this->data['form']['fields']['category'] = $form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'product_category[]',
                'value' => $this->data['product_category'],
                'options' => $this->data['categories'],
                'style' => 'chosen',
                'placeholder' => $this->language->get('text_select_category'),
        ));
        //load only prior saved products
        $resource = new AResource('image');
        $this->data['products'] = array();
        if (count($this->data['product_related'])) {
            $this->loadModel('catalog/product');
            $filter = array('subsql_filter' => 'p.product_id in (' . implode(',', $this->data['product_related']) . ')' );
            $results = $this->model_catalog_product->getProducts($filter);
            foreach( $results as $r ) {
                $thumbnail = $resource->getMainThumb('products',
                                                $r['product_id'],
                                                (int)$this->config->get('config_image_grid_width'),
                                                (int)$this->config->get('config_image_grid_height'),
                                                true);
                $this->data['products'][$r['product_id']]['name'] = $r['name']." (".$r['model'].")";
                $this->data['products'][$r['product_id']]['image'] = $thumbnail['thumb_html'];
            }
        }

        $this->data['form']['fields']['related'] = $form->getFieldHtml( array(
                'type' => 'multiselectbox',
                'name' => 'product_related[]',
                'value' => $this->data['product_related'],
                'options' => $this->data['products'],
                'style' => 'chosen',
                'ajax_url' => $this->html->getSecureURL('r/product/product/products'),
                'placeholder' => $this->language->get('text_select_from_lookup'),
        ));

        $this->data['form']['fields']['store'] = $form->getFieldHtml(array(
                'type' => 'checkboxgroup',
                'name' => 'product_store[]',
                'value' => $this->data['product_store'],
                'options' => $this->data['stores'],
                'style' => 'chosen',
        ));
        */

        $this->data['form']['fields']['seo'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'product_seo[]',
                'value' => $this->data['product_seo']['seo_title'], //Array (     [product_id] => 116     [language_id] => 1     [seo_pack] => my seo title     [short_description] => short description for what?     ['seo_h1'] => my seo h1     [seo_h2] => my seo h2     [language] => stdClass Object         (             [row] => Array                 (                     [product_id] => 116                     [language_id] => 1                     [seo_pack] => my seo title                     [short_description] => short description for what?                     ['seo_h1'] => my seo h1                     [seo_h2] => my seo h2                 )              [rows] => Array                 (                     [0] => Array                         (                             [product_id] => 116                             [language_id] => 1                             [seo_pack] => my seo title                             [short_description] => short description for what?                             ['seo_h1'] => my seo h1                             [seo_h2] => my seo h2                         )                  )              [num_rows] => 1         )  )
                //'options' => $this->data['stores'],
                //'style' => 'chosen',
                'multilingual' => true,
                            'placeholder' => $this->data['product_description']['name'],
        ));

        $this->data['form']['fields']['seo_h1'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'product_seo_h1[]',
                'value' => $this->data['product_seo']['seo_h1'],
                'multilingual' => true,
                            'placeholder' => $this->data['product_description']['name'],
        ));

        $this->data['form']['fields']['seo_meta_keywords'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'product_seo_meta_keywords[]',
                'value' => $this->data['product_description']['meta_keywords'],
                'multilingual' => true,
        ));

        $this->data['form']['fields']['seo_meta_description'] = $form->getFieldHtml(array(
                'type' => 'textarea',
                'name' => 'product_seo_meta_description[]',
                'value' => $this->data['product_description']['meta_description'],
                'multilingual' => true,
        ));

        $this->data['keyword_button'] = $form->getFieldHtml(array(
                        'type' => 'button',
                        'name' => 'generate_seo_keyword',
                        'text' => $this->language->get('button_generate'),
                    //set button not to submit a form
                        'attr' => 'type="button"',
                        'style' => 'btn btn-info',
                ));

        $this->data['form']['product_name'] = $this->data['product_description']['name'];
        $this->data['form']['generate_seo_url'] = $this->html->getSecureURL('common/common/getseokeyword', '&object_key_name=product_id&id='.$this->request->get['product_id']);
        $this->data['form']['current_seo_url'] = $product_info['keyword'];
        $this->data['form']['seo_h1'] = $this->data['product_seo']['seo_h1'];
        $this->data['form']['seo'] = $this->data['product_seo']['seo_title'];
        $this->data['form']['meta_description'] = $this->data['product_description']['meta_description'];
        $this->data['form']['description'] = $this->data['product_description']['description'];
        $this->data['form']['short_description'] = $this->data['product_seo']['short_description'];
        $this->data['form']['producturl'] = $this->html->getCatalogURL('product/product', '&product_id='.$this->request->get['product_id']);

        ////////
        // get uniq check meta_description
        $this->data['product_seo_uniq_meta_description'] = $this->model_seo_pack_product->getProductSeoUniqMetaDescr($this->request->get['product_id'], $this->data['product_description']['meta_description']);
        //send to tpl
        $this->data['form']['meta_description_uniq'] = $this->data['product_seo_uniq_meta_description'];

        // get uniq check h1 and title
        $product_seo_uniq_titleh = $this->model_seo_pack_product->getProductSeoUniqTitleh($this->request->get['product_id']);
        foreach ($product_seo_uniq_titleh as $key => $value) {
            if (mb_strlen($value['seo_title']) < 1) {
                $ret_seo_title = $value['name'];
            } else {
                $ret_seo_title = $value['seo_title'];
            }

            if (mb_strlen($value['seo_h1']) < 1) {
                $ret_seo_h1 = $value['name'];
            } else {
                $ret_seo_h1 = $value['seo_h1'];
            }
            $ret[] = array('product_id' => $value['product_id'], 'seo_title' => $ret_seo_title, 'seo_h1' => $ret_seo_h1);
        }

        //$this->log->write(print_r($ret , true).'--step2'); // print array to log

        // search for uniq count
        $number_of_titles_dupl = 0;
        /*deprecated
        $countrows = count($ret);
        for ($row = 0; $row < $countrows; $row++) {
            if($ret[$row]["seo_title"]=== $this->data['product_seo']['seo_title'] ) {
                 $number_of_titles_dupl++;
                 //echo $ret[$row]["name"] . '<br />';
            }
        }*/
        $number_of_h_dupl = 0;
        /* deprecated
        for ($row = 0; $row < $countrows; $row++) {
            if(strcmp($ret[$row]["seo_h1"],$this->data['product_seo']['seo_h1']) == 0 ) {
                 $number_of_h_dupl++;
                 //echo $ret[$row]["name"] . '<br />';
            }
        }*/

        // find key with specified value in multid array
        function mysearchfunction($products, $field, $value)
        {
            foreach ($products as $key => $product) {
                if ($product[$field] === $value) {
                    return $key;
                }
            }

            return false;
        }

        foreach ($ret as $val) {
            ++$arResult[$val['seo_h1']];
        } //count ALL duplicates H1

        foreach ($ret as $valt) {
            ++$arResulttitle[$valt['seo_title']];
        }    //count ALL duplicates titles

        //$this->log->write(print_r($arResulttitle , true).'--'); // print array to log

        $found_key = mysearchfunction($ret, 'product_id', $this->request->get['product_id']);
        $target_value_h = $ret[$found_key]['seo_h1'];
        $target_value_t = $ret[$found_key]['seo_title'];
        $number_of_h_dupl = $arResult[$target_value_h];
        $number_of_titles_dupl = $arResulttitle[$target_value_t];

        //uniqnes send to tpl
        $this->data['form']['product_seo_uniq_title'] = $number_of_titles_dupl;
        $this->data['form']['product_seo_uniq_h'] = $number_of_h_dupl;

        $this->data['form']['fields']['keyword'] = $form->getFieldHtml(array(
                        'type' => 'input',
                        'name' => 'keyword',
                        'value' => $product_info['keyword'],
                        'help_url' => $this->gen_help_url('seo_keyword'),
                        'multilingual' => true,
                        'attr' => ' gen-value="'.SEOEncode($this->data['product_info']['name']).'" ',
                ));

        //focus
        // get uniq check
        $this->data['product_seo_uniq'] = $this->model_seo_pack_product->getProductSeoUniq($this->request->get['product_id'], $this->data['product_seo']['short_description']);
        //send to tpl
        $this->data['form']['short_description_uniq'] = $this->data['product_seo_uniq'];

        $this->data['form']['fields']['short_description'] = $form->getFieldHtml(array(
                    'type' => 'input',
                    'name' => 'short_description[]',
                    'value' => $this->data['product_seo']['short_description'],
                    'multilingual' => true,
            ));

        /*if($this->config->get('config_embed_status')){
            $this->data['embed_url'] = $this->html->getSecureURL('common/do_embed/product', '&product_id=' . $this->request->get['product_id']);
        }*/
        $this->addChild('pages/catalog/product_summary', 'summary_form', 'pages/catalog/product_summary.tpl');
        //$this->view->assign('help_url', $this->gen_help_url('product_extra_options'));
        $this->view->assign('form_language_switch', $this->html->getContentLanguageSwitcher());
        $this->view->batchAssign($this->data);
        $this->processTemplate('pages/extension/product_seo_pack.tpl');

        //update controller data
        $this->extensions->hk_UpdateData($this, __FUNCTION__);
    }
}
