<?php


if (! defined ( 'DIR_CORE' )) {
header ( 'Location: static_pages/' );
}

class ModelReturnsManagementReturnsManagement extends Model {
	public $data = array ();
	private $error = array ();

	/**
	 * @param int $customer_id
	 * @param int $limit
	 * @param int $offset
	 * @param string $order
	 * @return array
	 */
	public function getRequests($customer_id,$limit,$offset, $order=''){
		$customer_id = (int)$customer_id;
		$limit = (int)$limit;
		$offset = (int)$offset;
		$order = !$order ? 'date_added' : $order;
		if(!$customer_id){
			return array();
		}

		$sql = "SELECT *
				FROM ".$this->db->table('rma_requests')."
				WHERE customer_id=".$customer_id."
				ORDER BY ".$this->db->escape($order)."
				LIMIT ".$limit;
		if($offset){
			$sql .= " OFFSET ".$offset;
		}


		$result = $this->db->query($sql);
		if($result->num_rows){
			return $result->rows;
		}
		return array();
	}

	public function editRequest($data){
		$customer_id = (int)$data['customer_id'];
		if(!$customer_id){
			return false;
		}
		$data = (array)$data;

		if( $request_info = $this->getRequest((int)$data['order_id'])){
			$data['request_id'] = (int)$request_info['request_id'];
			$conversation = unserialize($request_info['conversation']);
		}

		$allowed_fields = array('request_status_id','rma_action','reason','details','conversation','customer_email');
		$update = array();

		if($data['request_id']){
			foreach($allowed_fields as $field_name){
				if(isset($data[$field_name])){
					if($field_name=='conversation'){
						if($data['conversation']){
							$customer_name = $this->customer->getFirstName().' '.$this->customer->getLastName();
							$data[$field_name] = htmlentities($data[$field_name],ENT_QUOTES,'UTF-8');
							$conversation[] = '('.date($this->language->get('date_format_short').' '.$this->language->get('time_format')).') '.$customer_name.":\n".$data[$field_name];
						}
						$data[$field_name] = serialize($conversation);
					}elseif($field_name=='details'){
						$data[$field_name] = serialize($data[$field_name]);
					}
					$update[] = "`".$field_name."`='".$this->db->escape($data[$field_name])."'";
				}
			}

			$sql = "UPDATE ".$this->db->table('rma_requests')."
					SET ".implode(", ", $update)."
					WHERE customer_id=".$customer_id."
						AND request_id = ".$data['request_id'].";";
			$this->db->query($sql);

		}else{
			$allowed_fields[] = 'order_id';
			$allowed_fields[] = 'customer_id';

			foreach($allowed_fields as $field_name){
				if(isset($data[$field_name])){
					if($field_name=='conversation'){
						if(!$data[$field_name]){
							continue;
						}
						$customer_name = $this->customer->getFirstName().' '.$this->customer->getLastName();
						$data[$field_name] = htmlentities($data[$field_name],ENT_QUOTES,'UTF-8');
						$conversation[] = '('.date($this->language->get('date_format_short').' '.$this->language->get('time_format')).') '.$customer_name.":\n".$data[$field_name];
						$data[$field_name] = serialize($conversation);
					}elseif($field_name=='details'){
						$data[$field_name] = serialize($data[$field_name]);
					}

					$update[$field_name] = $this->db->escape($data[$field_name]);

				}
			}

			$sql = "INSERT INTO ".$this->db->table('rma_requests')." (`".implode("`, `",array_keys($update))."`)
					VALUES ('".implode("', '",$update)."');";
			$this->db->query($sql);
			$data['request_id'] = $this->db->getLastId();
		}

		$subj = sprintf($this->language->get('rma_message_subject'), $data['request_id']);
		$text = sprintf( $this->language->get('rma_message_text'),
						$data['request_id'],
						'#admin#rt=returns_management/returns_management&s=' . ADMIN_PATH.'&order_id='.$data['order_id']
		);
		$text = $this->html->convertLinks(html_entity_decode($text, ENT_QUOTES, 'UTF-8'),'message');
		$this->messages->saveNotice( $subj, $text);

		if($this->config->get('returns_management_emails')){

			$view = new AView($this->registry, 0);
			$viewdata = array();

			$url = $this->html->getSecureURL('returns_management/returns_management',
											 '&s=' . ADMIN_PATH.'&order_id='.$data['order_id']	);

			$text = sprintf( $this->language->get('rma_message_text'),
							$data['request_id'],
							'<a href="'.$url.'">'.$this->language->get('text_rma_click_link').'</a>');

			$viewdata['text_message'] = $text;
			$viewdata['message'] = nl2br($text);

			$logo = $this->config->get('config_logo');
			if (is_file(DIR_RESOURCE . $logo)) {
				$viewdata['logo_url'] = HTTPS_DIR_RESOURCE . $this->config->get('config_logo');
			}else{
				$viewdata['logo_url'] = HTTPS_SERVER. $logo;
			}


			$viewdata['text_footer'] = '';
			$viewdata['store_name'] = $this->config->get('store_name');
			$viewdata['store_url'] = HTTPS_CATALOG;
			$view->batchAssign($viewdata);

			$mail = new AMail( $this->config );

			$mail->setTo($this->config->get('returns_management_emails'));
			$mail->setFrom($this->config->get('store_main_email'));
			$mail->setSender($this->config->get('store_name'));
			$mail->setSubject($subj);

			$mail->setHtml($view->fetch('pages/returns_management/returns_management_mail.tpl'));
			$mail->send();
			if ($mail->error) {
				$this->error = 'Error: Emails does not sent! Please see error log for details.';
			}
		}

	}

	public function getRequest($order_id){
		$customer_id = $this->customer->getId();
		$order_id = (int)$order_id;

		if(!$customer_id || !$order_id){
			return array();
		}

		$sql = "SELECT *
				FROM ".$this->db->table('rma_requests')."
				WHERE customer_id=".$customer_id." AND order_id=".$order_id;

		$result = $this->db->query($sql);
		if($result->num_rows){
			return $result->row;
		}
		return array();
	}


	public function getRequestStatusName($status_id) {
		switch ($status_id) {
			case 1:
				$text = $this->language->get('text_rma_request_status_requested');
				break;
			case 2:
				$text = $this->language->get('text_rma_request_status_approved');
				break;
			case 3:
				$text = $this->language->get('text_rma_request_status_declined');
				break;
			case 4:
				$text = $this->language->get('text_rma_request_status_completed');
				break;
			default:
				$text = $this->language->get('text_rma_request_status_requested');
		}
		return $text;
	}
 }
