<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

class ModelSaleOrderAttributes extends Model {

	public function getAttributesForGroup($customer_group_id, $language_id) {

		$results = $this->db->query(
			"SELECT
				oag.global_attribute_id,
				oag.customer_group_id,
				gad.name,
				gad.error_text
			FROM " . $this->db->table('order_attributes_to_groups')." oag
			INNER JOIN " . $this->db->table('global_attributes_descriptions')." gad
			ON oag.global_attribute_id = gad.attribute_id
			LEFT JOIN " . $this->db->table('global_attributes')." ga ON oag.global_attribute_id = ga.attribute_id
			WHERE
				oag.customer_group_id = " . (int) $customer_group_id . "
				AND gad.language_id = " . (int) $language_id."
			ORDER BY ga.sort_order"
		);

		return $results->rows;
	}

	public function getAttributeInfo($global_attribute_id, $mode='enabled') {
		$language_id = $this->language->getContentLanguageID();
		$results = $this->db->query(
			"SELECT
				oag.customer_group_id,
				oag.visible_by_customer,
				oag.show_shipping,
				oag.show_payment,
				oag.show_guest_checkout,
				oag.status,
				gad.name,
				gad.error_text,
				ga.attribute_id,
				ga.element_type,
				ga.sort_order,
				ga.settings,
				ga.required,
				ga.regexp_pattern
			FROM " . $this->db->table('order_attributes_to_groups')." oag
			INNER JOIN " . $this->db->table('global_attributes_descriptions')." gad ON oag.global_attribute_id = gad.attribute_id
			INNER JOIN " . $this->db->table('global_attributes')." ga ON oag.global_attribute_id = ga.attribute_id
			WHERE
				ga.attribute_id = " . (int) $global_attribute_id . "
				AND language_id = " . (int) $language_id . "
				". ($mode=='enabled' ? ' AND ga.status = 1' : '') ."
			ORDER BY ga.sort_order ASC"
		);

		if ( has_value($results->row['settings']) ) {
			$results->row['settings'] = unserialize($results->row['settings']);
		}

		$results->row['values'] = $this->getAttributeValues($results->row['attribute_id'], $language_id);

		return $results->row;
	}

	public function getAttributeValues($global_attribute_id, $language_id) {

		$sql = "SELECT gav.attribute_value_id, gav.sort_order, gavd.value
				FROM " . $this->db->table('global_attributes_values')." gav
				INNER JOIN " . $this->db->table('global_attributes_value_descriptions')." gavd ON gav.attribute_value_id = gavd.attribute_value_id
				WHERE gav.attribute_id = " . (int) $global_attribute_id . " AND gavd.language_id = " . (int) $language_id . "
				ORDER BY gav.sort_order ASC";

		$results = $this->db->query($sql);
		return $results->rows;
	}

	public function addAttributeToGroup($customer_group_id, $data) {

		if ( is_numeric($data['global_attribute_id']) ) {

			$sql = "INSERT INTO " . $this->db->table('order_attributes_to_groups')."
					SET
					global_attribute_id = ". (int) $data['global_attribute_id'] .",
					customer_group_id = ". (int) $customer_group_id;

			if ( isset($data['visible']) ) {
				$visible = ( (int) $data['visible'] > 0 ) ? 1 : 0;
				$sql .= ", visible_by_customer = " . $visible;
			}

			if ( isset($data['show_shipping']) ) {
				$shipping = ( (int) $data['show_shipping'] > 0 ) ? 1 : 0;
			} else {
				$shipping = 1;
			}
			$sql .= ", show_shipping = " . $shipping;

			if ( isset($data['show_payment']) ) {
				$payment = ( (int) $data['show_payment'] > 0 ) ? 1 : 0;
				$sql .= ", show_payment = " . $payment;
			}

			if ( isset($data['show_guest_checkout']) ) {
				$checkout = ( (int) $data['show_guest_checkout'] > 0 ) ? 1 : 0;

			} else {
				$checkout = 1;
			}
			$sql .= ", show_guest_checkout = " . $checkout;

			if ( isset($data['status']) ) {
				$status = ( (int) $data['status'] > 0 ) ? 1 : 0;

			} else {
				$status = 1;
			}
			$sql .= ", status = " . $status;

			$this->db->query($sql);
			return true;
		}
		return false;
	}

	public function removeCustomerAttributeFromGroup($global_attribute_id, $customer_group_id) {

		$this->db->query(
				"DELETE FROM " . $this->db->table('order_attributes_to_groups')."
		        WHERE global_attribute_id = " . (int) $global_attribute_id . "
					AND customer_group_id = " . (int) $customer_group_id);
		$orders = $this->db->query("SELECT order_id
									FROM " . $this->db->table('orders')."
									WHERE customer_group_id = " . (int) $customer_group_id);
		foreach ( $orders->rows as $order ) {
			$values = $this->db->query("SELECT order_attribute_id
										FROM ".$this->db->table('order_attributes')."
										WHERE global_attribute_id = " . (int) $global_attribute_id . "
											AND order_id = " . $order['order_id']);
			$this->db->query("DELETE FROM ".$this->db->table('order_attributes')."
			                  WHERE global_attribute_id = " . (int) $global_attribute_id . "
			                        AND order_id = " . $order['order_id']);
			foreach ( $values->rows as $val ) {
				$this->db->query("DELETE FROM ".$this->db->table('order_attribute_values')."
								  WHERE order_attribute_id = " . (int)$val['order_attribute_id']);
			}
		}
	}

	public function updateAttribute($data) {

		$attribute_manager = new AAttribute_Manager();

		$insert = array(
			'name' => $data['name'],
			'error_text' => $data['error_text'],
			'attribute_type_id' => $attribute_manager->getAttributeTypeID('order_attribute'),
			'element_type' => $data['element_type'],
			'sort_order' => $data['sort_order'],
			'required' => $data['required'],
			'regexp_pattern' => $data['regexp_pattern'],
			'settings' => $data['settings'],
			'status' => 1
		);

		if ( !isset($data['values']) ) {
			$insert['values'][0] = '';
		} else {
			$insert['values'] = $data['values'];
		}

		if ( !isset($data['sort_orders']) ) {
			$insert['sort_orders'][0] = '';
		} else {
			$insert['sort_orders'] = $data['sort_orders'];
		}

		$attribute_manager->updateAttribute($data['attribute_id'], $insert);
		$this->updateAttributesToGroups($data);
	}

	public function updateAttributesToGroups($data) {

		$this->db->query(
			"UPDATE " . $this->db->table('order_attributes_to_groups')."
			SET
				show_shipping = ". (int) $data['show_shipping'] . ",
				show_payment = " . (int) $data['show_payment'] . ",
				show_guest_checkout = " . (int) $data['show_guest_checkout'] . ",
				visible_by_customer = " . (int) $data['visible'] . ",
				status = " . (int) $data['status'] . "
			WHERE
				global_attribute_id = ". (int) $data['attribute_id'] . "
				AND customer_group_id = ". (int) $data['customer_group_id']

		);
	}

	public function updateGlobalAttributeValues($attribute_id, $data) {
		$language_id = $this->session->data['content_language_id'];
		$attribute_manager = new AAttribute_Manager();
		$data = (array)$data;

		if ( isset($data['settings']) ) {
			if ( isset($this->request->get['name']) ) {
				$data['name'] = $this->request->get['name'];
			}
			$attribute_manager->updateAttribute($attribute_id, $data);
		} else {
			$data['attribute_value_id'] = (array)$data['attribute_value_id'];
			foreach ( $data['attribute_value_id'] as $key => $status ) {
				$value_data = array(
					'attribute_value_id' => $data['attribute_value_id'][$key],
					'name' => $data['name'][$key],
					'sort_order' => $data['sort_order'][$key],
				);

				//Check if new, delete or update
				if ( $status == 'delete' && strpos($key,'new')===FALSE) {
					//delete this attribute value for all languages
					$attribute_manager->deleteAttributeValueDescription($key, $language_id);
					$attribute_manager->deleteAttributeValues($key);
				}
				else if ( $status == 'new') {
					// Need to create new attribute value
					$val_id = $attribute_manager->addAttributeValue($attribute_id, $value_data['sort_order']);
					$langs = $this->language->getAvailableLanguages();
					foreach ( $langs as $lang ) {
						$attribute_manager->addAttributeValueDescription ($attribute_id, $val_id, $lang['language_id'], $value_data['name']);
					}
				} else {
					//Existing need to update
					$attribute_manager->updateAttributeValue($key, $value_data['sort_order']);
					$attribute_manager->updateAttributeValueDescription($attribute_id, $key, $language_id, $value_data['name']);
				}
			}
		}

		$this->clearCache();
	}

	public function deleteGlobalAttributeValueDescription($attribute_value_id) {
		$this->db->query(
			"DELETE FROM ".$this->db->table('global_attributes_value_descriptions')."
			 WHERE attribute_value_id = " . (int) $attribute_value_id
		);
		$this->clearCache();
	}

	public function getOrderAttributes($orderID) {

		$attributes = $this->db->query("
			SELECT oa.order_attribute_id, oa.global_attribute_id, ga.sort_order
			FROM ".$this->db->table('order_attributes')." oa
			LEFT JOIN ".$this->db->table('global_attributes')." ga ON ga.attribute_id = oa.global_attribute_id
			WHERE oa.order_id = " . (int) $orderID."
			ORDER BY ga.sort_order"
		);

		$results = $attributes->rows;

		foreach ( $results as &$item ) {
			$selected_values = $this->db->query(
				"SELECT order_attribute_value_id, order_attribute_value
				FROM " . $this->db->table('order_attribute_values') . "
				WHERE order_attribute_id = " . $item['order_attribute_id'] . "
				ORDER BY order_attribute_value_id"
			);
			$item['selected_values'] = $selected_values->rows;

			$item = array_merge($item, $this->getAttributeInfo($item['global_attribute_id']));
		}

		return $results;
	}

	public function getOrderAttributesIds($orderID) {
		$ids = array();
		$res = $this->db->query("SELECT order_attribute_id
								FROM ".$this->db->table('order_attributes')."
								WHERE order_id = " . (int) $orderID);
		foreach ( $res->rows as $row ) {
			$ids[] = $row['order_attribute_id'];
		}
		return $ids;
	}

	public function updateOrderAttributeValues($orderID, $data) {
		if ( !has_value($data) ) {
			return null;
		}

		$ids = $this->getOrderAttributesIds($orderID);

		foreach ( $data as $key => $item ) {
			//protect from editing wrong order
			if ( in_array($key, $ids) ) {
				$this->db->query("DELETE FROM ".$this->db->table('order_attribute_values')."
								  WHERE order_attribute_id = " . (int) $key);
				if ( is_array($item) ) {
					foreach ( $item as $val ) {
						$this->db->query(
							"INSERT INTO ".$this->db->table('order_attribute_values')."
							SET order_attribute_id = " . (int) $key .",
								order_attribute_value = '" . $this->db->escape($val) . "'");
					}
				} else {
					$this->db->query(
						"INSERT INTO ".$this->db->table('order_attribute_values')."
						SET order_attribute_id = " . (int) $key .",
							order_attribute_value = '" . $this->db->escape($item) . "'"	);
				}
			}
		}
	}

	private function clearCache(){
	}

}