<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

/**
 * Class ControllerPagesSaleOrderAttributes
 * @property ModelSaleOrderAttributes $model_sale_order_attributes
 */
class ControllerPagesSaleOrderAttributes extends AController {
	public $data = array();

	public function main() {

		$this->loadModel('sale/order_attributes');

		if ($this->request->is_POST() && $this->_validateForm() ) {
			if ( !isset($this->request->post['global_attribute_id']) || !is_numeric($this->request->post['global_attribute_id']) ) {
				$this->request->post['global_attribute_id'] = $this->_addGlobalAttribute($this->request->post);
			}
			$this->model_sale_order_attributes->addAttributeToGroup($this->request->get['customer_group_id'], $this->request->post);
			$this->redirect($this->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id'] ));
		}
		
	}

	public function update() {

		$this->loadLanguage('extension/order_attributes');

		$this->document->setTitle( $this->language->get('order_attributes_name') );

		$this->document->initBreadcrumb( array (
       		'href'      => $this->html->getSecureURL('index/home'),
       		'text'      => $this->language->get('text_home'),
      		'separator' => FALSE
   		));

		$this->document->addBreadcrumb( array (
       		'href'      => $this->html->getSecureURL('sale/customer_group'),
       		'text'      => $this->language->get('breadcrumb_customer_groups'),
      		'separator' => ' :: '
   		));

		$this->document->addBreadcrumb( array (
       		'href'      => $this->html->getSecureURL('sale/customer_group/update', '&customer_group_id=' . $this->request->get['customer_group_id'] ),
       		'text'      => $this->language->get('breadcrumb_edit_group'),
      		'separator' => ' :: '
   		));


   		$this->document->addBreadcrumb( array (
       		'href'      => $this->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id']),
       		'text'      => $this->language->get('order_attributes_name'),
      		'separator' => ' :: ',
	        'current'  => true
   		));

		$this->data['heading_title'] = $this->language->get('order_attributes_name');


		$tabs['general'] = array(
			'name' => 'customer_group_edit',
			'text' => $this->language->get('tab_general'),
			'href' => $this->html->getSecureURL('sale/customer_group/update', '&customer_group_id=' . $this->request->get['customer_group_id'], true),
			'sort_order' => 0
		);

		$tabs['order_attributes'] = array(
			'name' => 'order_attributes',
			'text' => $this->language->get('order_attributes_name'),
			'href' => $this->html->getSecureURL('sale/order_attributes/update', '&customer_group_id=' . $this->request->get['customer_group_id']),
			'active' => true
		);

		$obj = $this->dispatch('responses/common/tabs', array(
						'sale/customer_group', //parent controller. Use customer group to use for other extensions that will add tabs via their hooks
						array('tabs' => $tabs))
		);
		$this->data['tabs'] = $obj->dispatchGetOutput();

		$attributes = array(
			'new' => $this->language->get('text_add_new_attribute')
		);

		$this->attribute_manager = new AAttribute_Manager();
		$results = $this->attribute_manager->getAttributes(
			array(
				'search' => " ga.attribute_type_id = '" . $this->attribute_manager->getAttributeTypeID('order_attribute') . "'
				AND ga.status = 1
				AND ga.attribute_parent_id = 0 ",
				'limit' => 100
			),
			$this->language->getContentLanguageID()
		);

		foreach ($results as $type) {
			$attributes[$type['attribute_id']] = $type['name'];
		}

		$this->data['order_attributes_name'] = $this->language->get('order_attributes_name');
		$this->data['error_required'] = $this->language->get('error_required');

		$this->loadModel('sale/order_attributes');

		$this->data['group_attributes'] = array();

		if ( $this->request->get['customer_group_id'] ) {

			$group_attributes = $this->model_sale_order_attributes->getAttributesForGroup(
				$this->request->get['customer_group_id'],
				$this->language->getContentLanguageID()
			);
			foreach($group_attributes as $row){
				$options[$row['global_attribute_id']] = $row['name'];
			}
			$this->data['group_attributes'] = $this->html->buildElement(array(
						'type' => 'selectbox',
						'name' => 'order_attribute_id',
						'options' => $options,
					));

		}


		$form = new AForm('HT');

		$form->setForm(array(
		    'form_name' => 'new_attribute_form',
		    'update' => ''
	    ));

		$this->data['action'] = $this->html->getSecureURL(
			'sale/order_attributes',
			'&customer_group_id=' . $this->request->get['customer_group_id']
		);

	    $this->data['form']['form_open'] = $form->getFieldHtml(array(
		    'type' => 'form',
		    'name' => 'new_attribute_form',
		    'action' => $this->data['action'],
		    'attr' => 'data-confirm-exit="true"  class="form-horizontal"'
	    ));

		$this->data['attributes'] = $form->getFieldHtml(array(
			'type' => 'selectbox',
			'name' => 'global_attribute_id',
			'options' => $attributes,
			'style' => 'chosen',
		));

		$this->data['form']['submit'] = $form->getFieldHtml(array(
			'type' => 'button',
			'name' => 'submit',
			'text' => $this->language->get('button_add_attribute'),
			'style' => 'button1',
		));

		$this->data['button_reset'] = $this->html->buildButton(array(
			'text' => $this->language->get('button_reset'),
			'style' => 'button2',
		));

		$results = HtmlElementFactory::getAvailableElements();

        $element_types = array( '' => $this->language->get('text_select'));
        foreach ($results as $key => $type) {
	        if(!in_array($key,array('P','L','Z'))) // zones, captcha and multivalue element type disabled for now
            $element_types[$key] = $type['type'];
        }

		$this->data['entry_name'] = $this->language->get('entry_attribute_name');
		$this->data['attribute_name'] = $form->getFieldHtml(array(
            'type' => 'input',
			'name' => 'attribute_name',
            'required' => true,
		));

		$this->data['entry_status'] = $this->language->get('entry_status');
        $this->data['status'] = $form->getFieldHtml(array(
            'type' => 'checkbox',
            'name' => 'status',
            'value' => 1,
            'style' => 'btn_switch',
        ));

        $this->data['entry_sort_order'] = $this->language->get('entry_sort_order');
        $this->data['sort_order'] = $form->getFieldHtml(array(
            'type' => 'input',
            'name' => 'sort_order',
            'style' => 'small-field'
        ));

        $this->data['entry_required'] = $this->language->get('entry_required');
        $this->data['required'] = $form->getFieldHtml(array(
            'type' => 'checkbox',
            'name' => 'required',
	        'value'=> 1
        ));

        $this->data['entry_element_type'] = $this->language->get('entry_element_type');
        $this->data['element_type'] = $form->getFieldHtml(array(
            'type' => 'selectbox',
            'name' => 'element_type',
            'required' => true,
            'options' => $element_types,
        ));


		$this->data['urls'] = array();
		$this->data['urls']['get_attributes_list'] = $this->html->getSecureURL('order_attributes/attributes/get_attributes_list', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['urls']['load_attribute'] = $this->html->getSecureURL('order_attributes/attributes/load_attribute', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['urls']['update_attribute'] = $this->html->getSecureURL('order_attributes/attributes/update_attribute', '&customer_group_id=' . $this->request->get['customer_group_id']);
		$this->data['text_success_attribute'] = $this->language->get('text_success_attribute');


		$this->data['add_attribute_url'] = $this->html->getSecureURL('catalog/attribute/insert', '&attribute_type_id='.$this->attribute_manager->getAttributeTypeID('customer_attribute'));

		$this->data['help_url'] = $this->gen_help_url('order_attributes');
		$this->data['form_language_switch'] = $this->html->getContentLanguageSwitcher();

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/order_attributes/attributes_form.tpl');
	}


	public function details() {

		$this->data = array('parent_controller' => 'sale/order_attributes/details');
		$this->loadLanguage('extension/order_attributes');
		$this->loadLanguage('sale/order');
		$this->loadModel('sale/order_attributes');
		$this->loadModel('sale/order');

		//load tabs controller
		$tabs_obj = $this->dispatch('pages/sale/order_tabs', array($this->data));
		$this->data['order_tabs'] = $tabs_obj->dispatchGetOutput();

		$this->addChild('pages/sale/order_summary', 'summary_form', 'pages/sale/order_summary.tpl');

    	$this->document->setTitle( $this->language->get('heading_title') );

    	if ($this->request->is_POST() && $this->_validateForm()) {
			$this->model_sale_order_attributes->updateOrderAttributeValues($this->request->get['order_id'], $this->request->post['attributes']);
			$this->session->data['success'] = $this->language->get('text_success');
			$this->redirect($this->html->getSecureURL('sale/order_attributes/details', '&order_id='.$this->request->get['order_id']));
		}

		if (isset($this->request->get['order_id'])) {
			$order_id = $this->request->get['order_id'];
		} else {
			$order_id = 0;
		}

    	$order_info = $this->model_sale_order->getOrder($order_id);

		if (empty($order_info)) {
			$this->session->data['error'] = $this->language->get('error_order_load');
			$this->redirect($this->html->getSecureURL('sale/order'));
		}

		$this->document->initBreadcrumb( array (
			'href'      => $this->html->getSecureURL('index/home'),
			'text'      => $this->language->get('text_home'),
			'separator' => FALSE
		 ));

		$this->document->addBreadcrumb( array (
			'href'      => $this->html->getSecureURL('sale/order'),
			'text'      => $this->language->get('heading_title'),
			'separator' => ' :: '
		 ));
		$this->document->addBreadcrumb( array (
			'href'      => $this->html->getSecureURL('sale/order/details', '&order_id='. $this->request->get['order_id'] ),
			'text'      => $this->language->get('heading_title') .' #'.$order_info['order_id'],
			'separator' => ' :: '
		 ));
		$this->document->addBreadcrumb( array (
			'href'      => $this->html->getSecureURL('sale/order_attributes/details', '&order_id='. $this->request->get['order_id'] ),
			'text'      => $this->language->get('order_attributes_name'),
			'separator' => ' :: ',
			'current'   => true
		 ));

		if (isset($this->session->data['success'])) {
			$this->data['success'] = $this->session->data['success'];
			unset($this->session->data['success']);
		} else {
			$this->data['success'] = '';
		}

		$this->data['order_id'] = $this->request->get['order_id'];
		$this->data['invoice'] = $this->html->getSecureURL('sale/invoice', '&order_id=' . (int)$this->request->get['order_id']);
		$this->data['button_invoice'] = $this->html->buildButton(array('name' => 'invoice', 'text' => $this->language->get('text_invoice'), 'style' => 'button3',));
		$this->data['action'] = $this->html->getSecureURL('sale/order_attributes/details', '&order_id=' . $this->request->get['order_id']);
		$this->data['cancel'] = $this->html->getSecureURL('sale/order');
		$this->data['common_zone'] = $this->html->getSecureURL('common/zone');

		$this->data['form_title'] = $this->language->get('edit_title_order_attributes');
		$form = new AForm('ST');

		$form->setForm(array(
		    'form_name' => 'orderAttrFrm',
			'update' => ''//$this->data['update'],
	    ));

        $this->data['form']['id'] = 'orderAttrFrm';
        $this->data['form']['form_open'] = $form->getFieldHtml(array(
		    'type' => 'form',
		    'name' => 'orderAttrFrm',
		    'action' => $this->data['action'],
		    'attr' => 'data-confirm-exit="true"  class="form-horizontal"',
	    ));
        $this->data['form']['submit'] = $form->getFieldHtml(array(
		    'type' => 'button',
		    'name' => 'submit',
		    'text' => $this->language->get('button_save'),
		    'style' => 'button1',
	    ));
		$this->data['form']['cancel'] = $form->getFieldHtml(array(
		    'type' => 'button',
		    'name' => 'cancel',
		    'text' => $this->language->get('button_cancel'),
		    'style' => 'button2',
	    ));

		$this->data['form']['fields'] = array();

		$attributes = $this->model_sale_order_attributes->getOrderAttributes($this->request->get['order_id']);

    	$elements = HtmlElementFactory::getAvailableElements();
		$html_multivalue_elements = HtmlElementFactory::getMultivalueElements();

    	foreach ( $attributes as $attribute ) {

			if ( !isset($attribute['element_type']) ) {
				continue;
			}


			$values = array();
			$value = array();
			if ( count($attribute['selected_values']) > 1 ) {
				foreach ($attribute['selected_values'] as $val) {
					$value[$val['order_attribute_value']] = $val['order_attribute_value'];
				}
			} else {
				$value = $attribute['selected_values'][0]['order_attribute_value'];
			}

			foreach ( $attribute['values'] as $val ) {
				$values[$val['attribute_value_id']] = $val['value'];
			}

			$html_type = $elements[ $attribute['element_type'] ]['type'];

			if ( !in_array($attribute['element_type'], $html_multivalue_elements) ) {
				$option_name = 'attributes['.$attribute['order_attribute_id'].']';
			} else {
				$option_name = 'attributes['.$attribute['order_attribute_id'].']['.$attribute['order_attribute_value_id'].']';
			}

			$option_data = array(
				'type' => $html_type,
				'name' => $option_name,
				'value' => $value,
				'options' => $values,
				'required' => $attribute['required'],
				'style' => 'large-field'
			);

			// for ipadress
			if($html_type=='IPaddress'){
				$option_data['type'] = 'input';
			}

			if ( $attribute['element_type'] == 'Z' ) { // set selected zone
				$option_data['zone_name'] = $attribute['selected_values'][1]['order_attribute_value'];
			}

			if ( $html_type == 'checkbox' ) {
				$option_data['label_text'] = $value;
				if ( !empty($option_data['value']) && !empty($attribute['selected_values']) ) {
					$option_data['checked'] = true;
				}
			} elseif ( $html_type == 'checkboxgroup' ) {
				$option_data['scrollbox'] = false;
				$option_data['style'] = 'small-field';
			} elseif ( $html_type == 'hidden' ) {
				$option_data['type'] = 'input';
			}

			$this->data['entry_attribute_'.$attribute['order_attribute_id']] = $attribute['name'];

			if ( $html_type == 'file' ) {
				$field_value = '<a href="' . $this->html->getSecureURL('tool/files/download', '&filename=' . urlencode($value) . '&attribute_id=' . (int) $attribute['global_attribute_id']) . '&attribute_type=order_attribute" title=" to download file" target="_blank">' . $value . '</a>';
			} else {
				$field_value = $this->html->buildElement($option_data);
			}
			$this->data['form']['fields']['attribute_'.$attribute['order_attribute_id']] = $field_value;

		}

		$this->view->assign('help_url', $this->gen_help_url('order_payment') );

		$this->view->batchAssign($this->data);
		$this->processTemplate('pages/order_attributes/attributes_details.tpl');
	}

	private function _addGlobalAttribute($data) {

		$attribute_manager = new AAttribute_Manager();

    	$insert = array(
    		'name' => $data['attribute_name'],
    		'attribute_type_id' => $attribute_manager->getAttributeTypeID('order_attribute'),
    		'element_type' => $data['element_type'],
    		'sort_order' => $data['sort_order'],
    		'required' => $data['required'],
    		'status' => 1
    	);

    	if ( !isset($data['values']) ) {
    		$insert['values'][0] = '';
    	} else {
    		$insert['values'] = $data['values'];
    	}

    	if ( !isset($data['sort_orders']) ) {
    		$insert['sort_orders'][0] = '';
    	} else {
    		$insert['sort_orders'] = $data['sort_orders'];
    	}

    	return $attribute_manager->addAttribute($insert);
	}

	private function _validateForm() {
		if (!$this->user->hasPermission('modify', 'sale/order_attributes')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}

		if (!$this->error) {
			return TRUE;
		} else {
			return FALSE;
		}
	}

	
}