<?php
/*------------------------------------------------------------------------------
  $Id$

  AbanteCart, Ideal OpenSource Ecommerce Solution
  http://www.AbanteCart.com

  Copyright © 2011 Belavier Commerce LLC

  This source file is subject to Open Software License (OSL 3.0)
  License details is bundled with this package in the file LICENSE.txt.
  It is also available at this URL:
  <http://www.opensource.org/licenses/OSL-3.0>

 UPGRADE NOTE:
   Do not edit or add to this file if you wish to upgrade AbanteCart to newer
   versions in the future. If you wish to customize AbanteCart for your
   needs please refer to http://www.AbanteCart.com for more information.
------------------------------------------------------------------------------*/
if (!defined('DIR_CORE')) {
	header('Location: static_pages/');
}

/**
 * Class ControllerResponsesExtensionOfflineCreditCardProcessing
 * @property ModelExtensionOfflineCreditCardProcessing $model_extension_offline_credit_card_processing
 *
 */
class ControllerResponsesExtensionOfflineCreditCardProcessing extends AController {
	public $data;
	public function main() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->loadLanguage('offline_credit_card_processing/offline_credit_card_processing');
		$data = $this->_prepare_data();
		$back = $this->request->get[ 'rt' ] != 'checkout/guest_step_3'
												? $this->html->getSecureURL('checkout/payment')
												: $this->html->getSecureURL('checkout/guest_step_2');
		$data[ 'back' ] = HtmlElementFactory::create(
									array(
											'type' => 'button',
											'name' => 'back',
											'text' => $this->language->get('button_back'),
											'style' => 'button',
											'href' => $back
									));

		$data[ 'submit' ] = HtmlElementFactory::create(
									array(
											'type' => 'button',
											'name' => 'cc_submit_button',
											'text' => $this->language->get('button_confirm'),
											'style' => 'btn-orange button',
											'icon'  => 'icon-ok'
									));
		$this->view->batchAssign($data);

		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);

		//load creditcard input validation
		$this->document->addScriptBottom($this->view->templateResource('/javascript/credit_card_validation.js'));
		$this->processTemplate('responses/offline_credit_card_processing.tpl');
	}

	public function api() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		$this->loadLanguage('offline_credit_card_processing/offline_credit_card_processing');

		$this->data = $this->_prepare_data();

		$this->data[ 'process_rt' ] = 'offline_credit_card_processing/send';
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
		$this->load->library('json');
		$this->response->setOutput(AJson::encode($this->data));
	}

	protected function _prepare_data () {
		$data = array();
		$data[ 'text_credit_card' ] = $this->language->get('text_credit_card');
		$data[ 'text_wait' ] = $this->language->get('text_wait');
		$data[ 'entry_cc_owner' ] = $this->language->get('entry_cc_owner');
		$this->loadModel('checkout/order');
		$order_info = $this->model_checkout_order->getOrder($this->session->data['order_id']);
		$data[ 'cc_owner' ] = HtmlElementFactory::create(
										array(
												'type' => 'input',
												'name' => 'cc_owner',
												'value' => $order_info['payment_firstname'] . ' ' . $order_info['payment_lastname']
										));
		$cc_types = explode(',', $this->config->get('offline_credit_card_processing_cc_types'));
		$cc_types_display = array('');
		foreach ($cc_types as $type){
			$cc_types_display[trim($type)] = trim($type);
		} 
		$data[ 'entry_cc_type' ] = $this->language->get('entry_cc_type');
		$data[ 'cc_type' ] = HtmlElementFactory::create(
										array(
												'type' => 'selectbox',
												'name' => 'cc_type',
												'options' => $cc_types_display,
												'value' => ''
										));

		$data[ 'entry_cc_number' ] = $this->language->get('entry_cc_number');
		$data[ 'cc_number' ] = HtmlElementFactory::create(
										array(
												'type' => 'input',
												'name' => 'cc_number',
												'value' => ''
										));

		$data[ 'entry_cc_expire_date' ] = $this->language->get('entry_cc_expire_date');

		$data[ 'entry_cc_cvv2' ] = $this->language->get('entry_cc_cvv2');
		$data[ 'entry_cc_cvv2_short' ] = $this->language->get('entry_cc_cvv2_short');
		$data['cc_cvv2_help_url'] = $this->html->getURL('r/extension/offline_credit_card_processing/cvv2_help');

		$data[ 'cc_cvv2' ] = HtmlElementFactory::create(
										array(
												'type' => 'input',
												'name' => 'cc_cvv2',
												'value' => '',
												'style' => 'short',
												'attr' => ' size="3" '
										));

		$data[ 'button_confirm' ] = $this->language->get('button_confirm');
		$data[ 'button_back' ] = $this->language->get('button_back');

		$months = array();

		for ($i = 1; $i <= 12; $i++) {
			$months[ sprintf('%02d', $i) ] = strftime('%B', mktime(0, 0, 0, $i, 1, 2000));
		}
		$data[ 'cc_expire_date_month' ] = HtmlElementFactory::create(
													array(
															'type' => 'selectbox',
															'name' => 'cc_expire_date_month',
															'value' => sprintf('%02d', date('m')),
															'options' => $months,
															'style' => 'input-medium short'
													));
		$data[ 'cc_expire_date_month' ] = $data[ 'cc_expire_date_month' ]->getHtml();

		$today = getdate();
		$years = array();
		for ($i = $today[ 'year' ]; $i < $today[ 'year' ] + 11; $i++) {
			$years[ strftime('%Y', mktime(0, 0, 0, 1, 1, $i)) ] = strftime('%Y', mktime(0, 0, 0, 1, 1, $i));
		}
		$data[ 'cc_expire_date_year' ] = HtmlElementFactory::create(
													array(
															'type' => 'selectbox',
															'name' => 'cc_expire_date_year',
															'value' => sprintf('%02d', date('Y') + 1),
															'options' => $years,
															'style' => 'short'
													));
		$data[ 'cc_expire_date_year' ] = $data[ 'cc_expire_date_year' ]->getHtml();
		return $data;
	}


	public function send() {
		//init controller data
		$this->extensions->hk_InitData($this, __FUNCTION__);
		//validate input 
		$message = '';
		if ( !has_value($this->request->post[ 'cc_type' ]) ) {
			$message .= "Please provide credit card type". "\n";
		}
		if ( !$this->_valid_cardnumber($this->request->post[ 'cc_number' ]) ) {
			$message .= "Credit card number is incorrect". "\n";
		}
		if ( !$this->_valid_exp_date($this->request->post[ 'cc_expire_date_month' ], $this->request->post[ 'cc_expire_date_year' ]) ) {
			$message .= "Credit card expiration date is incorrect". "\n";
		}
		if ( !has_value($this->request->post[ 'cc_cvv2' ]) ) {
			$message .= "Please provide Credit Card CVV". "\n";
		}

		if ( !$message ) {
			$this->load->model('checkout/order');
			$this->load->model('extension/offline_credit_card_processing');
			$encryption = new AEncryption( AEncryption::getHash($this->config->get('offline_credit_card_processing_encryption_key')));
			$cc_data = array(
				'order_id' => $this->session->data[ 'order_id' ],
				'card_data' => $encryption->encrypt( serialize($this->request->post) ),
			);
			if ( $this->model_extension_offline_credit_card_processing->save_cc_details( $cc_data ) ) {
				$this->model_checkout_order->confirm(
													$this->session->data[ 'order_id' ],
													$this->config->get('offline_credit_card_processing_status_id'
						));
				$this->data[ 'success' ] = $this->html->getSecureURL('checkout/success');
			} else {
				$this->data[ 'error' ] = 'Error with processing your order. Please try again.';
			}
		} else {
			$this->data[ 'error' ] = $message;
		}
		//update controller data
		$this->extensions->hk_UpdateData($this, __FUNCTION__);
		$this->load->library('json');
		$this->response->setOutput(AJson::encode($this->data));
	}

	public function cvv2_help() {
		//init controller data
		$this->extensions->hk_InitData($this,__FUNCTION__);
		$this->loadLanguage('offline_credit_card_processing/offline_credit_card_processing');
		$image = '<img src="' . $this->view->templateResource('/image/securitycode.jpg') . '" alt="' . $this->language->get('entry_what_cvv2') . '" />';
		$this->view->assign('title', '' );
		$this->view->assign('description', $image );

		//update controller data
		$this->extensions->hk_UpdateData($this,__FUNCTION__);
		$this->processTemplate('responses/content/content.tpl' );
	}

	/**
	 * @param $cc
	 * @return bool|mixed
	 */
	protected function _valid_cardnumber($cc) {
		$cards = array(
						"visa" => "(4\d{12}(?:\d{3})?)",
						"amex" => "(3[47]\d{13})",
						"jcb" => "(35[2-8][89]\d\d\d{10})",
						"maestro" => "((?:5020|5038|6304|6579|6761)\d{12}(?:\d\d)?)",
						"solo" => "((?:6334|6767)\d{12}(?:\d\d)?\d?)",
						"mastercard" => "(5[1-5]\d{14})",
						"switch" => "(?:(?:(?:4903|4905|4911|4936|6333|6759)\d{12})|(?:(?:564182|633110)\d{10})(\d\d)?\d?)",
						"other" => "(\d{16})",
		);
		$names = array("Visa", "American Express", "JCB", "Maestro", "Solo", "Mastercard", "Switch","other");
		$matches = array();
		$pattern = "#^(?:".implode("|", $cards).")$#";
		$result = preg_match($pattern, str_replace(" ", "", $cc), $matches);
		return ($result>0) ? $names[sizeof($matches)-2] : false;
	}

	protected function _valid_exp_date($month, $year) {
		/* Get timestamp of midnight on day after expiration month. */
		$exp_ts = mktime(0, 0, 0, $month + 1, 1, $year);
		$cur_ts = time();
		/* Don't validate for dates more than 10 years in future. */
		$max_ts = $cur_ts + (10 * 365 * 24 * 60 * 60);
		if ($exp_ts > $cur_ts && $exp_ts < $max_ts) {
			return true;
		} else {
			return false;
		}
	}
}