<?php
if ( !defined ( 'DIR_CORE' )) {
	header ( 'Location: static_pages/' );
}

class ExtensionOfflineCreditCardProcessing extends Extension {

	protected $registry;
	protected $r_data;

	public function  __construct() {
		$this->registry = Registry::getInstance();
	}

	//Hook to enable payment details tab in admin 
	public function onControllerPagesSaleOrderTabs_UpdateData() {
		$that = $this->baseObject;
		$order_id = $that->data['order_id'];
		//are we logged in and in admin?
		if ( IS_ADMIN && $that->user->isLogged() ) {
			//check if tab is not yet enabled.
			if ( in_array('payment_details', $that->data['groups'])) {
				return null;
			}
			//check if we this order is used this payment
			$this->_load_order_data($order_id, $that);
			if ( !$this->r_data ) {
				return;
			}
			$that->data['groups'][] = 'payment_details';
			$that->data['link_payment_details'] = $that->html->getSecureURL('sale/credit_card_details/details', '&order_id=' . $order_id);
			//reload main view data with updated tab
			$that->view->batchAssign( $that->data );
		}
	}

	protected function _load_order_data($order_id, $that) {
		//data already loaded, return 
		if ( $this->r_data ) {
			return null;
		}

		//load realex data
		$that->loadModel('sale/credit_card_details');
		$this->r_data = $that->model_sale_credit_card_details->getCardCarddetails($order_id);
		return null;
	}

}