<?php

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

class ExtensionFoxyTemplate extends Extension
{
    /**************************************************/
    public function onControllerPagesProductProduct_InitData()   // prodpage
    {
        $product_id = (int) $this->baseObject->request->get['product_id'];
        if (empty($product_id)) {//cart revert
            $product_id = (int) $this->baseObject->request->get['key'];
        }
        $this->baseObject->loadModel('catalog/review');
        $totalreviews = $this->baseObject->model_catalog_review->getTotalReviewsByProductId($product_id);
        $average = $this->baseObject->model_catalog_review->getAverageRating($product_id);
        $offer_url = $this->baseObject->html->getSEOURL('product/product', '&product_id='.$product_id, '&encode');
        $this->baseObject->view->assign('totalreviews', $totalreviews);
        $this->baseObject->view->assign('average', $average);
        $this->baseObject->view->assign('offer_url', $offer_url);
    }

    public function onControllerCommonHead_UpdateData()
    {
        //$data['notification_page_a'] = '0';
        //$data['notification_hide_mobile'] = $this->baseObject->config->get('notification_hide_mobile');

        //$view = new AView($this->registry, 0);
        //$view->batchAssign($data);

        function colourBrightness_foxy($hex, $percent)
        {
            // Work out if hash given
            $hash = '';
            if (stristr($hex, '#')) {
                $hex = str_replace('#', '', $hex);
                $hash = '#';
            }
            /// HEX TO RGB
            $rgb = array(hexdec(substr($hex, 0, 2)), hexdec(substr($hex, 2, 2)), hexdec(substr($hex, 4, 2)));
            //// CALCULATE
            for ($i = 0; $i < 3; ++$i) {
                // See if brighter or darker
                if ($percent > 0) {
                    // Lighter
                    $rgb[$i] = round($rgb[$i] * $percent) + round(255 * (1 - $percent));
                } else {
                    // Darker
                    $positivePercent = $percent - ($percent * 2);
                    $rgb[$i] = round($rgb[$i] * $positivePercent) + round(0 * (1 - $positivePercent));
                }
                // In case rounding up causes us to go to 256
                if ($rgb[$i] > 255) {
                    $rgb[$i] = 255;
                }
            }
            //// RBG to Hex
            $hex = '';
            for ($i = 0; $i < 3; ++$i) {
                // Convert the decimal digit to hex
                $hexDigit = dechex($rgb[$i]);
                // Add a leading zero if necessary
                if (1 == strlen($hexDigit)) {
                    $hexDigit = '0'.$hexDigit;
                }
                // Append to the hex string
                $hex .= $hexDigit;
            }
            //return $hash.$hex;
            return $hex;
        }
        /*Lighten a colour
        $colour = '#ae64fe';
        $brightness = 0.5; // 50% brighter
        $newColour = colourBrightness_foxy($colour,$brightness);

        /*Darken
        $colour = '#ae64fe';
        $brightness = -0.5; // 50% darker
        $newColour = colourBrightness_foxy($colour,$brightness);
        */
        /*****************************************************************/
        $this->baseObject->view->assign('foxy_template_header_size_1', ($this->baseObject->config->get('foxy_template_header_size_1')));

        $this->baseObject->view->assign('foxy_template_font_color_1', ($this->baseObject->config->get('foxy_template_font_color_1')));
        $this->baseObject->view->assign('foxy_template_font_color_2', ($this->baseObject->config->get('foxy_template_font_color_2')));
        $this->baseObject->view->assign('foxy_template_font_color_3', ($this->baseObject->config->get('foxy_template_font_color_3')));

        $this->baseObject->view->assign('foxy_template_font_color_links', ($this->baseObject->config->get('foxy_template_font_color_links')));

        $this->baseObject->view->assign('foxy_template_color_headerstrip', ($this->baseObject->config->get('foxy_template_color_headerstrip')));

        $this->baseObject->view->assign('foxy_template_header_link_color', ($this->baseObject->config->get('foxy_template_header_link_color')));
        $this->baseObject->view->assign('foxy_template_header_logo_bg_color', ($this->baseObject->config->get('foxy_template_header_logo_bg_color')));

        $this->baseObject->view->assign('foxy_template_color_button_1', ($this->baseObject->config->get('foxy_template_color_button_1')));
        $foxy_template_color_button_1_darken = colourBrightness_foxy($this->baseObject->config->get('foxy_template_color_button_1'), 0.5);
        $this->baseObject->view->assign('foxy_template_color_button_1_mouseover', $foxy_template_color_button_1_darken);
        $this->baseObject->view->assign('foxy_template_color_button_2', ($this->baseObject->config->get('foxy_template_color_button_2')));
        $foxy_template_color_button_2_darken = colourBrightness_foxy($this->baseObject->config->get('foxy_template_color_button_2'), 0.5);
        $this->baseObject->view->assign('foxy_template_color_button_2_mouseover', $foxy_template_color_button_2_darken);

        $this->baseObject->view->assign('foxy_template_color_menu_1', ($this->baseObject->config->get('foxy_template_color_menu_1')));

        $this->baseObject->view->assign('foxy_template_color_footer_1', ($this->baseObject->config->get('foxy_template_color_footer_1')));
        $this->baseObject->view->assign('foxy_template_color_footerlinks', ($this->baseObject->config->get('foxy_template_color_footerlinks')));
        $this->baseObject->view->assign('foxy_template_color_footerblocks', ($this->baseObject->config->get('foxy_template_color_footerblocks')));

        $this->baseObject->view->assign('foxy_template_font_color_heading1', ($this->baseObject->config->get('foxy_template_font_color_heading1')));
        $this->baseObject->view->assign('foxy_template_font_color_heading2', ($this->baseObject->config->get('foxy_template_font_color_heading2')));

        $this->baseObject->view->assign('foxy_template_font_color_pricetag', ($this->baseObject->config->get('foxy_template_font_color_pricetag')));

        $this->baseObject->view->assign('foxy_template_font_color_footermain', ($this->baseObject->config->get('foxy_template_font_color_footermain')));

        $this->baseObject->view->assign('foxy_template_banner_color', ($this->baseObject->config->get('foxy_template_banner_color')));

        $this->baseObject->view->assign('foxy_template_color_category_bg', ($this->baseObject->config->get('foxy_template_color_category_bg')));

        $this->baseObject->view->assign('foxy_template_body_font_size', ($this->baseObject->config->get('foxy_template_body_font_size')));

        $this->baseObject->view->assign('foxy_template_buttons_font_size', ($this->baseObject->config->get('foxy_template_buttons_font_size')));

        $this->baseObject->view->assign('foxy_template_header_logomaxsize', ($this->baseObject->config->get('foxy_template_header_logomaxsize')));

        $this->baseObject->view->assign('foxy_template_round', ($this->baseObject->config->get('foxy_template_round')));

        $this->baseObject->view->assign('foxy_template_body_bg_fixed', ($this->baseObject->config->get('foxy_template_body_bg_fixed')));
    }

    /******************/
}
