<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' )) {
    header ( 'Location: static_pages/' );
}

include_once DIR_EXT.'fedex_integration'.DIR_EXT_CORE.'lib/autoload.php';
require_once DIR_SYSTEM . "lib/vendor/autoload.php";

/**
 * ModelExtensionFedexIntegration
 * @property ModelExtensionfedexVerify $model_extension_fedex_verify
 */
class ModelExtensionFedexIntegration extends Model {

	public $data=[];

    /**
     * @param $address
     * @return array
     * @throws AException
     */
    function getQuote($address) {
        $this->load->model('extension/fedex_verify');
        $verify = $this->model_extension_fedex_verify->verify();
    	if ($verify===true) {
		    ini_set( "soap.wsdl_cache_enabled", "0" );
		    $cart = $this->cart;

		    $this->extensions->hk_InitData($this, __FUNCTION__);
		    $this->load->language( 'fedex_integration/fedex_integration' );
		    $this->load->model( 'localisation/country' );
		    if ( $this->config->get( 'fedex_integration_status' ) ) {

			    if ( ! $this->config->get( 'fedex_integration_location_id' ) ) {
				    $status = true;
			    } else {
				    $query = $this->db->query( "SELECT *
                                            FROM " . $this->db->table( 'zones_to_locations' ) . "
                                            WHERE location_id = '" . (int) $this->config->get( 'fedex_integration_location_id' ) . "'
                                                AND country_id = '" . (int) $address['country_id'] . "'
                                                AND (zone_id = '" . (int) $address['zone_id'] . "' OR zone_id = '0')" );
				    if ( $query->num_rows ) {
					    $status = true;
				    } else {
					    $status = false;
				    }
			    }
			    $countries = $this->model_localisation_country->getCountries();
			    foreach ( $countries as $item ) {
				    $country[ $item['iso_code_2'] ] = $item['name'];
			    }

			    if ( $status && ! has_value( $country[ $address['iso_code_2'] ] ) ) {
				    $status = false;
			    }
		    } else {
			    $status = false;
		    }

		    $method_data = [];

		    if ( ! $status ) {
			    return $method_data;
		    }
		    $id                  = 'fedex_integration.fedex_integration';
		    $quote_data          = [];
		    $generic_product_ids = $free_shipping_ids = $shipping_price_ids = []; // ids of products without special shipping cost
		    $shipping_price_cost = 0; // total shipping cost of product with fixed shipping price
		    $cart_products       = $cart->getProducts();
		    foreach ( $cart_products as $product ) {
			    //(exclude free shipping products)
			    if ( $product['free_shipping'] || $product['download'] ) {
				    $free_shipping_ids[] = $product['product_id'];
				    continue;
			    }
			    if ( $product['shipping_price'] > 0 ) {
				    $shipping_price_ids[] = $product['product_id'];
				    $shipping_price_cost  += $product['shipping_price'] * $product['quantity'];
			    }
			    $generic_product_ids[] = $product['product_id'];
		    }
		    //convert fixed prices to USD
		    $shipping_price_cost = $this->currency->convert( $shipping_price_cost, $this->config->get( 'config_currency' ), $this->currency->getCode() );

		    if ( $generic_product_ids ) {
			    $api_weight_product_ids = array_diff( $generic_product_ids, $shipping_price_ids );
			    //WHEN ONLY PRODUCTS WITH FIXED SHIPPING PRICES ARE IN BASKET
			    if ( ! $api_weight_product_ids ) {
				    $cost       = $shipping_price_cost;
				    $quote_data = [
					    'fedex_integration_plus' => [
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_fedex_title', 'fedex_integration/fedex_integration' ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ),$this->config->get('config_currency')),
						    'tax_class_id' => $this->config->get( 'fedex_integration_tax_class_id' ),
						    'text'         => $this->currency->format(
							    $this->tax->calculate( $this->currency->convert( $cost,
								    $this->config->get( 'config_currency' ),
								    $this->currency->getCode() ),
								    $this->config->get( 'fedex_integration_tax_class_id' ),
								    $this->config->get( 'config_tax' ) ),
							    $this->currency->getCode(),
							    1.0000000 )
					    ]
				    ];

				    $method_data = [
					    'id'         => 'fedex_integration',
					    'title'      => $this->language->get( 'text_fedex_title', 'fedex_integration/fedex_integration' ),
					    'quote'      => $quote_data,
					    'sort_order' => $this->config->get( 'fedex_integration_sort_order' ),
					    'error'      => ''
				    ];

				    return $method_data;
			    }
		    } else {
			    $api_weight_product_ids = $shipping_price_ids;
		    }
		    $basic_products          = $cart->basicShippingProducts();
		    $basic_products_subtotal = 0;
		    foreach ( $basic_products as $product ) {
			    $product_ids[]           = $product['product_id'];
			    $basic_products_subtotal += $product['total'];
		    }

            if ($basic_products) {
                $weight = $this->weight->convert($cart->getWeight($product_ids), $this->config->get('config_weight_class'), $this->config->get('config_weight_class')) + number_format((float)$this->config->get('fedex_integration_additional_weight'), 2, '.', '');
            } else {
                $weight = 0;
            }
            $weight = ( $weight < 0.1 ? 0.1 : $weight );

		    if ( ! $api_weight_product_ids && $free_shipping_ids ) {
			    $cost = 0.0;
			    if ( $address['iso_code_2'] == 'US' && $this->config->get( 'fedex_integration_free_domestic_method' ) !== 'NONE' ) {
				    $quote_data = [
					    'fedex_integration_plus' => [
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'fedex_integration_free_domestic_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get('config_currency')),
						    'tax_class_id' => $this->config->get( 'fedex_integration_tax_class_id' ),
						    'text'         => $this->currency->format(
							    $this->tax->calculate( $this->currency->convert( $cost,
								    $this->config->get( 'config_currency' ),
								    $this->currency->getCode() ),
								    $this->config->get( 'fedex_integration_tax_class_id' ),
								    $this->config->get( 'config_tax' ) ),
							    $this->currency->getCode(),
							    1.0000000 )
					    ]
				    ];
			    } elseif ( $address['iso_code_2'] != 'US' && $this->config->get( 'fedex_integration_free_international_method' ) !== 'NONE' ) {
				    $quote_data = [
					    'fedex_integration_plus' => [
						    'id'           => $id,
						    'title'        => $this->language->get( 'text_' . $this->config->get( 'fedex_integration_free_international_method' ) ),
						    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ), $this->config->get('config_currency')),
						    'tax_class_id' => $this->config->get( 'fedex_integration_tax_class_id' ),
						    'text'         => $this->currency->format(
							    $this->tax->calculate( $this->currency->convert( $cost,
								    $this->config->get( 'config_currency' ),
								    $this->currency->getCode() ),
								    $this->config->get( 'fedex_integration_tax_class_id' ),
								    $this->config->get( 'config_tax' ) ),
							    $this->currency->getCode(),
							    1.0000000 )
					    ]
				    ];
			    }

			    $method_data = [
				    'id'         => 'fedex_integration',
				    'title'      => $this->language->get( 'text_fedex_title', 'fedex_integration/fedex_integration' ),
				    'quote'      => $quote_data,
				    'sort_order' => $this->config->get( 'fedex_integration_sort_order' ),
				    'error'      => ''
			    ];

			    return $method_data;
		    }

		    ( ( $this->config->get( 'fedex_integration_length' ) == "" ) ? $defaultLength = "5" : $defaultLength = $this->config->get( 'fedex_integration_length' ) );
		    ( ( $this->config->get( 'fedex_integration_width' ) == "" ) ? $defaultWidth = "5" : $defaultWidth = $this->config->get( 'fedex_integration_width' ) );
		    ( ( $this->config->get( 'fedex_integration_height' ) == "" ) ? $defaultHeight = "5" : $defaultHeight = $this->config->get( 'fedex_integration_height' ) );
		    $postcode = str_replace( ' ', '', $address['postcode'] );

		    $length = ceil( $this->length->convert( $defaultLength, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) ) );
		    $width  = ceil( $this->length->convert( $defaultWidth, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) ) );
		    $height = ceil( $this->length->convert( $defaultHeight, $this->config->get( 'config_length_class' ), $this->config->get( 'config_length_class' ) ) );

		    $this->loadModel( 'localisation/country' );
		    $origin = $this->config->get( 'fedex_integration_country' );;
		    $destination    = $address['iso_code_2'];
		    $avg_weight     = $this->config->get( 'fedex_integration_weight' );
		    $avg            = $wt = $top = 0;
		    $avg_quote_data = $new_quote_data = [];
		    if ( $avg_weight !== '' && $weight > $avg_weight ) {
			    $avg = floor( $weight / (int) $avg_weight );
			    $wt  = fmod( $weight, $avg_weight );
		    }
		    $dest = '';

		    if ( $origin === $destination ) {
			    $dest = 'domestic';
		    }

		    if ( $basic_products ) {
			    if ( $avg !== 0 ) {
				    if ( $wt !== 0 ) {
					    $loop = $avg + 1;
					    $top  = $avg + 1;
				    } else {
					    $loop = $avg;
				    }
				    $j = 1;
				    for ( $i = 1; $i <= $loop; $i ++ ) {
					    if ( $j == $top ) {
						    $rateService = $this->_fetchRate( $address, $postcode, $wt, $length, $width, $height, $basic_products_subtotal, $dest );
					    } else {
						    $rateService = $this->_fetchRate( $address, $postcode, $avg_weight, $length, $width, $height, $basic_products_subtotal, $dest );
					    }
					    if ( $rateService ) {
						    $avg_quote_data = $this->_processRate( $rateService, $dest, '');
						    $error_msg      = $avg_quote_data['error_msg'];
						    $avg_quote_data = $avg_quote_data['quote_data'];
					    }
					    if ( $quote_data ) {
						    foreach ( $quote_data as $key => $value ) {
							    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $avg_quote_data[ $key ]['cost'];
							    $quote_data[ $key ]['text'] = $this->currency->format(
                                    $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                        $this->config->get( 'config_currency' ),
                                        $this->currency->getCode() ),
                                        $this->config->get( 'fedex_integration_tax_class_id' ),
                                        $this->config->get( 'config_tax' ) ),
                                    $this->currency->getCode(),
                                    1.0000000 );
						    }
					    } else if ( $avg_quote_data ) {
						    $quote_data = $avg_quote_data;
					    }
					    $j ++;
				    }
			    } else {
				    $rateService = $this->_fetchRate( $address, $postcode, $weight, $length, $width, $height, $basic_products_subtotal, $dest );
				    $quote_data  = $this->_processRate( $rateService, $dest, '' );
				    $error_msg   = $quote_data['error_msg'];
				    $quote_data  = $quote_data['quote_data'];
			    }
		    }

		    foreach ( $cart_products as $product ) {
			    if ( $product['ship_individually'] && $product['shipping_price'] == '0.00' ) {
				    $individualWeight = $this->weight->convert( $this->getIndividualWeight( [$product['product_id']]), $product['weight_class'], $this->config->get( 'config_weight_class' ) ) + number_format( (float) $this->config->get( 'fedex_integration_additional_weight' ), 2, '.', '' );
				    $individualWeight = ( $individualWeight < 0.1 ? 0.1 : $individualWeight );
				    $use_width        = ceil( ( ( $product['width'] != '0.00' ) ? $this->length->convert( $product['width'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) ) );
				    $use_length       = ceil( ( ( $product['length'] != '0.00' ) ? $this->length->convert( $product['length'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) ) );
				    $use_height       = ceil( ( ( $product['height'] != '0.00' ) ? $this->length->convert( $product['height'], $product['length_class'], $this->config->get( 'config_length_class' ) ) : $this->length->convert( '5', $product['length_class'], $this->config->get( 'config_length_class' ) ) ) );

				    $qty            = $product['quantity'];
				    $request        = $this->_fetchRate( $address, $postcode, $individualWeight, $use_length, $use_width, $use_height, $product['price'], $dest );
				    $dom_quote_data = $this->_processRate( $request, $dest, $qty );
				    $error_msg      = $dom_quote_data['error_msg'];
				    $dom_quote_data = $dom_quote_data['quote_data'];
				    if ( $quote_data ) {
					    foreach ( $quote_data as $key => $value ) {
						    $quote_data[ $key ]['cost'] = (float) $quote_data[ $key ]['cost'] + $dom_quote_data[ $key ]['cost'];
						    $quote_data[ $key ]['text'] = $this->currency->format(
                                $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                                    $this->config->get( 'config_currency' ),
                                    $this->currency->getCode() ),
                                    $this->config->get( 'fedex_integration_tax_class_id' ),
                                    $this->config->get( 'config_tax' ) ),
                                $this->currency->getCode(),
                                1.0000000 );
					    }
				    } else if ( $dom_quote_data ) {
					    $quote_data = $dom_quote_data;
				    }
			    }
		    }
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'] + $shipping_price_cost;
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                            $this->config->get( 'fedex_integration_tax_class_id' ),
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title       = $this->language->get( 'text_fedex_title', 'fedex_integration/fedex_integration' );
		    $method_data = [
			    'id'         => 'fedex_integration',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $this->config->get( 'fedex_integration_sort_order' ),
			    'error'      => $error_msg
		    ];

		    return $method_data;
	    }
    }

    /**
     * @param $address
     * @return array
     */
    public function getLocalDelivery($address) {
        $this->load->model('extension/fedex_verify');
        $verify = $this->model_extension_fedex_verify->verify();
		if ($verify === true) {
		    $postcode         = str_replace( ' ', '', $address['postcode'] );
		    $exclude_zipcodes = $this->config->get( 'fedex_integration_local_zipcodes' );
		    $fee              = $this->config->get( 'fedex_integration_local_delivery_fee' );
		    $valid            = '';
		    if ( $fee ) {
			    $cost  = $fee;
			    $title = $this->language->get( 'text_local_delivery_fee' );
		    } else {
			    $cost  = 0;
			    $title = $this->language->get( 'text_free_local_delivery' );
		    }

		    $zipcodes_list = explode( ',', $exclude_zipcodes );
		    if ( $zipcodes_list ) {
			    foreach ( $zipcodes_list as $zipcodes ) {
				    if ( fnmatch( $zipcodes, $postcode ) ) {
					    $valid = '1';
					    break;
				    }
			    }
		    } else {
			    if ( fnmatch( $exclude_zipcodes, $postcode ) ) {
				    $valid = '1';
			    }
		    }
		    if ( $exclude_zipcodes && $valid ) {
			    $local_delivery = [
				    'fedex_integration_local' => [
					    'id'           => 'fedex_integration_local.fedex_integration_local',
					    'title'        => $title,
					    'cost'         => $this->currency->convert( $cost, $this->config->get( 'config_currency' ),$this->config->get('config_currency')),
					    'tax_class_id' => $this->config->get( 'fedex_integration_tax_class_id' ),
					    'text'         => $this->currency->format(
						    $this->tax->calculate( $this->currency->convert( $cost,
							    $this->config->get( 'config_currency' ),
							    $this->currency->getCode() ),
							    $this->config->get( 'fedex_integration_tax_class_id' ),
							    $this->config->get( 'config_tax' ) ),
						    $this->currency->getCode(),
						    1.0000000 )
				    ]
			    ];
		    }

		    if ( $local_delivery ) {
			    $quote_data = $local_delivery;
		    }
		    if ( $quote_data ) {
			    foreach ( $quote_data as $key => $value ) {
				    $quote_data[ $key ]['cost'] = $quote_data[ $key ]['cost'];
				    $quote_data[ $key ]['text'] = $this->currency->format(
                        $this->tax->calculate( $this->currency->convert( $quote_data[ $key ]['cost'],
                            $this->config->get( 'config_currency' ),
                            $this->currency->getCode() ),
                            $this->config->get( 'fedex_integration_tax_class_id' ),
                            $this->config->get( 'config_tax' ) ),
                        $this->currency->getCode(),
                        1.0000000 );
			    }
		    }

		    $title       = $this->language->get( 'text_fedex_local_delivery', 'fedex_integration/fedex_integration' );
		    $method_data = [
			    'id'         => 'fedex_integration_local',
			    'title'      => $title,
			    'quote'      => $quote_data,
			    'sort_order' => $this->config->get( 'fedex_integration_sort_order' ),
		    ];

		    return $method_data;
	    }
    }

    /**
     * Get Rate Function
     * @param string $address
     * @param string $postcode
     * @param string $weight
     * @param string $length
     * @param string $width
     * @param string $height
     * @param string $subtotal
     * @param string $destination
     * @return mixed
     */
    private function _fetchRate($address,$postcode,$weight,$length,$width,$height,$subtotal,$destination) {
        $f = new \RocketShipItFedex\Rate('fedex');
        if ($this->config->get('fedex_integration_test')=='1' ) {
            $f->setParameter('debugMode',1);
        } else {
            $f->setParameter('debugMode',0);
        }

        $f->setParameter('key',$this->config->get('fedex_integration_key'));
        $f->setParameter('accountNumber',$this->config->get('fedex_integration_account'));
        $f->setParameter('password',$this->config->get('fedex_integration_password'));
        $f->setParameter('meterNumber',$this->config->get('fedex_integration_meter'));
        $f->setParameter('packagingType',$this->config->get('fedex_integration_packaging'));
        $f->setParameter('weightUnit',strtoupper($this->config->get('config_weight_class')));
        $f->setParameter('lengthUnit',strtoupper($this->config->get('config_length_class')));
        $originCity=$this->config->get('fedex_integration_city');
        $originCode=$this->config->get('fedex_integration_postcode');
        $originState=$this->config->get('fedex_integration_state');
        $originCountry=$this->config->get('fedex_integration_country');
        $destCity=$address['city'];
        $destCode=$postcode;
        $destCountry=$address['iso_code_2'];
        $f->setParameter('shipCity' ,$originCity);
        if ($originCode!=='') {
            $f->setParameter('shipCode', $originCode);
        }
        if ($originState!=='') {
            $f->setParameter('shipState' ,$originState);
        }
        $f->setParameter('shipCountry' ,$originCountry);
        $f->setParameter('toCity',$destCity);
        $f->setParameter('toCode', $destCode);
        $f->setParameter('toCountry', $destCountry);
        $f->setparameter('weight', $weight);
        $f->setParameter('dropoffType', $this->config->get('fedex_integration_dropoffType'));
        $f->setParameter('collectOnDelivery', 'NO');
        $f->setParameter('holdAtLocation', 'NO');
        $f->setParameter('codCollectionType', 'ANY');
        $f->setParameter('saturdayDelivery', 'NO');
        $f->setParameter('paymentType', 'SENDER');
	    $dateOfWeek=date('w');
	    if ($dateOfWeek==='0') {
		    $tomorrow=strtotime('+ 1 day');
		    $date = date('Y-m-d',$tomorrow).'T'.date('H:i:s',$tomorrow);
	    } else {
		    $date = date('Y-m-d').'T'.date('H:i:s');
	    }
	    $f->setParameter('shipDate',$date);
	    if ($destination==='domestic') {
            $smart_post = $this->config->get('fedex_integration_smart_post_hub_id');
            if ($smart_post === 'NONE') {
                $f->setparameter('length', $length);
                $f->setparameter('width', $width);
                $f->setparameter('height', $height);
            } else {
                $f->setParameter('smartPostIndicia', 'PARCEL_SELECT');
                $f->setParameter('smartPostHubId', $this->config->get('fedex_integration_smart_post_hub_id'));
            }
            if (!$address['address_1'] || $address['address_1']==='') {
                if ($this->config->get('fedex_integration_residential')==='1') {
                    $f->setParameter('residentialAddressIndicator','1');
                } else {
                    $f->setParameter('residentialAddressIndicator','0');
                }
            } else {
                $validate=$this->validateAddress($address);
                if (is_null($validate)) {
                    if ($this->config->get('fedex_integration_residential') === '1') {
                        $f->setParameter('residentialAddressIndicator', '1');
                    } else {
                        $f->setParameter('residentialAddressIndicator', '0');
                    }
                } else {
                    if ($validate) {
                        $f->setParameter('residentialAddressIndicator', '1');
                    } else {
                        $f->setParameter('residentialAddressIndicator', '0');
                    }
                }
            }
        } else {
            $f->setparameter('length', $length);
            $f->setparameter('width', $width);
            $f->setparameter('height', $height);
        }

        if ($this->config->get('fedex_integration_declared_value_nominal')!=='') {
            $decVal=$this->config->get('fedex_integration_declared_value_nominal');
        } else {
            $decVal=100;
        }

        if ($this->config->get('fedex_integration_declared_value')=='1' && $subtotal > $decVal) {
            $f->setParameter('insuredCurrency',$this->config->get('config_currency'));
            $f->setParameter('insuredValue',$this->currency->format($subtotal, false, false, false));
        }

        if ($originCountry != $destCountry || $originCountry=='IN') {
            $f->setParameter('customsCurrency',$this->config->get('config_currency'));
            $f->setParameter('customsValue',$this->currency->format($subtotal, false, false, false));
        }

        $response = $f->getAllRates();
        if ($this->config->get('fedex_integration_debug')) {
            $this->log->write('FedEx Integration Debug: '.html_entity_decode(var_export($f->debug(),true)));
        }
        $normalRate=$response['RateReply'];
        return $normalRate;
    }


    /**
     * Process Rate Function
     * @param string $rateService
     * @param string $dest
     * @param string $qty
     * @return array
     */
    private function _processRate($rateService="",$dest="",$qty="") {
        $cart = $this->cart;

	    $this->extensions->hk_InitData($this, __FUNCTION__);

        $discount_rates=$this->config->get('fedex_integration_discount_rates');
        if($rateService) {
            if ($rateService['Notifications']['Severity'] =='ERROR' || $rateService['Notifications']['Severity']=='WARNING') {
                $error = $rateService['Notifications']['Message'];
            }
            if ($rateService['RateReplyDetails']) {
                $services=$rateService['RateReplyDetails'];
                foreach ($services as $rates) {
                    if ($dest==='' && $rates['ServiceType']==='FEDEX_GROUND' && $this->config->get('fedex_integration_intl_FEDEX_GROUND')==='0' ||
                        $dest==='domestic' && $rates['ServiceType']==='FEDEX_GROUND' && $this->config->get('fedex_integration_domestic_FEDEX_GROUND')==='0' ){
                        continue;
                    }
                    if ($this->config->get('fedex_integration_intl_' . $rates['ServiceType']) === '1' || $this->config->get('fedex_integration_domestic_' . $rates['ServiceType']) === '1') {
                        $type=$this->config->get('fedex_integration_type');
                        $fee_rate=(float)$this->config->get('fedex_integration_additional_fee');
                        if ($discount_rates=='1') {
                            $rate = $rates['RatedShipmentDetails'][0]['ShipmentRateDetail']['TotalNetCharge']['Amount'];
                        } else {
                            $rate = $rates['RatedShipmentDetails'][1]['ShipmentRateDetail']['TotalNetCharge']['Amount'];
                        }
                        if ($type=='percent' && $fee_rate!='0') {
                            $fee=number_format($rate*($fee_rate/100), 2, '.', '');
                        } elseif ($type=='fixed' && $fee_rate!='0') {
                            $fee=number_format($fee_rate, 2, '.', '');
                        }
                        if ($qty != '') {
                            $domRate = ($rate+$fee) * $qty;
                        } else {
                            $domRate = $rate+$fee;
                        }

                        if ($dest === 'domestic') {
                            if ($this->config->get('fedex_integration_display_weight') == '1') {
                                $title = $this->language->get('text_domestic_' . $rates['ServiceType']) . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                            } else {
                                $title = $this->language->get('text_domestic_' . $rates['ServiceType']);
                            }
                        } else {
                            if ($this->config->get('fedex_integration_display_weight') == '1') {
                                $title = $this->language->get('text_intl_' . $rates['ServiceType']) . ' (' . $this->language->get('text_weight') . ' ' . $this->weight->format($cart->getWeight(), $this->config->get('config_weight_class')) . ')';
                            } else {
                                $title = $this->language->get('text_intl_' . $rates['ServiceType']);
                            }
                        }
                        $quote_data[$rates['ServiceType']] = [
                            'id' => 'fedex_integration.' . $rates['ServiceType'],
                            'title' => $title,
                            'cost' => $this->currency->convert($domRate, $this->config->get('config_currency'), $this->config->get('config_currency')),
                            'tax_class_id' => $this->config->get('fedex_integration_tax_class_id'),
                            'text' => $this->currency->format(
                                $this->tax->calculate($this->currency->convert($domRate,
                                    $this->config->get('config_currency'),
                                    $this->currency->getCode()),
                                    $this->config->get('fedex_integration_tax_class_id'),
                                    $this->config->get('config_tax')),
                                $this->currency->getCode(),
                                1.0000000)
                        ];
                    }
                }
            }
        }
        return ['quote_data'=>$quote_data, 'error_msg'=>$error];
    }

    /**
     * Validate Residential Address Function
     * @param $address
     * @return mixed
     */
    private function validateAddress($address) {
        $v = new \RocketShipItFedex\AddressValidate('fedex');
        $v->setParameter('key',$this->config->get('fedex_integration_key'));
        $v->setParameter('accountNumber',$this->config->get('fedex_integration_account'));
        $v->setParameter('password',$this->config->get('fedex_integration_password'));
        $v->setParameter('meterNumber',$this->config->get('fedex_integration_meter'));
        $v->setParameter('toState', $address['zone_code']);
        $v->setParameter('toAddr1', $address['address_1']);
        $v->setParameter('toCity', $address['city']);
        $v->setParameter('toCode', $address['postcode']);
        $response = $v->validate();
        return $response['Data']['Residential'];
    }

    /**
     * @param array $product_ids
     * @return float|int
     */
    private function getIndividualWeight( $product_ids = []) {
        $cart = $this->cart;
        $weight = 0;
        foreach ($cart->getProducts() as $product) {
            if (sizeof($product_ids) > 0 && !in_array((string)$product['product_id'], $product_ids) ) {
                continue;
            }

            if ($product['shipping']) {
                $product_weight = $product['weight'];
                // if product_option has weight value
                if($product['option']){
                    $hard = false;
                    foreach($product['option'] as $option){
                        if($option['weight'] == 0) continue; // if weight not set - skip
                        if($option['weight_type'] != '%'){
                            //If weight was set by option hard and other option sets another weight hard - ignore it
                            //skip negative weight. Negative allowed only for % based weight
                            if ($hard || $option['weight'] < 0) {
                                continue;
                            }
                            //$hard = true;
                            $product_weight = $cart->weight->convert($option['weight'], $option['weight_type'], $product['weight_class']);
                        }else{
                            //We need product base weight for % calculation
                            $temp = ($option['weight'] * $product['weight']/100) + $product['weight'];
                            $product_weight = $cart->weight->convert($temp, $option['weight_type'], $this->config->get('config_weight_class'));
                        }
                    }
                }
                $weight = $cart->weight->convert($product_weight, $product['weight_class'], $this->config->get('config_weight_class'));
            }
        }
        return $weight;
    }
}