<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/

if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}

if (!class_exists('ExtensionFedexIntegration')) {
    include_once('core/fedex_integration_hook.php');
}

$controllers = [
    'storefront' => [],
    'admin' => [
        'pages/extension/fedex_integration',
        'pages/extension/fedex_integration_updater',
        'responses/extension/fedex_test',
        'responses/extension/fedex_integration_save',
    ],
];

$models = [
    'storefront' => [
        'extension/fedex_integration',
        'extension/fedex_order',
        'extension/fedex_verify',
        'extension/fedex_integration_license_info'],
    'admin' => [
        'extension/fedex_integration_updater',
        'extension/fedex_verify',
        'extension/fedex_order',
        'extension/fedex_integration_license_info'
    ],
];

$templates = [
    'storefront' => [
        'embed/head.post.tpl',
        'common/head.post.tpl'],
    'admin' => [
        'pages/extension/fedex_integration.tpl',
        'pages/extension/fedex_integration_updater.tpl',
        'pages/extension/fedex_integration_manual.tpl',
        'pages/extension/extension_summary_button.tpl',
        'pages/extension/extensions.post.tpl',
        'pages/extension/extensions_edit.post.tpl',
    ]
];

$languages = [
    'storefront' => [
        'fedex_integration/fedex_integration'],
    'admin' => [
        'fedex_integration/fedex_integration']
];