<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' ) || !IS_ADMIN) {
    header ( 'Location: static_pages/' );
}
include_once DIR_EXT . 'fedex_integration' . DIR_EXT_CORE . 'lib/autoload.php';
class ControllerResponsesExtensionFedexTest extends AController {
    private $cfg = [];

    public function test() {
        $this->loadLanguage('fedex_integration/fedex_integration');
        $this->loadModel('setting/setting');
        $this->cfg = $this->model_setting_setting->getSetting('fedex_integration',(int)$this->session->data['current_store_id']);
        $json = [];
        $required_fields = [
            'key'        	 => 'fedex_integration_key',
            'account'   	 => 'fedex_integration_account',
            'pass'       	 => 'fedex_integration_password',
            'meter'       	 => 'fedex_integration_meter',
            'city'       	 => 'fedex_integration_city',
            'postcode'   	 => 'fedex_integration_postcode',
            'packaging'   	 => 'fedex_integration_packaging',
            'dropoffType'	 => 'fedex_integration_dropoffType',
            'country'	     => 'fedex_integration_country',
        ];
        $address = [];
        foreach ($required_fields as $k => $fld){
            if (!$this->cfg[$fld] && $k!=='postcode'){
                $json['error'] = true;
                $json['message'] = 'Error: Please fill and save all required fields and try again.';
                break;
            }
            $address[$k] = $this->cfg[$fld];
        }
        if ($json['error'] != true){
            $test_result = $this->_processRequest($address);
            $test_mode = $this->cfg['fedex_integration_test'] ? 'ON' : 'OFF';
            if (!$test_result){
                $json['error'] = true;
                $json['message'] = 'fedex Error: Wrong data was given. Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';
            } else if ($test_result['error']){
                $json['error'] = true;
                $json['message'] = 'fedex Error: ' . $test_result['error'] . "\n" . 'Please check your API Credentials and try again.' . "\n" . 'Also please note that Test mode is ' . $test_mode . '!';

            } else{
                $json['message'] = $this->language->get('text_connection_success');
                $json['error'] = false;
            }
        }
        $this->load->library('json');
        $this->response->setOutput(AJson::encode($json));
    }

    private function _processRequest($address){
        $fedex_key = $this->cfg['fedex_integration_key'];
        $fedex_account = $this->cfg['fedex_integration_account'];
        $fedex_password = $this->cfg['fedex_integration_password'];
        $fedex_meter = $this->cfg['fedex_integration_meter'];
        $fedex_packaging=$this->cfg['fedex_integration_packaging'];
        $fedex_dropoffType=$this->cfg['fedex_integration_dropoffType'];
        //Recepient Info
        $shipping_address = $address;

        $f = new \RocketShipItFedex\Rate('fedex');
        $f->setParameter('key',$fedex_key);
        $f->setParameter('accountNumber',$fedex_account);
        $f->setParameter('password',$fedex_password);
        $f->setParameter('meterNumber',$fedex_meter);
        $f->setParameter('packagingType',$this->config->get('fedex_integration_packaging'));
        $f->setParameter('weightUnit',strtoupper($this->config->get('config_weight_class')));
        $f->setParameter('lengthUnit',strtoupper($this->config->get('config_length_class')));
        $f->setParameter('shipCountry' ,$shipping_address['country']);
        $f->setParameter('shipCity' ,$shipping_address['city']);
        if ($address['postcode']!=='') {
            $f->setParameter('shipCode', $shipping_address['postcode']);
            $f->setParameter('toCode', $shipping_address['postcode']);
        }
        $f->setParameter('toCity',$shipping_address['city']);
        $f->setParameter('toCountry', $shipping_address['country']);
        $f->setParameter('packagingType', $fedex_packaging);
        $f->setParameter('dropoffType', $fedex_dropoffType);
        $f->setParameter('collectOnDelivery', 'NO');
        $f->setParameter('holdAtLocation', 'NO');
        $f->setParameter('codCollectionType', 'ANY');
        $f->setParameter('saturdayDelivery', 'NO');
        $f->setParameter('paymentType', 'SENDER');
        $f->setparameter('length', '1');
        $f->setparameter('width', '1');
        $f->setparameter('height', '1');
        $f->setParameter('weightUnit',strtoupper($this->config->get('config_weight_class')));
        $f->setParameter('lengthUnit',strtoupper($this->config->get('config_length_class')));
        $f->setParameter('weight', '1');
        if ($this->config->get('fedex_integration_domestic_SMART_POST')=='1') {
            $f->setParameter('smartPostHubId',$this->config->get('fedex_integration_smart_post'));
            $f->setParameter('smartPostIndicia', 'PARCEL_SELECT');
        }

        $error_msg='';
        $response = $f->getAllRates();
        if ($response['RateReply']['Notifications']['Severity'] =='ERROR' || $response['RateReply']['Notifications']['Severity'] =='WARNING') {
            $error_msg = $response['RateReply']['Notifications']['Message'];
        }

        return ['error' => $error_msg];
    }
}