<?php
/*------------------------------------------------------------------------------

  For Abante Cart, E-commerce Solution
  http://www.AbanteCart.com

  Copyright (c) 2014-2022 We Hear You 2, Inc.  (WHY2)

------------------------------------------------------------------------------*/
if ( !defined ( 'DIR_CORE' ) || !IS_ADMIN) {
	header ( 'Location: static_pages/' );
}

class ControllerResponsesExtensionFedexIntegrationSave extends AController {
	private $required_fields = [
			'fedex_integration_key',
			'fedex_integration_account',
			'fedex_integration_password',
            'fedex_integration_meter',
			'fedex_integration_city',
            'fedex_integration_country',
		];
    public function main(){}
    public function update() {
        $this->loadLanguage('extension/extensions');

        if (!$this->user->canModify('extension/extensions')) {
            $this->response->setOutput(sprintf($this->language->get('error_permission_modify'), 'extension/extensions'));
            return null;
        }
        foreach ($this->required_fields as $fld) {
            if (isset($this->request->post[$fld]) && trim($this->request->post[$fld]) == '') {
                $this->response->setOutput(sprintf($this->language->get('error_required_field'), 'extension/extensions'));
                return null;
            }
        }

        $store_id = isset($this->request->post['store_id']) ? (int)$this->request->post['store_id'] : $this->request->get['store_id'];
        $store_id = is_null($store_id) ? $this->config->get('config_store_id') : $store_id;
        $this->request->post['store_id'] = $store_id;
        $this->extension_manager->editSetting('fedex_integration', $this->request->post);
    }
}
