<?php
if (!defined('DIR_CORE')) {
    header('Location: static_pages/');
}
/**
 * Class ModelSaleCustomerAttributes
 */
/** @noinspection PhpUndefinedClassInspection */

class ModelSaleCustomerAttributes extends Model
{
    /**
     * @param int $customer_group_id
     * @param int $language_id
     *
     * @return array
     */
    public function getAttributesForGroup($customer_group_id, $language_id)
    {
        $language_id = (int)$language_id;
        $language_id = !$language_id ? $this->config->get('storefront_language_id') : $language_id;
        $sql = "SELECT	cag.customer_attribute_id,
                        cag.customer_group_id,
                        cag.editable_by_customer,
                        cag.visible_by_customer,
                        gad.name,
                        gad.error_text,
                        ga.element_type,
                        ga.sort_order,
                        ga.required,
                        ga.regexp_pattern,
                        ga.settings
                FROM ".$this->db->table('customer_attributes_to_groups')." cag
                INNER JOIN ".$this->db->table('customer_attribute_descriptions')." gad
                    ON cag.customer_attribute_id = gad.customer_attribute_id 
                        AND gad.language_id = ".(int)$language_id."
                INNER JOIN ".$this->db->table('customer_attributes')." ga 
                    ON cag.customer_attribute_id = ga.customer_attribute_id
                WHERE cag.customer_group_id = ".(int)$customer_group_id." AND cag.status = 1
                ORDER BY ga.sort_order ASC";

        $results = $this->db->query($sql);
        $output = (array)$results->rows;
        foreach ($output as &$row) {
            $row['values'] = $this->getAttributeValues($row['customer_attribute_id'], $language_id);
            $row['selected_values'] = array();
            $row['settings'] = $row['settings'] ? unserialize($row['settings']) : array();
        }
        unset($row);
        return $output;
    }

    /**
     * @param int $customer_attribute_id
     * @param int $language_id
     *
     * @return array
     */
    private function getAttributeValues($customer_attribute_id, $language_id = 0)
    {
        $customer_attribute_id = (int)$customer_attribute_id;
        if (!$customer_attribute_id) {
            return array();
        }
        $language_id = (int)$language_id;
        if (!$language_id) {
            $language_id = $this->language->getLanguageID();
        }

        $sql = "SELECT gav.customer_attribute_value_id,
                        gav.sort_order,
                        gavd.value
                FROM ".$this->db->table('customer_attribute_values_to_groups')." gav
                INNER JOIN ".$this->db->table('customer_attribute_value_descriptions_to_groups')." gavd
                    ON (gav.customer_attribute_value_id = gavd.customer_attribute_value_id
                        AND gavd.language_id = ".(int)$language_id.")
                WHERE gav.customer_attribute_id = ".$customer_attribute_id."
                ORDER BY gav.sort_order ASC";
        $results = $this->db->query($sql);
        return (array)$results->rows;
    }

    /**
     * @param int $customer_id
     * @param array $data
     *
     * @return bool
     */
    public function addAttributesToCustomer($customer_id, $data = array())
    {
        if (!is_array($data) || !(int)$customer_id) {
            return false;
        }
        foreach ($data as $attr_id => $val) {
            if (!is_array($val)) {
                $val = (array)$val;
            }
            $this->db->query("DELETE FROM ".$this->db->table('customer_attribute_values')."
                                WHERE customer_id = '".(int)$customer_id."' AND  customer_attribute_id = ".(int)$attr_id
                .";");

            foreach ($val as $attr_val) {

                $this->db->query("INSERT INTO ".$this->db->table('customer_attribute_values')."
                                                (customer_id, customer_attribute_id, customer_attribute_value)
                                  VALUES (".(int)$customer_id.", ".(int)$attr_id.", '".$this->db->escape($attr_val)
                    ."');");
            }
        }
        return true;
    }

    /**
     * @param int $customer_group_id
     *
     * @return array
     */
    public function getCustomerVisibleAttributes($customer_group_id)
    {
        $customer_group_id = (int)$customer_group_id;
        if (!$customer_group_id) {
            return array();
        }
        $customer_id = (int)$this->session->data['customer_id'];
        $language_id = $this->language->getLanguageID();
        $sql = "SELECT *, catg.customer_attribute_id
                FROM ".$this->db->table('customer_attributes_to_groups')." catg
                LEFT JOIN  ".$this->db->table('customer_attribute_descriptions')." cad
                    ON catg.customer_attribute_id = cad.customer_attribute_id AND cad.language_id = '".$language_id."'
                LEFT JOIN ".$this->db->table('customer_attributes')." ca 
                    ON ca.customer_attribute_id = catg.customer_attribute_id
                WHERE catg.visible_by_customer = 1 AND catg.status = 1
                        AND catg.customer_group_id = ".(int)$customer_group_id."
                ORDER BY  ca.sort_order";
        $result = $this->db->query($sql);

        $attributes = array();
        foreach ($result->rows as $row) {
            $sql = "SELECT customer_attribute_value_id, customer_attribute_value
                      FROM ".$this->db->table('customer_attribute_values')."
                      WHERE customer_attribute_id = ".(int)$row['customer_attribute_id']."
                            AND customer_id=".(int)$customer_id;
            $selected_values = $this->db->query($sql);
            $row['selected_values'] = $selected_values->rows;

            $sql = "SELECT *
                    FROM ".$this->db->table('customer_attribute_values_to_groups')." cavtg
                    LEFT JOIN ".$this->db->table('customer_attribute_value_descriptions_to_groups')." cavdtg
                        ON cavdtg.customer_attribute_value_id = cavtg.customer_attribute_value_id AND language_id = '"
                .$language_id."'
                    WHERE cavtg.customer_attribute_id = ".(int)$row['customer_attribute_id']."
                        AND cavtg.customer_group_id = ".$customer_group_id."
                    ORDER BY  cavtg.sort_order	";
            $all_values = $this->db->query($sql);
            $row['values'] = $all_values->rows;

            $attributes[] = $row;
        }

        return $attributes;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     */
    public function getVisibleAttributes($customer_id)
    {
        $customer_id = (int)$customer_id;
        if (!$customer_id) {
            return array();
        }
        $results = $this->db->query(
            "SELECT cag.customer_attribute_id
            FROM ".$this->db->table('customer_attributes_to_groups')." cag
            INNER JOIN ".$this->db->table('customers')." c
            ON cag.customer_group_id = c.customer_group_id
            WHERE c.customer_id = ".(int)$customer_id." AND cag.visible_by_customer = 1
            AND cag.status = 1 ");
        return $results->rows;
    }

    /**
     * @param int $customer_group_id
     * @param array $data
     *
     * @return array
     */
    public function validateAttributesForEdit($customer_group_id, $data)
    {

        $errors = array();
        $check = $this->getCustomerVisibleAttributes($customer_group_id);

        $fm = new AFile();

        foreach ($check as $check_attr) {
            $attribute_id = $check_attr['customer_attribute_id'];
            if (empty($data[$attribute_id]) && $check_attr['required'] == 1
                && $check_attr['editable_by_customer'] == 1) {
                //if value is empty
                if (($check_attr['element_type'] == 'U' && !$this->request->files['attributes']['name'][$attribute_id])
                    || $check_attr['element_type'] != 'U'
                ) {
                    $errors[$attribute_id] = $this->language->get('error_required');
                }
            } else {
                if (!empty($data[$attribute_id]) && $check_attr['regexp_pattern']
                    && !preg_match($check_attr['regexp_pattern'], $data[$attribute_id])) {
                    $errors[$attribute_id] = $check_attr['error_text'];
                }
            }
            //check uploaded file
            if ($this->request->files['attributes']['name'][$attribute_id] && $check_attr['element_type'] == 'U'
                && $check_attr['editable_by_customer'] == 1) {
                if (is_serialized($check_attr['settings'])) {
                    $check_attr['settings'] = unserialize($check_attr['settings']);
                }
                $name = $this->request->files['attributes']['name'][$attribute_id];
                $file_path_info = $fm->getUploadFilePath($check_attr['settings']['directory'], $name);
                $file_data = array(
                    'name'     => $file_path_info['name'],
                    'path'     => $file_path_info['path'],
                    'type'     => $this->request->files['attributes']['type'][$attribute_id],
                    'tmp_name' => $this->request->files['attributes']['tmp_name'][$attribute_id],
                    'error'    => $this->request->files['attributes']['error'][$attribute_id],
                    'size'     => $this->request->files['attributes']['size'][$attribute_id],
                );
                $errors[$attribute_id] = implode('<br>',
                    $fm->validateFileOption($check_attr['settings'], $file_data, $check_attr['required']));
            }

            //if checkbox is not required and was unchecked - set value to emptiness
            if (!$errors[$attribute_id]
                && !isset($data[$attribute_id])
                && $check_attr['element_type'] == 'C'
            ) {
                $this->request->post['attributes'][$attribute_id] = '';
            }
        }
        return $errors;
    }

    /**
     * @param int $customer_group_id
     * @param int $language_id
     * @param array $data
     *
     * @return array
     */
    public function validateAttributesForCreate($customer_group_id, $language_id, $data)
    {

        $customer_group_id = (int)$customer_group_id;
        $language_id = (int)$language_id;
        $data = (array)$data;
        $errors = array();
        $check = $this->getAttributesForGroup($customer_group_id, $language_id);
        $fm = new AFile();
        foreach ($check as $check_attr) {
            $attribute_id = $check_attr['customer_attribute_id'];
            if (empty($data[$attribute_id]) && $check_attr['required'] == 1) {
                if (
                    ($check_attr['element_type'] == 'U' && !$this->request->files['attributes']['name'][$attribute_id])
                    || $check_attr['element_type'] != 'U'
                ) {

                    $errors[$attribute_id] = $this->language->get('error_required');
                }

            } else {
                if (!empty($data[$attribute_id]) && $check_attr['regexp_pattern']
                    && !preg_match($check_attr['regexp_pattern'], $data[$attribute_id])) {
                    $errors[$attribute_id] = $check_attr['error_text'];
                }
            }
            //check uploaded files
            if ($this->request->files['attributes']['name'][$attribute_id] && $check_attr['element_type'] == 'U') {
                $name = $this->request->files['attributes']['name'][$attribute_id];
                $file_path_info = $fm->getUploadFilePath($check_attr['settings']['directory'], $name);
                $file_data = array(
                    'name'     => $file_path_info['name'],
                    'path'     => $file_path_info['path'],
                    'type'     => $this->request->files['attributes']['type'][$attribute_id],
                    'tmp_name' => $this->request->files['attributes']['tmp_name'][$attribute_id],
                    'error'    => $this->request->files['attributes']['error'][$attribute_id],
                    'size'     => $this->request->files['attributes']['size'][$attribute_id],
                );
                $file_errors = $fm->validateFileOption($check_attr['settings'], $file_data, $check_attr['required']);
                if($file_errors) {
                    $errors[$attribute_id] = implode('<br>', $file_errors);
                }
            }

            //if checkbox is not required and was unchecked - set value to emptiness
            if (!$errors[$attribute_id]
                && !isset($data[$attribute_id])
                && $check_attr['element_type'] == 'C'
            ) {
                $this->request->post['attributes'][$attribute_id] = '';
            }
        }
        return $errors;
    }

    /**
     * @param int $attribute_id
     *
     * @return array
     */
    public function getAttributeInfo($attribute_id)
    {
        $language_id = $this->config->get('storefront_language_id');
        $sql = "SELECT cag.customer_group_id,
                    cag.editable_by_customer,
                    cag.visible_by_customer,
                    cag.status,
                    gad.name,
                    gad.error_text,
                    ga.customer_attribute_id,
                    ga.element_type,
                    ga.sort_order,
                    ga.settings,
                    ga.required
            FROM ".$this->db->table('customer_attributes_to_groups')." cag
            INNER JOIN ".$this->db->table('customer_attribute_descriptions')
            ." gad ON cag.customer_attribute_id = gad.customer_attribute_id AND language_id = ".(int)$language_id."
            INNER JOIN ".$this->db->table('customer_attributes')." ga ON cag.customer_attribute_id = ga.customer_attribute_id
            WHERE ga.customer_attribute_id = ".(int)$attribute_id."  AND cag.status = 1";
        $results = $this->db->query($sql);
        if (has_value($results->row['settings'])) {
            $results->row['settings'] = unserialize($results->row['settings']);
        }
        $results->row['values'] = $this->getAttributeValues($results->row['attribute_id'], $language_id);
        return $results->row;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     */
    public function getCustomerAttributes($customer_id)
    {
        $language_id = $this->config->get('storefront_language_id');
        $results = $this->db->query(
            "SELECT
                ca.customer_attribute_id,
                cag.customer_group_id,
                cag.editable_by_customer,
                cag.visible_by_customer,
                cag.status,
                gad.name,
                gad.error_text,
                ga.attribute_id,
                ga.element_type,
                ga.sort_order,
                ga.required
            FROM ".$this->db->table('customer_attributes_to_groups')." cag
            INNER JOIN ".$this->db->table('customer_attribute_descriptions')." gad ON cag.customer_attribute_id = gad.customer_attribute_id
            INNER JOIN ".$this->db->table('customer_attributes_to_customers')." ca ON cag.customer_attribute_id = ca.customer_attribute_id
            WHERE
                cag.customer_group_id = (SELECT customer_group_id FROM ".$this->db->table('customers')
            ." WHERE customer_id='".(int)$customer_id."' LIMIT 0,1)
                AND language_id = ".(int)$language_id."
                AND ga.status = 1"
        );

        $results->row['values'] = $this->getAttributeValues($results->row['customer_attribute_id'], $language_id);
        return $results->row;
    }

    /**
     * @param int $customer_id
     *
     * @return array
     */
    public function getCustomerAttributesIds($customer_id)
    {
        $ids = array();
        $res = $this->db->query('SELECT customer_attribute_id
                                FROM '.DB_PREFIX.'customer_attributes
                                WHERE customer_id = '.(int)$customer_id);
        foreach ($res->rows as $row) {
            $ids[] = $row['customer_attribute_id'];
        }
        return $ids;
    }

    /**
     * @param int $customer_group_id
     *
     * @return array
     */
    public function getCustomerEditableAttributesIds($customer_group_id)
    {
        $ids = array();
        $res = $this->db->query("SELECT ca.customer_attribute_id
                                FROM ".$this->db->table('customer_attributes_to_groups')." cag
                                LEFT JOIN ".$this->db->table('customer_attributes')." ca ON ca.customer_attribute_id = cag.customer_attribute_id
                                WHERE cag.customer_group_id = '".(int)$customer_group_id."'
                                AND cag.editable_by_customer = 1");

        foreach ($res->rows as $row) {
            $ids[] = $row['customer_attribute_id'];
        }
        return $ids;
    }

    /**
     * @param int $customer_id
     * @param array $data
     *
     * @return null
     */
    public function updateCustomerAttributeValues($customer_id, $data)
    {

        if (!has_value($data)) {
            return false;
        }

        $ids = $this->getCustomerEditableAttributesIds($this->customer->getCustomerGroupId());

        foreach ($data as $key => $item) {
            //protect from editing wrong customer
            if (in_array($key, $ids)) {
                $this->db->query("DELETE FROM ".$this->db->table('customer_attribute_values')."
                                  WHERE customer_attribute_id = ".(int)$key."
                                    AND customer_id = ".(int)$customer_id);
                if (!is_array($item)) {
                    $item = array($item);
                }
                foreach ($item as $val) {
                    $this->db->query(
                        "INSERT INTO ".$this->db->table('customer_attribute_values')."
                        SET customer_id = ".(int)$customer_id.",
                            customer_attribute_id = ".(int)$key.",
                            customer_attribute_value = '".$this->db->escape($val)."'");
                }
            }
        }
        return true;
    }

}