DROP TABLE IF EXISTS `ac_customer_attributes`;
CREATE TABLE IF NOT EXISTS `ac_customer_attributes` (
	`customer_attribute_id` int(11) NOT NULL AUTO_INCREMENT,
	`global_attribute_id` int(11) NOT NULL,
  `regexp_pattern` varchar(255) COLLATE utf8_bin DEFAULT NULL,
  `element_type` char(1) COLLATE utf8_bin NOT NULL DEFAULT 'I',
  `sort_order` int(3) NOT NULL DEFAULT '0',
  `required` smallint(1) NOT NULL DEFAULT '0',
  `settings` text COLLATE utf8_bin NOT NULL,
	PRIMARY KEY (`customer_attribute_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_customer_attribute_descriptions`;
CREATE TABLE IF NOT EXISTS `ac_customer_attribute_descriptions` (
	`customer_attribute_id` int(11) NOT NULL,
	`language_id` int(11) NOT NULL,
	`name` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  `error_text` varchar(255) COLLATE utf8_general_ci NOT NULL COMMENT 'translatable'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


DROP TABLE IF EXISTS `ac_customer_attributes_to_groups`;
CREATE TABLE IF NOT EXISTS `ac_customer_attributes_to_groups` (
	`customer_attribute_id` int(11) NOT NULL,
	`customer_group_id` int(11) NOT NULL,
	`editable_by_customer` smallint(1) NOT NULL DEFAULT '1',
	`visible_by_customer` smallint(1) NOT NULL DEFAULT '1',
	`status` smallint(1) NOT NULL DEFAULT '1'
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_customer_attribute_values_to_groups`;
CREATE TABLE IF NOT EXISTS `ac_customer_attribute_values_to_groups` (
	`customer_attribute_value_id` int(11) NOT NULL AUTO_INCREMENT,
	`customer_attribute_id` int(11) NOT NULL,
	`customer_attribute_value` varchar(255) NOT NULL,
  `customer_group_id` int(11) NOT NULL,
  `sort_order` int(11) NOT NULL DEFAULT '0',
	PRIMARY KEY (`customer_attribute_value_id`,`customer_attribute_id`,`customer_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_customer_attribute_value_descriptions_to_groups`;
CREATE TABLE `ac_customer_attribute_value_descriptions_to_groups` (
  `customer_attribute_value_id` int(11) NOT NULL,
  `customer_attribute_id` int(11) NOT NULL,
  `customer_group_id` int(11) NOT NULL,
  `language_id` int(11) NOT NULL,
  `value` text COLLATE utf8_general_ci NOT NULL COMMENT 'translatable',
  PRIMARY KEY (`customer_attribute_value_id`,`customer_attribute_id`,`language_id`,`customer_group_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

DROP TABLE IF EXISTS `ac_customer_attribute_values`;
CREATE TABLE IF NOT EXISTS `ac_customer_attribute_values` (
	`customer_attribute_value_id` int(11) NOT NULL AUTO_INCREMENT,
  `customer_id` int(11) NOT NULL,
	`customer_attribute_id` int(11) NOT NULL,
	`customer_attribute_value` varchar(255) NOT NULL,
	PRIMARY KEY (`customer_attribute_value_id`,`customer_id`,`customer_attribute_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;


